/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Static;

public class SqlWithinGroupOperator
extends SqlBinaryOperator {
    public SqlWithinGroupOperator() {
        super("WITHIN GROUP", SqlKind.WITHIN_GROUP, 100, true, ReturnTypes.ARG0, null, (SqlOperandTypeChecker)OperandTypes.ANY_IGNORE);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.keyword("WITHIN GROUP");
        SqlWriter.Frame orderFrame = writer.startList(SqlWriter.FrameTypeEnum.ORDER_BY_LIST, "(", ")");
        writer.keyword("ORDER BY");
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endList(orderFrame);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        assert (call.operandCount() == 2);
        SqlValidatorUtil.FlatAggregate flat = SqlValidatorUtil.flatten(call);
        SqlOperator operator = flat.aggregateCall.getOperator();
        if (!operator.isAggregator()) {
            throw validator.newValidationError(call, Static.RESOURCE.withinGroupNotAllowed(operator.getName()));
        }
        for (SqlNode order : Objects.requireNonNull(flat.orderList)) {
            Objects.requireNonNull(validator.deriveType(scope, order));
        }
        validator.validateAggregateParams(flat.aggregateCall, flat.filter, flat.distinctList, flat.orderList, scope);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        SqlCall inner = (SqlCall)call.operand(0);
        SqlOperator operator = inner.getOperator();
        if (!operator.isAggregator()) {
            throw validator.newValidationError(call, Static.RESOURCE.withinGroupNotAllowed(operator.getName()));
        }
        if (inner.getOperator().getKind() == SqlKind.PERCENTILE_DISC || inner.getOperator().getKind() == SqlKind.PERCENTILE_CONT) {
            PercentileDiscCallBinding opBinding = new PercentileDiscCallBinding(validator, scope, inner, SqlWithinGroupOperator.getCollationColumn(call));
            inner.getOperator().checkOperandTypes(opBinding, true);
            RelDataType ret = inner.getOperator().inferReturnType(opBinding);
            validator.setValidatedNodeType(inner, ret);
            return ret;
        }
        return this.validateOperands(validator, scope, call);
    }

    private static SqlNode getCollationColumn(SqlCall call) {
        return ((SqlNodeList)call.operand(1)).get(0);
    }

    public static class PercentileDiscCallBinding
    extends SqlCallBinding {
        private final SqlNode collationColumn;

        private PercentileDiscCallBinding(SqlValidator validator, SqlValidatorScope scope, SqlCall call, SqlNode collation) {
            super(validator, scope, call);
            this.collationColumn = collation;
        }

        @Override
        public RelDataType getCollationType() {
            RelDataType type = SqlTypeUtil.deriveType((SqlCallBinding)this, this.collationColumn);
            SqlValidatorNamespace namespace = super.getValidator().getNamespace(this.collationColumn);
            return namespace != null ? namespace.getType() : type;
        }
    }
}

