/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import net.jcip.annotations.NotThreadSafe;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.handler.component.HttpShardHandler;
import org.apache.solr.handler.component.ParallelHttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ParallelHttpShardHandler
extends HttpShardHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ExecutorService commExecutor;
    private final ConcurrentMap<ShardResponse, FutureTask<Void>> submitFutures;

    public ParallelHttpShardHandler(ParallelHttpShardHandlerFactory httpShardHandlerFactory) {
        super(httpShardHandlerFactory);
        this.commExecutor = httpShardHandlerFactory.commExecutor;
        this.submitFutures = new ConcurrentHashMap<ShardResponse, FutureTask<Void>>();
    }

    @Override
    protected boolean responsesPending() {
        return super.responsesPending() || !this.submitFutures.isEmpty();
    }

    @Override
    protected void makeShardRequest(ShardRequest sreq, String shard, ModifiableSolrParams params, LBSolrClient.Req lbReq, HttpShardHandler.SimpleSolrResponse ssr, ShardResponse srsp, long startTimeNS) {
        FutureTask<Object> futureTask = new FutureTask<Object>(() -> super.makeShardRequest(sreq, shard, params, lbReq, ssr, srsp, startTimeNS), null);
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(futureTask, this.commExecutor);
        this.submitFutures.put(srsp, futureTask);
        completableFuture.whenComplete((r, t) -> {
            try {
                if (t != null) {
                    this.recordShardSubmitError(srsp, new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception occurred while trying to send a request to shard: " + shard, t));
                }
            }
            finally {
                this.submitFutures.remove(srsp);
            }
        });
    }

    @Override
    public void cancelAll() {
        super.cancelAll();
        this.submitFutures.values().forEach(future -> {
            if (!future.isDone()) {
                future.cancel(true);
            }
        });
        this.submitFutures.clear();
    }
}

