/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.packagemanager;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.client.api.model.UploadToFileStoreResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.JsonMapResponseParser;
import org.apache.solr.client.solrj.request.FileStoreApi;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.request.GenericV2SolrRequest;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.BlobRepository;
import org.apache.solr.filestore.ClusterFileStore;
import org.apache.solr.filestore.DistribFileStore;
import org.apache.solr.filestore.FileStoreAPI;
import org.apache.solr.packagemanager.SolrPackage;
import org.apache.solr.util.SolrJacksonAnnotationInspector;
import org.apache.zookeeper.server.ByteBufferInputStream;

public class PackageUtils {
    public static String LATEST = "latest";
    public static String PACKAGE_PATH = "/api/cluster/package";
    public static String CLUSTER_PLUGINS_PATH = "/api/cluster/plugin";
    public static String REPOSITORIES_ZK_PATH = "/repositories.json";
    public static String CLUSTERPROPS_PATH = "/api/cluster/zk/data/clusterprops.json";

    public static Configuration jsonPathConfiguration() {
        JacksonMappingProvider provider = new JacksonMappingProvider();
        JacksonJsonProvider jsonProvider = new JacksonJsonProvider();
        Configuration c = Configuration.builder().jsonProvider((JsonProvider)jsonProvider).mappingProvider((MappingProvider)provider).options(new Option[]{Option.REQUIRE_PROPERTIES}).build();
        return c;
    }

    public static ObjectMapper getMapper() {
        return new ObjectMapper().setAnnotationIntrospector((AnnotationIntrospector)new SolrJacksonAnnotationInspector());
    }

    public static void postFile(SolrClient client, ByteBuffer buffer, String name, String sig) throws SolrServerException, IOException {
        try (ByteBufferInputStream stream = new ByteBufferInputStream(buffer);){
            FileStoreApi.UploadFile uploadReq = new FileStoreApi.UploadFile(name, (Object)stream);
            if (sig != null) {
                uploadReq.setSig(List.of(sig));
            }
            UploadToFileStoreResponse uploadRsp = (UploadToFileStoreResponse)((FileStoreApi.UploadFileResponse)uploadReq.process(client)).getParsed();
            if (!name.equals(uploadRsp.file)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Mismatch in file uploaded. Uploaded: " + uploadRsp.file + ", Original: " + name);
            }
        }
    }

    public static <T> T getJson(SolrClient client, String path, Class<T> klass) {
        try {
            return (T)PackageUtils.getMapper().readValue(PackageUtils.getJsonStringFromNonCollectionApi(client, path, (SolrParams)new ModifiableSolrParams()), klass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFileFromJarsAsString(List<Path> jars, String filename) {
        for (Path jarfile : jars) {
            ZipEntry entry;
            ZipFile zipFile;
            block9: {
                zipFile = new ZipFile(jarfile.toFile());
                try {
                    entry = zipFile.getEntry(filename);
                    if (entry != null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)ex);
                    }
                }
                zipFile.close();
                continue;
            }
            String string = new String(zipFile.getInputStream(entry).readAllBytes(), StandardCharsets.UTF_8);
            zipFile.close();
            return string;
        }
        return null;
    }

    public static String getJsonStringFromCollectionApi(SolrClient client, String path, SolrParams params) {
        return PackageUtils.getJsonStringFromUrl(client, path, params, true);
    }

    public static String getJsonStringFromNonCollectionApi(SolrClient client, String path, SolrParams params) {
        return PackageUtils.getJsonStringFromUrl(client, path, params, false);
    }

    private static String getJsonStringFromUrl(SolrClient client, String path, SolrParams params, boolean isCollectionApi) {
        try {
            GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.GET, path, params).setRequiresCollection(isCollectionApi);
            request.setResponseParser((ResponseParser)new JsonMapResponseParser());
            NamedList response = client.request((SolrRequest)request);
            return response.jsonStr();
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    public static SolrPackage.Manifest fetchManifest(SolrClient solrClient, String manifestFilePath, String expectedSHA512) throws IOException, SolrServerException {
        GenericV2SolrRequest request = new GenericV2SolrRequest(SolrRequest.METHOD.GET, "/api/node/files" + manifestFilePath);
        request.setResponseParser((ResponseParser)new JsonMapResponseParser());
        NamedList response = solrClient.request((SolrRequest)request);
        String manifestJson = (String)response.get("response");
        String calculatedSHA512 = BlobRepository.sha512Digest(ByteBuffer.wrap(manifestJson.getBytes(StandardCharsets.UTF_8)));
        if (!expectedSHA512.equals(calculatedSHA512)) {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "The manifest SHA512 doesn't match expected SHA512. Possible unauthorized manipulation. Expected: " + expectedSHA512 + ", calculated: " + calculatedSHA512 + ", manifest location: " + manifestFilePath);
        }
        SolrPackage.Manifest manifest = (SolrPackage.Manifest)PackageUtils.getMapper().readValue(manifestJson, SolrPackage.Manifest.class);
        return manifest;
    }

    public static String resolve(String str, Map<String, String> defaults, Map<String, String> overrides, Map<String, String> systemParams) {
        if (str == null) {
            return null;
        }
        if (defaults != null) {
            for (Map.Entry<String, String> entry : defaults.entrySet()) {
                String param = entry.getKey();
                str = str.replace("${" + param + "}", overrides.containsKey(param) ? (CharSequence)overrides.get(param) : (CharSequence)entry.getValue());
            }
        }
        for (Map.Entry<String, String> entry : overrides.entrySet()) {
            str = str.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        for (Map.Entry<String, String> entry : systemParams.entrySet()) {
            str = str.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        return str;
    }

    public static void formatGreen(StringBuilder sb, Object message) {
        PackageUtils.format(sb, SolrCLI.GREEN, message);
    }

    public static void format(StringBuilder sb, Object message) {
        PackageUtils.format(sb, null, message);
    }

    @SuppressForbidden(reason="Need to use System.out.println() instead of log4j/slf4j for cleaner output")
    public static void print(String color, Object message) {
        String RESET = "\u001b[0m";
        if (color != null) {
            System.out.println(color + String.valueOf(message) + RESET);
        } else {
            System.out.println(message);
        }
    }

    public static void format(StringBuilder sb, String color, Object message) {
        String RESET = "\u001b[0m";
        if (color != null) {
            sb.append(color + String.valueOf(message) + RESET + "\n");
        } else {
            sb.append(String.valueOf(message) + "\n");
        }
    }

    public static String[] validateCollections(String[] collections) {
        for (String c : collections) {
            SolrIdentifierValidator.validateCollectionName((String)c);
        }
        return collections;
    }

    public static String getCollectionParamsPath(String collection) {
        return "/api/collections/" + collection + "/config/params";
    }

    public static void uploadKey(byte[] bytes, String path, Path home) throws IOException {
        FileStoreAPI.MetaData meta = ClusterFileStore._createJsonMetaData(bytes, null);
        DistribFileStore._persistToFile(home, path, ByteBuffer.wrap(bytes), ByteBuffer.wrap(Utils.toJSON((Object)meta)));
    }
}

