/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// generated by Fast Light User Interface Designer (fluid) version 1.0107

#include <global.hpp>
#include <align_elements_dialog.hpp>

void align_elements_dialog_button_cb(Fl_Widget* w , void* d){
  Fl_Double_Window* win=dynamic_cast<Fl_Double_Window*>(w->parent());
  win->hide();
}


align_elements_dialog::align_elements_dialog()
  :Fl_Double_Window(LARG_BUTTON_DEFAULT*3+9, LARG_BUTTON_DEFAULT+6, ""),
   _horiz_button(3, 3, LARG_BUTTON_DEFAULT,LARG_BUTTON_DEFAULT, "H"),
   _verti_button(LARG_BUTTON_DEFAULT+3, 3, 
		 LARG_BUTTON_DEFAULT, LARG_BUTTON_DEFAULT, "V"),
   _circu_button(LARG_BUTTON_DEFAULT*2+3, 3, 
		 LARG_BUTTON_DEFAULT, LARG_BUTTON_DEFAULT, "C")

{
   labeltype(FL_NORMAL_LABEL);
   
   _horiz_button.type(FL_RADIO_BUTTON);
   _horiz_button.callback(align_elements_dialog_button_cb);
   add(_horiz_button);
 
   _verti_button.type(FL_RADIO_BUTTON);
   _verti_button.callback(align_elements_dialog_button_cb);
   add(_verti_button);

   _circu_button.type(FL_RADIO_BUTTON);
   _circu_button.callback(align_elements_dialog_button_cb);
   add(_circu_button);
   
   end();

   set_modal();
   show();
  
}

align_elements_dialog::~align_elements_dialog(){ }


align_elements_type_align align_elements_dialog::get_alignment(){
  align_elements_type_align res=ALIGN_HOR;

  if(_horiz_button.value()){
    res=ALIGN_HOR;
  }else if(_verti_button.value()){
    res=ALIGN_VERT;
  }else if(_circu_button.value()){
    res=ALIGN_CIRC;
  }

  return res;
}
