//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/costmanagement/armcostmanagement/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ViewsServer is a fake server for instances of the armcostmanagement.ViewsClient type.
type ViewsServer struct {
	// CreateOrUpdate is the fake for method ViewsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, viewName string, parameters armcostmanagement.View, options *armcostmanagement.ViewsClientCreateOrUpdateOptions) (resp azfake.Responder[armcostmanagement.ViewsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateByScope is the fake for method ViewsClient.CreateOrUpdateByScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateByScope func(ctx context.Context, scope string, viewName string, parameters armcostmanagement.View, options *armcostmanagement.ViewsClientCreateOrUpdateByScopeOptions) (resp azfake.Responder[armcostmanagement.ViewsClientCreateOrUpdateByScopeResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ViewsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, viewName string, options *armcostmanagement.ViewsClientDeleteOptions) (resp azfake.Responder[armcostmanagement.ViewsClientDeleteResponse], errResp azfake.ErrorResponder)

	// DeleteByScope is the fake for method ViewsClient.DeleteByScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteByScope func(ctx context.Context, scope string, viewName string, options *armcostmanagement.ViewsClientDeleteByScopeOptions) (resp azfake.Responder[armcostmanagement.ViewsClientDeleteByScopeResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ViewsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, viewName string, options *armcostmanagement.ViewsClientGetOptions) (resp azfake.Responder[armcostmanagement.ViewsClientGetResponse], errResp azfake.ErrorResponder)

	// GetByScope is the fake for method ViewsClient.GetByScope
	// HTTP status codes to indicate success: http.StatusOK
	GetByScope func(ctx context.Context, scope string, viewName string, options *armcostmanagement.ViewsClientGetByScopeOptions) (resp azfake.Responder[armcostmanagement.ViewsClientGetByScopeResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ViewsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armcostmanagement.ViewsClientListOptions) (resp azfake.PagerResponder[armcostmanagement.ViewsClientListResponse])

	// NewListByScopePager is the fake for method ViewsClient.NewListByScopePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByScopePager func(scope string, options *armcostmanagement.ViewsClientListByScopeOptions) (resp azfake.PagerResponder[armcostmanagement.ViewsClientListByScopeResponse])
}

// NewViewsServerTransport creates a new instance of ViewsServerTransport with the provided implementation.
// The returned ViewsServerTransport instance is connected to an instance of armcostmanagement.ViewsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewViewsServerTransport(srv *ViewsServer) *ViewsServerTransport {
	return &ViewsServerTransport{
		srv:                 srv,
		newListPager:        newTracker[azfake.PagerResponder[armcostmanagement.ViewsClientListResponse]](),
		newListByScopePager: newTracker[azfake.PagerResponder[armcostmanagement.ViewsClientListByScopeResponse]](),
	}
}

// ViewsServerTransport connects instances of armcostmanagement.ViewsClient to instances of ViewsServer.
// Don't use this type directly, use NewViewsServerTransport instead.
type ViewsServerTransport struct {
	srv                 *ViewsServer
	newListPager        *tracker[azfake.PagerResponder[armcostmanagement.ViewsClientListResponse]]
	newListByScopePager *tracker[azfake.PagerResponder[armcostmanagement.ViewsClientListByScopeResponse]]
}

// Do implements the policy.Transporter interface for ViewsServerTransport.
func (v *ViewsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ViewsClient.CreateOrUpdate":
		resp, err = v.dispatchCreateOrUpdate(req)
	case "ViewsClient.CreateOrUpdateByScope":
		resp, err = v.dispatchCreateOrUpdateByScope(req)
	case "ViewsClient.Delete":
		resp, err = v.dispatchDelete(req)
	case "ViewsClient.DeleteByScope":
		resp, err = v.dispatchDeleteByScope(req)
	case "ViewsClient.Get":
		resp, err = v.dispatchGet(req)
	case "ViewsClient.GetByScope":
		resp, err = v.dispatchGetByScope(req)
	case "ViewsClient.NewListPager":
		resp, err = v.dispatchNewListPager(req)
	case "ViewsClient.NewListByScopePager":
		resp, err = v.dispatchNewListByScopePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *ViewsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if v.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/providers/Microsoft\.CostManagement/views/(?P<viewName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcostmanagement.View](req)
	if err != nil {
		return nil, err
	}
	viewNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("viewName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.CreateOrUpdate(req.Context(), viewNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).View, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *ViewsServerTransport) dispatchCreateOrUpdateByScope(req *http.Request) (*http.Response, error) {
	if v.srv.CreateOrUpdateByScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateByScope not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/views/(?P<viewName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcostmanagement.View](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	viewNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("viewName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.CreateOrUpdateByScope(req.Context(), scopeParam, viewNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).View, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *ViewsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if v.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/providers/Microsoft\.CostManagement/views/(?P<viewName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	viewNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("viewName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Delete(req.Context(), viewNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *ViewsServerTransport) dispatchDeleteByScope(req *http.Request) (*http.Response, error) {
	if v.srv.DeleteByScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteByScope not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/views/(?P<viewName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	viewNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("viewName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.DeleteByScope(req.Context(), scopeParam, viewNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *ViewsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.CostManagement/views/(?P<viewName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	viewNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("viewName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), viewNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).View, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *ViewsServerTransport) dispatchGetByScope(req *http.Request) (*http.Response, error) {
	if v.srv.GetByScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByScope not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/views/(?P<viewName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	viewNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("viewName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.GetByScope(req.Context(), scopeParam, viewNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).View, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *ViewsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := v.newListPager.get(req)
	if newListPager == nil {
		resp := v.srv.NewListPager(nil)
		newListPager = &resp
		v.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armcostmanagement.ViewsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		v.newListPager.remove(req)
	}
	return resp, nil
}

func (v *ViewsServerTransport) dispatchNewListByScopePager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListByScopePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByScopePager not implemented")}
	}
	newListByScopePager := v.newListByScopePager.get(req)
	if newListByScopePager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/views`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListByScopePager(scopeParam, nil)
		newListByScopePager = &resp
		v.newListByScopePager.add(req, newListByScopePager)
		server.PagerResponderInjectNextLinks(newListByScopePager, req, func(page *armcostmanagement.ViewsClientListByScopeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByScopePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListByScopePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByScopePager) {
		v.newListByScopePager.remove(req)
	}
	return resp, nil
}
