//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armfrontdoor

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AzureAsyncOperationResult.
func (a AzureAsyncOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", a.Error)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureAsyncOperationResult.
func (a *AzureAsyncOperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Backend.
func (b Backend) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", b.Address)
	populate(objectMap, "backendHostHeader", b.BackendHostHeader)
	populate(objectMap, "enabledState", b.EnabledState)
	populate(objectMap, "httpPort", b.HTTPPort)
	populate(objectMap, "httpsPort", b.HTTPSPort)
	populate(objectMap, "priority", b.Priority)
	populate(objectMap, "privateEndpointStatus", b.PrivateEndpointStatus)
	populate(objectMap, "privateLinkAlias", b.PrivateLinkAlias)
	populate(objectMap, "privateLinkApprovalMessage", b.PrivateLinkApprovalMessage)
	populate(objectMap, "privateLinkLocation", b.PrivateLinkLocation)
	populate(objectMap, "privateLinkResourceId", b.PrivateLinkResourceID)
	populate(objectMap, "weight", b.Weight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Backend.
func (b *Backend) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &b.Address)
			delete(rawMsg, key)
		case "backendHostHeader":
			err = unpopulate(val, "BackendHostHeader", &b.BackendHostHeader)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &b.EnabledState)
			delete(rawMsg, key)
		case "httpPort":
			err = unpopulate(val, "HTTPPort", &b.HTTPPort)
			delete(rawMsg, key)
		case "httpsPort":
			err = unpopulate(val, "HTTPSPort", &b.HTTPSPort)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &b.Priority)
			delete(rawMsg, key)
		case "privateEndpointStatus":
			err = unpopulate(val, "PrivateEndpointStatus", &b.PrivateEndpointStatus)
			delete(rawMsg, key)
		case "privateLinkAlias":
			err = unpopulate(val, "PrivateLinkAlias", &b.PrivateLinkAlias)
			delete(rawMsg, key)
		case "privateLinkApprovalMessage":
			err = unpopulate(val, "PrivateLinkApprovalMessage", &b.PrivateLinkApprovalMessage)
			delete(rawMsg, key)
		case "privateLinkLocation":
			err = unpopulate(val, "PrivateLinkLocation", &b.PrivateLinkLocation)
			delete(rawMsg, key)
		case "privateLinkResourceId":
			err = unpopulate(val, "PrivateLinkResourceID", &b.PrivateLinkResourceID)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &b.Weight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendPool.
func (b BackendPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendPool.
func (b *BackendPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendPoolListResult.
func (b BackendPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendPoolListResult.
func (b *BackendPoolListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendPoolProperties.
func (b BackendPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backends", b.Backends)
	populate(objectMap, "healthProbeSettings", b.HealthProbeSettings)
	populate(objectMap, "loadBalancingSettings", b.LoadBalancingSettings)
	populate(objectMap, "resourceState", b.ResourceState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendPoolProperties.
func (b *BackendPoolProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backends":
			err = unpopulate(val, "Backends", &b.Backends)
			delete(rawMsg, key)
		case "healthProbeSettings":
			err = unpopulate(val, "HealthProbeSettings", &b.HealthProbeSettings)
			delete(rawMsg, key)
		case "loadBalancingSettings":
			err = unpopulate(val, "LoadBalancingSettings", &b.LoadBalancingSettings)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &b.ResourceState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendPoolUpdateParameters.
func (b BackendPoolUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backends", b.Backends)
	populate(objectMap, "healthProbeSettings", b.HealthProbeSettings)
	populate(objectMap, "loadBalancingSettings", b.LoadBalancingSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendPoolUpdateParameters.
func (b *BackendPoolUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backends":
			err = unpopulate(val, "Backends", &b.Backends)
			delete(rawMsg, key)
		case "healthProbeSettings":
			err = unpopulate(val, "HealthProbeSettings", &b.HealthProbeSettings)
			delete(rawMsg, key)
		case "loadBalancingSettings":
			err = unpopulate(val, "LoadBalancingSettings", &b.LoadBalancingSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendPoolsSettings.
func (b BackendPoolsSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enforceCertificateNameCheck", b.EnforceCertificateNameCheck)
	populate(objectMap, "sendRecvTimeoutSeconds", b.SendRecvTimeoutSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendPoolsSettings.
func (b *BackendPoolsSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enforceCertificateNameCheck":
			err = unpopulate(val, "EnforceCertificateNameCheck", &b.EnforceCertificateNameCheck)
			delete(rawMsg, key)
		case "sendRecvTimeoutSeconds":
			err = unpopulate(val, "SendRecvTimeoutSeconds", &b.SendRecvTimeoutSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheConfiguration.
func (c CacheConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cacheDuration", c.CacheDuration)
	populate(objectMap, "dynamicCompression", c.DynamicCompression)
	populate(objectMap, "queryParameterStripDirective", c.QueryParameterStripDirective)
	populate(objectMap, "queryParameters", c.QueryParameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheConfiguration.
func (c *CacheConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cacheDuration":
			err = unpopulate(val, "CacheDuration", &c.CacheDuration)
			delete(rawMsg, key)
		case "dynamicCompression":
			err = unpopulate(val, "DynamicCompression", &c.DynamicCompression)
			delete(rawMsg, key)
		case "queryParameterStripDirective":
			err = unpopulate(val, "QueryParameterStripDirective", &c.QueryParameterStripDirective)
			delete(rawMsg, key)
		case "queryParameters":
			err = unpopulate(val, "QueryParameters", &c.QueryParameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateSourceParameters.
func (c CertificateSourceParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateType", c.CertificateType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateSourceParameters.
func (c *CertificateSourceParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateType":
			err = unpopulate(val, "CertificateType", &c.CertificateType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityInput.
func (c CheckNameAvailabilityInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityInput.
func (c *CheckNameAvailabilityInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityOutput.
func (c CheckNameAvailabilityOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "nameAvailability", c.NameAvailability)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityOutput.
func (c *CheckNameAvailabilityOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "nameAvailability":
			err = unpopulate(val, "NameAvailability", &c.NameAvailability)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomHTTPSConfiguration.
func (c CustomHTTPSConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateSource", c.CertificateSource)
	populate(objectMap, "frontDoorCertificateSourceParameters", c.FrontDoorCertificateSourceParameters)
	populate(objectMap, "keyVaultCertificateSourceParameters", c.KeyVaultCertificateSourceParameters)
	populate(objectMap, "minimumTlsVersion", c.MinimumTLSVersion)
	populate(objectMap, "protocolType", c.ProtocolType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomHTTPSConfiguration.
func (c *CustomHTTPSConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateSource":
			err = unpopulate(val, "CertificateSource", &c.CertificateSource)
			delete(rawMsg, key)
		case "frontDoorCertificateSourceParameters":
			err = unpopulate(val, "FrontDoorCertificateSourceParameters", &c.FrontDoorCertificateSourceParameters)
			delete(rawMsg, key)
		case "keyVaultCertificateSourceParameters":
			err = unpopulate(val, "KeyVaultCertificateSourceParameters", &c.KeyVaultCertificateSourceParameters)
			delete(rawMsg, key)
		case "minimumTlsVersion":
			err = unpopulate(val, "MinimumTLSVersion", &c.MinimumTLSVersion)
			delete(rawMsg, key)
		case "protocolType":
			err = unpopulate(val, "ProtocolType", &c.ProtocolType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomRule.
func (c CustomRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", c.Action)
	populate(objectMap, "enabledState", c.EnabledState)
	populate(objectMap, "matchConditions", c.MatchConditions)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "priority", c.Priority)
	populate(objectMap, "rateLimitDurationInMinutes", c.RateLimitDurationInMinutes)
	populate(objectMap, "rateLimitThreshold", c.RateLimitThreshold)
	populate(objectMap, "ruleType", c.RuleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomRule.
func (c *CustomRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &c.Action)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &c.EnabledState)
			delete(rawMsg, key)
		case "matchConditions":
			err = unpopulate(val, "MatchConditions", &c.MatchConditions)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &c.Priority)
			delete(rawMsg, key)
		case "rateLimitDurationInMinutes":
			err = unpopulate(val, "RateLimitDurationInMinutes", &c.RateLimitDurationInMinutes)
			delete(rawMsg, key)
		case "rateLimitThreshold":
			err = unpopulate(val, "RateLimitThreshold", &c.RateLimitThreshold)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &c.RuleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomRuleList.
func (c CustomRuleList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "rules", c.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomRuleList.
func (c *CustomRuleList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rules":
			err = unpopulate(val, "Rules", &c.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultErrorResponse.
func (d DefaultErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", d.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultErrorResponse.
func (d *DefaultErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &d.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultErrorResponseError.
func (d DefaultErrorResponseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", d.Code)
	populate(objectMap, "message", d.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultErrorResponseError.
func (d *DefaultErrorResponseError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &d.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &d.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Endpoint.
func (e Endpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpoint", e.Endpoint)
	populate(objectMap, "name", e.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Endpoint.
func (e *Endpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpoint":
			err = unpopulate(val, "Endpoint", &e.Endpoint)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "innerError", e.InnerError)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Error.
func (e *Error) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "innerError":
			err = unpopulate(val, "InnerError", &e.InnerError)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetails.
func (e ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetails.
func (e *ErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Experiment.
func (e Experiment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Experiment.
func (e *Experiment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExperimentList.
func (e ExperimentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExperimentList.
func (e *ExperimentList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExperimentProperties.
func (e ExperimentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "enabledState", e.EnabledState)
	populate(objectMap, "endpointA", e.EndpointA)
	populate(objectMap, "endpointB", e.EndpointB)
	populate(objectMap, "resourceState", e.ResourceState)
	populate(objectMap, "scriptFileUri", e.ScriptFileURI)
	populate(objectMap, "status", e.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExperimentProperties.
func (e *ExperimentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &e.EnabledState)
			delete(rawMsg, key)
		case "endpointA":
			err = unpopulate(val, "EndpointA", &e.EndpointA)
			delete(rawMsg, key)
		case "endpointB":
			err = unpopulate(val, "EndpointB", &e.EndpointB)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &e.ResourceState)
			delete(rawMsg, key)
		case "scriptFileUri":
			err = unpopulate(val, "ScriptFileURI", &e.ScriptFileURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &e.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExperimentUpdateModel.
func (e ExperimentUpdateModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExperimentUpdateModel.
func (e *ExperimentUpdateModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExperimentUpdateProperties.
func (e ExperimentUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "enabledState", e.EnabledState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExperimentUpdateProperties.
func (e *ExperimentUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &e.EnabledState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForwardingConfiguration.
func (f ForwardingConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendPool", f.BackendPool)
	populate(objectMap, "cacheConfiguration", f.CacheConfiguration)
	populate(objectMap, "customForwardingPath", f.CustomForwardingPath)
	populate(objectMap, "forwardingProtocol", f.ForwardingProtocol)
	objectMap["@odata.type"] = "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForwardingConfiguration.
func (f *ForwardingConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendPool":
			err = unpopulate(val, "BackendPool", &f.BackendPool)
			delete(rawMsg, key)
		case "cacheConfiguration":
			err = unpopulate(val, "CacheConfiguration", &f.CacheConfiguration)
			delete(rawMsg, key)
		case "customForwardingPath":
			err = unpopulate(val, "CustomForwardingPath", &f.CustomForwardingPath)
			delete(rawMsg, key)
		case "forwardingProtocol":
			err = unpopulate(val, "ForwardingProtocol", &f.ForwardingProtocol)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &f.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FrontDoor.
func (f FrontDoor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "location", f.Location)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "tags", f.Tags)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FrontDoor.
func (f *FrontDoor) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &f.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &f.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FrontendEndpoint.
func (f FrontendEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FrontendEndpoint.
func (f *FrontendEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FrontendEndpointLink.
func (f FrontendEndpointLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FrontendEndpointLink.
func (f *FrontendEndpointLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FrontendEndpointProperties.
func (f FrontendEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customHttpsConfiguration", f.CustomHTTPSConfiguration)
	populate(objectMap, "customHttpsProvisioningState", f.CustomHTTPSProvisioningState)
	populate(objectMap, "customHttpsProvisioningSubstate", f.CustomHTTPSProvisioningSubstate)
	populate(objectMap, "hostName", f.HostName)
	populate(objectMap, "resourceState", f.ResourceState)
	populate(objectMap, "sessionAffinityEnabledState", f.SessionAffinityEnabledState)
	populate(objectMap, "sessionAffinityTtlSeconds", f.SessionAffinityTTLSeconds)
	populate(objectMap, "webApplicationFirewallPolicyLink", f.WebApplicationFirewallPolicyLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FrontendEndpointProperties.
func (f *FrontendEndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customHttpsConfiguration":
			err = unpopulate(val, "CustomHTTPSConfiguration", &f.CustomHTTPSConfiguration)
			delete(rawMsg, key)
		case "customHttpsProvisioningState":
			err = unpopulate(val, "CustomHTTPSProvisioningState", &f.CustomHTTPSProvisioningState)
			delete(rawMsg, key)
		case "customHttpsProvisioningSubstate":
			err = unpopulate(val, "CustomHTTPSProvisioningSubstate", &f.CustomHTTPSProvisioningSubstate)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &f.HostName)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &f.ResourceState)
			delete(rawMsg, key)
		case "sessionAffinityEnabledState":
			err = unpopulate(val, "SessionAffinityEnabledState", &f.SessionAffinityEnabledState)
			delete(rawMsg, key)
		case "sessionAffinityTtlSeconds":
			err = unpopulate(val, "SessionAffinityTTLSeconds", &f.SessionAffinityTTLSeconds)
			delete(rawMsg, key)
		case "webApplicationFirewallPolicyLink":
			err = unpopulate(val, "WebApplicationFirewallPolicyLink", &f.WebApplicationFirewallPolicyLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FrontendEndpointUpdateParameters.
func (f FrontendEndpointUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostName", f.HostName)
	populate(objectMap, "sessionAffinityEnabledState", f.SessionAffinityEnabledState)
	populate(objectMap, "sessionAffinityTtlSeconds", f.SessionAffinityTTLSeconds)
	populate(objectMap, "webApplicationFirewallPolicyLink", f.WebApplicationFirewallPolicyLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FrontendEndpointUpdateParameters.
func (f *FrontendEndpointUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostName":
			err = unpopulate(val, "HostName", &f.HostName)
			delete(rawMsg, key)
		case "sessionAffinityEnabledState":
			err = unpopulate(val, "SessionAffinityEnabledState", &f.SessionAffinityEnabledState)
			delete(rawMsg, key)
		case "sessionAffinityTtlSeconds":
			err = unpopulate(val, "SessionAffinityTTLSeconds", &f.SessionAffinityTTLSeconds)
			delete(rawMsg, key)
		case "webApplicationFirewallPolicyLink":
			err = unpopulate(val, "WebApplicationFirewallPolicyLink", &f.WebApplicationFirewallPolicyLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink.
func (f FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink.
func (f *FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FrontendEndpointsListResult.
func (f FrontendEndpointsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FrontendEndpointsListResult.
func (f *FrontendEndpointsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HeaderAction.
func (h HeaderAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "headerActionType", h.HeaderActionType)
	populate(objectMap, "headerName", h.HeaderName)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HeaderAction.
func (h *HeaderAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "headerActionType":
			err = unpopulate(val, "HeaderActionType", &h.HeaderActionType)
			delete(rawMsg, key)
		case "headerName":
			err = unpopulate(val, "HeaderName", &h.HeaderName)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthProbeSettingsListResult.
func (h HealthProbeSettingsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", h.NextLink)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthProbeSettingsListResult.
func (h *HealthProbeSettingsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &h.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthProbeSettingsModel.
func (h HealthProbeSettingsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthProbeSettingsModel.
func (h *HealthProbeSettingsModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthProbeSettingsProperties.
func (h HealthProbeSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabledState", h.EnabledState)
	populate(objectMap, "healthProbeMethod", h.HealthProbeMethod)
	populate(objectMap, "intervalInSeconds", h.IntervalInSeconds)
	populate(objectMap, "path", h.Path)
	populate(objectMap, "protocol", h.Protocol)
	populate(objectMap, "resourceState", h.ResourceState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthProbeSettingsProperties.
func (h *HealthProbeSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabledState":
			err = unpopulate(val, "EnabledState", &h.EnabledState)
			delete(rawMsg, key)
		case "healthProbeMethod":
			err = unpopulate(val, "HealthProbeMethod", &h.HealthProbeMethod)
			delete(rawMsg, key)
		case "intervalInSeconds":
			err = unpopulate(val, "IntervalInSeconds", &h.IntervalInSeconds)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &h.Path)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &h.Protocol)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &h.ResourceState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthProbeSettingsUpdateParameters.
func (h HealthProbeSettingsUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabledState", h.EnabledState)
	populate(objectMap, "healthProbeMethod", h.HealthProbeMethod)
	populate(objectMap, "intervalInSeconds", h.IntervalInSeconds)
	populate(objectMap, "path", h.Path)
	populate(objectMap, "protocol", h.Protocol)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthProbeSettingsUpdateParameters.
func (h *HealthProbeSettingsUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabledState":
			err = unpopulate(val, "EnabledState", &h.EnabledState)
			delete(rawMsg, key)
		case "healthProbeMethod":
			err = unpopulate(val, "HealthProbeMethod", &h.HealthProbeMethod)
			delete(rawMsg, key)
		case "intervalInSeconds":
			err = unpopulate(val, "IntervalInSeconds", &h.IntervalInSeconds)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &h.Path)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &h.Protocol)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultCertificateSourceParameters.
func (k KeyVaultCertificateSourceParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secretName", k.SecretName)
	populate(objectMap, "secretVersion", k.SecretVersion)
	populate(objectMap, "vault", k.Vault)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultCertificateSourceParameters.
func (k *KeyVaultCertificateSourceParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secretName":
			err = unpopulate(val, "SecretName", &k.SecretName)
			delete(rawMsg, key)
		case "secretVersion":
			err = unpopulate(val, "SecretVersion", &k.SecretVersion)
			delete(rawMsg, key)
		case "vault":
			err = unpopulate(val, "Vault", &k.Vault)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultCertificateSourceParametersVault.
func (k KeyVaultCertificateSourceParametersVault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", k.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultCertificateSourceParametersVault.
func (k *KeyVaultCertificateSourceParametersVault) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LatencyMetric.
func (l LatencyMetric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aCLower95CI", l.ACLower95CI)
	populate(objectMap, "aHUpper95CI", l.AHUpper95CI)
	populate(objectMap, "aValue", l.AValue)
	populate(objectMap, "bCLower95CI", l.BCLower95CI)
	populate(objectMap, "bUpper95CI", l.BUpper95CI)
	populate(objectMap, "bValue", l.BValue)
	populate(objectMap, "delta", l.Delta)
	populate(objectMap, "deltaPercent", l.DeltaPercent)
	populate(objectMap, "endDateTimeUTC", l.EndDateTimeUTC)
	populate(objectMap, "name", l.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LatencyMetric.
func (l *LatencyMetric) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aCLower95CI":
			err = unpopulate(val, "ACLower95CI", &l.ACLower95CI)
			delete(rawMsg, key)
		case "aHUpper95CI":
			err = unpopulate(val, "AHUpper95CI", &l.AHUpper95CI)
			delete(rawMsg, key)
		case "aValue":
			err = unpopulate(val, "AValue", &l.AValue)
			delete(rawMsg, key)
		case "bCLower95CI":
			err = unpopulate(val, "BCLower95CI", &l.BCLower95CI)
			delete(rawMsg, key)
		case "bUpper95CI":
			err = unpopulate(val, "BUpper95CI", &l.BUpper95CI)
			delete(rawMsg, key)
		case "bValue":
			err = unpopulate(val, "BValue", &l.BValue)
			delete(rawMsg, key)
		case "delta":
			err = unpopulate(val, "Delta", &l.Delta)
			delete(rawMsg, key)
		case "deltaPercent":
			err = unpopulate(val, "DeltaPercent", &l.DeltaPercent)
			delete(rawMsg, key)
		case "endDateTimeUTC":
			err = unpopulate(val, "EndDateTimeUTC", &l.EndDateTimeUTC)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LatencyScorecard.
func (l LatencyScorecard) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LatencyScorecard.
func (l *LatencyScorecard) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LatencyScorecardProperties.
func (l LatencyScorecardProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "country", l.Country)
	populate(objectMap, "description", l.Description)
	populateDateTimeRFC3339(objectMap, "endDateTimeUTC", l.EndDateTimeUTC)
	populate(objectMap, "endpointA", l.EndpointA)
	populate(objectMap, "endpointB", l.EndpointB)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "latencyMetrics", l.LatencyMetrics)
	populate(objectMap, "name", l.Name)
	populateDateTimeRFC3339(objectMap, "startDateTimeUTC", l.StartDateTimeUTC)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LatencyScorecardProperties.
func (l *LatencyScorecardProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "country":
			err = unpopulate(val, "Country", &l.Country)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "endDateTimeUTC":
			err = unpopulateDateTimeRFC3339(val, "EndDateTimeUTC", &l.EndDateTimeUTC)
			delete(rawMsg, key)
		case "endpointA":
			err = unpopulate(val, "EndpointA", &l.EndpointA)
			delete(rawMsg, key)
		case "endpointB":
			err = unpopulate(val, "EndpointB", &l.EndpointB)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "latencyMetrics":
			err = unpopulate(val, "LatencyMetrics", &l.LatencyMetrics)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "startDateTimeUTC":
			err = unpopulateDateTimeRFC3339(val, "StartDateTimeUTC", &l.StartDateTimeUTC)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListResult.
func (l ListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListResult.
func (l *ListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancingSettingsListResult.
func (l LoadBalancingSettingsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancingSettingsListResult.
func (l *LoadBalancingSettingsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancingSettingsModel.
func (l LoadBalancingSettingsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancingSettingsModel.
func (l *LoadBalancingSettingsModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancingSettingsProperties.
func (l LoadBalancingSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalLatencyMilliseconds", l.AdditionalLatencyMilliseconds)
	populate(objectMap, "resourceState", l.ResourceState)
	populate(objectMap, "sampleSize", l.SampleSize)
	populate(objectMap, "successfulSamplesRequired", l.SuccessfulSamplesRequired)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancingSettingsProperties.
func (l *LoadBalancingSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalLatencyMilliseconds":
			err = unpopulate(val, "AdditionalLatencyMilliseconds", &l.AdditionalLatencyMilliseconds)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &l.ResourceState)
			delete(rawMsg, key)
		case "sampleSize":
			err = unpopulate(val, "SampleSize", &l.SampleSize)
			delete(rawMsg, key)
		case "successfulSamplesRequired":
			err = unpopulate(val, "SuccessfulSamplesRequired", &l.SuccessfulSamplesRequired)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancingSettingsUpdateParameters.
func (l LoadBalancingSettingsUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalLatencyMilliseconds", l.AdditionalLatencyMilliseconds)
	populate(objectMap, "sampleSize", l.SampleSize)
	populate(objectMap, "successfulSamplesRequired", l.SuccessfulSamplesRequired)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancingSettingsUpdateParameters.
func (l *LoadBalancingSettingsUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalLatencyMilliseconds":
			err = unpopulate(val, "AdditionalLatencyMilliseconds", &l.AdditionalLatencyMilliseconds)
			delete(rawMsg, key)
		case "sampleSize":
			err = unpopulate(val, "SampleSize", &l.SampleSize)
			delete(rawMsg, key)
		case "successfulSamplesRequired":
			err = unpopulate(val, "SuccessfulSamplesRequired", &l.SuccessfulSamplesRequired)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleDefinition.
func (m ManagedRuleDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultAction", m.DefaultAction)
	populate(objectMap, "defaultState", m.DefaultState)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "ruleId", m.RuleID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleDefinition.
func (m *ManagedRuleDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultAction":
			err = unpopulate(val, "DefaultAction", &m.DefaultAction)
			delete(rawMsg, key)
		case "defaultState":
			err = unpopulate(val, "DefaultState", &m.DefaultState)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "ruleId":
			err = unpopulate(val, "RuleID", &m.RuleID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleExclusion.
func (m ManagedRuleExclusion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchVariable", m.MatchVariable)
	populate(objectMap, "selector", m.Selector)
	populate(objectMap, "selectorMatchOperator", m.SelectorMatchOperator)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleExclusion.
func (m *ManagedRuleExclusion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchVariable":
			err = unpopulate(val, "MatchVariable", &m.MatchVariable)
			delete(rawMsg, key)
		case "selector":
			err = unpopulate(val, "Selector", &m.Selector)
			delete(rawMsg, key)
		case "selectorMatchOperator":
			err = unpopulate(val, "SelectorMatchOperator", &m.SelectorMatchOperator)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleGroupDefinition.
func (m ManagedRuleGroupDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "ruleGroupName", m.RuleGroupName)
	populate(objectMap, "rules", m.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleGroupDefinition.
func (m *ManagedRuleGroupDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "ruleGroupName":
			err = unpopulate(val, "RuleGroupName", &m.RuleGroupName)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &m.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleGroupOverride.
func (m ManagedRuleGroupOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exclusions", m.Exclusions)
	populate(objectMap, "ruleGroupName", m.RuleGroupName)
	populate(objectMap, "rules", m.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleGroupOverride.
func (m *ManagedRuleGroupOverride) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exclusions":
			err = unpopulate(val, "Exclusions", &m.Exclusions)
			delete(rawMsg, key)
		case "ruleGroupName":
			err = unpopulate(val, "RuleGroupName", &m.RuleGroupName)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &m.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleOverride.
func (m ManagedRuleOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", m.Action)
	populate(objectMap, "enabledState", m.EnabledState)
	populate(objectMap, "exclusions", m.Exclusions)
	populate(objectMap, "ruleId", m.RuleID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleOverride.
func (m *ManagedRuleOverride) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &m.Action)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &m.EnabledState)
			delete(rawMsg, key)
		case "exclusions":
			err = unpopulate(val, "Exclusions", &m.Exclusions)
			delete(rawMsg, key)
		case "ruleId":
			err = unpopulate(val, "RuleID", &m.RuleID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleSet.
func (m ManagedRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exclusions", m.Exclusions)
	populate(objectMap, "ruleGroupOverrides", m.RuleGroupOverrides)
	populate(objectMap, "ruleSetAction", m.RuleSetAction)
	populate(objectMap, "ruleSetType", m.RuleSetType)
	populate(objectMap, "ruleSetVersion", m.RuleSetVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleSet.
func (m *ManagedRuleSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exclusions":
			err = unpopulate(val, "Exclusions", &m.Exclusions)
			delete(rawMsg, key)
		case "ruleGroupOverrides":
			err = unpopulate(val, "RuleGroupOverrides", &m.RuleGroupOverrides)
			delete(rawMsg, key)
		case "ruleSetAction":
			err = unpopulate(val, "RuleSetAction", &m.RuleSetAction)
			delete(rawMsg, key)
		case "ruleSetType":
			err = unpopulate(val, "RuleSetType", &m.RuleSetType)
			delete(rawMsg, key)
		case "ruleSetVersion":
			err = unpopulate(val, "RuleSetVersion", &m.RuleSetVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleSetDefinition.
func (m ManagedRuleSetDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleSetDefinition.
func (m *ManagedRuleSetDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleSetDefinitionList.
func (m ManagedRuleSetDefinitionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleSetDefinitionList.
func (m *ManagedRuleSetDefinitionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleSetDefinitionProperties.
func (m ManagedRuleSetDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "ruleGroups", m.RuleGroups)
	populate(objectMap, "ruleSetId", m.RuleSetID)
	populate(objectMap, "ruleSetType", m.RuleSetType)
	populate(objectMap, "ruleSetVersion", m.RuleSetVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleSetDefinitionProperties.
func (m *ManagedRuleSetDefinitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "ruleGroups":
			err = unpopulate(val, "RuleGroups", &m.RuleGroups)
			delete(rawMsg, key)
		case "ruleSetId":
			err = unpopulate(val, "RuleSetID", &m.RuleSetID)
			delete(rawMsg, key)
		case "ruleSetType":
			err = unpopulate(val, "RuleSetType", &m.RuleSetType)
			delete(rawMsg, key)
		case "ruleSetVersion":
			err = unpopulate(val, "RuleSetVersion", &m.RuleSetVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleSetList.
func (m ManagedRuleSetList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "managedRuleSets", m.ManagedRuleSets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleSetList.
func (m *ManagedRuleSetList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "managedRuleSets":
			err = unpopulate(val, "ManagedRuleSets", &m.ManagedRuleSets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MatchCondition.
func (m MatchCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValue", m.MatchValue)
	populate(objectMap, "matchVariable", m.MatchVariable)
	populate(objectMap, "negateCondition", m.NegateCondition)
	populate(objectMap, "operator", m.Operator)
	populate(objectMap, "selector", m.Selector)
	populate(objectMap, "transforms", m.Transforms)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MatchCondition.
func (m *MatchCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValue":
			err = unpopulate(val, "MatchValue", &m.MatchValue)
			delete(rawMsg, key)
		case "matchVariable":
			err = unpopulate(val, "MatchVariable", &m.MatchVariable)
			delete(rawMsg, key)
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &m.NegateCondition)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &m.Operator)
			delete(rawMsg, key)
		case "selector":
			err = unpopulate(val, "Selector", &m.Selector)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &m.Transforms)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicySettings.
func (p PolicySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customBlockResponseBody", p.CustomBlockResponseBody)
	populate(objectMap, "customBlockResponseStatusCode", p.CustomBlockResponseStatusCode)
	populate(objectMap, "enabledState", p.EnabledState)
	populate(objectMap, "mode", p.Mode)
	populate(objectMap, "redirectUrl", p.RedirectURL)
	populate(objectMap, "requestBodyCheck", p.RequestBodyCheck)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicySettings.
func (p *PolicySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customBlockResponseBody":
			err = unpopulate(val, "CustomBlockResponseBody", &p.CustomBlockResponseBody)
			delete(rawMsg, key)
		case "customBlockResponseStatusCode":
			err = unpopulate(val, "CustomBlockResponseStatusCode", &p.CustomBlockResponseStatusCode)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &p.EnabledState)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &p.Mode)
			delete(rawMsg, key)
		case "redirectUrl":
			err = unpopulate(val, "RedirectURL", &p.RedirectURL)
			delete(rawMsg, key)
		case "requestBodyCheck":
			err = unpopulate(val, "RequestBodyCheck", &p.RequestBodyCheck)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PreconfiguredEndpoint.
func (p PreconfiguredEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PreconfiguredEndpoint.
func (p *PreconfiguredEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PreconfiguredEndpointList.
func (p PreconfiguredEndpointList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PreconfiguredEndpointList.
func (p *PreconfiguredEndpointList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PreconfiguredEndpointProperties.
func (p PreconfiguredEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backend", p.Backend)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "endpoint", p.Endpoint)
	populate(objectMap, "endpointType", p.EndpointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PreconfiguredEndpointProperties.
func (p *PreconfiguredEndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backend":
			err = unpopulate(val, "Backend", &p.Backend)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &p.Endpoint)
			delete(rawMsg, key)
		case "endpointType":
			err = unpopulate(val, "EndpointType", &p.EndpointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Profile.
func (p Profile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Profile.
func (p *Profile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileList.
func (p ProfileList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileList.
func (p *ProfileList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileProperties.
func (p ProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabledState", p.EnabledState)
	populate(objectMap, "resourceState", p.ResourceState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileProperties.
func (p *ProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabledState":
			err = unpopulate(val, "EnabledState", &p.EnabledState)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &p.ResourceState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileUpdateModel.
func (p ProfileUpdateModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileUpdateModel.
func (p *ProfileUpdateModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileUpdateProperties.
func (p ProfileUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabledState", p.EnabledState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileUpdateProperties.
func (p *ProfileUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabledState":
			err = unpopulate(val, "EnabledState", &p.EnabledState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendPools", p.BackendPools)
	populate(objectMap, "backendPoolsSettings", p.BackendPoolsSettings)
	populate(objectMap, "cname", p.Cname)
	populate(objectMap, "enabledState", p.EnabledState)
	populate(objectMap, "extendedProperties", p.ExtendedProperties)
	populate(objectMap, "friendlyName", p.FriendlyName)
	populate(objectMap, "frontdoorId", p.FrontdoorID)
	populate(objectMap, "frontendEndpoints", p.FrontendEndpoints)
	populate(objectMap, "healthProbeSettings", p.HealthProbeSettings)
	populate(objectMap, "loadBalancingSettings", p.LoadBalancingSettings)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "resourceState", p.ResourceState)
	populate(objectMap, "routingRules", p.RoutingRules)
	populate(objectMap, "rulesEngines", p.RulesEngines)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Properties.
func (p *Properties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendPools":
			err = unpopulate(val, "BackendPools", &p.BackendPools)
			delete(rawMsg, key)
		case "backendPoolsSettings":
			err = unpopulate(val, "BackendPoolsSettings", &p.BackendPoolsSettings)
			delete(rawMsg, key)
		case "cname":
			err = unpopulate(val, "Cname", &p.Cname)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &p.EnabledState)
			delete(rawMsg, key)
		case "extendedProperties":
			err = unpopulate(val, "ExtendedProperties", &p.ExtendedProperties)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &p.FriendlyName)
			delete(rawMsg, key)
		case "frontdoorId":
			err = unpopulate(val, "FrontdoorID", &p.FrontdoorID)
			delete(rawMsg, key)
		case "frontendEndpoints":
			err = unpopulate(val, "FrontendEndpoints", &p.FrontendEndpoints)
			delete(rawMsg, key)
		case "healthProbeSettings":
			err = unpopulate(val, "HealthProbeSettings", &p.HealthProbeSettings)
			delete(rawMsg, key)
		case "loadBalancingSettings":
			err = unpopulate(val, "LoadBalancingSettings", &p.LoadBalancingSettings)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &p.ResourceState)
			delete(rawMsg, key)
		case "routingRules":
			err = unpopulate(val, "RoutingRules", &p.RoutingRules)
			delete(rawMsg, key)
		case "rulesEngines":
			err = unpopulate(val, "RulesEngines", &p.RulesEngines)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PurgeParameters.
func (p PurgeParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentPaths", p.ContentPaths)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PurgeParameters.
func (p *PurgeParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentPaths":
			err = unpopulate(val, "ContentPaths", &p.ContentPaths)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RedirectConfiguration.
func (r RedirectConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customFragment", r.CustomFragment)
	populate(objectMap, "customHost", r.CustomHost)
	populate(objectMap, "customPath", r.CustomPath)
	populate(objectMap, "customQueryString", r.CustomQueryString)
	objectMap["@odata.type"] = "#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration"
	populate(objectMap, "redirectProtocol", r.RedirectProtocol)
	populate(objectMap, "redirectType", r.RedirectType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RedirectConfiguration.
func (r *RedirectConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customFragment":
			err = unpopulate(val, "CustomFragment", &r.CustomFragment)
			delete(rawMsg, key)
		case "customHost":
			err = unpopulate(val, "CustomHost", &r.CustomHost)
			delete(rawMsg, key)
		case "customPath":
			err = unpopulate(val, "CustomPath", &r.CustomPath)
			delete(rawMsg, key)
		case "customQueryString":
			err = unpopulate(val, "CustomQueryString", &r.CustomQueryString)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &r.ODataType)
			delete(rawMsg, key)
		case "redirectProtocol":
			err = unpopulate(val, "RedirectProtocol", &r.RedirectProtocol)
			delete(rawMsg, key)
		case "redirectType":
			err = unpopulate(val, "RedirectType", &r.RedirectType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteConfiguration.
func (r RouteConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["@odata.type"] = r.ODataType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteConfiguration.
func (r *RouteConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "@odata.type":
			err = unpopulate(val, "ODataType", &r.ODataType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingRule.
func (r RoutingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingRule.
func (r *RoutingRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingRuleLink.
func (r RoutingRuleLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingRuleLink.
func (r *RoutingRuleLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingRuleListResult.
func (r RoutingRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingRuleListResult.
func (r *RoutingRuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingRuleProperties.
func (r RoutingRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acceptedProtocols", r.AcceptedProtocols)
	populate(objectMap, "enabledState", r.EnabledState)
	populate(objectMap, "frontendEndpoints", r.FrontendEndpoints)
	populate(objectMap, "patternsToMatch", r.PatternsToMatch)
	populate(objectMap, "resourceState", r.ResourceState)
	populate(objectMap, "routeConfiguration", r.RouteConfiguration)
	populate(objectMap, "rulesEngine", r.RulesEngine)
	populate(objectMap, "webApplicationFirewallPolicyLink", r.WebApplicationFirewallPolicyLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingRuleProperties.
func (r *RoutingRuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acceptedProtocols":
			err = unpopulate(val, "AcceptedProtocols", &r.AcceptedProtocols)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &r.EnabledState)
			delete(rawMsg, key)
		case "frontendEndpoints":
			err = unpopulate(val, "FrontendEndpoints", &r.FrontendEndpoints)
			delete(rawMsg, key)
		case "patternsToMatch":
			err = unpopulate(val, "PatternsToMatch", &r.PatternsToMatch)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &r.ResourceState)
			delete(rawMsg, key)
		case "routeConfiguration":
			r.RouteConfiguration, err = unmarshalRouteConfigurationClassification(val)
			delete(rawMsg, key)
		case "rulesEngine":
			err = unpopulate(val, "RulesEngine", &r.RulesEngine)
			delete(rawMsg, key)
		case "webApplicationFirewallPolicyLink":
			err = unpopulate(val, "WebApplicationFirewallPolicyLink", &r.WebApplicationFirewallPolicyLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingRuleUpdateParameters.
func (r RoutingRuleUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acceptedProtocols", r.AcceptedProtocols)
	populate(objectMap, "enabledState", r.EnabledState)
	populate(objectMap, "frontendEndpoints", r.FrontendEndpoints)
	populate(objectMap, "patternsToMatch", r.PatternsToMatch)
	populate(objectMap, "routeConfiguration", r.RouteConfiguration)
	populate(objectMap, "rulesEngine", r.RulesEngine)
	populate(objectMap, "webApplicationFirewallPolicyLink", r.WebApplicationFirewallPolicyLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingRuleUpdateParameters.
func (r *RoutingRuleUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acceptedProtocols":
			err = unpopulate(val, "AcceptedProtocols", &r.AcceptedProtocols)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &r.EnabledState)
			delete(rawMsg, key)
		case "frontendEndpoints":
			err = unpopulate(val, "FrontendEndpoints", &r.FrontendEndpoints)
			delete(rawMsg, key)
		case "patternsToMatch":
			err = unpopulate(val, "PatternsToMatch", &r.PatternsToMatch)
			delete(rawMsg, key)
		case "routeConfiguration":
			r.RouteConfiguration, err = unmarshalRouteConfigurationClassification(val)
			delete(rawMsg, key)
		case "rulesEngine":
			err = unpopulate(val, "RulesEngine", &r.RulesEngine)
			delete(rawMsg, key)
		case "webApplicationFirewallPolicyLink":
			err = unpopulate(val, "WebApplicationFirewallPolicyLink", &r.WebApplicationFirewallPolicyLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink.
func (r RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink.
func (r *RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RulesEngine.
func (r RulesEngine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RulesEngine.
func (r *RulesEngine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RulesEngineAction.
func (r RulesEngineAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "requestHeaderActions", r.RequestHeaderActions)
	populate(objectMap, "responseHeaderActions", r.ResponseHeaderActions)
	populate(objectMap, "routeConfigurationOverride", r.RouteConfigurationOverride)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RulesEngineAction.
func (r *RulesEngineAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "requestHeaderActions":
			err = unpopulate(val, "RequestHeaderActions", &r.RequestHeaderActions)
			delete(rawMsg, key)
		case "responseHeaderActions":
			err = unpopulate(val, "ResponseHeaderActions", &r.ResponseHeaderActions)
			delete(rawMsg, key)
		case "routeConfigurationOverride":
			r.RouteConfigurationOverride, err = unmarshalRouteConfigurationClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RulesEngineListResult.
func (r RulesEngineListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RulesEngineListResult.
func (r *RulesEngineListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RulesEngineMatchCondition.
func (r RulesEngineMatchCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "negateCondition", r.NegateCondition)
	populate(objectMap, "rulesEngineMatchValue", r.RulesEngineMatchValue)
	populate(objectMap, "rulesEngineMatchVariable", r.RulesEngineMatchVariable)
	populate(objectMap, "rulesEngineOperator", r.RulesEngineOperator)
	populate(objectMap, "selector", r.Selector)
	populate(objectMap, "transforms", r.Transforms)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RulesEngineMatchCondition.
func (r *RulesEngineMatchCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "negateCondition":
			err = unpopulate(val, "NegateCondition", &r.NegateCondition)
			delete(rawMsg, key)
		case "rulesEngineMatchValue":
			err = unpopulate(val, "RulesEngineMatchValue", &r.RulesEngineMatchValue)
			delete(rawMsg, key)
		case "rulesEngineMatchVariable":
			err = unpopulate(val, "RulesEngineMatchVariable", &r.RulesEngineMatchVariable)
			delete(rawMsg, key)
		case "rulesEngineOperator":
			err = unpopulate(val, "RulesEngineOperator", &r.RulesEngineOperator)
			delete(rawMsg, key)
		case "selector":
			err = unpopulate(val, "Selector", &r.Selector)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &r.Transforms)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RulesEngineProperties.
func (r RulesEngineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceState", r.ResourceState)
	populate(objectMap, "rules", r.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RulesEngineProperties.
func (r *RulesEngineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceState":
			err = unpopulate(val, "ResourceState", &r.ResourceState)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &r.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RulesEngineRule.
func (r RulesEngineRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", r.Action)
	populate(objectMap, "matchConditions", r.MatchConditions)
	populate(objectMap, "matchProcessingBehavior", r.MatchProcessingBehavior)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "priority", r.Priority)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RulesEngineRule.
func (r *RulesEngineRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &r.Action)
			delete(rawMsg, key)
		case "matchConditions":
			err = unpopulate(val, "MatchConditions", &r.MatchConditions)
			delete(rawMsg, key)
		case "matchProcessingBehavior":
			err = unpopulate(val, "MatchProcessingBehavior", &r.MatchProcessingBehavior)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &r.Priority)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RulesEngineUpdateParameters.
func (r RulesEngineUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "rules", r.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RulesEngineUpdateParameters.
func (r *RulesEngineUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rules":
			err = unpopulate(val, "Rules", &r.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPolicyLink.
func (s SecurityPolicyLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPolicyLink.
func (s *SecurityPolicyLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubResource.
func (s SubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubResource.
func (s *SubResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsObject.
func (t TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagsObject.
func (t *TagsObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Timeseries.
func (t Timeseries) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Timeseries.
func (t *Timeseries) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TimeseriesDataPoint.
func (t TimeseriesDataPoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dateTimeUTC", t.DateTimeUTC)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TimeseriesDataPoint.
func (t *TimeseriesDataPoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateTimeUTC":
			err = unpopulate(val, "DateTimeUTC", &t.DateTimeUTC)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TimeseriesProperties.
func (t TimeseriesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationInterval", t.AggregationInterval)
	populate(objectMap, "country", t.Country)
	populate(objectMap, "endDateTimeUTC", t.EndDateTimeUTC)
	populate(objectMap, "endpoint", t.Endpoint)
	populate(objectMap, "startDateTimeUTC", t.StartDateTimeUTC)
	populate(objectMap, "timeseriesData", t.TimeseriesData)
	populate(objectMap, "timeseriesType", t.TimeseriesType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TimeseriesProperties.
func (t *TimeseriesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationInterval":
			err = unpopulate(val, "AggregationInterval", &t.AggregationInterval)
			delete(rawMsg, key)
		case "country":
			err = unpopulate(val, "Country", &t.Country)
			delete(rawMsg, key)
		case "endDateTimeUTC":
			err = unpopulate(val, "EndDateTimeUTC", &t.EndDateTimeUTC)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &t.Endpoint)
			delete(rawMsg, key)
		case "startDateTimeUTC":
			err = unpopulate(val, "StartDateTimeUTC", &t.StartDateTimeUTC)
			delete(rawMsg, key)
		case "timeseriesData":
			err = unpopulate(val, "TimeseriesData", &t.TimeseriesData)
			delete(rawMsg, key)
		case "timeseriesType":
			err = unpopulate(val, "TimeseriesType", &t.TimeseriesType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateParameters.
func (u UpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendPools", u.BackendPools)
	populate(objectMap, "backendPoolsSettings", u.BackendPoolsSettings)
	populate(objectMap, "enabledState", u.EnabledState)
	populate(objectMap, "friendlyName", u.FriendlyName)
	populate(objectMap, "frontendEndpoints", u.FrontendEndpoints)
	populate(objectMap, "healthProbeSettings", u.HealthProbeSettings)
	populate(objectMap, "loadBalancingSettings", u.LoadBalancingSettings)
	populate(objectMap, "routingRules", u.RoutingRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateParameters.
func (u *UpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendPools":
			err = unpopulate(val, "BackendPools", &u.BackendPools)
			delete(rawMsg, key)
		case "backendPoolsSettings":
			err = unpopulate(val, "BackendPoolsSettings", &u.BackendPoolsSettings)
			delete(rawMsg, key)
		case "enabledState":
			err = unpopulate(val, "EnabledState", &u.EnabledState)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &u.FriendlyName)
			delete(rawMsg, key)
		case "frontendEndpoints":
			err = unpopulate(val, "FrontendEndpoints", &u.FrontendEndpoints)
			delete(rawMsg, key)
		case "healthProbeSettings":
			err = unpopulate(val, "HealthProbeSettings", &u.HealthProbeSettings)
			delete(rawMsg, key)
		case "loadBalancingSettings":
			err = unpopulate(val, "LoadBalancingSettings", &u.LoadBalancingSettings)
			delete(rawMsg, key)
		case "routingRules":
			err = unpopulate(val, "RoutingRules", &u.RoutingRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateCustomDomainInput.
func (v ValidateCustomDomainInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostName", v.HostName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateCustomDomainInput.
func (v *ValidateCustomDomainInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostName":
			err = unpopulate(val, "HostName", &v.HostName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateCustomDomainOutput.
func (v ValidateCustomDomainOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customDomainValidated", v.CustomDomainValidated)
	populate(objectMap, "message", v.Message)
	populate(objectMap, "reason", v.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateCustomDomainOutput.
func (v *ValidateCustomDomainOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customDomainValidated":
			err = unpopulate(val, "CustomDomainValidated", &v.CustomDomainValidated)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &v.Message)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &v.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebApplicationFirewallPolicy.
func (w WebApplicationFirewallPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", w.Etag)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebApplicationFirewallPolicy.
func (w *WebApplicationFirewallPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &w.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &w.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebApplicationFirewallPolicyList.
func (w WebApplicationFirewallPolicyList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebApplicationFirewallPolicyList.
func (w *WebApplicationFirewallPolicyList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebApplicationFirewallPolicyProperties.
func (w WebApplicationFirewallPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customRules", w.CustomRules)
	populate(objectMap, "frontendEndpointLinks", w.FrontendEndpointLinks)
	populate(objectMap, "managedRules", w.ManagedRules)
	populate(objectMap, "policySettings", w.PolicySettings)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "resourceState", w.ResourceState)
	populate(objectMap, "routingRuleLinks", w.RoutingRuleLinks)
	populate(objectMap, "securityPolicyLinks", w.SecurityPolicyLinks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebApplicationFirewallPolicyProperties.
func (w *WebApplicationFirewallPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customRules":
			err = unpopulate(val, "CustomRules", &w.CustomRules)
			delete(rawMsg, key)
		case "frontendEndpointLinks":
			err = unpopulate(val, "FrontendEndpointLinks", &w.FrontendEndpointLinks)
			delete(rawMsg, key)
		case "managedRules":
			err = unpopulate(val, "ManagedRules", &w.ManagedRules)
			delete(rawMsg, key)
		case "policySettings":
			err = unpopulate(val, "PolicySettings", &w.PolicySettings)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "resourceState":
			err = unpopulate(val, "ResourceState", &w.ResourceState)
			delete(rawMsg, key)
		case "routingRuleLinks":
			err = unpopulate(val, "RoutingRuleLinks", &w.RoutingRuleLinks)
			delete(rawMsg, key)
		case "securityPolicyLinks":
			err = unpopulate(val, "SecurityPolicyLinks", &w.SecurityPolicyLinks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
