//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridcompute

import "time"

// AgentConfiguration - Configurable properties that the user can set locally via the azcmagent config command, or remotely
// via ARM.
type AgentConfiguration struct {
	// READ-ONLY; Name of configuration mode to use. Modes are pre-defined configurations of security controls, extension allowlists
	// and guest configuration, maintained by Microsoft.
	ConfigMode *AgentConfigurationMode

	// READ-ONLY; Array of extensions that are allowed to be installed or updated.
	ExtensionsAllowList []*ConfigurationExtension

	// READ-ONLY; Array of extensions that are blocked (cannot be installed or updated)
	ExtensionsBlockList []*ConfigurationExtension

	// READ-ONLY; Specifies whether the extension service is enabled or disabled.
	ExtensionsEnabled *string

	// READ-ONLY; Specified whether the guest configuration service is enabled or disabled.
	GuestConfigurationEnabled *string

	// READ-ONLY; Specifies the list of ports that the agent will be able to listen on.
	IncomingConnectionsPorts []*string

	// READ-ONLY; List of service names which should not use the specified proxy server.
	ProxyBypass []*string

	// READ-ONLY; Specifies the URL of the proxy to be used.
	ProxyURL *string
}

// AgentUpgrade - The info w.r.t Agent Upgrade.
type AgentUpgrade struct {
	// The correlation ID passed in from RSM per upgrade.
	CorrelationID *string

	// Specifies the version info w.r.t AgentUpgrade for the machine.
	DesiredVersion *string

	// Specifies if RSM should try to upgrade this machine
	EnableAutomaticUpgrade *bool

	// READ-ONLY; Specifies the version of the last attempt
	LastAttemptDesiredVersion *string

	// READ-ONLY; Failure message of last upgrade attempt if any.
	LastAttemptMessage *string

	// READ-ONLY; Specifies the status of Agent Upgrade.
	LastAttemptStatus *LastAttemptStatusEnum

	// READ-ONLY; Timestamp of last upgrade attempt
	LastAttemptTimestamp *string
}

// AgentVersion - Describes properties of Agent Version.
type AgentVersion struct {
	// Represents the agent version.
	AgentVersion *string

	// Represents the download link of specific agent version.
	DownloadLink *string

	// Defines the os type.
	OSType *string
}

// AgentVersionsList - Describes AgentVersions List.
type AgentVersionsList struct {
	// The URI to fetch the next 10 available Agent Versions.
	NextLink *string

	// The list of available Agent Versions.
	Value []*AgentVersion
}

// AvailablePatchCountByClassification - Summarization of patches available for installation on the machine by classification.
type AvailablePatchCountByClassification struct {
	// READ-ONLY; Number of critical patches available for installation.
	Critical *int32

	// READ-ONLY; Number of definition patches available for installation.
	Definition *int32

	// READ-ONLY; Number of feature pack patches available for installation.
	FeaturePack *int32

	// READ-ONLY; Number of other patches available for installation.
	Other *int32

	// READ-ONLY; Number of security patches available for installation.
	Security *int32

	// READ-ONLY; Number of service pack patches available for installation.
	ServicePack *int32

	// READ-ONLY; Number of tools patches available for installation.
	Tools *int32

	// READ-ONLY; Number of update Rollup patches available for installation.
	UpdateRollup *int32

	// READ-ONLY; Number of updates category patches available for installation.
	Updates *int32
}

// CloudMetadata - The metadata of the cloud environment (Azure/GCP/AWS/OCI…).
type CloudMetadata struct {
	// READ-ONLY; Specifies the cloud provider (Azure/AWS/GCP…).
	Provider *string
}

// ConfigurationExtension - Describes properties that can identify extensions.
type ConfigurationExtension struct {
	// READ-ONLY; Publisher of the extension.
	Publisher *string

	// READ-ONLY; Type of the extension.
	Type *string
}

type ConnectionDetail struct {
	// READ-ONLY; The private endpoint connection group id
	GroupID *string

	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; The private endpoint connection link identifier
	LinkIdentifier *string

	// READ-ONLY; The private endpoint connection member name
	MemberName *string

	// READ-ONLY; The private endpoint connection private ip address
	PrivateIPAddress *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// EsuKey - ESU key
type EsuKey struct {
	// The current status of the license profile key.
	LicenseStatus *string

	// SKU number.
	SKU *string
}

// EsuProfileUpdateProperties - Describes the Update properties of a License Profile.
type EsuProfileUpdateProperties struct {
	// The resource id of the license.
	AssignedLicense *string
}

// ExtensionTargetProperties - Describes the Machine Extension Target Version Properties
type ExtensionTargetProperties struct {
	// Properties for the specified Extension to Upgrade.
	TargetVersion *string
}

// ExtensionValue - Describes a Extension Metadata
type ExtensionValue struct {
	// The single extension based on search criteria
	Properties *ExtensionValueProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ExtensionValueListResult - The List Extension Metadata response.
type ExtensionValueListResult struct {
	// READ-ONLY; The list of extension metadata
	Value []*ExtensionValue
}

// ExtensionValueProperties - Describes Extension Metadata properties
type ExtensionValueProperties struct {
	// READ-ONLY; The type of the Extension being received.
	ExtensionType *string

	// READ-ONLY; The publisher of the Extension being received.
	Publisher *string

	// READ-ONLY; The version of the Extension being received.
	Version *string
}

// HybridIdentityMetadata - Defines the HybridIdentityMetadata.
type HybridIdentityMetadata struct {
	// REQUIRED; Resource properties.
	Properties *HybridIdentityMetadataProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// HybridIdentityMetadataList - List of HybridIdentityMetadata.
type HybridIdentityMetadataList struct {
	// REQUIRED; Array of HybridIdentityMetadata
	Value []*HybridIdentityMetadata

	// Url to follow for getting next page of HybridIdentityMetadata.
	NextLink *string
}

// HybridIdentityMetadataProperties - Defines the resource properties.
type HybridIdentityMetadataProperties struct {
	// The Public Key.
	PublicKey *string

	// The unique identifier for the resource.
	VMID *string

	// READ-ONLY; Identity for the resource.
	Identity *Identity
}

// IPAddress - Describes properties of the IP address.
type IPAddress struct {
	// Represents the IP Address.
	Address *string

	// Represents the Ip Address Version.
	IPAddressVersion *string

	// READ-ONLY; The subnet to which this IP address belongs.
	Subnet *Subnet
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *string

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// License - Describes a license in a hybrid machine.
type License struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Hybrid Compute License properties
	Properties *LicenseProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LicenseDetails - Describes the properties of a License.
type LicenseDetails struct {
	// Describes the edition of the license. The values are either Standard or Datacenter.
	Edition *LicenseEdition

	// Describes the number of processors.
	Processors *int32

	// Describes the state of the license.
	State *LicenseState

	// Describes the license target server.
	Target *LicenseTarget

	// Describes the license core type (pCore or vCore).
	Type *LicenseCoreType

	// READ-ONLY; Describes the number of assigned licenses.
	AssignedLicenses *int32

	// READ-ONLY; Describes the immutable id.
	ImmutableID *string
}

// LicenseProfile - Describes a license profile in a hybrid machine.
type LicenseProfile struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Describe the properties of a license profile.
	Properties *LicenseProfileProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LicenseProfileArmEsuProperties - Describes the properties of a License Profile ARM model.
type LicenseProfileArmEsuProperties struct {
	// The resource id of the license.
	AssignedLicense *string

	// READ-ONLY; The guid id of the license.
	AssignedLicenseImmutableID *string

	// READ-ONLY; Indicates the eligibility state of Esu.
	EsuEligibility *EsuEligibility

	// READ-ONLY; Indicates whether there is an ESU Key currently active for the machine.
	EsuKeyState *EsuKeyState

	// READ-ONLY; The list of ESU keys.
	EsuKeys []*EsuKey

	// READ-ONLY; The type of the Esu servers.
	ServerType *EsuServerType
}

// LicenseProfileMachineInstanceView - License Profile Instance View in Machine Properties.
type LicenseProfileMachineInstanceView struct {
	// Properties for the Machine ESU profile.
	EsuProfile *LicenseProfileMachineInstanceViewEsuProperties
}

// LicenseProfileMachineInstanceViewEsuProperties - Properties for the Machine ESU profile.
type LicenseProfileMachineInstanceViewEsuProperties struct {
	// The assigned license resource.
	AssignedLicense *License

	// Describes the license assignment state (Assigned or NotAssigned).
	LicenseAssignmentState *LicenseAssignmentState

	// READ-ONLY; The guid id of the license.
	AssignedLicenseImmutableID *string

	// READ-ONLY; Indicates the eligibility state of Esu.
	EsuEligibility *EsuEligibility

	// READ-ONLY; Indicates whether there is an ESU Key currently active for the machine.
	EsuKeyState *EsuKeyState

	// READ-ONLY; The list of ESU keys.
	EsuKeys []*EsuKey

	// READ-ONLY; The type of the Esu servers.
	ServerType *EsuServerType
}

// LicenseProfileProperties - Describe the properties of a license profile.
type LicenseProfileProperties struct {
	// Hybrid Compute ESU Profile properties
	EsuProfile *LicenseProfileArmEsuProperties

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *ProvisioningState
}

// LicenseProfileUpdate - Describes a License Profile Update.
type LicenseProfileUpdate struct {
	// Describe the Update properties of a license profile.
	Properties *LicenseProfileUpdateProperties

	// Resource tags
	Tags map[string]*string
}

// LicenseProfileUpdateProperties - Describe the Update properties of a license profile.
type LicenseProfileUpdateProperties struct {
	// Hybrid Compute ESU Profile Update properties
	EsuProfile *EsuProfileUpdateProperties
}

// LicenseProfilesListResult - The List hybrid machine license profile operation response.
type LicenseProfilesListResult struct {
	// REQUIRED; The list of license profiles.
	Value []*LicenseProfile

	// The URI to fetch the next page of Machines. Call ListNext() with this URI to fetch the next page of license profile.
	NextLink *string
}

// LicenseProperties - Describes the properties of a License Profile.
type LicenseProperties struct {
	// Describes the properties of a License.
	LicenseDetails *LicenseDetails

	// The type of the license resource.
	LicenseType *LicenseType

	// Describes the tenant id.
	TenantID *string

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *ProvisioningState
}

// LicenseUpdate - Describes a License Update.
type LicenseUpdate struct {
	// License Update properties
	Properties *LicenseUpdateProperties

	// Resource tags
	Tags map[string]*string
}

// LicenseUpdateProperties - Describes the Update properties of a License Profile.
type LicenseUpdateProperties struct {
	LicenseDetails *LicenseUpdatePropertiesLicenseDetails

	// The type of the license resource.
	LicenseType *LicenseType
}

type LicenseUpdatePropertiesLicenseDetails struct {
	// Describes the edition of the license. The values are either Standard or Datacenter.
	Edition *LicenseEdition

	// Describes the number of processors.
	Processors *int32

	// Describes the state of the license.
	State *LicenseState

	// Describes the license target server.
	Target *LicenseTarget

	// Describes the license core type (pCore or vCore).
	Type *LicenseCoreType
}

// LicensesListResult - The List license operation response.
type LicensesListResult struct {
	// REQUIRED; The list of licenses.
	Value []*License

	// The URI to fetch the next page of Machines. Call ListNext() with this URI to fetch the next page of license profile.
	NextLink *string
}

// LinuxParameters - Input for InstallPatches on a Linux VM, as directly received by the API
type LinuxParameters struct {
	// The update classifications to select when installing patches for Linux.
	ClassificationsToInclude []*VMGuestPatchClassificationLinux

	// packages to exclude in the patch operation. Format: packageName_packageVersion
	PackageNameMasksToExclude []*string

	// packages to include in the patch operation. Format: packageName_packageVersion
	PackageNameMasksToInclude []*string
}

// LocationData - Metadata pertaining to the geographic location of the resource.
type LocationData struct {
	// REQUIRED; A canonical name for the geographic or physical location.
	Name *string

	// The city or locality where the resource is located.
	City *string

	// The country or region where the resource is located
	CountryOrRegion *string

	// The district, state, or province where the resource is located.
	District *string
}

// Machine - Describes a hybrid machine.
type Machine struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Identity for the resource.
	Identity *Identity

	// Indicates which kind of Arc machine placement on-premises, such as HCI, SCVMM or VMware etc.
	Kind *ArcKindEnum

	// Hybrid Compute Machine properties
	Properties *MachineProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The list of extensions affiliated to the machine
	Resources []*MachineExtension

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// MachineAssessPatchesResult - Describes the properties of an AssessPatches result.
type MachineAssessPatchesResult struct {
	// Summarization of patches available for installation on the machine by classification.
	AvailablePatchCountByClassification *AvailablePatchCountByClassification

	// READ-ONLY; The activity ID of the operation that produced this result.
	AssessmentActivityID *string

	// READ-ONLY; The errors that were encountered during execution of the operation. The details array contains the list of them.
	ErrorDetails *ErrorDetail

	// READ-ONLY; The UTC timestamp when the operation finished.
	LastModifiedDateTime *time.Time

	// READ-ONLY; The operating system type of the machine.
	OSType *OsType

	// READ-ONLY; Specifies the patch service used for the operation.
	PatchServiceUsed *PatchServiceUsed

	// READ-ONLY; The overall reboot status of the VM. It will be true when partially installed patches require a reboot to complete
	// installation but the reboot has not yet occurred.
	RebootPending *bool

	// READ-ONLY; The UTC timestamp when the operation began.
	StartDateTime *time.Time

	// READ-ONLY; Indicates if operation was triggered by user or by platform.
	StartedBy *PatchOperationStartedBy

	// READ-ONLY; The overall success or failure status of the operation. It remains "InProgress" until the operation completes.
	// At that point it will become "Unknown", "Failed", "Succeeded", or
	// "CompletedWithWarnings."
	Status *PatchOperationStatus
}

// MachineExtension - Describes a Machine Extension.
type MachineExtension struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Describes Machine Extension Properties.
	Properties *MachineExtensionProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// MachineExtensionInstanceView - Describes the Machine Extension Instance View.
type MachineExtensionInstanceView struct {
	// The machine extension name.
	Name *string

	// Instance view status.
	Status *MachineExtensionInstanceViewStatus

	// Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string

	// Specifies the version of the script handler.
	TypeHandlerVersion *string
}

// MachineExtensionInstanceViewStatus - Instance view status.
type MachineExtensionInstanceViewStatus struct {
	// The status code.
	Code *string

	// The short localizable label for the status.
	DisplayStatus *string

	// The level code.
	Level *StatusLevelTypes

	// The detailed status message, including for alerts and error messages.
	Message *string

	// The time of the status.
	Time *time.Time
}

// MachineExtensionProperties - Describes the properties of a Machine Extension.
type MachineExtensionProperties struct {
	// Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed,
	// however, the extension will not upgrade minor versions unless redeployed, even
	// with this property set to true.
	AutoUpgradeMinorVersion *bool

	// Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available.
	EnableAutomaticUpgrade *bool

	// How the extension handler should be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string

	// The machine extension instance view.
	InstanceView *MachineExtensionInstanceView

	// The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings map[string]any

	// The name of the extension handler publisher.
	Publisher *string

	// Json formatted public settings for the extension.
	Settings map[string]any

	// Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string

	// Specifies the version of the script handler.
	TypeHandlerVersion *string

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string
}

// MachineExtensionUpdate - Describes a Machine Extension Update.
type MachineExtensionUpdate struct {
	// Describes Machine Extension Update Properties.
	Properties *MachineExtensionUpdateProperties

	// Resource tags
	Tags map[string]*string
}

// MachineExtensionUpdateProperties - Describes the properties of a Machine Extension.
type MachineExtensionUpdateProperties struct {
	// Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed,
	// however, the extension will not upgrade minor versions unless redeployed, even
	// with this property set to true.
	AutoUpgradeMinorVersion *bool

	// Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available.
	EnableAutomaticUpgrade *bool

	// How the extension handler should be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string

	// The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings map[string]any

	// The name of the extension handler publisher.
	Publisher *string

	// Json formatted public settings for the extension.
	Settings map[string]any

	// Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string

	// Specifies the version of the script handler.
	TypeHandlerVersion *string
}

// MachineExtensionUpgrade - Describes the Machine Extension Upgrade Properties.
type MachineExtensionUpgrade struct {
	// Describes the Extension Target Properties.
	ExtensionTargets map[string]*ExtensionTargetProperties
}

// MachineExtensionsListResult - Describes the Machine Extensions List Result.
type MachineExtensionsListResult struct {
	// The uri to fetch the next page of machine extensions. Call ListNext() with this to fetch the next page of extensions.
	NextLink *string

	// The list of extensions
	Value []*MachineExtension
}

// MachineInstallPatchesParameters - Input for InstallPatches as directly received by the API
type MachineInstallPatchesParameters struct {
	// REQUIRED; Specifies the maximum amount of time that the operation will run. It must be an ISO 8601-compliant duration string
	// such as PT4H (4 hours)
	MaximumDuration *string

	// REQUIRED; Defines when it is acceptable to reboot a VM during a software update operation.
	RebootSetting *VMGuestPatchRebootSetting

	// Input for InstallPatches on a Linux VM, as directly received by the API
	LinuxParameters *LinuxParameters

	// Input for InstallPatches on a Windows VM, as directly received by the API
	WindowsParameters *WindowsParameters
}

// MachineInstallPatchesResult - The result summary of an installation operation.
type MachineInstallPatchesResult struct {
	// READ-ONLY; The errors that were encountered during execution of the operation. The details array contains the list of them.
	ErrorDetails *ErrorDetail

	// READ-ONLY; The number of patches that were not installed due to the user blocking their installation.
	ExcludedPatchCount *int32

	// READ-ONLY; The number of patches that could not be installed due to some issue. See errors for details.
	FailedPatchCount *int32

	// READ-ONLY; The activity ID of the operation that produced this result.
	InstallationActivityID *string

	// READ-ONLY; The number of patches successfully installed.
	InstalledPatchCount *int32

	// READ-ONLY; The UTC timestamp when the operation finished.
	LastModifiedDateTime *time.Time

	// READ-ONLY; Whether the operation ran out of time before it completed all its intended actions.
	MaintenanceWindowExceeded *bool

	// READ-ONLY; The number of patches that were detected as available for install, but did not meet the operation's criteria.
	NotSelectedPatchCount *int32

	// READ-ONLY; The operating system type of the machine.
	OSType *OsType

	// READ-ONLY; Specifies the patch service used for the operation.
	PatchServiceUsed *PatchServiceUsed

	// READ-ONLY; The number of patches that were identified as meeting the installation criteria, but were not able to be installed.
	// Typically this happens when maintenanceWindowExceeded == true.
	PendingPatchCount *int32

	// READ-ONLY; The reboot state of the VM following completion of the operation.
	RebootStatus *VMGuestPatchRebootStatus

	// READ-ONLY; The UTC timestamp when the operation began.
	StartDateTime *time.Time

	// READ-ONLY; Indicates if operation was triggered by user or by platform.
	StartedBy *PatchOperationStartedBy

	// READ-ONLY; The overall success or failure status of the operation. It remains "InProgress" until the operation completes.
	// At that point it will become "Failed", "Succeeded", "Unknown" or "CompletedWithWarnings."
	Status *PatchOperationStatus
}

// MachineListResult - The List hybrid machine operation response.
type MachineListResult struct {
	// REQUIRED; The list of hybrid machines.
	Value []*Machine

	// The URI to fetch the next page of Machines. Call ListNext() with this URI to fetch the next page of hybrid machines.
	NextLink *string
}

// MachineProperties - Describes the properties of a hybrid machine.
type MachineProperties struct {
	// The info of the machine w.r.t Agent Upgrade
	AgentUpgrade *AgentUpgrade

	// Public Key that the client provides to be used during initial resource onboarding
	ClientPublicKey *string

	// The metadata of the cloud environment (Azure/GCP/AWS/OCI…).
	CloudMetadata *CloudMetadata

	// Machine Extensions information (deprecated field)
	Extensions []*MachineExtensionInstanceView

	// Specifies the ESU related properties for a machine.
	LicenseProfile *LicenseProfileMachineInstanceView

	// Metadata pertaining to the geographic location of the resource.
	LocationData *LocationData

	// Specifies whether any MS SQL instance is discovered on the machine.
	MssqlDiscovered *string

	// Specifies the operating system settings for the hybrid machine.
	OSProfile *OSProfile

	// The type of Operating System (windows/linux).
	OSType *string

	// The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any.
	ParentClusterResourceID *string

	// The resource id of the private link scope this machine is assigned to, if any.
	PrivateLinkScopeResourceID *string

	// Statuses of dependent services that are reported back to ARM.
	ServiceStatuses *ServiceStatuses

	// Specifies the hybrid machine unique ID.
	VMID *string

	// READ-ONLY; Specifies the AD fully qualified display name.
	AdFqdn *string

	// READ-ONLY; Configurable properties that the user can set locally via the azcmagent config command, or remotely via ARM.
	AgentConfiguration *AgentConfiguration

	// READ-ONLY; The hybrid machine agent full version.
	AgentVersion *string

	// READ-ONLY; Specifies the DNS fully qualified display name.
	DNSFqdn *string

	// READ-ONLY; Detected properties from the machine.
	DetectedProperties map[string]*string

	// READ-ONLY; Specifies the hybrid machine display name.
	DisplayName *string

	// READ-ONLY; Specifies the Windows domain name.
	DomainName *string

	// READ-ONLY; Details about the error state.
	ErrorDetails []*ErrorDetail

	// READ-ONLY; The time of the last status change.
	LastStatusChange *time.Time

	// READ-ONLY; Specifies the hybrid machine FQDN.
	MachineFqdn *string

	// READ-ONLY; Information about the network the machine is on.
	NetworkProfile *NetworkProfile

	// READ-ONLY; The Operating System running on the hybrid machine.
	OSName *string

	// READ-ONLY; Specifies the Operating System product SKU.
	OSSKU *string

	// READ-ONLY; The version of Operating System running on the hybrid machine.
	OSVersion *string

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string

	// READ-ONLY; The status of the hybrid machine agent.
	Status *StatusTypes

	// READ-ONLY; Specifies the Arc Machine's unique SMBIOS ID
	VMUUID *string
}

// MachineUpdate - Describes a hybrid machine Update.
type MachineUpdate struct {
	// Identity for the resource.
	Identity *Identity

	// Indicates which kind of Arc machine placement on-premises, such as HCI, SCVMM or VMware etc.
	Kind *ArcKindEnum

	// Hybrid Compute Machine properties
	Properties *MachineUpdateProperties

	// Resource tags
	Tags map[string]*string
}

// MachineUpdateProperties - Describes the ARM updatable properties of a hybrid machine.
type MachineUpdateProperties struct {
	// The info of the machine w.r.t Agent Upgrade
	AgentUpgrade *AgentUpgrade

	// The metadata of the cloud environment (Azure/GCP/AWS/OCI…).
	CloudMetadata *CloudMetadata

	// Metadata pertaining to the geographic location of the resource.
	LocationData *LocationData

	// Specifies the operating system settings for the hybrid machine.
	OSProfile *OSProfile

	// The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any.
	ParentClusterResourceID *string

	// The resource id of the private link scope this machine is assigned to, if any.
	PrivateLinkScopeResourceID *string
}

// NetworkInterface - Describes a network interface.
type NetworkInterface struct {
	// The list of IP addresses in this interface.
	IPAddresses []*IPAddress
}

// NetworkProfile - Describes the network information on this machine.
type NetworkProfile struct {
	// The list of network interfaces.
	NetworkInterfaces []*NetworkInterface
}

// OSProfile - Specifies the operating system settings for the hybrid machine.
type OSProfile struct {
	// Specifies the linux configuration for update management.
	LinuxConfiguration *OSProfileLinuxConfiguration

	// Specifies the windows configuration for update management.
	WindowsConfiguration *OSProfileWindowsConfiguration

	// READ-ONLY; Specifies the host OS name of the hybrid machine.
	ComputerName *string
}

// OSProfileLinuxConfiguration - Specifies the linux configuration for update management.
type OSProfileLinuxConfiguration struct {
	// Specifies the patch settings.
	PatchSettings *PatchSettings
}

// OSProfileWindowsConfiguration - Specifies the windows configuration for update management.
type OSProfileWindowsConfiguration struct {
	// Specifies the patch settings.
	PatchSettings *PatchSettings
}

// OperationListResult - The List Compute Operation operation response.
type OperationListResult struct {
	// READ-ONLY; The list of compute operations
	Value []*OperationValue
}

// OperationValue - Describes the properties of a Compute Operation value.
type OperationValue struct {
	// Display properties
	Display *OperationValueDisplay

	// READ-ONLY; This property indicates if the operation is an action or a data action
	IsDataAction *bool

	// READ-ONLY; The name of the compute operation.
	Name *string

	// READ-ONLY; The origin of the compute operation.
	Origin *string
}

// OperationValueDisplay - Describes the properties of a Hybrid Compute Operation Value Display.
type OperationValueDisplay struct {
	// READ-ONLY; The description of the operation.
	Description *string

	// READ-ONLY; The display name of the compute operation.
	Operation *string

	// READ-ONLY; The resource provider for the operation.
	Provider *string

	// READ-ONLY; The display name of the resource the operation applies to.
	Resource *string
}

// PatchSettings - Specifies the patch settings.
type PatchSettings struct {
	// Specifies the assessment mode.
	AssessmentMode *AssessmentModeTypes

	// Specifies the patch mode.
	PatchMode *PatchModeTypes
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionDataModel - The Data Model for a Private Endpoint Connection associated with a Private Link Scope
type PrivateEndpointConnectionDataModel struct {
	// The Private Endpoint Connection properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; The ARM Resource Id of the Private Endpoint.
	ID *string

	// READ-ONLY; The Name of the Private Endpoint.
	Name *string

	// READ-ONLY; Azure resource type
	Type *string
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections.
type PrivateEndpointConnectionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty

	// Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty

	// READ-ONLY; List of group IDs.
	GroupIDs []*string

	// READ-ONLY; State of the private endpoint connection.
	ProvisioningState *string
}

// PrivateEndpointProperty - Private endpoint which the connection belongs to.
type PrivateEndpointProperty struct {
	// Resource id of the private endpoint.
	ID *string
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string

	// READ-ONLY; Required DNS zone names of the the private link resource.
	RequiredZoneNames []*string
}

// PrivateLinkScope - An Azure Arc PrivateLinkScope definition.
type PrivateLinkScope struct {
	// REQUIRED; Resource location
	Location *string

	// Properties that define a Azure Arc PrivateLinkScope resource.
	Properties *PrivateLinkScopeProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData

	// READ-ONLY; Azure resource type
	Type *string
}

// PrivateLinkScopeListResult - Describes the list of Azure Arc PrivateLinkScope resources.
type PrivateLinkScopeListResult struct {
	// REQUIRED; List of Azure Arc PrivateLinkScope definitions.
	Value []*PrivateLinkScope

	// The URI to get the next set of Azure Arc PrivateLinkScope definitions if too many PrivateLinkScopes where returned in the
	// result set.
	NextLink *string
}

// PrivateLinkScopeProperties - Properties that define a Azure Arc PrivateLinkScope resource.
type PrivateLinkScopeProperties struct {
	// Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
	PublicNetworkAccess *PublicNetworkAccessType

	// READ-ONLY; The collection of associated Private Endpoint Connections.
	PrivateEndpointConnections []*PrivateEndpointConnectionDataModel

	// READ-ONLY; The Guid id of the private link scope.
	PrivateLinkScopeID *string

	// READ-ONLY; Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it
	// is defined. Users cannot change this value but are able to read from it. Values will include
	// Provisioning ,Succeeded, Canceled and Failed.
	ProvisioningState *string
}

type PrivateLinkScopeValidationDetails struct {
	// List of Private Endpoint Connection details.
	ConnectionDetails []*ConnectionDetail

	// Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
	PublicNetworkAccess *PublicNetworkAccessType

	// READ-ONLY; Azure resource Id
	ID *string
}

// PrivateLinkServiceConnectionStateProperty - State of the private endpoint connection.
type PrivateLinkServiceConnectionStateProperty struct {
	// REQUIRED; The private link service connection description.
	Description *string

	// REQUIRED; The private link service connection status.
	Status *string

	// READ-ONLY; The actions required for private link service connection.
	ActionsRequired *string
}

// ServiceStatus - Describes the status and behavior of a service.
type ServiceStatus struct {
	// The behavior of the service when the Arc-enabled machine starts up.
	StartupType *string

	// The current status of the service.
	Status *string
}

// ServiceStatuses - Reports the state and behavior of dependent services.
type ServiceStatuses struct {
	// The state of the extension service on the Arc-enabled machine.
	ExtensionService *ServiceStatus

	// The state of the guest configuration service on the Arc-enabled machine.
	GuestConfigurationService *ServiceStatus
}

// Subnet - Describes the subnet.
type Subnet struct {
	// Represents address prefix.
	AddressPrefix *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TagsResource - A container holding only the Tags for a resource, allowing the user to update the tags on a PrivateLinkScope
// instance.
type TagsResource struct {
	// Resource tags
	Tags map[string]*string
}

// WindowsParameters - Input for InstallPatches on a Windows VM, as directly received by the API
type WindowsParameters struct {
	// The update classifications to select when installing patches for Windows.
	ClassificationsToInclude []*VMGuestPatchClassificationWindows

	// Filters out Kbs that don't have an InstallationRebootBehavior of 'NeverReboots' when this is set to true.
	ExcludeKbsRequiringReboot *bool

	// Kbs to exclude in the patch operation
	KbNumbersToExclude []*string

	// Kbs to include in the patch operation
	KbNumbersToInclude []*string

	// This is used to install patches that were published on or before this given max published date.
	MaxPatchPublishDate *time.Time
}
