//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/securityinsights/armsecurityinsights"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// ThreatIntelligenceIndicatorsServer is a fake server for instances of the armsecurityinsights.ThreatIntelligenceIndicatorsClient type.
type ThreatIntelligenceIndicatorsServer struct {
	// NewListPager is the fake for method ThreatIntelligenceIndicatorsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, workspaceName string, options *armsecurityinsights.ThreatIntelligenceIndicatorsClientListOptions) (resp azfake.PagerResponder[armsecurityinsights.ThreatIntelligenceIndicatorsClientListResponse])
}

// NewThreatIntelligenceIndicatorsServerTransport creates a new instance of ThreatIntelligenceIndicatorsServerTransport with the provided implementation.
// The returned ThreatIntelligenceIndicatorsServerTransport instance is connected to an instance of armsecurityinsights.ThreatIntelligenceIndicatorsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewThreatIntelligenceIndicatorsServerTransport(srv *ThreatIntelligenceIndicatorsServer) *ThreatIntelligenceIndicatorsServerTransport {
	return &ThreatIntelligenceIndicatorsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armsecurityinsights.ThreatIntelligenceIndicatorsClientListResponse]](),
	}
}

// ThreatIntelligenceIndicatorsServerTransport connects instances of armsecurityinsights.ThreatIntelligenceIndicatorsClient to instances of ThreatIntelligenceIndicatorsServer.
// Don't use this type directly, use NewThreatIntelligenceIndicatorsServerTransport instead.
type ThreatIntelligenceIndicatorsServerTransport struct {
	srv          *ThreatIntelligenceIndicatorsServer
	newListPager *tracker[azfake.PagerResponder[armsecurityinsights.ThreatIntelligenceIndicatorsClientListResponse]]
}

// Do implements the policy.Transporter interface for ThreatIntelligenceIndicatorsServerTransport.
func (t *ThreatIntelligenceIndicatorsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ThreatIntelligenceIndicatorsClient.NewListPager":
		resp, err = t.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *ThreatIntelligenceIndicatorsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := t.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityInsights/threatIntelligence/main/indicators`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		var options *armsecurityinsights.ThreatIntelligenceIndicatorsClientListOptions
		if filterParam != nil || topParam != nil || skipTokenParam != nil || orderbyParam != nil {
			options = &armsecurityinsights.ThreatIntelligenceIndicatorsClientListOptions{
				Filter:    filterParam,
				Top:       topParam,
				SkipToken: skipTokenParam,
				Orderby:   orderbyParam,
			}
		}
		resp := t.srv.NewListPager(resourceGroupNameParam, workspaceNameParam, options)
		newListPager = &resp
		t.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecurityinsights.ThreatIntelligenceIndicatorsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		t.newListPager.remove(req)
	}
	return resp, nil
}
