//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentListByServer.json
func ExampleVulnerabilityAssessmentsSettingsClient_NewListByServerPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVulnerabilityAssessmentsSettingsClient().NewListByServerPager("vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VulnerabilityAssessmentListResult = armsql.VulnerabilityAssessmentListResult{
		// 	Value: []*armsql.VulnerabilityAssessment{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/sqlVulnerabilityAssessments"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/sqlVulnerabilityAssessments/"),
		// 			Properties: &armsql.VulnerabilityAssessmentPolicyProperties{
		// 				State: to.Ptr(armsql.SQLVulnerabilityAssessmentStateEnabled),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentGet.json
func ExampleVulnerabilityAssessmentsSettingsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVulnerabilityAssessmentsSettingsClient().Get(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", armsql.SQLVulnerabilityAssessmentNameDefault, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VulnerabilityAssessment = armsql.VulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/sqlVulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/sqlVulnerabilityAssessments/default"),
	// 	Properties: &armsql.VulnerabilityAssessmentPolicyProperties{
	// 		State: to.Ptr(armsql.SQLVulnerabilityAssessmentStateEnabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/SqlVulnerabilityAssessmentCreate.json
func ExampleVulnerabilityAssessmentsSettingsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVulnerabilityAssessmentsSettingsClient().CreateOrUpdate(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", armsql.VulnerabilityAssessmentNameDefault, armsql.VulnerabilityAssessment{
		Properties: &armsql.VulnerabilityAssessmentPolicyProperties{
			State: to.Ptr(armsql.SQLVulnerabilityAssessmentStateEnabled),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VulnerabilityAssessment = armsql.VulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/sqlVulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/sqlVulnerabilityAssessments/default"),
	// 	Properties: &armsql.VulnerabilityAssessmentPolicyProperties{
	// 		State: to.Ptr(armsql.SQLVulnerabilityAssessmentStateEnabled),
	// 	},
	// }
}
