# settings.py
#
# Copyright 2024 Christopher Talbot
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

from gi.repository import Gio
from gi.repository import Gtk
from gi.repository import GLib
from gi.repository import GObject
import gettext

class SettingsObject(GObject.GObject):
    __gtype_name__ = 'SettingsObject'

    def set_print_packets(self, print_packets):
        return self._settings.set_boolean("print-packets", print_packets)
        self._settings.apply()

    def get_print_packets(self):
        return self._settings.get_boolean("print-packets")

    def set_log_packets(self, log_packets):
        self._settings.set_boolean("log-packets", log_packets)
        self._settings.apply()

    def get_log_packets(self):
        return self._settings.get_boolean("log-packets")

    def set_return_sends_message(self, return_sends_message):
        return self._settings.set_boolean("return-sends-message", return_sends_message)
        self._settings.apply()

    def get_return_sends_message(self):
        return self._settings.get_boolean("return-sends-message")

    def set_create_gps_socket(self, create_gps_socket):
        return self._settings.set_boolean("create-gps-socket", create_gps_socket)
        self._settings.apply()

    def get_create_gps_socket(self):
        return self._settings.get_boolean("create-gps-socket")

    def set_quit_if_connected(self, quit_if_connected):
        return self._settings.set_boolean("quit-if-connected", quit_if_connected)
        self._settings.apply()

    def get_quit_if_connected(self):
        return self._settings.get_boolean("quit-if-connected")

    def set_default_url(self, default_url):
        return self._settings.set_string("default-url", default_url)
        self._settings.apply()

    def get_default_url(self):
        return self._settings.get_string("default-url")

    def __init__(self, project_rdnn_name, **kwargs):
        super().__init__(**kwargs)
        app = Gtk.Application.get_default()

        self.logger = app.logger
        self._settings = Gio.Settings.new(project_rdnn_name)
