<?php
/*
 * Hydrogen
 * Copyright(c) 2002-2008 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 * Copyright(c) 2008-2023 The hydrogen development team [hydrogen-devel@lists.sourceforge.net]
 *
 * http://www.hydrogen-music.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see https://www.gnu.org/licenses
 *
 */


	/*
		Use this script if you want to share your hydrogen songs,patterns and
		drumkits with other people. It generates a xml-file which can be used
		with the hydrogen soundlibrary.

		Just place this script in one directory with all your drumkits, songs
		and patterns and make it available via a webserver.

		Songs and patterns could be parsed in place. Since drumkits are archives,
		we cannot parse the files at runtime. Therefore, just the name and the url of the drumkit will be used.
		If you want additional information ( such as author / info ) take a look
		at the metaInfo.inc file (the file has to be in the same directory as this script).
		
	*/


	/*
		metaInfo.inc holds meta information about the drumkits, namely:
		
		- url
		- author
		- info
		- name

		If metaInfo.inc is not available, the script takes the filename as namely	and guesses the url
	*/

	if ( is_file("metaInfo.inc") ) {
		include("metaInfo.inc");
	}


	function getTag( $xml , $tag ){
		preg_match( "/". $tag . "(.*)</" , $xml , $found );
		if( ISSET( $found[1] ) ) {
			return $found[1];
		}
	}


	//$url should be defined in metaInfo.inc
	if( ! ISSET( $url ) ){
		$url = $_SERVER [ 'SERVER_NAME' ] ;
		$dir = dirname ( $_SERVER['PHP_SELF'] ) ;
		$url = "http://$url$dir";
		$drumkitImageUrl = $url + '/' + $drumkitImageDir;
	}

	$author = "";
	$info = "";

	/* Start of xml-document */

	print "<?xml version='1.0' encoding='UTF-8'?>\n";
	print "<drumkit_list>\n";


	/* Start of song listing */
	

	$dir = "./";
	if ($dh = opendir( $dir )) {
        	while (( $file = readdir($dh) ) !== false) {
			$extension = array_pop( explode(".", $file) );
			if( $extension == "h2song" ) {
				print "\t<song>\n";
				$content = file( $dir.$file );
				$xml = join( " ",$content );
				print "\t\t<name>" . getTag( $xml , "<name>" ) . "</name>\n";
				print "\t\t<url>" . $url.$file ."</url>\n";
				print "\t\t<author>" . getTag( $xml , "<author>" ) . "</author>\n";
				print "\t\t<info>" . getTag( $xml , "<info>" ) . "</info>\n";
				print "\t</song>\n";
			}
        	}
	    	closedir( $dh );
    	}
	/* End of song listing */



	/* Start of pattern listing */
	$dir = "./";
	if ($dh = opendir( $dir )) {
        	while ( ( $file = readdir( $dh ) ) !== false ) {
			$extension = array_pop(explode( ".", $file ));
			if( $extension == "h2pattern" ) {
				$content = file( $dir.$file );
				$xml = join( " " , $content );
				print "\t<pattern>\n";
				print "\t\t<name>" . getTag( $xml , "<name>" ) . "</name>\n";
				print "\t\t<url>" . $url.$file ."</url>\n";
				print "\t</pattern>\n";
			}
        	}
	    	closedir( $dh );
    	}	
	/* End of pattern listing */


	/* Start of drumkit listing */
	$dir = "./";
	$hasImages = false;
	if ($imageDirHandle = opendir( $drumkitImageDir ) ) {
		$hasImages = true;
		$imageFiles[] = array();
		while ( ( $f = readdir($imageDirHandle ) ) !== false ) {
		      $imageFiles[] = $file;
		}
		closedir($dh);
	}

	if ($dh = opendir( $dir ) ) {
        	while ( ( $file = readdir( $dh ) ) !== false) {
			$extension = array_pop( explode( ".", $file ) );
			if( $extension == "h2drumkit" ) {
				$content = file( $dir.$file );
				$xml = join( " " , $content );
				print "\t<drumkit>\n";
			
				//name: filename without extension
				$name = basename( $file,".h2drumkit" );

				If( ISSET( $drumkit_list[ $name ]) ){
					$author = $drumkit_list[ $name ][ "author" ];
					$info = $drumkit_list[ $name ][ "info" ];
				}

				print "\t\t<name> $name </name>\n";
				print "\t\t<url>" . $url.$file ."</url>\n";
				print "\t\t<author>$author</author>\n";
				print "\t\t<info>$info</info>\n";
				// Get image
				// Possible method: Have image filename same as basename of drumkit file.
				// ie: for DeathMetal.h2drumkit, image file would be DeathMetal.jpeg
				//     and allow for .png as well (non-case sensitive extension)
				//	The drumkit filenames need to be unique, and this would force the
				//     images to be unique names but be consistent.
				//     use regex like: /.*\.(?:jpeg|jpg|png)/i
				//
				//	Go through all files in image directory named $basename.* and
				//	see if there's a regex match, if so use that image file
				if ( $hasImages )
				{
					// search $imageFiles array for basename that matches with extension that matches regex					
					$images = preg_grep( "/.*\.(?:jpeg|jpg|png)/i", $imageFiles );
					if ( count( $images ) ) {
						// if there's more than one match we'll just use the first
						print "\t\t<image>" . $drumkitImageUrl . "/" . $images[0] . "</image>";
					}
				}
				print "\t</drumkit>\n";
			}
        	}
	    	closedir( $dh );
    	}	
	/* End of pattern listing */


	print "</drumkit_list>\n";
		

?>
