
(use-modules (g-golf support sxml))


(define %plugin-dialog
  `(interface
    (requires (@ (version "4.0") (lib "gtk")))
    (template
     (@ (class "PluginDialog")
        (parent "GtkWindow"))
     (property (@ (name "title")
                  (translatable "yes")) "Plugin Setup")
     (property (@ (name "default-width")) 500)
     (property (@ (name "default-height")) 250)
     (child
      (object
       (@ (class "GtkBox"))
       (property (@ (name "orientation")) "vertical")
       (property (@ (name "spacing")) 10)
       (property (@ (name "margin-start")) 20)
       (property (@ (name "margin-end")) 20)
       (property (@ (name "margin-top")) 20)
       (property (@ (name "margin-bottom")) 20)
       (property (@ (name "halign")) "start")
       (child
        (object
         (@ (class "GtkImage"))
         (property (@ (name "icon-name")) "applications-other")
         (property (@ (name "icon-size")) "large")))
       (child
        (object
         (@ (class "GtkGrid"))
         (property (@ (name "row-spacing")) 5)
         (property (@ (name "column-spacing")) 20)
         (property (@ (name "halign")) "start")
         (child
          (object
           (@ (class "GtkLabel"))
           (property
            (@ (name "label"))
            "Plugin")
           (property (@ (name "halign")) "start")
           (property (@ (name "xalign")) 0.0)
           (property (@ (name "width-request")) 150)
           (layout
            (property
             (@ (name "column")) 0)
            (property
             (@ (name "row")) 0))))
         (child  
          (object
           (@ (class "GtkDropDown")
              (id "dropdown-plugin"))
        ;;    (property
        ;;     (@ (name "model"))
        ;;     (object
        ;;      (@ (class "GtkStringList") (id "stringlist-plugin"))
        ;;      (items
        ;;       (item (@ (translatable "yes")) "plugin1")
        ;;       (item (@ (translatable "yes")) "plugin2"))))
           (property (@ (name "width-request")) 250)
           (layout
            (property
             (@ (name "column")) 1)
            (property
             (@ (name "row")) 0))))
         (child
          (object
           (@ (class "GtkLabel"))
           (property
            (@ (name "label"))
            "Procedure")
           (property (@ (name "halign")) "start")
           (property (@ (name "xalign")) 0.0)
           (property (@ (name "width-request")) 150)
           (layout
            (property
             (@ (name "column")) 0)
            (property
             (@ (name "row")) 1))))
         (child  
          (object
           (@ (class "GtkEntry")
              (id "entry-proc"))
           (property
            (@ (name "buffer"))
            (object
             (@ (class "GtkEntryBuffer") (id "buffer-proc"))))
           (property (@ (name "width-request")) 250)
           (layout
            (property
             (@ (name "column")) 1)
            (property
             (@ (name "row")) 1))))
         (child
          (object
           (@ (class "GtkLabel"))
           (property
            (@ (name "label"))
            "Number of arguments")
           (property (@ (name "halign")) "start")
           (property (@ (name "xalign")) 0.0)
           (property (@ (name "width-request")) 150)
           (layout
            (property
             (@ (name "column")) 0)
            (property
             (@ (name "row")) 2))))
         (child  
          (object
           (@ (class "GtkEntry")
              (id "entry-nargs"))
           (property
            (@ (name "buffer"))
            (object
             (@ (class "GtkEntryBuffer") (id "buffer-nargs"))))
           (property (@ (name "width-request")) 250)
           (layout
            (property
             (@ (name "column")) 1)
            (property
             (@ (name "row")) 2))))))
       (child
        (object
         (@ (class "GtkBox"))
         (property (@ (name "orientation")) "vertical")
         (property (@ (name "spacing")) 10)
         (child
          (object
           (@ (class "GtkCheckButton") (id "checkbutton-normal-var"))
           (property (@ (name "label")) "Simple procedure")
           (property (@ (name "active")) True)))
         (child
          (object
           (@ (class "GtkCheckButton") (id "checkbutton-ngp"))
           (property (@ (name "label")) "Normal generic procedure")
           (property (@ (name "group")) "checkbutton-normal-var")))
         (child
          (object
           (@ (class "GtkCheckButton") (id "checkbutton-vgp"))
           (property (@ (name "label")) "Virtual generic procedure")
           (property (@ (name "group")) "checkbutton-normal-var")))))
       (child
        (object
         (@ (class "GtkBox"))
         (property (@ (name "orientation")) "horizontal")
         (property (@ (name "spacing")) 10)
         (child
          (object
           (@ (class "GtkButton") (id "button-ok"))
           (property (@ (name "label")
                        (translatable "yes")) "Ok")))
         (child
          (object
           (@ (class "GtkButton") (id "button-cancel"))
           (property (@ (name "label")
                        (translatable "yes")) "Cancel"))))))))))


(define (make-ui)
  (sxml->ui %plugin-dialog))
