/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Bindery;
import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.DecimalFormatManager;
import com.icl.saxon.KeyManager;
import com.icl.saxon.Mode;
import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.PreviewManager;
import com.icl.saxon.RuleManager;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.Navigator;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.Stripper;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLGeneralIncorporate;
import com.icl.saxon.style.XSLNamespaceAlias;
import com.icl.saxon.style.XSLOutput;
import com.icl.saxon.style.XSLScript;
import com.icl.saxon.style.XSLTemplate;
import com.icl.saxon.trace.SimpleTraceListener;
import com.icl.saxon.trace.TraceListener;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLStyleSheet
extends StyleElement {
    private boolean wasIncluded = false;
    private int precedence = 0;
    private int minImportPrecedence = 0;
    private XSLStyleSheet importer = null;
    private PreparedStyleSheet stylesheet;
    private Vector topLevel;
    private Mode stripperRules = null;
    private RuleManager ruleManager;
    private KeyManager keyManager = new KeyManager();
    private DecimalFormatManager decimalFormatManager = new DecimalFormatManager();
    private PreviewManager previewManager = null;
    private int numberOfAliases = 0;
    private short[] aliasSCodes = new short[5];
    private short[] aliasRCodes = new short[5];
    private int numberOfVariables = 0;
    private int largestStackFrame = 0;

    public void setPreparedStyleSheet(PreparedStyleSheet preparedStyleSheet) {
        this.stylesheet = preparedStyleSheet;
        this.ruleManager = new RuleManager(preparedStyleSheet.getNamePool());
    }

    public PreparedStyleSheet getPreparedStyleSheet() {
        if (this.importer != null) {
            return this.importer.getPreparedStyleSheet();
        }
        return this.stylesheet;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    protected Mode getStripperRules() {
        if (this.stripperRules == null) {
            this.stripperRules = new Mode();
        }
        return this.stripperRules;
    }

    public Stripper newStripper() {
        return new Stripper(this.stripperRules);
    }

    public boolean stripsWhitespace() {
        StandardNames standardNames = this.getStandardNames();
        int n = 0;
        while (n < this.topLevel.size()) {
            NodeInfo nodeInfo = (NodeInfo)this.topLevel.elementAt(n);
            if (nodeInfo.getFingerprint() == standardNames.XSL_STRIP_SPACE) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        return this.decimalFormatManager;
    }

    public PreviewManager getPreviewManager() {
        return this.previewManager;
    }

    public void setPreviewManager(PreviewManager previewManager) {
        this.previewManager = previewManager;
    }

    public void setPrecedence(int n) {
        this.precedence = n;
    }

    public int getPrecedence() {
        if (this.wasIncluded) {
            return this.importer.getPrecedence();
        }
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public void setMinImportPrecedence(int n) {
        this.minImportPrecedence = n;
    }

    public void setImporter(XSLStyleSheet xSLStyleSheet) {
        this.importer = xSLStyleSheet;
    }

    public XSLStyleSheet getImporter() {
        return this.importer;
    }

    public void setWasIncluded() {
        this.wasIncluded = true;
    }

    public boolean wasIncluded() {
        return this.wasIncluded;
    }

    public Vector getTopLevel() {
        return this.topLevel;
    }

    public int allocateSlotNumber() {
        return this.numberOfVariables++;
    }

    public void allocateLocalSlots(int n) {
        if (n > this.largestStackFrame) {
            this.largestStackFrame = n;
        }
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.VERSION) {
                this.version = attributeCollection.getValueByFingerprint(n3);
            } else if (n3 != standardNames.ID && n3 != standardNames.EXTENSION_ELEMENT_PREFIXES && n3 != standardNames.EXCLUDE_RESULT_PREFIXES) {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (this.version == null) {
            this.reportAbsence("version");
        }
    }

    protected void processVersionAttribute(int n) {
        this.version = this.getAttributeValue(n & 0xFFFFF);
    }

    protected short getNamespaceAlias(short s) {
        int n = this.numberOfAliases - 1;
        while (n >= 0) {
            if (s == this.aliasSCodes[n]) {
                return this.aliasRCodes[n];
            }
            --n;
        }
        return s;
    }

    public void validate() throws TransformerConfigurationException {
        if (this.validationError != null) {
            this.compileError(this.validationError);
        }
        if (!(this.getParentNode() instanceof DocumentInfo)) {
            throw new TransformerConfigurationException(this.getDisplayName() + " must be the outermost element");
        }
    }

    public void preprocess() throws TransformerConfigurationException {
        this.spliceIncludes();
        this.processAllAttributes();
        this.collectNamespaceAliases();
        this.validate();
        int n = 0;
        while (n < this.topLevel.size()) {
            Object e = this.topLevel.elementAt(n);
            if (e instanceof StyleElement) {
                ((StyleElement)e).validateSubtree();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.topLevel.size()) {
            Object e = this.topLevel.elementAt(n2);
            if (e instanceof StyleElement) {
                try {
                    ((StyleElement)e).preprocess();
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    ((StyleElement)e).compileError(transformerConfigurationException);
                }
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void spliceIncludes() throws TransformerConfigurationException {
        var1_1 = false;
        this.topLevel = new Vector<E>();
        this.minImportPrecedence = this.precedence;
        var2_2 = this;
        var3_3 = (NodeImpl)this.getFirstChild();
        while (var3_3 != null) {
            block11: {
                block12: {
                    block10: {
                        if (var3_3.getNodeType() != 3) break block10;
                        if (!Navigator.isWhite(var3_3.getStringValue())) {
                            var2_2.compileError("No character data is allowed between top-level elements");
                        }
                        break block11;
                    }
                    var2_2 = (StyleElement)var3_3;
                    if (!(var3_3 instanceof XSLGeneralIncorporate)) break block12;
                    var4_4 = (XSLGeneralIncorporate)var3_3;
                    var4_4.processAttributes();
                    if (var4_4.isImport()) {
                        if (var1_1) {
                            var4_4.compileError("xsl:import elements must come first");
                        }
                    } else {
                        var1_1 = true;
                    }
                    if ((var5_5 = var4_4.getIncludedStyleSheet(this, this.precedence)) == null) {
                        return;
                    }
                    if (var4_4.isImport()) {
                        this.precedence = var5_5.getPrecedence() + 1;
                    } else {
                        this.precedence = var5_5.getPrecedence();
                        var5_5.setMinImportPrecedence(this.minImportPrecedence);
                        var5_5.setWasIncluded();
                    }
                    var6_6 = var5_5.topLevel;
                    var7_7 = 0;
                    while (var7_7 < var6_6.size()) {
                        block13: {
                            var8_8 = (StyleElement)var6_6.elementAt(var7_7);
                            var9_9 = this.topLevel.size() - 1;
                            if (var9_9 >= 0 && var8_8.getPrecedence() < ((StyleElement)this.topLevel.elementAt(var9_9)).getPrecedence()) ** GOTO lbl38
                            this.topLevel.addElement(var8_8);
                            break block13;
lbl-1000:
                            // 1 sources

                            {
                                --var9_9;
lbl38:
                                // 2 sources

                                ** while (var9_9 >= 0 && var8_8.getPrecedence() < ((StyleElement)this.topLevel.elementAt((int)var9_9)).getPrecedence())
                            }
lbl39:
                            // 1 sources

                            this.topLevel.insertElementAt(var8_8, var9_9 + 1);
                        }
                        ++var7_7;
                    }
                    break block11;
                }
                var1_1 = true;
                this.topLevel.addElement(var3_3);
            }
            var3_3 = (NodeImpl)var3_3.getNextSibling();
        }
    }

    private void collectNamespaceAliases() {
        int n = 0;
        while (n < this.topLevel.size()) {
            Object e = this.topLevel.elementAt(n);
            if (e instanceof XSLNamespaceAlias) {
                XSLNamespaceAlias xSLNamespaceAlias = (XSLNamespaceAlias)e;
                if (this.numberOfAliases == this.aliasSCodes.length) {
                    short[] sArray = new short[this.numberOfAliases * 2];
                    short[] sArray2 = new short[this.numberOfAliases * 2];
                    System.arraycopy(this.aliasSCodes, 0, sArray, 0, this.numberOfAliases);
                    System.arraycopy(this.aliasRCodes, 0, sArray2, 0, this.numberOfAliases);
                    this.aliasSCodes = sArray;
                    this.aliasRCodes = sArray2;
                }
                this.aliasSCodes[this.numberOfAliases] = xSLNamespaceAlias.getStylesheetURICode();
                this.aliasRCodes[this.numberOfAliases] = xSLNamespaceAlias.getResultURICode();
                ++this.numberOfAliases;
            }
            ++n;
        }
    }

    protected boolean hasNamespaceAliases() {
        return this.numberOfAliases > 0;
    }

    public void processAllAttributes() throws TransformerConfigurationException {
        this.prepareAttributes();
        Vector vector = this.topLevel;
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof StyleElement) {
                try {
                    ((StyleElement)e).processAllAttributes();
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    ((StyleElement)e).compileError(transformerConfigurationException);
                }
            }
            ++n;
        }
    }

    public void initialiseBindery(Bindery bindery) {
        bindery.allocateGlobals(this.numberOfVariables);
        bindery.allocateLocals(this.largestStackFrame);
    }

    public void gatherOutputProperties(Properties properties) {
        Vector vector = this.topLevel;
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof XSLOutput) {
                ((XSLOutput)e).gatherOutputProperties(properties);
            }
            ++n;
        }
    }

    public void updateOutputProperties(Properties properties, Context context) throws TransformerException {
        Vector vector = this.topLevel;
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof XSLOutput) {
                ((XSLOutput)e).updateOutputProperties(properties, context);
            }
            ++n;
        }
    }

    public Class getExternalJavaClass(String string) throws TransformerException {
        Vector vector = this.topLevel;
        if (!((Boolean)this.getPreparedStyleSheet().getTransformerFactory().getAttribute("http://icl.com/saxon/feature/allow-external-functions")).booleanValue()) {
            return null;
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            XSLScript xSLScript;
            Class clazz;
            Object e = vector.elementAt(n);
            if (e instanceof XSLScript && (clazz = (xSLScript = (XSLScript)e).getJavaClass(string)) != null) {
                return clazz;
            }
            --n;
        }
        return null;
    }

    public void process(Context context) throws TransformerException {
        Object e;
        int n;
        Controller controller = context.getController();
        String string = this.getAttributeValue("http://icl.com/saxon", "trace");
        if (string != null && string.equals("yes")) {
            controller.setTraceListener(new SimpleTraceListener());
        }
        Vector vector = this.topLevel;
        boolean bl = controller.isTracing();
        TraceListener traceListener = null;
        if (bl) {
            traceListener = controller.getTraceListener();
            n = 0;
            while (n < vector.size()) {
                e = vector.elementAt(n);
                traceListener.toplevel((NodeInfo)e);
                ++n;
            }
        }
        n = 0;
        while (n < vector.size()) {
            e = vector.elementAt(n);
            if (e instanceof StyleElement) {
                try {
                    if (bl && !(e instanceof XSLTemplate)) {
                        traceListener.enter((StyleElement)e, context);
                        ((StyleElement)e).process(context);
                        traceListener.leave((StyleElement)e, context);
                    } else {
                        ((StyleElement)e).process(context);
                    }
                }
                catch (TransformerException transformerException) {
                    throw ((StyleElement)e).styleError(transformerException);
                }
            }
            ++n;
        }
    }
}

