/*
 * Cheops Network User Interface
 *
 * Copyright (C) 1999, Adtran, Inc.
 * 
 * Distributed under the terms of the GNU GPL
 *
 */

#include <gtk/gtkmain.h>
#include <gtk/gtksignal.h>
#include <gtk/gtkfixed.h>
#include "gtklink.h"

static GtkWidgetClass *parent_class = NULL;

static void gtk_link_class_init (GtkLinkClass *);
static void gtk_link_init (GtkLink *);
static gint gtk_link_expose (GtkWidget *, GdkEventExpose *event);

guint
gtk_link_get_type ()
{
	static guint link_type = 0;

	if (!link_type) {
		GtkTypeInfo link_info =
            	{
              		"Gtklink",
              		sizeof (GtkLink),
              		sizeof (GtkLinkClass),
               		(GtkClassInitFunc) gtk_link_class_init,
               		(GtkObjectInitFunc) gtk_link_init,
               		NULL,
               		NULL,
		};

		link_type = gtk_type_unique (gtk_widget_get_type (), &link_info);
       }

       return link_type;
}

static void
gtk_link_class_init (GtkLinkClass *class)
{
         GtkObjectClass *object_class;
         GtkWidgetClass *widget_class;

         object_class = (GtkObjectClass*) class;
         widget_class = (GtkWidgetClass*) class;

         parent_class = gtk_type_class (gtk_widget_get_type ());

         widget_class->expose_event = gtk_link_expose;

}

static void
gtk_link_init (GtkLink *link)
{
	 GTK_WIDGET_SET_FLAGS(link, GTK_NO_WINDOW);

         link->x1 = -1;
	 link->x2 = -1;
	 link->y1 = -1;
	 link->y2 = -1;
	 link->xos=0;
	 link->yos=0;
}

GtkWidget*
gtk_link_new (void)
{
         GtkLink *link;

         link = gtk_type_new (gtk_link_get_type ());

         return GTK_WIDGET (link);
}

static gint gtk_link_expose (GtkWidget *widget, GdkEventExpose *event)
{
	GtkLink *link;

	g_return_val_if_fail (widget != NULL, FALSE);
        g_return_val_if_fail (GTK_IS_LINK (widget), FALSE);
        g_return_val_if_fail (event != NULL, FALSE);

	link = GTK_LINK(widget);	
	
	if ((link->x1 < 0) || (link->x2 < 0) || (link->y1 < 0) || (link->y2 < 0))
		return FALSE;

	gdk_draw_line (widget->window,
                       widget->style->fg_gc[widget->state],
                       link->x1 ,
                       link->y1 ,
                       link->x2 ,
                       link->y2);
	return FALSE;
}

void gtk_link_set_coords(GtkLink *link, int x1, int y1, int x2, int y2)
{

	int s;
	int diff=0;
	g_return_if_fail (link != NULL);
        g_return_if_fail (GTK_IS_LINK (link));


	if (x2 < x1) {
		s = x2;
		x2=x1;
		x1 = s;
		s = y2;
		y2=y1;
		y1 = s;
	}

	if (x1 >= 0) {
		if (link->x1 != x1)
			diff++;
		link->x1 = x1;
	}
	if (y1 >= 0) {
		if (link->y1 != y1)
			diff++;
		link->y1 = y1;
	}
	if (x2 >= 0) {
		if (link->x2 != x2)
			diff++;
		link->x2 = x2;
	}
	if (y2 >= 0) { 
		if (link->y2 != y2)
			diff++;
		link->y2 = y2;
	}
	
	if ((x1 < 0) || (x2 < 0) || (y1 < 0) || (y2 < 0)) {
		GTK_WIDGET(link)->requisition.width = 0;
		GTK_WIDGET(link)->requisition.height = 0;
		link->xos=0;
		link->yos=0;
	} else 
	if (diff) {
		GTK_WIDGET(link)->requisition.width = MAX(x2,x1)  - MIN(x1,x2) + 1;
		GTK_WIDGET(link)->requisition.height = MAX(y2,y1) - MIN(y2,y1) + 1;
		link->xos = MIN(x1,x2);
		link->yos = MIN(y1,y2);
		gtk_widget_set_uposition(GTK_WIDGET(link), link->xos, link->yos);
	}

	if (GTK_WIDGET_VISIBLE(link) && diff) {
		gtk_widget_queue_resize(GTK_WIDGET(link));
	}
}
