# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [v1.3.0]

### Changed

- [3ebcf6b](https://github.com/williamdes/mariadb-mysql-kbs/commit/3ebcf6be61ce1accd8b8477b36ef65e8f1439f29) [MySQL] updates
- [95178f7](https://github.com/williamdes/mariadb-mysql-kbs/commit/95178f78598c82be01343206dbf3af3a82668e14) [MariaDB] updates
- [49c426c](https://github.com/williamdes/mariadb-mysql-kbs/commit/49c426c1a26470430d7acc9523203a497545172d) [MySQL] updates
- [c2fa420](https://github.com/williamdes/mariadb-mysql-kbs/commit/c2fa420e0eba4064a8a7c479220e7551f8db513e) [MySQL] updates
- [2cbd269](https://github.com/williamdes/mariadb-mysql-kbs/commit/2cbd269c36110658fbd3351c3ec86a0896c90970) [MySQL] updates
- [e597c4e](https://github.com/williamdes/mariadb-mysql-kbs/commit/e597c4e8c325a536dec78d63bd2830e12a900e6c) [MariaDB] updates
- [6f2eccf](https://github.com/williamdes/mariadb-mysql-kbs/commit/6f2eccf9cee1277ddca35f10e8d5933f6dc47e61) [MySQL] updates
- [a38c721](https://github.com/williamdes/mariadb-mysql-kbs/commit/a38c72172a447069e8bbd08ffaf3620ebf17d121) [MySQL] updates
- [435f5d2](https://github.com/williamdes/mariadb-mysql-kbs/commit/435f5d293be75297f6b0a583283e57067b429237) [MySQL] updates
- [55c37c0](https://github.com/williamdes/mariadb-mysql-kbs/commit/55c37c05d704e742e548f83d22c317885507972e) [MySQL] updates
- [70dafa1](https://github.com/williamdes/mariadb-mysql-kbs/commit/70dafa1643467fda7b757693a80657b7e410da50) 🤖 Some updates 🤖
- [0b67fa3](https://github.com/williamdes/mariadb-mysql-kbs/commit/0b67fa36a28a0edf8bb855fdb513bc2b68cde994) [MariaDB] && [MySQL] updates
- [47ea5bf](https://github.com/williamdes/mariadb-mysql-kbs/commit/47ea5bfff1dd64df5d851de3ba5ceb7b8bf07290) [MariaDB] updates
- [05c1792](https://github.com/williamdes/mariadb-mysql-kbs/commit/05c1792d53892faea152bace044cf10f51a15957) [MariaDB] && [MySQL] updates
- [968d99a](https://github.com/williamdes/mariadb-mysql-kbs/commit/968d99a36a059c49806fcf5b4ff8922c4fa9cd36) [MariaDB] && [MySQL] updates
- [a5f4c83](https://github.com/williamdes/mariadb-mysql-kbs/commit/a5f4c83d2bd77f80e031bf3cbdc7d18912009287) [MariaDB] updates
- [3a5a298](https://github.com/williamdes/mariadb-mysql-kbs/commit/3a5a298ceb765a67d4c6b96eedee77ab5b502caf) [MariaDB] && [MySQL] updates
- [1830af0](https://github.com/williamdes/mariadb-mysql-kbs/commit/1830af0b6787b4b09e5f965bbd6e3f306962d4fa) [MySQL] updates
- [e5fb3b5](https://github.com/williamdes/mariadb-mysql-kbs/commit/e5fb3b581a59b5d1e3ac2a6407708c755d99d1fd) [MariaDB] && [MySQL] updates
- [5789b4e](https://github.com/williamdes/mariadb-mysql-kbs/commit/5789b4e1c7663d6186c43eb6238f095575a1bc34) [MariaDB] updates
- [0e71c5f](https://github.com/williamdes/mariadb-mysql-kbs/commit/0e71c5f1a39471b850a390be5bb2a6a866779b47) [MariaDB] updates
- [b86e4fd](https://github.com/williamdes/mariadb-mysql-kbs/commit/b86e4fd4f1b8fa2da8f9adeb38e76f8760b9b18f) [MariaDB] updates
- [69f672b](https://github.com/williamdes/mariadb-mysql-kbs/commit/69f672b4f6a0f6a281a9f0e5e664cd041ef49a74) [MariaDB] updates
- [05e5265](https://github.com/williamdes/mariadb-mysql-kbs/commit/05e526519efec5d7a355f7b080a83d0cf8a4be53) [MariaDB] updates
- [1f14d40](https://github.com/williamdes/mariadb-mysql-kbs/commit/1f14d40bcb4df6b99e62e74b808280a3a683c991) [MariaDB] && [MySQL] updates
- [77c2421](https://github.com/williamdes/mariadb-mysql-kbs/commit/77c2421b7783d174792d2dd7a2d03c99248741b6) [MariaDB] updates
- [17d6fcc](https://github.com/williamdes/mariadb-mysql-kbs/commit/17d6fcc2140136f1523ad5cce3fa6c412c6d179e) [MySQL] updates
- [750fae2](https://github.com/williamdes/mariadb-mysql-kbs/commit/750fae2142255336f9615dc0679f628971778c50) [MariaDB] updates
- [a1f9ebf](https://github.com/williamdes/mariadb-mysql-kbs/commit/a1f9ebf7f08ed5810924dc072440105b30f5f3a4) [MariaDB] updates
- [e0bf90d](https://github.com/williamdes/mariadb-mysql-kbs/commit/e0bf90dfe8fc85b4027de95ba001d22432d108c1) [MySQL] updates
- [3c04516](https://github.com/williamdes/mariadb-mysql-kbs/commit/3c045169defe28dd15ab7b41f11e08c1fbb8a7e5) [MariaDB] updates
- [44b81ec](https://github.com/williamdes/mariadb-mysql-kbs/commit/44b81ec9e545156125f69a64fb5d9a0673c6189f) [MariaDB] updates
- [578d933](https://github.com/williamdes/mariadb-mysql-kbs/commit/578d9338fdfeb3aef70dbbad1d38ec333228078e) [MariaDB] && [MySQL] updates
- [512abb9](https://github.com/williamdes/mariadb-mysql-kbs/commit/512abb98f16e0d2d029d87849cd0a234580114ce) [MySQL] updates
- [9d21121](https://github.com/williamdes/mariadb-mysql-kbs/commit/9d21121f36bfe8573ab27c60177af37fb6003aa5) [MySQL] updates
- [a30b051](https://github.com/williamdes/mariadb-mysql-kbs/commit/a30b051ed74c8e2d5b6576420d44cdb50dedf95d) [MySQL] updates
- [0bc9215](https://github.com/williamdes/mariadb-mysql-kbs/commit/0bc921533bbe0847f09b3b95a75abfc4a8921f1e) [MariaDB] updates
- [a7c1571](https://github.com/williamdes/mariadb-mysql-kbs/commit/a7c1571b88d54c831aa148dbc77ab1aa436d0aaa) [MariaDB] updates
- [98c3fb4](https://github.com/williamdes/mariadb-mysql-kbs/commit/98c3fb4cb21a0003a7c636e6de3fea830a669175) [MariaDB] updates
- [e229d13](https://github.com/williamdes/mariadb-mysql-kbs/commit/e229d136e5859b39d921b51a1c6fc7c438913286) [MariaDB] updates
- [068042f](https://github.com/williamdes/mariadb-mysql-kbs/commit/068042f3c0135ba433b242b40e39a24c7d653d42) [MariaDB] && [MySQL] updates
- [8b1a2e7](https://github.com/williamdes/mariadb-mysql-kbs/commit/8b1a2e71f847671b31620fb1b6ef03b3cad1cd6c) [MariaDB] updates
- [1c0ca16](https://github.com/williamdes/mariadb-mysql-kbs/commit/1c0ca16d5a26eb5feed28640f8b80e2576408ab3) [MySQL] updates
- [a812d9f](https://github.com/williamdes/mariadb-mysql-kbs/commit/a812d9f74685ded12850a40fc8b830f6dfc9158d) [MariaDB] && [MySQL] updates

### Fixed

- [1fe544a](https://github.com/williamdes/mariadb-mysql-kbs/commit/1fe544a3323100432cd8f0ab4aef2daf1c9fd186) id can be missing
- [64af575](https://github.com/williamdes/mariadb-mysql-kbs/commit/64af575e124cef4dce3f39dbdb45ce6defe9cfb9) allow dots in variable names
- [9021078](https://github.com/williamdes/mariadb-mysql-kbs/commit/90210780ee02c658b88e74a18c26566f2baec465) better handling of some specific cases
- [8affa1a](https://github.com/williamdes/mariadb-mysql-kbs/commit/8affa1a279150d78619f5a31140dfeff3cf56119) minor fixups
- [cb55dc0](https://github.com/williamdes/mariadb-mysql-kbs/commit/cb55dc026ce0a5e5e18960c61308740f9d5eeca1) schema updates
- [1a495a9](https://github.com/williamdes/mariadb-mysql-kbs/commit/1a495a9b81dc395aa2b7919579f2afb4c65ac482) remove non needed code
- [a0cb494](https://github.com/williamdes/mariadb-mysql-kbs/commit/a0cb4948df39ad1424a07a87a7473271c2e53612) update and improve schemas
- [edc6964](https://github.com/williamdes/mariadb-mysql-kbs/commit/edc69642983c1280f6497c2877897a2b1fa35574) update Aurora MySQL anchor
- [baa60c2](https://github.com/williamdes/mariadb-mysql-kbs/commit/baa60c2c9ed17e74ed21104972481b532ef59cf1) merge script
- [1a5b954](https://github.com/williamdes/mariadb-mysql-kbs/commit/1a5b95491f7d1c3a9acdb7f07775e2e4e0e1da25) release script upload artifact
- [5139349](https://github.com/williamdes/mariadb-mysql-kbs/commit/513934986e8c0b990143e8fcb76a5474df15d713) release script detect non valid token

### Features

- [80f2d83](https://github.com/williamdes/mariadb-mysql-kbs/commit/80f2d83a0f5734cdadce581658bf5206b201b936) support keyring-system-variables
- [b9a5257](https://github.com/williamdes/mariadb-mysql-kbs/commit/b9a525720a4cd90e9a812c3810e46bd1e7e5f32e) add variables for MySQL 5.7
- [0b2a6ad](https://github.com/williamdes/mariadb-mysql-kbs/commit/0b2a6ad48341fc34aa6136f1fe5b66ddb739a57e) implement variables index
- [8c60fff](https://github.com/williamdes/mariadb-mysql-kbs/commit/8c60fffc7a6b3c55427e772c8f4015fbe3a629e7) also support statvar_
- [d1bec07](https://github.com/williamdes/mariadb-mysql-kbs/commit/d1bec0718b9ee9132468eae7bd3d941417be94da) also search into server-status-variables
- [20871d6](https://github.com/williamdes/mariadb-mysql-kbs/commit/20871d6e3dad305fb702d1922ded95cedf75ae26) handle links without table contents
- [601cb68](https://github.com/williamdes/mariadb-mysql-kbs/commit/601cb68d0fcff88204846beb202ae61a9603898e) implement Aurora MySQL
- [f83b854](https://github.com/williamdes/mariadb-mysql-kbs/commit/f83b854cdaed51b63e168ce2c814bb7542aa0591) implement optional id and Aurora MySQL
- [71ab731](https://github.com/williamdes/mariadb-mysql-kbs/commit/71ab731707b260b3be550dcff1d1dc80b235774f) update schemas
- [d6a4673](https://github.com/williamdes/mariadb-mysql-kbs/commit/d6a467381dac5445d8fec483f4409648370fe472) allow phpunit 10 and 11
- [d0c3176](https://github.com/williamdes/mariadb-mysql-kbs/commit/d0c317692cf7f3f23a1c9d9cdab7328c82c8438e) implement AWS variables
- [e0fb457](https://github.com/williamdes/mariadb-mysql-kbs/commit/e0fb457bb4be8575e14def02435013520c724119) refactor find missing data script to Rust
- [6e42be2](https://github.com/williamdes/mariadb-mysql-kbs/commit/6e42be2f7c852358b9768cde00c11fded3749104) stop storing the data in a static
- [569c92b](https://github.com/williamdes/mariadb-mysql-kbs/commit/569c92bda5c392f1d4dad692cdc90ac381de7c4b) implement a search engine to search into the data

### Documentation

- [36864e7](https://github.com/williamdes/mariadb-mysql-kbs/commit/36864e7c5b7509bd72341f9b2af4504db9804250) add a maintenance badge

### Others

- [e9c2091](https://github.com/williamdes/mariadb-mysql-kbs/commit/e9c2091418cd9680c5a362570d03582cbcfd73f2) support crates.io
- [0e73a47](https://github.com/williamdes/mariadb-mysql-kbs/commit/0e73a478c37b3c22e7316c5c9179cea668d0459a) bump dependencies
- [2cf1ff2](https://github.com/williamdes/mariadb-mysql-kbs/commit/2cf1ff25ddac2ef505fd14ad7779bd665d8051e5) drop changelog-generator-twig
- [a812ffa](https://github.com/williamdes/mariadb-mysql-kbs/commit/a812ffab3964e8a314735bb1033bb5bb0afbfd0e) use Node 20
- [f1572be](https://github.com/williamdes/mariadb-mysql-kbs/commit/f1572beb30485c4e2c3a107a2dc0b0eca97e7eb2) bump actions
- [2c9ced6](https://github.com/williamdes/mariadb-mysql-kbs/commit/2c9ced6764382d392c633bcd50f2189519e97fd5) bump Rust to 1.3.0-rc6
- [dd124b2](https://github.com/williamdes/mariadb-mysql-kbs/commit/dd124b2760c8915b49a3bad3bd258d662eeca8a5) add token to coverage upload
- [12a4d39](https://github.com/williamdes/mariadb-mysql-kbs/commit/12a4d3973a239fb15b60f85138a42d0cc1274d30) bump actions
- [0e7e637](https://github.com/williamdes/mariadb-mysql-kbs/commit/0e7e637056934ddde9cd1dba0c1d5460cb0fe4a6) use rc5
- [f962813](https://github.com/williamdes/mariadb-mysql-kbs/commit/f96281334fee0fc08d1bf7ef851ade5b12524cc3) bump Rust to 1.3.0-rc5
- [5b3e270](https://github.com/williamdes/mariadb-mysql-kbs/commit/5b3e270e3948786fb1674025e402728c6e7ceefd) use rc4
- [673fe7c](https://github.com/williamdes/mariadb-mysql-kbs/commit/673fe7cd5a38f7534df12b898b79b9a5297f0022) bump Rust to 1.3.0-rc4
- [030397e](https://github.com/williamdes/mariadb-mysql-kbs/commit/030397e0936c01d7fca5e5e473d9eaf8115e9b31) update editorconfig
- [21c417c](https://github.com/williamdes/mariadb-mysql-kbs/commit/21c417cdcccc48f2334968bdf656a348689f7348) exclude .github from sudo-bot
- [e10df8f](https://github.com/williamdes/mariadb-mysql-kbs/commit/e10df8f3a5c79b8101d0553ac3b377a4fc0772e0) exclude .github from git ls files
- [fed8500](https://github.com/williamdes/mariadb-mysql-kbs/commit/fed85005416f009b3afdd303e3524b1dc15299f3) fix current dir "." in find
- [a6821c6](https://github.com/williamdes/mariadb-mysql-kbs/commit/a6821c6d4904cbe6e2d498154ee1b573052ba2da) fix excluding folder paths
- [78b002a](https://github.com/williamdes/mariadb-mysql-kbs/commit/78b002a76a52b3d6af7c797236622b16ab45fcb0) fix file cleanup
- [2e4713c](https://github.com/williamdes/mariadb-mysql-kbs/commit/2e4713c87e77c49b90c0b877104d1f36bba26190) improve cleanup script
- [d915fdb](https://github.com/williamdes/mariadb-mysql-kbs/commit/d915fdb405b3f1e1313dd8e77f621968a09852e4) fix coverage on PHP 7.2
- [a317c6d](https://github.com/williamdes/mariadb-mysql-kbs/commit/a317c6dd664d012a7e96c3108942c38a7489c9af) fix coverage filter
- [8325323](https://github.com/williamdes/mariadb-mysql-kbs/commit/8325323b28353bc9d69dc99db7986e581917b147) fix sending coverage
- [be53582](https://github.com/williamdes/mariadb-mysql-kbs/commit/be53582e85d2ff3ff1f6c9368f4dbad6f8613989) bump JS dependencies
- [6ae9f27](https://github.com/williamdes/mariadb-mysql-kbs/commit/6ae9f278003cdc2814bcbf22a308f90595dc9095) bump Rust to 1.74
- [c8c5921](https://github.com/williamdes/mariadb-mysql-kbs/commit/c8c59210d2d2e87430ec9586f26e65f5e0564ee3) bump to RC3
- [bfc2165](https://github.com/williamdes/mariadb-mysql-kbs/commit/bfc216599942225409acc19c43cd2a08a4948820) bump Rust to 1.3.0-rc3
- [d60f35e](https://github.com/williamdes/mariadb-mysql-kbs/commit/d60f35e3b8bb884394e59eb5e64a28453251e466) bump dependencies
- [9594c2d](https://github.com/williamdes/mariadb-mysql-kbs/commit/9594c2d09ffb7fe67a1ffbbcf8b5d50f76aaead5) install grcov
- [bb60ba9](https://github.com/williamdes/mariadb-mysql-kbs/commit/bb60ba9bcc6962007002bb826a2713bad2c9246c) remove /test and /phpunit.xml from the vendor tarball
- [56fc4d8](https://github.com/williamdes/mariadb-mysql-kbs/commit/56fc4d80119e3856973b8d17aae5e621efb7cf8a) add workflow_dispatch for two workflows
- [53d9d17](https://github.com/williamdes/mariadb-mysql-kbs/commit/53d9d17fe039178f101684fd504dfb7f9730c8af) drop support for PHP 7.1
- [7a579c0](https://github.com/williamdes/mariadb-mysql-kbs/commit/7a579c03aa502abfd048785cce402f438847c7dd) bumps
- [1313a81](https://github.com/williamdes/mariadb-mysql-kbs/commit/1313a811841a898c79eb6492ae5b8dca4b5ef877) improve key name
- [63e20b6](https://github.com/williamdes/mariadb-mysql-kbs/commit/63e20b64a6683c13bc4b80d978cfaf79405a15c0) add more fun to my PRs
- [c5d518a](https://github.com/williamdes/mariadb-mysql-kbs/commit/c5d518a7b81b527c18701a3d7bbbc51fbe19b7d4) upgrade prettier
- [f959ff1](https://github.com/williamdes/mariadb-mysql-kbs/commit/f959ff1ddadf2330ae55373a9df0dc8debe51462) fixup create-pr.sh
- [0587253](https://github.com/williamdes/mariadb-mysql-kbs/commit/058725393a6b1ecc679a79dfc52cd2264e10e761) upgrade dependencies
- [39cb676](https://github.com/williamdes/mariadb-mysql-kbs/commit/39cb676ebb7622064927c2577c38fe0d6552af9a) drop non used code block

## [v1.2.14]

### Changed

- [4e0db1e](https://github.com/williamdes/mariadb-mysql-kbs/commit/4e0db1e4fbfed4db6d7fee042f0127c8c6fe49f4) 🤖 Some updates 🤖
- [1a00fee](https://github.com/williamdes/mariadb-mysql-kbs/commit/1a00fee805173cdd16529890c5e1750acb18ec2f) [MariaDB] updates
- [61dabb8](https://github.com/williamdes/mariadb-mysql-kbs/commit/61dabb8615870f257df510aa776847143015161e) [MariaDB] updates
- [4191cc3](https://github.com/williamdes/mariadb-mysql-kbs/commit/4191cc3f6dca9c0b45f7fe9edb6546a5cb9c5fc3) [MariaDB] && [MySQL] updates
- [45f9a5b](https://github.com/williamdes/mariadb-mysql-kbs/commit/45f9a5b804ad247b49809e306124cc4626adced5) [MariaDB] updates
- [90cd023](https://github.com/williamdes/mariadb-mysql-kbs/commit/90cd023cd653139da1a77fc7e66ca22090cd8794) [MariaDB] updates
- [949efc5](https://github.com/williamdes/mariadb-mysql-kbs/commit/949efc519489d4ba0c61faaa9b595ce030f9497a) [MariaDB] updates
- [d05a0f4](https://github.com/williamdes/mariadb-mysql-kbs/commit/d05a0f48a05170f2bfb19684aeabc8afc4bfec92) [MariaDB] && [MySQL] updates
- [a637d2e](https://github.com/williamdes/mariadb-mysql-kbs/commit/a637d2e94a7c4ec0531d806a84ebe79db6e2407c) [MySQL] updates
- [ff1fc4c](https://github.com/williamdes/mariadb-mysql-kbs/commit/ff1fc4c8594bcdf09dfc728f79fe536e63472012) [MariaDB] updates
- [128a3b6](https://github.com/williamdes/mariadb-mysql-kbs/commit/128a3b67201abc717830760d0e8194133df18c88) [MariaDB] updates
- [3ae4a1f](https://github.com/williamdes/mariadb-mysql-kbs/commit/3ae4a1f34ebee7416c369456e3b8fc70eb8ff6c7) [MariaDB] updates
- [f4ff905](https://github.com/williamdes/mariadb-mysql-kbs/commit/f4ff9057a75d0c39d4f994b5cf5a93b871485536) [MariaDB] updates
- [e4f6a92](https://github.com/williamdes/mariadb-mysql-kbs/commit/e4f6a923dd18e8b748f25bed491cafec9c4cd2fb) [MariaDB] updates
- [6cb972f](https://github.com/williamdes/mariadb-mysql-kbs/commit/6cb972f63a82c9598ec215292a1988c79294d99c) [MySQL] updates
- [a4adf6d](https://github.com/williamdes/mariadb-mysql-kbs/commit/a4adf6d4528fced180ddf87b1e79c0836d190182) [MariaDB] updates
- [dbb0cab](https://github.com/williamdes/mariadb-mysql-kbs/commit/dbb0cabf6a9bc925cee0f995de870b83465fbf6b) [MariaDB] && [MySQL] updates
- [f85d339](https://github.com/williamdes/mariadb-mysql-kbs/commit/f85d339d80c370c1ca6428540875adfaf02e758e) [MySQL] updates
- [2425f11](https://github.com/williamdes/mariadb-mysql-kbs/commit/2425f11c900df98a943ada83270edb9d615b4339) [MariaDB] updates
- [e77b759](https://github.com/williamdes/mariadb-mysql-kbs/commit/e77b7596bdf6f638748e81ddd045afb42ad1c8a2) [MariaDB] updates
- [84e651d](https://github.com/williamdes/mariadb-mysql-kbs/commit/84e651d99fc0d7c1b6ed96470e699d306137d843) [MySQL] updates
- [10d5cf7](https://github.com/williamdes/mariadb-mysql-kbs/commit/10d5cf7107b1c5f576d28062f2e50028ee0becd6) [MySQL] updates
- [115a407](https://github.com/williamdes/mariadb-mysql-kbs/commit/115a40767d7c9790a949489eaca363a721f3bd06) [MariaDB] updates
- [8a3fc60](https://github.com/williamdes/mariadb-mysql-kbs/commit/8a3fc60ac7e9a73848a5032f6f0f27f184bb085c) [MySQL] updates
- [d9a691c](https://github.com/williamdes/mariadb-mysql-kbs/commit/d9a691cfb1b8c0e3e430b33976e2cd2d9572eef4) [MariaDB] updates
- [0642bd1](https://github.com/williamdes/mariadb-mysql-kbs/commit/0642bd184f1b25a562358accdb646820c8cc2e30) [MariaDB] && [MySQL] updates
- [f53bc86](https://github.com/williamdes/mariadb-mysql-kbs/commit/f53bc86aaae10d30f898598ec5930ee7ba6c9c85) [MariaDB] && [MySQL] updates
- [8ed4c82](https://github.com/williamdes/mariadb-mysql-kbs/commit/8ed4c82675a0292a7e28cd37a5284cb378129ddd) [MariaDB] && [MySQL] updates
- [7bef047](https://github.com/williamdes/mariadb-mysql-kbs/commit/7bef047cc9d62fbf694f7ac12d02aa10a66a4243) [MySQL] updates
- [ce74236](https://github.com/williamdes/mariadb-mysql-kbs/commit/ce74236928f582b9d11b32cf5b2241a145a49f6b) [MariaDB] updates
- [ad65873](https://github.com/williamdes/mariadb-mysql-kbs/commit/ad65873039e2d369faa5e22205e80ca4944f73af) [MySQL] updates
- [ad4583d](https://github.com/williamdes/mariadb-mysql-kbs/commit/ad4583d53bb2fd847aca5bce89217531d0af4b73) [MySQL] updates
- [54fbf31](https://github.com/williamdes/mariadb-mysql-kbs/commit/54fbf31043cc256c9fcb428298a1ff1af7ec5db5) [MariaDB] && [MySQL] updates
- [5104adb](https://github.com/williamdes/mariadb-mysql-kbs/commit/5104adb9295b9ae05a74d36809ef0313fadd4198) [MariaDB] updates

### Fixed

- [42567a2](https://github.com/williamdes/mariadb-mysql-kbs/commit/42567a2ca369a00cc282fca21a42311827744b40) --allow-empty for commits that are already made (maybe)
- [eda616e](https://github.com/williamdes/mariadb-mysql-kbs/commit/eda616ee84768fdc07abd2eb014fcae67b763b5c) broken data links
- [e6e8f99](https://github.com/williamdes/mariadb-mysql-kbs/commit/e6e8f99a56e329d0fff051f58a498089284e0bcd) remove keywords
- [3d0a42f](https://github.com/williamdes/mariadb-mysql-kbs/commit/3d0a42f89937c342f975a90f7a15f30796cea840) do not allow all default values to use the first <code> tag
- [0f2b9ad](https://github.com/williamdes/mariadb-mysql-kbs/commit/0f2b9aded144661edc24623ac8816518c35152fc) better implement default and key name handling
- [a8e944e](https://github.com/williamdes/mariadb-mysql-kbs/commit/a8e944e3ba8e398c8b44e416d772403bc97d2b84) improve range and type detection
- [35f2c28](https://github.com/williamdes/mariadb-mysql-kbs/commit/35f2c28497902866c39bfd80727be1f2948b43b4) also detect properly data type with a comment
- [7f6c3a7](https://github.com/williamdes/mariadb-mysql-kbs/commit/7f6c3a715d4a8267c5804c082b2aaa5980795f09) also handle "type" for data type
- [62102a7](https://github.com/williamdes/mariadb-mysql-kbs/commit/62102a7b1425fb2a99ab64eef8a8b4354cb8d67b) skip serialize if Range is empty
- [d6ca996](https://github.com/williamdes/mariadb-mysql-kbs/commit/d6ca996010cc2f23ebbe73be3a0dbb4fc3578468) drop useless data from mysql options list at MariaDB

### Features

- [ab411c2](https://github.com/williamdes/mariadb-mysql-kbs/commit/ab411c230adff9b5264cc0205eb83e59872ab86a) implement some more small quirks to support more data
- [9087cdc](https://github.com/williamdes/mariadb-mysql-kbs/commit/9087cdc6a2a01ac7f4504a40acb6aee4ca5ac9ec) support "Range - 64 bit" and "Default Value - 64 bit"
- [648d431](https://github.com/williamdes/mariadb-mysql-kbs/commit/648d431ff056bc0461a1635f5a4f4fbaed7e374a) implement --dataset on the CLI and cleanup the CLI
- [c834981](https://github.com/williamdes/mariadb-mysql-kbs/commit/c8349813e398362fbe9db68310e42e604d1ae330) implement is_removed for mariadb variables
- [668ece2](https://github.com/williamdes/mariadb-mysql-kbs/commit/668ece2d4b35e4a57655b1879fed41f1ad87f48d) implement back finding type by description
- [e870390](https://github.com/williamdes/mariadb-mysql-kbs/commit/e870390b37a212e018c23d346510ba326d872939) implement more cases to handle range data
- [5e62fb5](https://github.com/williamdes/mariadb-mysql-kbs/commit/5e62fb5fbbc51576bb3536a3cc10b4d28ebf0679) implement has_description
- [4e5d00f](https://github.com/williamdes/mariadb-mysql-kbs/commit/4e5d00f9ab143d97697dfd154b42bd574cc1429e) implement back "upwards" on Range
- [f2573fd](https://github.com/williamdes/mariadb-mysql-kbs/commit/f2573fdc1763fe6831e8715ada70199860abd710) implement mariadb parsing
- [7b57a5c](https://github.com/williamdes/mariadb-mysql-kbs/commit/7b57a5c3f02d9c5646556a57fe0b2bf4459d1381) better implement back the searching for the anchor
- [94c3137](https://github.com/williamdes/mariadb-mysql-kbs/commit/94c31373cd675f78a08cb66a6069887a2538a339) handle floats and write all mysql files and use LF instead of CRLF
- [3ea756d](https://github.com/williamdes/mariadb-mysql-kbs/commit/3ea756d9deb5bc21d3f2cd0c585122f90797dcb7) implement writing files
- [17f8046](https://github.com/williamdes/mariadb-mysql-kbs/commit/17f8046a942cac0000a68b5516248102631f30e2) implement serializing data and more options
- [e1c850a](https://github.com/williamdes/mariadb-mysql-kbs/commit/e1c850ad95ab076fa7c2f65725849ccb4d914fa9) implement more fields of the struct
- [31d57b3](https://github.com/williamdes/mariadb-mysql-kbs/commit/31d57b3d85705587de6adf9ab35c95852ac14c8a) support rust cargo
- [a3d4c9b](https://github.com/williamdes/mariadb-mysql-kbs/commit/a3d4c9b38c37e075b0cc48feb1db4bbee8c6e61d) add a type to files
- [5cca3f5](https://github.com/williamdes/mariadb-mysql-kbs/commit/5cca3f56267a8100c50d037e26be7c27cfbfa2b2) add new MariaDB documentations
- [ea189ee](https://github.com/williamdes/mariadb-mysql-kbs/commit/ea189ee6e564e4a2512512ef01c5f21053e692ca) add missing URLs for MariaDB data
- [f0a41ac](https://github.com/williamdes/mariadb-mysql-kbs/commit/f0a41ac5ddd7d9311dc98f82ce6752c3cff831fc) add a script to find missing MariaDB data
- [9389b9a](https://github.com/williamdes/mariadb-mysql-kbs/commit/9389b9a7b4f98818ea1d56c41038ee279dae5006) add sql-error-log-plugin for MariaDB
- [bd99d8d](https://github.com/williamdes/mariadb-mysql-kbs/commit/bd99d8d0e07c775c60ef06511dedf95860895bbb) add allow-plugins to composer.json

### Documentation

- [2c6d0cf](https://github.com/williamdes/mariadb-mysql-kbs/commit/2c6d0cf808d361f5458f47479e136b689c5547a0) update CHANGELOG.md
- [9a5f284](https://github.com/williamdes/mariadb-mysql-kbs/commit/9a5f2848a9c3655fdfe9b9476a35704d0b2ae9cb) replace LGTM.com that will shut-down in december by rust-reportcard.xuri.me
- [0160852](https://github.com/williamdes/mariadb-mysql-kbs/commit/01608529cecd8094d84fa2131028b271e046fe89) fix some phpdocs that are nullable
- [833ab62](https://github.com/williamdes/mariadb-mysql-kbs/commit/833ab62e7315ad2da9eb9e6a9fe8118a120efffd) update my website link
- [a800a45](https://github.com/williamdes/mariadb-mysql-kbs/commit/a800a4550b1d3fa9f069a3526297aa1182e893d0) drop non working dependency badge

### Testing

- [1c77f85](https://github.com/williamdes/mariadb-mysql-kbs/commit/1c77f85fe6b55087a886019c49018cb1ccf7c04e) add more test cases to cover the edge case that was fixed previously

### Others

- [1179505](https://github.com/williamdes/mariadb-mysql-kbs/commit/11795050f328a952809712e2e99a85b562e3c53c) exclude test files from composer archive
- [b2fced3](https://github.com/williamdes/mariadb-mysql-kbs/commit/b2fced3406bcf11e4945b315e18eb517965c54a5) add flags to codecov config and threshold
- [4ef6f98](https://github.com/williamdes/mariadb-mysql-kbs/commit/4ef6f982c973fe8ad4df02c10f782d890625c78d) drop non used PHP commented out code
- [7ec1649](https://github.com/williamdes/mariadb-mysql-kbs/commit/7ec16491d79492dbac1f110fed462525ce80fd8d) add codecov.yml config
- [7cb1d91](https://github.com/williamdes/mariadb-mysql-kbs/commit/7cb1d918c37cc3b1582170a45c52ac6b7e2f2561) bump to rc2
- [2b6276b](https://github.com/williamdes/mariadb-mysql-kbs/commit/2b6276b1c142df29b9db7c9988fbd93f61878484) remove a useless comment
- [14ba5cd](https://github.com/williamdes/mariadb-mysql-kbs/commit/14ba5cd5f809fe67f8cee7e8181c2799a086afa4) report coverage in a different way
- [b1e6617](https://github.com/williamdes/mariadb-mysql-kbs/commit/b1e6617af75dec0e6813f6f7598818c34243a526) fix set-output deprecation
- [514dc35](https://github.com/williamdes/mariadb-mysql-kbs/commit/514dc3543218750a82aece011d9403ec22679a22) make some CIs run on file changes and not always
- [dca1c9b](https://github.com/williamdes/mariadb-mysql-kbs/commit/dca1c9b807cade479e87ef9168d49bd4087d3d51) upgrade js dependencies and remove crawler
- [7cea6f2](https://github.com/williamdes/mariadb-mysql-kbs/commit/7cea6f253a86a0e3ef2d9fc935b40ad2770ac766) exclude src/rust and Cargo.{toml,lock}
- [7303b5b](https://github.com/williamdes/mariadb-mysql-kbs/commit/7303b5b4753584638be157ff2e574b67e1c43c5c) limit Rust CIs to changed files in src/rust
- [223edb4](https://github.com/williamdes/mariadb-mysql-kbs/commit/223edb484755c1693e5f021deeda5819329899af) fixup cron
- [952ab6e](https://github.com/williamdes/mariadb-mysql-kbs/commit/952ab6e065fd75987e739268c732fe6e82d4be35) build
- [0441d2f](https://github.com/williamdes/mariadb-mysql-kbs/commit/0441d2f18eae7015f40022379c786693548bf25c) move parser test to .rs
- [7f60823](https://github.com/williamdes/mariadb-mysql-kbs/commit/7f608237b2c400d887e04e1d87ea1898533e5648) update test case 4 to remove a specific case that does not exist anymore, add tests, and implement a missing syntax
- [3c3a23e](https://github.com/williamdes/mariadb-mysql-kbs/commit/3c3a23eb358e196d26e888f4f07be476544a0a74) remove non used commented code
- [f83060a](https://github.com/williamdes/mariadb-mysql-kbs/commit/f83060a046fb857b0f431d5cb1bf7cbde2c2607a) remove non necessary grov config
- [da5c7d7](https://github.com/williamdes/mariadb-mysql-kbs/commit/da5c7d7c609ea0065b49f0fd619c1e63ff6365a8) cache cargo binaries and install grcov from cargo
- [bbc82fe](https://github.com/williamdes/mariadb-mysql-kbs/commit/bbc82fedcc0f8ddc7baff72da2d80e5d1a552a63) ignore new coverage files
- [25fecb1](https://github.com/williamdes/mariadb-mysql-kbs/commit/25fecb1973cf3c272f4061008251720f3dfdf570) remove verbose on codecov
- [3972cfc](https://github.com/williamdes/mariadb-mysql-kbs/commit/3972cfc25bb7dfd287d0b00f9fb4298c299fa3b3) fix dedupe workflows
- [0614775](https://github.com/williamdes/mariadb-mysql-kbs/commit/06147759be0341e6f144b97ef142c1d679131a29) add missing component and fix bash commands
- [7475be1](https://github.com/williamdes/mariadb-mysql-kbs/commit/7475be1a253d2cc10deeadad88aa8c769a3e2b6b) manually use grcov
- [c2fd0f5](https://github.com/williamdes/mariadb-mysql-kbs/commit/c2fd0f529b8bf7ba6e6731d7174b1aad2b3e8847) add cancel in progress workflow
- [ce45275](https://github.com/williamdes/mariadb-mysql-kbs/commit/ce45275d27c94d6636836ffb9518c38b78ce2c63) add debug step
- [8a8dad9](https://github.com/williamdes/mariadb-mysql-kbs/commit/8a8dad9cb45e83461a866d24272940bc21da527a) remove filter: covered
- [b4786c7](https://github.com/williamdes/mariadb-mysql-kbs/commit/b4786c725644342231bd5367f5309b49a034cb21) try to fixup cargo flags
- [e5bd8cd](https://github.com/williamdes/mariadb-mysql-kbs/commit/e5bd8cd3d9ac6c511fe0587c0c16c85a336902ed) add Rust code coverage
- [d95e54f](https://github.com/williamdes/mariadb-mysql-kbs/commit/d95e54f4d52896959e9d6aabfc0674ab1e832df4) add a workflow to build and test Rust code
- [aa239fa](https://github.com/williamdes/mariadb-mysql-kbs/commit/aa239fa7c9c3f5f017080e2df9368cd0604b07f6) update editorconfig for 2 spaces for data files
- [627ce21](https://github.com/williamdes/mariadb-mysql-kbs/commit/627ce21b5c7d670c29ec0d0916fc0d1e1ee87de2) re-implement most of the MySQL parser
- [057a5d6](https://github.com/williamdes/mariadb-mysql-kbs/commit/057a5d631842ea17ec74a8d58b8872af71a96fea) rustify the mysql.rs file
- [3340ac8](https://github.com/williamdes/mariadb-mysql-kbs/commit/3340ac84f4da65e1877df24bc837c5e3d431855f) move mysql.js to mysql.rs
- [2c61433](https://github.com/williamdes/mariadb-mysql-kbs/commit/2c614333158cb3b36ba2e72e3f6dedd3dc7c78bb) re-build cleaner.js to Rust
- [2393ada](https://github.com/williamdes/mariadb-mysql-kbs/commit/2393ada322758c04d730b86fca36a2047f5fcf10) move cleaner.rs to Rust code
- [71d6974](https://github.com/williamdes/mariadb-mysql-kbs/commit/71d6974466a4e50139ff8d6121c45b84b027e101) move JS code into Rust code
- [fe2e067](https://github.com/williamdes/mariadb-mysql-kbs/commit/fe2e067d57159583f81ece3fbdf214ac750f6d4f) refurbish the Rust implementation from 2 years ago
- [c4660a9](https://github.com/williamdes/mariadb-mysql-kbs/commit/c4660a9385caaeed29b37e9dcd3d89a7b6f82a91) only publish necessary dist files on NPM
- [adf3ae4](https://github.com/williamdes/mariadb-mysql-kbs/commit/adf3ae4f108835948b45d3785d37691b2bbf2937) move variables from data to data/variables
- [1d4d52a](https://github.com/williamdes/mariadb-mysql-kbs/commit/1d4d52a1888a614963f4e74a568047559eddd562) add permissions on workflows
- [56d5b4d](https://github.com/williamdes/mariadb-mysql-kbs/commit/56d5b4d1a119f236638ff430ade79f8286aaed96) bump sudo-bot/action-pull-request-lock to v1.1.0
- [094c0b4](https://github.com/williamdes/mariadb-mysql-kbs/commit/094c0b45276e6c0db222ab6f4ce7f81275dca456) bump sudo-bot/action-pull-request-merge to v1.2.0
- [6db6be0](https://github.com/williamdes/mariadb-mysql-kbs/commit/6db6be06dc1e0505e8ab61a19b9b3a10f8e56e42) also resolve documentation URLs for better final matches
- [766014b](https://github.com/williamdes/mariadb-mysql-kbs/commit/766014b908e9fccc532217ce4a089bd8b205d85b) require node 14
- [5bf9152](https://github.com/williamdes/mariadb-mysql-kbs/commit/5bf9152e6eac3adaefa8fb466e121f488e2f72c6) use node 18
- [ef24a6d](https://github.com/williamdes/mariadb-mysql-kbs/commit/ef24a6da39d84f409f6338d50105e4cf6d12f61c) change the node versions we test
- [d942dd6](https://github.com/williamdes/mariadb-mysql-kbs/commit/d942dd669173c363821ed0f7c646f9c05a6b206b) bump all packages
- [c9d0d2b](https://github.com/williamdes/mariadb-mysql-kbs/commit/c9d0d2bf8f64eb7c545d1614c93b2d02a3670ad9) drop dependabot
- [0794398](https://github.com/williamdes/mariadb-mysql-kbs/commit/07943987a685eb9dc5ce48a8379672d9c15b8114) bump actions/setup-node to v3
- [cd7adcc](https://github.com/williamdes/mariadb-mysql-kbs/commit/cd7adcc9c1fc7ea4694bf35b9a0e78ee23da3d9c) bump prettier from 2.6.1 to 2.6.2
- [8a2ef6e](https://github.com/williamdes/mariadb-mysql-kbs/commit/8a2ef6e54679083722da3d3aca72ad0504a0e9b1) upgrade to actions/checkout@v3
- [aef8c79](https://github.com/williamdes/mariadb-mysql-kbs/commit/aef8c79a0b625e1a16af2a80ce81652607d3806f) improve coding standard config
- [9368b22](https://github.com/williamdes/mariadb-mysql-kbs/commit/9368b22f72140f1a5bad0bd731e14816cd6f3b52) improve composer commands
- [c189c7a](https://github.com/williamdes/mariadb-mysql-kbs/commit/c189c7a93baf5603ebf0dc24383fc5e087612798) bump actions cache to v3
- [fd43621](https://github.com/williamdes/mariadb-mysql-kbs/commit/fd436211070df62e3b07325e639598eea6b5cebb) bump mocha from 9.2.1 to 9.2.2
- [7c90755](https://github.com/williamdes/mariadb-mysql-kbs/commit/7c9075572c7841dbc738cd64b7d83482319be76a) bump prettier from 2.5.1 to 2.6.1
- [8940a2d](https://github.com/williamdes/mariadb-mysql-kbs/commit/8940a2d71cf0d770c0c8203e218607a965b82462) bump minimist from 1.2.5 to 1.2.6
- [8bf032a](https://github.com/williamdes/mariadb-mysql-kbs/commit/8bf032a574af14ae65e9582ab0d8749473305282) bump mocha from 9.2.0 to 9.2.1
- [ff537e6](https://github.com/williamdes/mariadb-mysql-kbs/commit/ff537e6dd240ea9c7bf7977b9acfc1196e1d7358) bump ajv from 6.12.0 to 6.12.6
- [b722655](https://github.com/williamdes/mariadb-mysql-kbs/commit/b722655b701a0cebddb6370daf04de9844390aab) bump jshint from 2.13.2 to 2.13.4
- [edf3d34](https://github.com/williamdes/mariadb-mysql-kbs/commit/edf3d3489a6b1e6ca7cdbcedaf06a180155ef6f3) bump chai from 4.3.4 to 4.3.6
- [a9d8b03](https://github.com/williamdes/mariadb-mysql-kbs/commit/a9d8b03b1c6fc2f1cabe3a6ac8432db0ee336c45) bump mocha from 9.1.3 to 9.2.0
- [a029a60](https://github.com/williamdes/mariadb-mysql-kbs/commit/a029a609238c75140e6feb6298fdb4b3da9e6498) bump jshint from 2.13.1 to 2.13.2

## [v1.2.13]

### Changed

- [e96314f](https://github.com/williamdes/mariadb-mysql-kbs/commit/e96314f47373a45c1829a91d1cd5fa574343ea4a) [MariaDB] && [MySQL] updates
- [d4cbcc7](https://github.com/williamdes/mariadb-mysql-kbs/commit/d4cbcc7acf033e7cf4a22aeda749f9870e2d1beb) [MariaDB] updates
- [6d0aed2](https://github.com/williamdes/mariadb-mysql-kbs/commit/6d0aed2a94f4247655cc1ccbd47a1950abac6eb3) [MariaDB] && [MySQL] updates
- [6646d76](https://github.com/williamdes/mariadb-mysql-kbs/commit/6646d764c62136474f0ffaa42ba7bb1a324f3c0f) [MySQL] updates
- [be98073](https://github.com/williamdes/mariadb-mysql-kbs/commit/be9807377b13d08ed6998ae185400d27686f4f38) [MariaDB] && [MySQL] updates
- [f6fd5f6](https://github.com/williamdes/mariadb-mysql-kbs/commit/f6fd5f6a2f06d4116266833b3f68d7a8a1d10be6) [MariaDB] && [MySQL] updates
- [cb8f850](https://github.com/williamdes/mariadb-mysql-kbs/commit/cb8f850bb4cf0b9619986313696d476aad53e8ee) [MariaDB] updates
- [05e1883](https://github.com/williamdes/mariadb-mysql-kbs/commit/05e18834cbd44f544d8a131a477f90af9df439f0) [MariaDB] updates
- [15deeb9](https://github.com/williamdes/mariadb-mysql-kbs/commit/15deeb9672cb3309adcdd7b2554e5abb5e6ebc56) [MySQL] updates
- [1a8bf0a](https://github.com/williamdes/mariadb-mysql-kbs/commit/1a8bf0a2c31013b3bcf11f0862ef0e39f5b9ba74) [MariaDB] updates
- [90a0b26](https://github.com/williamdes/mariadb-mysql-kbs/commit/90a0b26638e67e32e230a1a1022878dbe8e7dd35) [MariaDB] && [MySQL] updates
- [50ab914](https://github.com/williamdes/mariadb-mysql-kbs/commit/50ab914b6df67ce5a4d63121bd8b1772bcadf872) [MariaDB] && [MySQL] updates
- [4b57142](https://github.com/williamdes/mariadb-mysql-kbs/commit/4b57142e4705617280ad3da9729240348b494f90) [MySQL] updates
- [daa313e](https://github.com/williamdes/mariadb-mysql-kbs/commit/daa313ea4fc19400ddc6fb5350dc79daf85d1a21) [MySQL] updates
- [1f02417](https://github.com/williamdes/mariadb-mysql-kbs/commit/1f024175e0deb70eff34e36d7305b58c0cef68d4) [MySQL] updates
- [bc011b7](https://github.com/williamdes/mariadb-mysql-kbs/commit/bc011b7ea4f36b10de81c4f58f55b6ff079ff2e2) [MariaDB] updates
- [925f01f](https://github.com/williamdes/mariadb-mysql-kbs/commit/925f01fd8dae8f8e4a72e680bce6223f1ab1084b) [MariaDB] updates
- [1eb110b](https://github.com/williamdes/mariadb-mysql-kbs/commit/1eb110b8c9238a88d406f0e232d63d8aa3d18053) [MariaDB] && [MySQL] updates
- [886d599](https://github.com/williamdes/mariadb-mysql-kbs/commit/886d599fb4ecd2e886629c177b2f9815c1fae957) [MariaDB] && [MySQL] updates
- [fbc1e98](https://github.com/williamdes/mariadb-mysql-kbs/commit/fbc1e98d0c4b98506b03ee30b60ee08fdbbe9440) [MySQL] updates
- [4726cd1](https://github.com/williamdes/mariadb-mysql-kbs/commit/4726cd1c799e3dad815f7113f3e62a7f383a7f40) [MariaDB] && [MySQL] updates
- [b7bc2db](https://github.com/williamdes/mariadb-mysql-kbs/commit/b7bc2dbf779c55c13f804a1cc4ce459e46f0e3e0) [MariaDB] && [MySQL] updates
- [ef773a7](https://github.com/williamdes/mariadb-mysql-kbs/commit/ef773a7a118e275b98b57cf18d0ad6cbfe514def) [MariaDB] && [MySQL] updates
- [9837411](https://github.com/williamdes/mariadb-mysql-kbs/commit/9837411eedb53b0cb61047699ad7081480f9c458) [MariaDB] && [MySQL] updates
- [1da68a2](https://github.com/williamdes/mariadb-mysql-kbs/commit/1da68a28fcbcf1f9fa9f886aab84526b0408424b) [MySQL] updates
- [8b290ce](https://github.com/williamdes/mariadb-mysql-kbs/commit/8b290ce7109586eca5a259f63cda60551da8ab61) [MySQL] updates
- [9a30263](https://github.com/williamdes/mariadb-mysql-kbs/commit/9a302637313e79c392467e28c925a39ab573b61d) [MySQL] updates
- [a1fbb55](https://github.com/williamdes/mariadb-mysql-kbs/commit/a1fbb55335510afabfe1b544564f24639ad6f668) [MySQL] updates

### Fixed

- [a402856](https://github.com/williamdes/mariadb-mysql-kbs/commit/a4028565d062339f18a504f39c61cfa04a962802) exclude merge.php from Doctum
- [c69d529](https://github.com/williamdes/mariadb-mysql-kbs/commit/c69d5296b09e7a5478b23d00ab865e3b3564a0cd) cleanup the accepted values for an enum
- [2104623](https://github.com/williamdes/mariadb-mysql-kbs/commit/21046232efaa4f5ec355477fe50b0dab19a44ca2) MariaDb enum values without a code tag
- [66c6992](https://github.com/williamdes/mariadb-mysql-kbs/commit/66c69927e3945cdc65f7919e7a757bd50dfe75c3) create PR script install in "/usr/local/bin"
- [4f10b0e](https://github.com/williamdes/mariadb-mysql-kbs/commit/4f10b0eb4f2551fa1d2643fead412bb8b6f9dd2d) yarn binary path
- [de8ef42](https://github.com/williamdes/mariadb-mysql-kbs/commit/de8ef42628bcfeb04627aa850783d88d82046ba6) binary path for sudo-bot
- [c1528ea](https://github.com/williamdes/mariadb-mysql-kbs/commit/c1528ea35b0838ceefc18dbbf82141848a8c0213) coding standard migration mistake
- [de8945b](https://github.com/williamdes/mariadb-mysql-kbs/commit/de8945b622f3360245784f7fa7653537c72b592b) data URLs
- [0f31076](https://github.com/williamdes/mariadb-mysql-kbs/commit/0f31076dae1ebe2af5c13521e6a2031bc2381f14) do not try to match another scope than global or session for MariaDB

### Features

- [1b8f387](https://github.com/williamdes/mariadb-mysql-kbs/commit/1b8f3874c595b9ee5991041c4926ce062e80bef4) pass phpstan v1 max level
- [0273dbf](https://github.com/williamdes/mariadb-mysql-kbs/commit/0273dbfdfa6c7b808954235fd40c9897ad8ad121) simplify PHP 8 composer installs
- [7c6a94e](https://github.com/williamdes/mariadb-mysql-kbs/commit/7c6a94e557d593b2cd168a462c43dbbac2b1b52c) add new S3 data file
- [29960a3](https://github.com/williamdes/mariadb-mysql-kbs/commit/29960a349e49bb6be5e299593f6dd6829cae5a25) add new data sets

### Documentation

- [b0af14e](https://github.com/williamdes/mariadb-mysql-kbs/commit/b0af14ef9e78259da65be9fc3756013fe50dc7b4) update CHANGELOG
- [41631bf](https://github.com/williamdes/mariadb-mysql-kbs/commit/41631bf402f20242aa55e2f2815488dafe9508de) add FUNDING and SECURITY
- [474885d](https://github.com/williamdes/mariadb-mysql-kbs/commit/474885d4eb22a3bab8e81b72dd7cf002a5723c29) update docs submodule

### Others

- [5a708dd](https://github.com/williamdes/mariadb-mysql-kbs/commit/5a708ddd0d444fde62eee557350677ffb538ea23) do not try to change version in composer.json
- [b492531](https://github.com/williamdes/mariadb-mysql-kbs/commit/b492531f6ee0eb067ef6cea95b7039729d8acd8d) set back coverage to xdebug for PHP 7.1
- [095d6bf](https://github.com/williamdes/mariadb-mysql-kbs/commit/095d6bfbd2bd71665959d824f2edfdfa667da6a2) set PHP 8.1 as a normal tested version and nightly as an experimental version
- [848c359](https://github.com/williamdes/mariadb-mysql-kbs/commit/848c359c933f90568ff65ce4a6efb9267430c968) ignore composer.lock
- [7f56820](https://github.com/williamdes/mariadb-mysql-kbs/commit/7f5682015cb6728ab7871da69d92e49a112ed213) remove version field from composer.json
- [ed98920](https://github.com/williamdes/mariadb-mysql-kbs/commit/ed98920339eecdae90c986a6c7dc8e11337add96) upgrade phpstan to ^1.2.0
- [4dc14cd](https://github.com/williamdes/mariadb-mysql-kbs/commit/4dc14cd791e74e929274b6a276d8b8c80015a2a6) do not require SKIP_DOCS_STEPS ENV
- [624b71e](https://github.com/williamdes/mariadb-mysql-kbs/commit/624b71e435557946d45ea387abe4d6bcf32f5a09) update jshint, mocha, prettier
- [ad4aa81](https://github.com/williamdes/mariadb-mysql-kbs/commit/ad4aa81ca96a17b413b5f89496c0bada4209febb) bump prettier from 2.4.1 to 2.5.1
- [fe39dac](https://github.com/williamdes/mariadb-mysql-kbs/commit/fe39dacc391bc001d580ba1294542716c21748d1) bump mocha from 9.1.2 to 9.1.3
- [8fa43bb](https://github.com/williamdes/mariadb-mysql-kbs/commit/8fa43bb1dbe9aeed24b46781d805f4613959e67e) bump ansi-regex from 5.0.0 to 5.0.1
- [a4a2df7](https://github.com/williamdes/mariadb-mysql-kbs/commit/a4a2df73705d5a8d13d102c72274ca2f8be0f167) bump mocha from 9.1.1 to 9.1.2
- [bbbfb76](https://github.com/williamdes/mariadb-mysql-kbs/commit/bbbfb764f555fa54ca5f61f9b0865ea4b00ca677) bump prettier from 2.3.2 to 2.4.1
- [db0ae9d](https://github.com/williamdes/mariadb-mysql-kbs/commit/db0ae9de5294cd8533762986f3d7964ca01f01f1) bump jshint from 2.13.0 to 2.13.1
- [a181a03](https://github.com/williamdes/mariadb-mysql-kbs/commit/a181a03f594ee4ebb1fa2113d1536bfa7a2314f2) bump mocha from 9.0.3 to 9.1.1
- [af0326c](https://github.com/williamdes/mariadb-mysql-kbs/commit/af0326c04ccefffed1f1bbe26c5f086387985883) add new workflow environment names
- [47b89f9](https://github.com/williamdes/mariadb-mysql-kbs/commit/47b89f93f5e9d93e436e1e5cd77213562232dc01) bump path-parse from 1.0.6 to 1.0.7
- [b8e8d8d](https://github.com/williamdes/mariadb-mysql-kbs/commit/b8e8d8d40ce18cc35771e3ece0d29cf913719abe) bump mocha from 9.0.2 to 9.0.3
- [2e6ae05](https://github.com/williamdes/mariadb-mysql-kbs/commit/2e6ae05b8fa1ba7ba8339ecb10a5baa09a112ae0) update dependencies
- [a5a3627](https://github.com/williamdes/mariadb-mysql-kbs/commit/a5a36270c7a1423d404dbeb21257ed3556af0fc5) fix workflow
- [44fa150](https://github.com/williamdes/mariadb-mysql-kbs/commit/44fa1500f117cbcf8aa91c46ed7dbdfcb6eecca1) bump mocha from 8.4.0 to 9.0.1
- [c394c88](https://github.com/williamdes/mariadb-mysql-kbs/commit/c394c88150f5ec394f0de3e32eda8c1781594d0c) bump prettier from 2.3.1 to 2.3.2
- [12cb0c7](https://github.com/williamdes/mariadb-mysql-kbs/commit/12cb0c705abedc4f7eca992fc8e32c41dc68b905) adjust lint and analyse CI config and run tests on PHP 8.1
- [4dc1d57](https://github.com/williamdes/mariadb-mysql-kbs/commit/4dc1d57ec3a8c7054143decf3c59515b1ba143e4) bump glob-parent from 5.1.0 to 5.1.2
- [eea7ab0](https://github.com/williamdes/mariadb-mysql-kbs/commit/eea7ab029bc359b9c23c2ae8a08287d8c0ee1a24) bump y18n from 4.0.0 to 4.0.3
- [64aa594](https://github.com/williamdes/mariadb-mysql-kbs/commit/64aa59415bc1c382999fc20a34b63f055d2d5b92) bump locutus from 2.0.14 to 2.0.15
- [9c72287](https://github.com/williamdes/mariadb-mysql-kbs/commit/9c7228749af60ad40f2f522803a518bb21f54921) test on node 12, 14, 15, 16
- [6954d32](https://github.com/williamdes/mariadb-mysql-kbs/commit/6954d326fdda0b041396997112fe3c45a56541c2) require node 12
- [13bf7a5](https://github.com/williamdes/mariadb-mysql-kbs/commit/13bf7a53327c9b89a32ec95bdc27e2469f478a01) upgrade jshint, mocha, prettier
- [a027e74](https://github.com/williamdes/mariadb-mysql-kbs/commit/a027e74fd513343acd35f74fca94e08c04a0ae49) bump mocha from 8.3.2 to 8.4.0
- [95203fa](https://github.com/williamdes/mariadb-mysql-kbs/commit/95203fa6f6bfa988ce957ccda4aa019b41ce7618) bump prettier from 2.2.1 to 2.3.0
- [f779cae](https://github.com/williamdes/mariadb-mysql-kbs/commit/f779caee970b93354ce783d3f4ceabf9080087e2) bump jshint from 2.12.0 to 2.13.0
- [250c21b](https://github.com/williamdes/mariadb-mysql-kbs/commit/250c21b5fbe00fdb358d47270ee58839b989e7f2) bump lodash from 4.17.19 to 4.17.21
- [237bebb](https://github.com/williamdes/mariadb-mysql-kbs/commit/237bebb6303e6f4ea4a4b4351eeeac402b28c193) bump locutus from 2.0.11 to 2.0.14
- [e120770](https://github.com/williamdes/mariadb-mysql-kbs/commit/e12077002cae75b0ac2d3f5515ac6d7d21fca403) remove sudo for pages build
- [8e31e3b](https://github.com/williamdes/mariadb-mysql-kbs/commit/8e31e3b5bdf748cc3454deed0c113fb37815b4df) remove composer arguments
- [2552a4b](https://github.com/williamdes/mariadb-mysql-kbs/commit/2552a4b103ffcf73635c67150fff95f47696d061) use different templates for each workflow
- [2944134](https://github.com/williamdes/mariadb-mysql-kbs/commit/294413447143adf4c4a525eec5327fba67d88124) allow access to secrets
- [ca5bb42](https://github.com/williamdes/mariadb-mysql-kbs/commit/ca5bb42fd68d0ba38b761f75368af6e3c3364618) handle non docs workflow
- [3cc68cb](https://github.com/williamdes/mariadb-mysql-kbs/commit/3cc68cb8c8f2a7365a78d710e8087d704107b5a7) fix NodeJs not expanding ~ of paths
- [852e2c3](https://github.com/williamdes/mariadb-mysql-kbs/commit/852e2c3f7fc13729b7a91800a5718d8725b295a5) fix build process missing files
- [80eb36d](https://github.com/williamdes/mariadb-mysql-kbs/commit/80eb36dcdf817da45c7a392d7a268cb9dcfc0eaa) use non relative paths for some file arguments on sudo-bot
- [61263ca](https://github.com/williamdes/mariadb-mysql-kbs/commit/61263ca257ead278e377748bce45ed9fb8f2d25f) fix secret for sudo-bot GPG passphrase
- [547e15e](https://github.com/williamdes/mariadb-mysql-kbs/commit/547e15ece69560a45556916edc7e7a58d99ce576) ci: remove duplicates lines on the sudo-bot script
That simple..., wtf keyboard what did you do /o\

- [a208602](https://github.com/williamdes/mariadb-mysql-kbs/commit/a2086022e8c68c151fcc0cf29753e2aa0430cf1d) ci: add more debugs for sudo-bot script
What is wrong ? :/

- [c8255a2](https://github.com/williamdes/mariadb-mysql-kbs/commit/c8255a254c6fc782a86ce8a62050662558914628) fix sudo-bot, use bash instead of sh
- [3f0f318](https://github.com/williamdes/mariadb-mysql-kbs/commit/3f0f3185a346292a16ee71e0f9b9db4279545e0b) debug command line issue
- [fa11e54](https://github.com/williamdes/mariadb-mysql-kbs/commit/fa11e54d410ba435f660afed58ee80d275b4be18) use bash equals for sudo-bot
- [4329113](https://github.com/williamdes/mariadb-mysql-kbs/commit/432911397912e4fd29d513058ed7be9b571c09a3) fix move to root dir for API docs
- [373a22f](https://github.com/williamdes/mariadb-mysql-kbs/commit/373a22febd0253d04a5c6c656633878b49b08987) rename cache to tmp
- [085abed](https://github.com/williamdes/mariadb-mysql-kbs/commit/085abeda4486d41ee274b5ee72b33fa11b14796c) fetch all the repository to have the gh-pages branch available
- [43d7ecd](https://github.com/williamdes/mariadb-mysql-kbs/commit/43d7ecd45999b0720ca7bd9939c1c6727d00332a) fix root dir path for sudo-bot docs
- [5cfd151](https://github.com/williamdes/mariadb-mysql-kbs/commit/5cfd151f09e78643ac42dc2c4029069eadd2ad8c) make sudo-bot script executable
- [44293ad](https://github.com/williamdes/mariadb-mysql-kbs/commit/44293ad4f9bb3377c237e75f0d7591eec59963e6) fix PHP documentation workflow
- [6b0f012](https://github.com/williamdes/mariadb-mysql-kbs/commit/6b0f012cfec344d8b49b7a3fb9e788d3e1f50a5f) drop all the old sudo-bot process and re-build it
- [dcad6c8](https://github.com/williamdes/mariadb-mysql-kbs/commit/dcad6c83674b26f50885281bd03d51c3cade077b) rename GPG_PRIV_PASSWORD ENV to GPG_PASSPHRASE
- [3ba3766](https://github.com/williamdes/mariadb-mysql-kbs/commit/3ba37668d67e29b31ac0f96c860d279464298f47) upgrade chai and mocha
- [4f4423e](https://github.com/williamdes/mariadb-mysql-kbs/commit/4f4423e895d10ba9917feb4ca01ed6f0d9d6f200) bump chai from 4.2.0 to 4.3.0
- [d34c628](https://github.com/williamdes/mariadb-mysql-kbs/commit/d34c62812e2083f4ade20df63ffecc23f2db401b) bump mocha from 8.2.1 to 8.3.0
- [e48d0c0](https://github.com/williamdes/mariadb-mysql-kbs/commit/e48d0c01895a397198b6751fafd310420b15e575) Update actions/checkout to v2

## [v1.2.12]

### Changed

- [b78197e](https://github.com/williamdes/mariadb-mysql-kbs/commit/b78197e1c16522c86fab4b23c8b75050efd27dd0) [MySQL] updates
- [537d185](https://github.com/williamdes/mariadb-mysql-kbs/commit/537d1853dbe02c175ad917f17bd1fbf852a7ff06) [MySQL] updates
- [1f7868b](https://github.com/williamdes/mariadb-mysql-kbs/commit/1f7868baba0df415ec7fb5e4358494127915bafe) [MariaDB] updates
- [fce5e6a](https://github.com/williamdes/mariadb-mysql-kbs/commit/fce5e6ab7c105d8e1b9493724ea942ee8aea84c3) [MariaDB] && [MySQL] updates
- [8aabb2b](https://github.com/williamdes/mariadb-mysql-kbs/commit/8aabb2b929f601a29645df0c8c55166f18e64a76) [MariaDB] && [MySQL] updates
- [deaa820](https://github.com/williamdes/mariadb-mysql-kbs/commit/deaa8204e46a2af4947489d348a58331367d5d94) [MariaDB] && [MySQL] updates
- [fd5e5de](https://github.com/williamdes/mariadb-mysql-kbs/commit/fd5e5de7c0019df37d905ae1e28ee4340d16cc51) 🤖 Some updates 🤖
- [4278ad9](https://github.com/williamdes/mariadb-mysql-kbs/commit/4278ad9b212e6679d5c19d27d49f516f01f03863) [MariaDB] && [MySQL] updates
- [37a7156](https://github.com/williamdes/mariadb-mysql-kbs/commit/37a7156d2027122955fc8087b1d056f54dd1ca74) [MariaDB] && [MySQL] updates
- [74c152c](https://github.com/williamdes/mariadb-mysql-kbs/commit/74c152cc366fa0bd9fcdf5e774aa6a4002a52fa8) [MariaDB] updates
- [3b86e1f](https://github.com/williamdes/mariadb-mysql-kbs/commit/3b86e1f34a60651c071289b920bd52a6ad0bac4c) [MySQL] updates

### Fixed

- [a8a7893](https://github.com/williamdes/mariadb-mysql-kbs/commit/a8a78939ccad4937600d06364f265b79745b1b9a) KBEntry::jsonSerialize phpdoc block
- [4d33f7e](https://github.com/williamdes/mariadb-mysql-kbs/commit/4d33f7eb822920e5336e64d0e8f4930e336257c9) Rename master to source for MySQL replication options

### Features

- [2402554](https://github.com/williamdes/mariadb-mysql-kbs/commit/240255492c4f19a895e0422e8e509caecce27928) improve release script
- [632dc1c](https://github.com/williamdes/mariadb-mysql-kbs/commit/632dc1cc09142588f5443c8d6c419215d233cb70) update documentation submodule
- [c9bcc1c](https://github.com/williamdes/mariadb-mysql-kbs/commit/c9bcc1cacde7f2932e1015499b4fc277f6621e62) improve API docs config

### Others

- [afe0194](https://github.com/williamdes/mariadb-mysql-kbs/commit/afe01940758385406d5e99829fd89684c80bc948) sudo move the docs
- [fcbc300](https://github.com/williamdes/mariadb-mysql-kbs/commit/fcbc300b46fb29667845a5e0b511303bb9b04636) chmod and chown docs before moving them
- [9b8fa27](https://github.com/williamdes/mariadb-mysql-kbs/commit/9b8fa272267b52dd900f56c59b355d69525ecad0) chmod files before moving them
- [bba46a3](https://github.com/williamdes/mariadb-mysql-kbs/commit/bba46a3ac03b1d999786a4f1f0bb9de3c6f1d59c) use sudo-bot/action-doctum
- [7eb9806](https://github.com/williamdes/mariadb-mysql-kbs/commit/7eb98063afe4a68234a6ee3c3b78c98c382fb361) bump prettier from 2.2.0 to 2.2.1
- [3550bd1](https://github.com/williamdes/mariadb-mysql-kbs/commit/3550bd164152a29e1bce45285f208d97032a2d4d) update dependencies
- [35b9c29](https://github.com/williamdes/mariadb-mysql-kbs/commit/35b9c2998f2f8c2abd2c136836c157e5a0749755) update lint and analyse workflows
- [0527afa](https://github.com/williamdes/mariadb-mysql-kbs/commit/0527afa638bf0fd89eca9b511aa604726b1f2fd2) bump prettier from 2.1.1 to 2.1.2
- [7c08136](https://github.com/williamdes/mariadb-mysql-kbs/commit/7c08136d1042b62c50a076e4ecc4f2415576de02) change php requirements to "^7.1 || ^8.0"
- [b48b3be](https://github.com/williamdes/mariadb-mysql-kbs/commit/b48b3bedd294dfb873f2992692ff8cf19b3d6924) remove .gitignore from vendor bundles

## [v1.2.11]

### Changed

- [749afd6](https://github.com/williamdes/mariadb-mysql-kbs/commit/749afd6b2dec8e203109628b3ee4d62d3ae5437a) [MariaDB] updates
- [238e5ae](https://github.com/williamdes/mariadb-mysql-kbs/commit/238e5ae2aa76868164f2a7f0de9e08dcdebde304) [MariaDB] && [MySQL] updates
- [eb62400](https://github.com/williamdes/mariadb-mysql-kbs/commit/eb62400bc18d0e9d2f845434cc367707fe68daa0) [MariaDB] && [MySQL] updates
- [bf0405b](https://github.com/williamdes/mariadb-mysql-kbs/commit/bf0405b255e1b79c358175f1391acdd94286f261) [MySQL] updates
- [85e3b2b](https://github.com/williamdes/mariadb-mysql-kbs/commit/85e3b2b0402948b01f4d2751d2776fedbee4ced1) [MariaDB] && [MySQL] updates
- [5f24772](https://github.com/williamdes/mariadb-mysql-kbs/commit/5f24772774a2e6753183aa14d6381a66fe63f819) [MariaDB] updates
- [17e905f](https://github.com/williamdes/mariadb-mysql-kbs/commit/17e905f2ba8cbc42193398c6718169564700627d) [MariaDB] updates
- [7fb17c1](https://github.com/williamdes/mariadb-mysql-kbs/commit/7fb17c1a1f7f29d9e623f5702d696b7744356cda) [MariaDB] updates
- [2ab4b94](https://github.com/williamdes/mariadb-mysql-kbs/commit/2ab4b9445dda64d4d76206b20d4680802197d06f) [MySQL] updates
- [6dca35c](https://github.com/williamdes/mariadb-mysql-kbs/commit/6dca35c3d7e138db1df9fa91cbb3acae045e33ad) [MariaDB] updates
- [25cc2f5](https://github.com/williamdes/mariadb-mysql-kbs/commit/25cc2f5c6ae9702d68d07fa7b2673824762b6942) [MariaDB] updates
- [a106adc](https://github.com/williamdes/mariadb-mysql-kbs/commit/a106adce4673a781299c05ad71a2f03d5f8f2762) [MariaDB] && [MySQL] updates
- [f32aa3c](https://github.com/williamdes/mariadb-mysql-kbs/commit/f32aa3c94886a030a9405d2d64fb32d7665111a9) [MySQL] updates
- [1a9712e](https://github.com/williamdes/mariadb-mysql-kbs/commit/1a9712ef486c366e4eab4796da6cc71207a035a0) [MariaDB] updates
- [e68823d](https://github.com/williamdes/mariadb-mysql-kbs/commit/e68823d481781ec91642414baba745b5009efd54) [MariaDB] && [MySQL] updates
- [25327b8](https://github.com/williamdes/mariadb-mysql-kbs/commit/25327b891ca02d0b5f2639532829e086b2b97755) [MariaDB] && [MySQL] updates
- [c70c4d5](https://github.com/williamdes/mariadb-mysql-kbs/commit/c70c4d5d87067e6ce7a3cc7a398bb618a27f31f6) [MariaDB] && [MySQL] updates
- [24a7590](https://github.com/williamdes/mariadb-mysql-kbs/commit/24a75905df8b1baad20ff5a6a74a2a200b75d7cb) [MySQL] updates
- [86688c6](https://github.com/williamdes/mariadb-mysql-kbs/commit/86688c678cba028750b6678faef3d398bdecf11d) [MySQL] updates
- [62e472b](https://github.com/williamdes/mariadb-mysql-kbs/commit/62e472b485c5008fe5c2db1b3569efa8f83735cd) [MariaDB] updates
- [8715b00](https://github.com/williamdes/mariadb-mysql-kbs/commit/8715b00fe605af5cf27dec34b2402ecb6ee21271) [MySQL] updates

### Fixed

- [438f58b](https://github.com/williamdes/mariadb-mysql-kbs/commit/438f58b093f9e97e6a50f3ad6b8c7ff15fc1636d) use another way to validate variables in MySQL documentation
- [e23b886](https://github.com/williamdes/mariadb-mysql-kbs/commit/e23b8868e34fbe922ba0e83bcf5b55ee0c9b6966) use stdout instead of stderr for phpunit
- [1da576b](https://github.com/williamdes/mariadb-mysql-kbs/commit/1da576b61e661762e41c3bf501b9e163f8a2f298) remove an invalid edge case
- [6cb4b61](https://github.com/williamdes/mariadb-mysql-kbs/commit/6cb4b611d443f038e22e3ea2821dbb7b10e3328c) support bad naming for enums
- [f836f84](https://github.com/williamdes/mariadb-mysql-kbs/commit/f836f84a0ee1d0c4e19cd848af50494fea33a7ae) activate back h3 detection
- [894cce5](https://github.com/williamdes/mariadb-mysql-kbs/commit/894cce551c007c232b41cd696cc447db507d5c63) detect nodes until next header
- [ff6fa4a](https://github.com/williamdes/mariadb-mysql-kbs/commit/ff6fa4a23e0d5735b035f2b66f4cfc20880cb866) ignore non variables headings
- [c4d3a15](https://github.com/williamdes/mariadb-mysql-kbs/commit/c4d3a1506299dc0bc09b4e8d76df78cbefe9f8aa) detect all the nodes until a separation line
- [8dbe3d1](https://github.com/williamdes/mariadb-mysql-kbs/commit/8dbe3d151413070ed35b0451265e503bc054aedd) headers can be td or th elements on some MySQL pages
- [8d5ff2e](https://github.com/williamdes/mariadb-mysql-kbs/commit/8d5ff2eb867ea8e17b6cb2957e66846e0f3e7bb4) update XSD url for phpunit
- [f127419](https://github.com/williamdes/mariadb-mysql-kbs/commit/f1274199744eb6d6ffdbe80a5aafd98a85ea7376) remove incompatible expectExceptionMessage with phpunit 7
- [239fa7f](https://github.com/williamdes/mariadb-mysql-kbs/commit/239fa7f50ea27d7e1b0c90bbe613c2407ea90e61) phpunit test must use expectExceptionMessageMatches intead of expectExceptionMessageRegExp
- [45f5288](https://github.com/williamdes/mariadb-mysql-kbs/commit/45f5288456765d6f91f06251e0cba550304191a8) add target folder to .npmignore

### Features

- [7823f6b](https://github.com/williamdes/mariadb-mysql-kbs/commit/7823f6ba556f393a329028b4e049e2e3a737cd0f) move to phar method to generate docs
- [b0b51b9](https://github.com/williamdes/mariadb-mysql-kbs/commit/b0b51b9473c450fd1ba967d477f700695a5339e9) add a PR template for documentation updates
- [6e0e3c4](https://github.com/williamdes/mariadb-mysql-kbs/commit/6e0e3c4a8fff19ed2832078d974aea52e55291ea) remove sami/sami and use code-lts/doctum
- [00439a0](https://github.com/williamdes/mariadb-mysql-kbs/commit/00439a01b887dd21d22e2d364e73674c0a35cac5) set main as the default branch
- [bb22aac](https://github.com/williamdes/mariadb-mysql-kbs/commit/bb22aac607c5a5f5118b36b358e447877dcc998b) add test cases for the MariaDB extraction script
- [44ca8ce](https://github.com/williamdes/mariadb-mysql-kbs/commit/44ca8ce4f1ae2ce4e5717484d1b047e560434ad7) export MariaDB functions for testing
- [d3e5cab](https://github.com/williamdes/mariadb-mysql-kbs/commit/d3e5cab043426498926d8abde07469f3ffeb5c74) Allow phpunit 9

### Documentation

- [f457e52](https://github.com/williamdes/mariadb-mysql-kbs/commit/f457e52f1274efc3b6f6c813e4f055e1ae6b07bd) Update Repology badge after the merge of Fedora and Debian data

### Testing

- [36faf63](https://github.com/williamdes/mariadb-mysql-kbs/commit/36faf63fed2259ce9484e8be839ae328f57fdcee) add a test case for the new MySQL documentation display
- [6e11f0d](https://github.com/williamdes/mariadb-mysql-kbs/commit/6e11f0df19428abc0288a4f09eb0c819a9c01e02) cover KBEntry with Documentation case
- [d7ba3fc](https://github.com/williamdes/mariadb-mysql-kbs/commit/d7ba3fcf58d140e89916f55ef577606e179c8acc) add JsonEncodeTest
- [4bd2634](https://github.com/williamdes/mariadb-mysql-kbs/commit/4bd26348b160a7542c981425375c84da4d08f3a8) test templates better
- [3d1050a](https://github.com/williamdes/mariadb-mysql-kbs/commit/3d1050ad4c06eb6707f4311789e287bd059df915) activate h3 detection
- [dd1dc5e](https://github.com/williamdes/mariadb-mysql-kbs/commit/dd1dc5e084a9045ad105fa0d8afdff66fbf02e6f) add a test case for a very edge case
- [a4bd4e4](https://github.com/williamdes/mariadb-mysql-kbs/commit/a4bd4e4bfaaa91481f62d297d231e630b3297d94) add a test case for output not following the convention
- [355c404](https://github.com/williamdes/mariadb-mysql-kbs/commit/355c404d6c37c88fcefc4d794c4fab59e7875f9a) add a test case
- [218531e](https://github.com/williamdes/mariadb-mysql-kbs/commit/218531e699b35d6dda08235801d14bb70cfdd3c8) add a test case for headings
- [6065657](https://github.com/williamdes/mariadb-mysql-kbs/commit/606565738e13ef72dcf3759cf76c77f9219ccf60) add test case for headers are not td but th

### Others

- [72e9c6b](https://github.com/williamdes/mariadb-mysql-kbs/commit/72e9c6bc5c84a2c06c677c40accfebb4ed6fa523) bump node-fetch from 2.6.0 to 2.6.1
- [4b24c7b](https://github.com/williamdes/mariadb-mysql-kbs/commit/4b24c7b6d2119b3587a6963c94e9408a5795e4c1) bump jshint from 2.11.2 to 2.12.0
- [7248301](https://github.com/williamdes/mariadb-mysql-kbs/commit/724830124813756ffd5af87e520ae459154c66da) bump mocha from 8.1.0 to 8.1.3
- [3da7203](https://github.com/williamdes/mariadb-mysql-kbs/commit/3da7203ada3a2eac567914feaaa38606643d5d48) bump prettier from 2.0.5 to 2.1.1
- [c304be5](https://github.com/williamdes/mariadb-mysql-kbs/commit/c304be5bddc74d02b991aa21a001667f66fa39a4) use actions/cache@v2
- [5e0e575](https://github.com/williamdes/mariadb-mysql-kbs/commit/5e0e57542b669cbaf125160e3ea62ce08389a9dd) update phpstan config
- [bd06752](https://github.com/williamdes/mariadb-mysql-kbs/commit/bd067524ca5e0f38fe444d580f38a44f41399d86) upgrade dependabot to v2
- [7ad7e47](https://github.com/williamdes/mariadb-mysql-kbs/commit/7ad7e4728bdbaeaffa846e7a6ee9fd09dc02cd77) Upgrade jshint and mocha
- [d5edf64](https://github.com/williamdes/mariadb-mysql-kbs/commit/d5edf6466c17c8ea7916fb4cb4746ef85677c0af) bump jshint from 2.11.1 to 2.11.2
- [d9a16d7](https://github.com/williamdes/mariadb-mysql-kbs/commit/d9a16d78aa951aae3eab3264a90d814f7bd15caa) bump mocha from 8.0.1 to 8.1.0
- [1c1f10c](https://github.com/williamdes/mariadb-mysql-kbs/commit/1c1f10c4d8dd040092c515ce455e58d370784269) bump lodash from 4.17.15 to 4.17.19
- [b945b95](https://github.com/williamdes/mariadb-mysql-kbs/commit/b945b95fc7944800eb960a7f7e09c0d6319ddcc5) upgrade @sudo-bot/sudo-bot to ^1.2.3
- [9d4752e](https://github.com/williamdes/mariadb-mysql-kbs/commit/9d4752ebb4be10870363eb70e105b96693fecbd9) upgrade @sudo-bot/sudo-bot to ^1.2.2
- [d614556](https://github.com/williamdes/mariadb-mysql-kbs/commit/d6145560c4ca97ffdc80d373810773a26ced6bd8) use the docs/build temp dir to buid docs
- [ef3e911](https://github.com/williamdes/mariadb-mysql-kbs/commit/ef3e911dba1d68f9877f82ed0f3b9e9ffced1ccf) upgrade @sudo-bot/sudo-bot to ^1.2.1
- [87feee1](https://github.com/williamdes/mariadb-mysql-kbs/commit/87feee104b810e70869495a705111518f871875a) improve doctum config
- [5ae8538](https://github.com/williamdes/mariadb-mysql-kbs/commit/5ae85389ce9fd94992dda42bac6583316a448316) make the script render instead of parse
- [ce383e6](https://github.com/williamdes/mariadb-mysql-kbs/commit/ce383e63f65da54ea1cbfbfef491035a4533c59f) upgrade crawler and mocha
- [2444a8d](https://github.com/williamdes/mariadb-mysql-kbs/commit/2444a8d4a8ed7c8c8778655a488f63f0b6708c86) upgrade @sudo-bot/sudo-bot to ^1.2.0
- [5cb8e6f](https://github.com/williamdes/mariadb-mysql-kbs/commit/5cb8e6f332462831a04ae265bf8371a9f95daa34) upgrade sudo-bot/action-pull-request-merge to 1.1.1
- [390ee9c](https://github.com/williamdes/mariadb-mysql-kbs/commit/390ee9cc96c7137476ea7b4c4a90ca4c39319c94) Ignore php 8.0 because of phpunit
- [7f72d9c](https://github.com/williamdes/mariadb-mysql-kbs/commit/7f72d9c4b39b9ef0190b434801d2cc56d9faeb76) add php 7.4 and 8.0 to the matrix
- [5ca10f0](https://github.com/williamdes/mariadb-mysql-kbs/commit/5ca10f0a9615bae11e22d27f2c37bf9836b9cfa7) remove the need of upload token, upgrade shivammathur/setup-php to v2
- [d37a838](https://github.com/williamdes/mariadb-mysql-kbs/commit/d37a838ff32938de91d94669cfb4370dc121e829) change php versions requirements from ^7.1 to >=7.1
- [0d21cc7](https://github.com/williamdes/mariadb-mysql-kbs/commit/0d21cc7306fc45d87d02fe33bfb372c8817346f5) upgrade some dependencies to require recent versions
- [c4c75df](https://github.com/williamdes/mariadb-mysql-kbs/commit/c4c75df0bd0a2ba4e0d27c18b26b17bedfb1e7f5) upgrade dependencies
- [6c4674a](https://github.com/williamdes/mariadb-mysql-kbs/commit/6c4674ab33264a25592f2b31c4ff79505a21bbd8) bump nyc from 15.0.1 to 15.1.0
- [8d6b221](https://github.com/williamdes/mariadb-mysql-kbs/commit/8d6b221d1e31e6fa3567af9a67a8d2d8fadc81c1) bump jshint from 2.11.0 to 2.11.1
- [706aa36](https://github.com/williamdes/mariadb-mysql-kbs/commit/706aa3675cf136448e5335f5734f8ad75e2d5094) bump mocha from 7.1.2 to 7.2.0
- [719d45b](https://github.com/williamdes/mariadb-mysql-kbs/commit/719d45b86c9f54a07b40b1874fe1abed08938345) bump mocha from 7.1.1 to 7.1.2
- [3c07e90](https://github.com/williamdes/mariadb-mysql-kbs/commit/3c07e909d3ae20ea611a2feff55eecf59ff159df) bump nyc from 15.0.0 to 15.0.1
- [8a1fa5e](https://github.com/williamdes/mariadb-mysql-kbs/commit/8a1fa5ee82c65ee971637ade05555d515025460c) bump prettier from 2.0.2 to 2.0.5
- [1c7e91f](https://github.com/williamdes/mariadb-mysql-kbs/commit/1c7e91ff3df0362b2d9fe1960c81bcc08c93536c) [security] bump minimist from 1.2.0 to 1.2.5

## [v1.2.10]

### Changed

- [8b61506](https://github.com/williamdes/mariadb-mysql-kbs/commit/8b61506fe329efcfaaa6b66e969ba23248c52dd6) [MariaDB] updates and other changes
- [3826dad](https://github.com/williamdes/mariadb-mysql-kbs/commit/3826dad219b15ff3f6cc0aabd85a4b8f30bf9b17) [MariaDB] updates
- [3300c03](https://github.com/williamdes/mariadb-mysql-kbs/commit/3300c03b0a24f742be901960bd87d6e4c984a8e3) [MariaDB] updates
- [dd877a2](https://github.com/williamdes/mariadb-mysql-kbs/commit/dd877a282f24f44bd58ccc69424f2181cd1add20) [MySQL] updates

### Features

- [969103e](https://github.com/williamdes/mariadb-mysql-kbs/commit/969103e09c5550bead53592755b5bed058a945cb) exclude some files from git archive version of the repo "export-ignore"
- [f564f47](https://github.com/williamdes/mariadb-mysql-kbs/commit/f564f47d03459a2eab97c79aa1290b9d39fa93ac) move all commands to yarn
- [4ac523a](https://github.com/williamdes/mariadb-mysql-kbs/commit/4ac523abc11da0de15cb2defd1639562cea98449) move to yarn

### Others

- [937d0d1](https://github.com/williamdes/mariadb-mysql-kbs/commit/937d0d1904a43e5f1c6bb0412979bf7d53e0fa71) remove codecov npm dependency
- [cc58d9d](https://github.com/williamdes/mariadb-mysql-kbs/commit/cc58d9d2ecd1d852512342bd1d246be0a280976d) [security] bump codecov from 3.6.4 to 3.6.5
- [ed2d7ba](https://github.com/williamdes/mariadb-mysql-kbs/commit/ed2d7baa38bf9da5502b34b71fad4d4654e40004) bump codecov from 3.6.2 to 3.6.4

## [v1.2.9]

### Added

- [d9742f4](https://github.com/williamdes/mariadb-mysql-kbs/commit/d9742f4bb8e6962c5149c725a7baadf5a79da359) Travis CI cron
- [403f751](https://github.com/williamdes/mariadb-mysql-kbs/commit/403f751af50c2a7c5d8c57cffbee552e6c8b7cf1) Workflows
- [fad58a0](https://github.com/williamdes/mariadb-mysql-kbs/commit/fad58a0793ac5279de779371cf9429f85a5f12ca) get clean type from mixed string
- [58f6ce1](https://github.com/williamdes/mariadb-mysql-kbs/commit/58f6ce174bf326e91345509ee49703b234af503d) test case 4 before type detection enhancement

### Changed

- [4d67c9c](https://github.com/williamdes/mariadb-mysql-kbs/commit/4d67c9c891aaa9576faf635a8c2acde506a29826) [MySQL] updates and other changes
- [3231ac4](https://github.com/williamdes/mariadb-mysql-kbs/commit/3231ac4cc4a4497c45580686bf2d587141a860e8) [MySQL] updates
- [a50744f](https://github.com/williamdes/mariadb-mysql-kbs/commit/a50744f4555c79200e80ae8a104f47e99980fb80) [MySQL] updates
- [034b517](https://github.com/williamdes/mariadb-mysql-kbs/commit/034b517927997297f2bc07eb700dc71003fa51f2) [MySQL] updates
- [a551a29](https://github.com/williamdes/mariadb-mysql-kbs/commit/a551a299b11b50ab0e282741976bd49adf8eca67) [MariaDB] updates
- [af7a10c](https://github.com/williamdes/mariadb-mysql-kbs/commit/af7a10cb89c1df513dff2e697f850fae6af6e113) [MariaDB] updates
- [7a979e2](https://github.com/williamdes/mariadb-mysql-kbs/commit/7a979e26722661e4faa78c0ee04b65b37f6ebeeb) [MySQL] updates

### Fixed

- [4c7126f](https://github.com/williamdes/mariadb-mysql-kbs/commit/4c7126ff4ff9c035351549ae7c0808cef3848a45) use new build command and convention for changelog-generator-twig
- [ed7158c](https://github.com/williamdes/mariadb-mysql-kbs/commit/ed7158c890e0b5b7d6b4306520503189e5305348) Improve docs generation script
- [4176e94](https://github.com/williamdes/mariadb-mysql-kbs/commit/4176e9440dd3d556d32d9479142b19565b51062e) phpdoc errors reported by phpstan
- [8369147](https://github.com/williamdes/mariadb-mysql-kbs/commit/8369147444eb5b488b748b598df611c58c56bb21) phpdoc block
- [3faaae7](https://github.com/williamdes/mariadb-mysql-kbs/commit/3faaae71a507438aba3d8c8f2fbdab64bc104c6b) Use version 1.0.5 of sudo-bot/action-pull-request-lock
- [4b06ebe](https://github.com/williamdes/mariadb-mysql-kbs/commit/4b06ebe880fd33e4749cf96b261677f313def6da) test case 4 after adding support for 'type: default, range' in MySQL pages

### Features

- [ee30714](https://github.com/williamdes/mariadb-mysql-kbs/commit/ee3071446e7d07753962afaa53fe99dd5b89e5a7) Detect bad version name in release script
- [6e928c7](https://github.com/williamdes/mariadb-mysql-kbs/commit/6e928c70e38780007b145800e240f8f747b1578d) Add a release script
- [03809c5](https://github.com/williamdes/mariadb-mysql-kbs/commit/03809c5af460f1c806826dd2a6308d99719bcb4b) make Swaggest\JsonSchema\Schema optional for Debian packaging vendors
- [22744bb](https://github.com/williamdes/mariadb-mysql-kbs/commit/22744bb96b45aef525119dfc9cef2fcdd9650d98) get rid of the url:: resolver to make the vendor optional 
- [ab4a210](https://github.com/williamdes/mariadb-mysql-kbs/commit/ab4a2109604528b40581ac4a036d219f8feef7ce) added sign-release script
- [7e58e57](https://github.com/williamdes/mariadb-mysql-kbs/commit/7e58e571772d4bfff49c628876eaaae7e32f1f99) Improve sudo-bot template file
- [668f1a0](https://github.com/williamdes/mariadb-mysql-kbs/commit/668f1a014870202ea994404baedbb6d60bae1676) Add docs build and PR
- [530f0c1](https://github.com/williamdes/mariadb-mysql-kbs/commit/530f0c148d180430329d01a8788389b51c2334de) Add packaging status badge from repology
- [0e37662](https://github.com/williamdes/mariadb-mysql-kbs/commit/0e37662ab711fd99c2948057d219cf878b2c7980) Add workflow to lock a closed pull-request
- [8c65961](https://github.com/williamdes/mariadb-mysql-kbs/commit/8c659616e3a7fe7c264e234bcc983b06de9a5585) Add script to trigger a workflow
- [74fbc90](https://github.com/williamdes/mariadb-mysql-kbs/commit/74fbc90329639523581617c693a04f4b6a4a797a) support 'type: default, range' in MySQL pages

### Others

- [89c3397](https://github.com/williamdes/mariadb-mysql-kbs/commit/89c339730a3728dd35dbbc8018464fba5688c652) remove /schemas folder for dist archives (composer)
- [976d936](https://github.com/williamdes/mariadb-mysql-kbs/commit/976d936f6dd8a8cc8002e2d254df91315401025a) remove /target folder for dist archives (rust support)
- [7634363](https://github.com/williamdes/mariadb-mysql-kbs/commit/7634363f0ab12eddf80aba61f04483da53c0412c) Add .gitattributes to ignored dir for dist archives
- [73dfae0](https://github.com/williamdes/mariadb-mysql-kbs/commit/73dfae02cf268b03972fc0e5b4c869375e372717) move tests to a more standard place
- [dc37421](https://github.com/williamdes/mariadb-mysql-kbs/commit/dc374211df97b2187317028a40171d5adc39bfa3) simplify phpunit version regex
- [32c4ccd](https://github.com/williamdes/mariadb-mysql-kbs/commit/32c4ccd915f2a0f9f31aca08bb682e862205ff8e) bump nyc from 14.1.1 to 15.0.0
- [9fc286a](https://github.com/williamdes/mariadb-mysql-kbs/commit/9fc286ab32ca693c5978474495a66b3f737edb6e) Add merge pull-request workflow
- [44d115e](https://github.com/williamdes/mariadb-mysql-kbs/commit/44d115ed3d27355b75f3d6e081411c18003f0049) add --no-interaction and fix docs build
- [a1596a5](https://github.com/williamdes/mariadb-mysql-kbs/commit/a1596a526084da7df3212cf26876950d7560436b) update phpstan/phpstan to 0.12
- [f96a3d1](https://github.com/williamdes/mariadb-mysql-kbs/commit/f96a3d19220bc4444629520a40e2d27785e8f46e) update slevomat/coding-standard to 6.0
- [6248da5](https://github.com/williamdes/mariadb-mysql-kbs/commit/6248da5b030f35b6e6adde216e173d2534024129) Update docs submodule
- [4d97b7a](https://github.com/williamdes/mariadb-mysql-kbs/commit/4d97b7ae02acce968b53cc8b7b1a2cf532447c11) fix secrets in cron
- [f3ac5ee](https://github.com/williamdes/mariadb-mysql-kbs/commit/f3ac5ee6b54ca2557a1822947776787d00c90a4d) replace badge in README.md
- [42cf92f](https://github.com/williamdes/mariadb-mysql-kbs/commit/42cf92ffc22dc973420586dadf643693312efa23) finish migration to GitHub actions
- [f0cb417](https://github.com/williamdes/mariadb-mysql-kbs/commit/f0cb417661ecdd039dbeccb10873fe2fe722da59) remove all TravisCI files

## [v1.2.8]

### Added

- [8ca6999](https://github.com/williamdes/mariadb-mysql-kbs/commit/8ca6999e1487a9f43846530a3cc241ef7109b5bf) .gitattributes file

### Changed

- [b4afbca](https://github.com/williamdes/mariadb-mysql-kbs/commit/b4afbcabc7b40ebfb5b072de568f60063cf86adb) dependencies
- [856b39c](https://github.com/williamdes/mariadb-mysql-kbs/commit/856b39cbc7027bfee0f22c661960f694bbf08b32) [MySQL] updates
- [9d7b3c3](https://github.com/williamdes/mariadb-mysql-kbs/commit/9d7b3c3b973a3b0fa8fae5adc25f5ef02909203d) .gitattributes file
- [9eab800](https://github.com/williamdes/mariadb-mysql-kbs/commit/9eab8008ee3fc91c8817e744fc3755e7815cee47) .gitattributes file
- [530c6a6](https://github.com/williamdes/mariadb-mysql-kbs/commit/530c6a68d0f12eca9f1b0f4fd0f7d55f825847ae) [MariaDB] updates
- [53bae92](https://github.com/williamdes/mariadb-mysql-kbs/commit/53bae92f735f39271c881858074961fe3bc2e39e) [MariaDB] && [MySQL] updates
- [aeb2ffd](https://github.com/williamdes/mariadb-mysql-kbs/commit/aeb2ffd26fb7810d16a92330978f87f06da280a7) [MariaDB] && [MySQL] updates
- [fd9ac5e](https://github.com/williamdes/mariadb-mysql-kbs/commit/fd9ac5e27e321e4625150e70dac8cb645fcfbfb6) [MariaDB] && [MySQL] updates
- [0860955](https://github.com/williamdes/mariadb-mysql-kbs/commit/0860955d111d44d4e0a6ee3e8392724cbfc32e2a) dependencies
- [215fcf3](https://github.com/williamdes/mariadb-mysql-kbs/commit/215fcf3849a0441c55abd64d7f56119428994218) [MySQL] updates
- [0434d0a](https://github.com/williamdes/mariadb-mysql-kbs/commit/0434d0a918087e1f0f3679ba007ab12d06b6c00d) [MySQL] updates
- [9a65d87](https://github.com/williamdes/mariadb-mysql-kbs/commit/9a65d879cbb67aaf34450d518b6df3d651ee23f5) [MariaDB] && [MySQL] updates
- [6f6f19f](https://github.com/williamdes/mariadb-mysql-kbs/commit/6f6f19fd404bee47239fe6648bca607ceb0b97e0) dependencies
- [f7fed9f](https://github.com/williamdes/mariadb-mysql-kbs/commit/f7fed9fdeaba9818cf32f5ea3f151f1083eb7bd8) changelog

### Fixed

- [baee0c0](https://github.com/williamdes/mariadb-mysql-kbs/commit/baee0c02d1428d8d1c8d7e0824bdb5463e68cc7f) some MySQL and MariaDB fixes
- [185ebb2](https://github.com/williamdes/mariadb-mysql-kbs/commit/185ebb223ba0904e65395f226a13b3bc708014fb) cleanCli undefined

### Features

- [14d2a95](https://github.com/williamdes/mariadb-mysql-kbs/commit/14d2a95d61e0c1831e82d0a8d2c67132c18de4d8) add tests for MySQL parser
- [228ee4a](https://github.com/williamdes/mariadb-mysql-kbs/commit/228ee4aba365dea063806c059a96c2d7c3c7902a) Add cleaner for default values

## [v1.2.7]

### Changed

- [6416780](https://github.com/williamdes/mariadb-mysql-kbs/commit/64167803686aff4090f72a6d89826364b1d88d7d) package version to 1.2.7
- [1db8c2e](https://github.com/williamdes/mariadb-mysql-kbs/commit/1db8c2ee7ff93c7b8d0cea2bb8a2037a10a6dc10) changelog
- [520d89c](https://github.com/williamdes/mariadb-mysql-kbs/commit/520d89cbe75a088444e3536e7a2f0be31449efba) [security] bump lodash from 4.17.11 to 4.17.14
- [cf60c43](https://github.com/williamdes/mariadb-mysql-kbs/commit/cf60c43cc4e7d7c284fa5181707343145f2d88f5) [security] bump lodash.merge from 4.6.1 to 4.6.2
- [dfda544](https://github.com/williamdes/mariadb-mysql-kbs/commit/dfda544ecf47bf8cd995e3aebfb445d07f25bf5c) [MariaDB] && [MySQL] updates
- [4b31b18](https://github.com/williamdes/mariadb-mysql-kbs/commit/4b31b18c50a25f3e32a19d2b13218ef18166daa8) [MariaDB] && [MySQL] updates and other changes

### Fixed

- [9afafca](https://github.com/williamdes/mariadb-mysql-kbs/commit/9afafca3b542ee637a8b0067546517cfc00a94d4) php 7.3 on CI for OSX
- [5f67aed](https://github.com/williamdes/mariadb-mysql-kbs/commit/5f67aedb59132eacefd793b02b20e0b9a0bebb01) php 7.3 on CI for OSX

## [v1.2.6]

### Added

- [1c5ccf2](https://github.com/williamdes/mariadb-mysql-kbs/commit/1c5ccf288d2f96e8e18451bf17964de4bc8f38f4) SECURITY.md
- [61a933f](https://github.com/williamdes/mariadb-mysql-kbs/commit/61a933f6e0d67f4287ba73243f2d69417b76f609) dependencies up to date badge
- [a55aa0c](https://github.com/williamdes/mariadb-mysql-kbs/commit/a55aa0c33ed0f9a70921a5b5ee205f3a79442413) php lint to CI and removed apt cache key
- [b3edac6](https://github.com/williamdes/mariadb-mysql-kbs/commit/b3edac617d653623b1840f7dbc89bac9276c3f82) .phpunit.result.cache to ignores
- [77830b6](https://github.com/williamdes/mariadb-mysql-kbs/commit/77830b64be3803c7880702e0ba900d5946a11501) test command to composer.json
- [0daf1a8](https://github.com/williamdes/mariadb-mysql-kbs/commit/0daf1a866d8ae22033297df652e6795052ab2ebe) jshint to dev dependencies
- [3987131](https://github.com/williamdes/mariadb-mysql-kbs/commit/398713113a0387a3b666d52c55766a8dbb8bbad5) .jshintignore

### Changed

- [e4a96c9](https://github.com/williamdes/mariadb-mysql-kbs/commit/e4a96c94f85ca7e1fefe3a93761d20895790f857) package version to 1.2.6
- [57a2f9c](https://github.com/williamdes/mariadb-mysql-kbs/commit/57a2f9cac2a45792cdc1ae214bc33308614cf9f2) [MariaDB] && [MySQL] updates
- [1ba2bdd](https://github.com/williamdes/mariadb-mysql-kbs/commit/1ba2bdd21b634d29aff5dd4dd0620e24b4fee2c7) [MariaDB] && [MySQL] updates
- [10e8854](https://github.com/williamdes/mariadb-mysql-kbs/commit/10e88548866862ef2c4313ec591c075ac7d70fa6) .travis.yml
- [25241ee](https://github.com/williamdes/mariadb-mysql-kbs/commit/25241eed66be5943685159ad7583a121b04947ed) dependencies and package-lock.json
- [824f4f0](https://github.com/williamdes/mariadb-mysql-kbs/commit/824f4f01517dbf5e0654d486402545001d3f2015) [MySQL] data
- [55d6f72](https://github.com/williamdes/mariadb-mysql-kbs/commit/55d6f72913e24c2f32f2c9c3df285ba117f10f8a) [MariaDB] data
- [f679d22](https://github.com/williamdes/mariadb-mysql-kbs/commit/f679d2207b5c8d99044471de6e492b3ccd5b4a78) dependencies and package-lock.json 
- [46f52d8](https://github.com/williamdes/mariadb-mysql-kbs/commit/46f52d8c91a332480b7f5907d28fea3e391662df) [MySQL] data
- [22a609b](https://github.com/williamdes/mariadb-mysql-kbs/commit/22a609b4072296a943102965f79b6e9a2be61fc2) swaggest/json-schema from 0.12.3+ to 0.12.9+ & phpunit command
- [18d2e32](https://github.com/williamdes/mariadb-mysql-kbs/commit/18d2e3237f3ed8a316fe3c4c2683012196b2ac9d) [MySQL] data
- [c5cafc6](https://github.com/williamdes/mariadb-mysql-kbs/commit/c5cafc66b59aee56e0db8ca42a0ddb8e0fc14f7e) [MariaDB] && [MySQL] updates
- [b2f66ca](https://github.com/williamdes/mariadb-mysql-kbs/commit/b2f66ca3851a5908d491769cacb4cbc726c558bd) dependencies and package-lock.json 
- [ac490c2](https://github.com/williamdes/mariadb-mysql-kbs/commit/ac490c2c6f3b7267fb72cb06d7990e547dd435d3) @sudo-bot cron script and README.md
- [13b93dc](https://github.com/williamdes/mariadb-mysql-kbs/commit/13b93dc37cb2f2e1d5ebfe6cc990a1065920da7a) [MariaDB] && [MySQL] updates
- [a9ddf62](https://github.com/williamdes/mariadb-mysql-kbs/commit/a9ddf62d554500b04a52ca0d425cceab955a656a) prettier and mocha dependencies
- [1df9f60](https://github.com/williamdes/mariadb-mysql-kbs/commit/1df9f6031d72257f4b2e5223ed78d3ded32bfa6a) [MariaDB] && [MySQL] updates
- [1862d41](https://github.com/williamdes/mariadb-mysql-kbs/commit/1862d4158b6b285da798b9919af39686de683205) sudo-bot and codecov npm dependencies
- [d2c8b8e](https://github.com/williamdes/mariadb-mysql-kbs/commit/d2c8b8ebdcdc603084c4235e78f93fd4c9f24c8d) [MySQL] updates

### Removed

- [f2d43b0](https://github.com/williamdes/mariadb-mysql-kbs/commit/f2d43b099df2442e5599130c86a72200811c4dbf) spy script (useless)

### Fixed

- [4277ed2](https://github.com/williamdes/mariadb-mysql-kbs/commit/4277ed250f2500cb4c47253796f35dfba69d88b2) alert detected by lgtm
- [3994f74](https://github.com/williamdes/mariadb-mysql-kbs/commit/3994f748e4f54ba8c0d0602a2802441ce6d6f4be) changelog 📖
- [9324c2a](https://github.com/williamdes/mariadb-mysql-kbs/commit/9324c2a8f5904546ecb780ed57bedf7e055c8584) CI @sudo-bot script
- [b8ab559](https://github.com/williamdes/mariadb-mysql-kbs/commit/b8ab5592c5d54a35a6767b3a10c26d7fd53a7689) MariaDB script
- [5a183ac](https://github.com/williamdes/mariadb-mysql-kbs/commit/5a183ac7ebf5470c17b23b0e33608eebbed075ba) remove debug
- [2362512](https://github.com/williamdes/mariadb-mysql-kbs/commit/2362512aa8da242158303620d4d2509229769e85) move crawler to dev-dependencies
- [f106ca1](https://github.com/williamdes/mariadb-mysql-kbs/commit/f106ca1f2e2e6ba92bbae29bf343de90b0292717) CI and .gitignore and phpstan command
- [ba2631e](https://github.com/williamdes/mariadb-mysql-kbs/commit/ba2631e1fd3265e58764ee06ce1a8bc37ab11813) cleaner and add tests
- [e80c410](https://github.com/williamdes/mariadb-mysql-kbs/commit/e80c410f72cb8f899cab74eb72026db1026e6457) @sudo-bot CI
- [a7cf7bd](https://github.com/williamdes/mariadb-mysql-kbs/commit/a7cf7bdf0a9ce4e49d6f7b56e26a58c71fa79ec0) remove renamed file
- [cc7aac7](https://github.com/williamdes/mariadb-mysql-kbs/commit/cc7aac74f2ba0341661b65ab49b65ebd1afd1e41) CI reporting for non mocha tests
- [b40a61b](https://github.com/williamdes/mariadb-mysql-kbs/commit/b40a61bd0c0d3a2ecf3bdf6532bee02009fc1245) @sudo-bot use 'npm ci' when package-lock.json exists
- [43b8e95](https://github.com/williamdes/mariadb-mysql-kbs/commit/43b8e95d27bfdba9a242b04c7e105e418a7fc816) CI rename style to lint

## [v1.2.5]

### Added

- [046c3fe](https://github.com/williamdes/mariadb-mysql-kbs/commit/046c3fe15cbf57d89e283b62f5a8b03c576a0337) php7.3 and osx php7.3 to test matrix
- [2491c41](https://github.com/williamdes/mariadb-mysql-kbs/commit/2491c415adaa65ab37b47d52cfb322d95fe7767d) snyk and dependabot to README.md
- [3fa4313](https://github.com/williamdes/mariadb-mysql-kbs/commit/3fa43131b44f8b5407bb63411589ffa61dcb75b9) dependabot config
- [571ccf3](https://github.com/williamdes/mariadb-mysql-kbs/commit/571ccf3edc1b3b5cfa0245d5518063a9434d0835) LGTM and fixed changelog
- [a068fde](https://github.com/williamdes/mariadb-mysql-kbs/commit/a068fde4a0421f96d4e1897170b409d638f9aabe) merged data and tests to PR template
- [effd148](https://github.com/williamdes/mariadb-mysql-kbs/commit/effd1487a0227d1092455838abd73e145808fd01) template for sudo-bot and mocha
- [d17883b](https://github.com/williamdes/mariadb-mysql-kbs/commit/d17883bc5b41d187f9c3132a8577fd470fb3213e) sudo-bot

### Changed

- [44264b0](https://github.com/williamdes/mariadb-mysql-kbs/commit/44264b03e02d0908749b696f68721fac99cbd133) package version to 1.2.5
- [97ec035](https://github.com/williamdes/mariadb-mysql-kbs/commit/97ec035605cca060e3b7abf92d46ada85465a6d2) [MySQL] updates
- [9eb743f](https://github.com/williamdes/mariadb-mysql-kbs/commit/9eb743f65f4a1fbc80abab0247fe6e3896c98930) commit message format
- [5366e10](https://github.com/williamdes/mariadb-mysql-kbs/commit/5366e10a0625fa9f95f7eac7a43dfb9af43f72b6) package-lock.json and package.json and changelog
- [2786d1a](https://github.com/williamdes/mariadb-mysql-kbs/commit/2786d1a5c98dd3b93bfca8706cc9d7e92b1770a7) MySQL data
- [9cffbf6](https://github.com/williamdes/mariadb-mysql-kbs/commit/9cffbf64046836229d9c3f83674b213848833036) MariaDB data
- [13d7ba4](https://github.com/williamdes/mariadb-mysql-kbs/commit/13d7ba4510e9957352790a02551eb247f4b17ad6) composer.json && updated: composer.lock
- [7e80648](https://github.com/williamdes/mariadb-mysql-kbs/commit/7e80648f583ce760ab717a0a942bd6f576ede4bc) composer.lock
- [affedaf](https://github.com/williamdes/mariadb-mysql-kbs/commit/affedaf9c5762fc01c5b6084b31f321de5e50140) package-lock.json and dependabot config
- [0f8b1a0](https://github.com/williamdes/mariadb-mysql-kbs/commit/0f8b1a05978fc5d0573c0eacc23a97df17cc032e) changelog 📖
- [e031ee1](https://github.com/williamdes/mariadb-mysql-kbs/commit/e031ee1af193878dfccf7892c2aa553bc76f4f00) package.json & package-lock.json
- [b4675f3](https://github.com/williamdes/mariadb-mysql-kbs/commit/b4675f313ad67ef4bee7a661014d0ffcf9911bd2) sudo-bot
- [dd0ff5c](https://github.com/williamdes/mariadb-mysql-kbs/commit/dd0ff5c9448f65dde6d5ef829589e2115292aa20) [MySQL] & [MariaDB] data
- [852b3a2](https://github.com/williamdes/mariadb-mysql-kbs/commit/852b3a2a527f620310fe2b90877d15ef315a60c9) composer.lock and package-lock.json and updated package.json
- [ef766fd](https://github.com/williamdes/mariadb-mysql-kbs/commit/ef766fd9991e4fd1e80bb7b14abb2a352ecd4689) changelog 📖

### Removed

- [16a3d25](https://github.com/williamdes/mariadb-mysql-kbs/commit/16a3d259263d00eab648fa9bce2249e993be0aeb) composer.lock
- [b0f997d](https://github.com/williamdes/mariadb-mysql-kbs/commit/b0f997d2abc033740a35d14cf16982356b207f16) old changelog script
- [ab83775](https://github.com/williamdes/mariadb-mysql-kbs/commit/ab83775286f122b186526c106079e798525ca307) deploy on tag

### Fixed

- [741b07e](https://github.com/williamdes/mariadb-mysql-kbs/commit/741b07e927b55cf35e918085462e0052153ff8dc) .npmignore .gitignore and composer archive ignore
- [3e5ca71](https://github.com/williamdes/mariadb-mysql-kbs/commit/3e5ca71a782aeedd4e6a726ae1737905ca74d7e6) composer non feature branches and nyc coverage
- [b00a8b0](https://github.com/williamdes/mariadb-mysql-kbs/commit/b00a8b09496f193c3289bf6f3c2ece4cd3a95967) osx CI
- [9ac6e9b](https://github.com/williamdes/mariadb-mysql-kbs/commit/9ac6e9bf898de7760f7f53ddabdc28a2c5a548bb) changelog
- [2b23349](https://github.com/williamdes/mariadb-mysql-kbs/commit/2b23349f867450f308a37045486ac6b61eb25a99) Travis CI
- [5377cec](https://github.com/williamdes/mariadb-mysql-kbs/commit/5377cec845b0cc0888a23a8185e24553f7c2a476) NPM package name in README.md
- [1b433f8](https://github.com/williamdes/mariadb-mysql-kbs/commit/1b433f8f30c6f1cb4ad42540f869614f13239fbb) nyc coverage
- [2f24409](https://github.com/williamdes/mariadb-mysql-kbs/commit/2f244099934d2d125d01d55dbe5c2388c09693ff) Coverage report and ignore files
- [8bee75a](https://github.com/williamdes/mariadb-mysql-kbs/commit/8bee75af85dc02e8be72fae9ff9e29c0670c7b77) CI coverage
- [ae75ce8](https://github.com/williamdes/mariadb-mysql-kbs/commit/ae75ce8c4fd44cdae42748f3ab769cdd0401868c) CI & mocha tests installation
- [8fa12ea](https://github.com/williamdes/mariadb-mysql-kbs/commit/8fa12eaab4a917677828a4f12f0b07f936c8a023) composer namespace
- [ee2c058](https://github.com/williamdes/mariadb-mysql-kbs/commit/ee2c05800e170ed0743b5905db43450359ca10e6) travis CI and other files
- [a4974c5](https://github.com/williamdes/mariadb-mysql-kbs/commit/a4974c5050132cd38945d2c639fdd614fb080d11) OSX CI
- [a6a9ed8](https://github.com/williamdes/mariadb-mysql-kbs/commit/a6a9ed8d17fc672413bbebc5908928a1ad80a679) OSX on CI
- [4762da9](https://github.com/williamdes/mariadb-mysql-kbs/commit/4762da9723c8da0378d990a3a9062b89ac71f4f6) npm ignore

## [v1.2.4]

### Added

- [5c00bb6](https://github.com/williamdes/mariadb-mysql-kbs/commit/5c00bb63e8423d092b5e21689e14ee83e9fc918f) deploy on tag
- [83b9b19](https://github.com/williamdes/mariadb-mysql-kbs/commit/83b9b19fe47b2a62065c5c3f3f67d1582b6554f1) Travis CI labels
- [00a10ea](https://github.com/williamdes/mariadb-mysql-kbs/commit/00a10eab8e00aaa0d073062957de291a02a472e5) sudo-bot cron script :factory:
- [071ef1d](https://github.com/williamdes/mariadb-mysql-kbs/commit/071ef1d991a718e972cf551f962e9a5f7b2f51c3) CODEOWNERS :lock:
- [4f71020](https://github.com/williamdes/mariadb-mysql-kbs/commit/4f7102047f310df55c85b0967aa872ada8d9fec5) [MariaDB] system-versioned-tables

### Changed

- [3092bc0](https://github.com/williamdes/mariadb-mysql-kbs/commit/3092bc0a3d03d580466b86de4036130e644ec94d) composer.json & package.json - version 1.2.4
- [797b1f3](https://github.com/williamdes/mariadb-mysql-kbs/commit/797b1f304443c18076cfa5e910af8c5f23703601) [MySQL] & [MariaDB] data
- [c999377](https://github.com/williamdes/mariadb-mysql-kbs/commit/c9993779f679c7b02161977b6733706b7e793f08) [MySQL] data
- [03d5d6e](https://github.com/williamdes/mariadb-mysql-kbs/commit/03d5d6ea73e29023466449021cb5441b67ffeea6) [MariaDB] data
- [68f2187](https://github.com/williamdes/mariadb-mysql-kbs/commit/68f2187842df8cba506394ccbbb3ddcc7bc401fc) changelog :book:

### Fixed

- [247f98b](https://github.com/williamdes/mariadb-mysql-kbs/commit/247f98b3d21ddd43d336e9f62af5808980bc3806) OSX tests
- [10e4ff6](https://github.com/williamdes/mariadb-mysql-kbs/commit/10e4ff6ff34c65248815d64c2699e5f2f7847c24) typo
- [cb792c8](https://github.com/williamdes/mariadb-mysql-kbs/commit/cb792c8133d5c48116d940a3e92657c51f8b4f64) npm ignore

## [v1.2.3]

### Added

- [03cb762](https://github.com/williamdes/mariadb-mysql-kbs/commit/03cb7629b06f8d64e7b6ebced942a10d3d59c410) json schema validation for merged-ultraslim.json
- [fd46f68](https://github.com/williamdes/mariadb-mysql-kbs/commit/fd46f68ba96ffe28c53eeda1c2e41bb9e157d936) swaggest/json-schema

### Changed

- [8076644](https://github.com/williamdes/mariadb-mysql-kbs/commit/80766444c4443ba3101e4da6d0b3cfeef3c06351) composer.json & package.json - version 1.2.3
- [9bd0602](https://github.com/williamdes/mariadb-mysql-kbs/commit/9bd06026ca172822f806a7d0625b2ddf85e47e54) api docs :book:
- [fb2f2f6](https://github.com/williamdes/mariadb-mysql-kbs/commit/fb2f2f6f6cdba32d4518529a272cbbf3ed37391f) changelog :book:
- [6696ca7](https://github.com/williamdes/mariadb-mysql-kbs/commit/6696ca745ce172a24d1fb5ae1fefe82ae10b222a) merged data
- [143e1f2](https://github.com/williamdes/mariadb-mysql-kbs/commit/143e1f24f559469f2f13bab7da5366d59d54e2fd) [MariaDB] data
- [c99e2f7](https://github.com/williamdes/mariadb-mysql-kbs/commit/c99e2f7e07faedef1db039c5fc5c7c44f5dc8c52) [MySQL] data
- [c2903a2](https://github.com/williamdes/mariadb-mysql-kbs/commit/c2903a29e2f2f60988276f21dc1f23464133ac4b) composer.lock :lock:
- [5378614](https://github.com/williamdes/mariadb-mysql-kbs/commit/53786144f25bf89d0a040f3be6bc0378a17661f0) changelog :book:

### Removed

- [2ab9b3c](https://github.com/williamdes/mariadb-mysql-kbs/commit/2ab9b3ce7aa43af77c47d0c096b3c7363203a053) validate file
- [84fe040](https://github.com/williamdes/mariadb-mysql-kbs/commit/84fe040254d39f239286bbe77427298d590e5547) testbench file

### Fixed

- [8abb014](https://github.com/williamdes/mariadb-mysql-kbs/commit/8abb01492af0b8c054cb878fa79560b774a637be) npm ignore

## [v1.2.2]

### Added

- [e95b8dc](https://github.com/williamdes/mariadb-mysql-kbs/commit/e95b8dc10379bf00236ed0ee24abc0723b6a743a) phpcs rules
- [e402e0c](https://github.com/williamdes/mariadb-mysql-kbs/commit/e402e0c03086b8712b68d084bca1f5118ec282af) getVariable
- [4e7ae6f](https://github.com/williamdes/mariadb-mysql-kbs/commit/4e7ae6f4e2b349f25f68c028b1e5c3dab171b8b5) badges and install intructions :book:
- [9bed254](https://github.com/williamdes/mariadb-mysql-kbs/commit/9bed254abc3ac85b46aa8f6ddd3eb0fd03f32008) npm ignore
- [47c5d56](https://github.com/williamdes/mariadb-mysql-kbs/commit/47c5d56b7549050fc7b71da971cc5fc64f5790fb) changelog :book:
- [bbeed46](https://github.com/williamdes/mariadb-mysql-kbs/commit/bbeed466908936e25fa7685509e4b0834d2636f6) changelog generator :book:
- [5cf8a17](https://github.com/williamdes/mariadb-mysql-kbs/commit/5cf8a17fe58762591da828de2aeb930d55d70027) [MariaDB] more documentation

### Changed

- [5b6a4bd](https://github.com/williamdes/mariadb-mysql-kbs/commit/5b6a4bdca787a6204fd8ce9fdfffa3ea7cd43ee7) composer.json & package.json + :lock: - version 1.2.2
- [aa546c7](https://github.com/williamdes/mariadb-mysql-kbs/commit/aa546c73a3cd940d01f0866663c3a0ea99f1be4e) changelog :book:
- [1777f13](https://github.com/williamdes/mariadb-mysql-kbs/commit/1777f13df5866179ce749ecb5b5c00988897f757) prettier
- [e94a9db](https://github.com/williamdes/mariadb-mysql-kbs/commit/e94a9db838d678ccc3db039dccf116eb38586b2a) [MySQL] & [MariaDB] data
- [59e5baa](https://github.com/williamdes/mariadb-mysql-kbs/commit/59e5baa7a31ac72c2ff4a17b5aefec40f98ed6a1) release script
- [5140d06](https://github.com/williamdes/mariadb-mysql-kbs/commit/5140d062bb32ea80fe9155843d99f6a32e178782) api docs
- [2bc0164](https://github.com/williamdes/mariadb-mysql-kbs/commit/2bc016434ed62141a45f3890cf5711bbd0f8755f) composer.lock :lock:
- [c6cb704](https://github.com/williamdes/mariadb-mysql-kbs/commit/c6cb704b8711f2510769494362c60c63cc7cab6f) composer.json & package.json
- [e2c6706](https://github.com/williamdes/mariadb-mysql-kbs/commit/e2c6706c74d9274f63f4185b108e6b335ecff14f) changelog generator :book:
- [fb4cabe](https://github.com/williamdes/mariadb-mysql-kbs/commit/fb4cabe90393f1a7ec863f759be3795cdea36f84) submodule commit hash

### Fixed

- [06737df](https://github.com/williamdes/mariadb-mysql-kbs/commit/06737dfb47665487ce9fb5cf7b490f54614fc0b2) phpcs rule
- [9acaab8](https://github.com/williamdes/mariadb-mysql-kbs/commit/9acaab87b15b2e9be1a21d9a3703faeb04bcaaf8) @throws is allowed in phpdoc
- [d4870a6](https://github.com/williamdes/mariadb-mysql-kbs/commit/d4870a6d02ff314001403cc1a1c45b93cce734ea) dataType bug

## [v1.2.1]

### Added

- [fe488b8](https://github.com/williamdes/mariadb-mysql-kbs/commit/fe488b8008f153ba71e7b4a30432182db9c78e29) KBException>Exception
- [016346b](https://github.com/williamdes/mariadb-mysql-kbs/commit/016346bb53487b9761475468b35bffa1d73103f1) markdown format :package: :book:
- [8742aa0](https://github.com/williamdes/mariadb-mysql-kbs/commit/8742aa0cb2cb669b6df9e8d3637f18b12fc1fab7) markdown format in data :package:
- [5c01220](https://github.com/williamdes/mariadb-mysql-kbs/commit/5c0122006d029180bf358ece53c94194f8b58035) API docs :book:

### Changed

- [057b23f](https://github.com/williamdes/mariadb-mysql-kbs/commit/057b23face95ef95e977d7e145e58cb4b68aac3f) composer.json & package.* - version 1.2.1
- [bdaf01a](https://github.com/williamdes/mariadb-mysql-kbs/commit/bdaf01ae451c3b221b65ac7fe6462a17532055cd) prettier ignore & composer archive & phpcs
- [f8786b2](https://github.com/williamdes/mariadb-mysql-kbs/commit/f8786b2d0519aaa1d37d4a74631830e360347975) [MySQL] & [MariaDB] data
- [f64d72c](https://github.com/williamdes/mariadb-mysql-kbs/commit/f64d72c8db530449f3b72e9a71e3819518a5374d) travis config
- [7df7e60](https://github.com/williamdes/mariadb-mysql-kbs/commit/7df7e60acf154fada34f3346669672b12f885732) README :book:
- [bdf4e22](https://github.com/williamdes/mariadb-mysql-kbs/commit/bdf4e22b2d75523a63cc03c91b640485aceed1be) phpcs & phpstan config

### Fixed

- [c16e655](https://github.com/williamdes/mariadb-mysql-kbs/commit/c16e655bd9ed2eebdb0cb8292184911794f3f808) command line bug in data
- [3637458](https://github.com/williamdes/mariadb-mysql-kbs/commit/3637458d2df6c1642ec323a405e73fc403aa693e) bug in validValues

## [v1.2.0]

### Added

- [1928c75](https://github.com/williamdes/mariadb-mysql-kbs/commit/1928c755602b21f6f80b6480216b2defed345950) getVariableType in API :rocket:
- [94b083c](https://github.com/williamdes/mariadb-mysql-kbs/commit/94b083cea9e669693d1be369fb454ae002a2a40b) variable type & ultraslim php :package:
- [e7368b7](https://github.com/williamdes/mariadb-mysql-kbs/commit/e7368b75acf63b22c87fa311b7bf784ddbf56540) spy script :eye:
- [ab2594e](https://github.com/williamdes/mariadb-mysql-kbs/commit/ab2594e07a2c7fdfb246f6a63c7f8a79eca47db8) [MySQL] documentation
- [e16eb29](https://github.com/williamdes/mariadb-mysql-kbs/commit/e16eb29a36a1cdc94e18041c6cd0fda1e468bda8) [MySQL] documentation
- [4e86741](https://github.com/williamdes/mariadb-mysql-kbs/commit/4e86741f2fc5d91f3011569ad78e6cafb63f4462) [MySQL] documentations
- [e156e4f](https://github.com/williamdes/mariadb-mysql-kbs/commit/e156e4f1301a9368e7ce4c63e631a4d6cd57911a) [MySQL] documentations
- [58751e1](https://github.com/williamdes/mariadb-mysql-kbs/commit/58751e1ebc7ada1a958886ce6ec9c572848a1572) JSON key sorter
- [0a66b68](https://github.com/williamdes/mariadb-mysql-kbs/commit/0a66b680e8ad0eddb88a683dc8dea9a148eb3740) [MySQL] data
- [f744088](https://github.com/williamdes/mariadb-mysql-kbs/commit/f744088ae963d7d060e120102465750fc5d7ab06) [MySQL] replication options documentation

### Changed

- [bf3be0f](https://github.com/williamdes/mariadb-mysql-kbs/commit/bf3be0f2f91e4299e23665cfe97df9e2489b578c) composer.* & package.* - version 1.2.0
- [599dee7](https://github.com/williamdes/mariadb-mysql-kbs/commit/599dee7e07f72826e339442d00fe0ee1ace42cc0) phpcs & phpstan config
- [0dee19e](https://github.com/williamdes/mariadb-mysql-kbs/commit/0dee19efb1081b196b2fd9100b52b2174bbed786) composer.json archive
- [414021d](https://github.com/williamdes/mariadb-mysql-kbs/commit/414021daa725c39190cbc402ccee2f0b1740b132) [MySQL] & [MariaDB] data
- [84fe8e7](https://github.com/williamdes/mariadb-mysql-kbs/commit/84fe8e7d46006f7b25e087f953b6db0ed3f5c07c) phpstan config
- [e8eb1d4](https://github.com/williamdes/mariadb-mysql-kbs/commit/e8eb1d4b8400ea54efbc1a82217dc1af26c115df) [MySQL] data
- [17370d6](https://github.com/williamdes/mariadb-mysql-kbs/commit/17370d6c621cda7008775bbaa2bfc5be4c9b66b2) [MySQL] data
- [89ae61b](https://github.com/williamdes/mariadb-mysql-kbs/commit/89ae61bf3c68f0217167b4002fe0771620330558) [MySQL] data
- [93f47a5](https://github.com/williamdes/mariadb-mysql-kbs/commit/93f47a54eedaef85b4b581ee5062d7eb7139f3f6) [MySQL] & [MariaDB] data

### Removed

- [0c37939](https://github.com/williamdes/mariadb-mysql-kbs/commit/0c37939a1ac2fc5b206b0b4954ee48b3cef089d8) :bug: dataType from data, now type

### Fixed

- [d33d2a1](https://github.com/williamdes/mariadb-mysql-kbs/commit/d33d2a1e7a99b77ef9aa2c37b2c06a52c9942c24) reported errors
- [34a58da](https://github.com/williamdes/mariadb-mysql-kbs/commit/34a58daba6097f2ad7ca4790b6afd51a81fcd3ef) dataType bug in spy :eye
- [42720e2](https://github.com/williamdes/mariadb-mysql-kbs/commit/42720e214b4821063636822e49d8dc8326d8dfa2) type bug
- [6e012b3](https://github.com/williamdes/mariadb-mysql-kbs/commit/6e012b3e511de60f2ebfb43e49a166762e0806a5) not array bug in merge
- [69484ae](https://github.com/williamdes/mariadb-mysql-kbs/commit/69484ae383825aa464895fd15190c057834ea498) key does not exist

## [v1.1.0]

### Added

- [1dc3bf7](https://github.com/williamdes/mariadb-mysql-kbs/commit/1dc3bf7a651060398b9b6a28e1cb3b99cdf1f71e) prettier
- [797487a](https://github.com/williamdes/mariadb-mysql-kbs/commit/797487abd268ad01f6ecf05b8c3577d147ca5083) Search & phpcs & phpstan & travis & phpunit & test
- [5586808](https://github.com/williamdes/mariadb-mysql-kbs/commit/55868083a95b6e7926e1fb4f51cde2cd08129fac) data builder

### Changed

- [0a0b691](https://github.com/williamdes/mariadb-mysql-kbs/commit/0a0b6913a40827ca9a9f4c094f7788a16c154436) composer.json - version 1.1.0
- [d5a006d](https://github.com/williamdes/mariadb-mysql-kbs/commit/d5a006dbee72acc89feb60a867a7c8342cff6f61) merge script
- [d891c83](https://github.com/williamdes/mariadb-mysql-kbs/commit/d891c83d44039bd9b74ea9b490b22a0d3c1e24da) [MariaDB] kb url
- [5879b6f](https://github.com/williamdes/mariadb-mysql-kbs/commit/5879b6fa1ee361c7ede73b76f8939bde26033797) .gitignore
- [29523ef](https://github.com/williamdes/mariadb-mysql-kbs/commit/29523efca1f4e65d8df7516a4dc004292511b365) composer.json
- [1d0bcea](https://github.com/williamdes/mariadb-mysql-kbs/commit/1d0bcea1d4df934e7ac019826274e6705cb89eb5) [MariaDB] data
- [39d5440](https://github.com/williamdes/mariadb-mysql-kbs/commit/39d54407d4ee11d76b6f074ba525a49d89466e1c) [MySQL] & [MariaDB] data

### Fixed

- [8adc939](https://github.com/williamdes/mariadb-mysql-kbs/commit/8adc939a8128c20f11e806b97231d083cb5a9af0) phpcs config
- [e1bd1e6](https://github.com/williamdes/mariadb-mysql-kbs/commit/e1bd1e6a188f37780c988c58a929bae979d6c4ef) composer.json autoload
- [04865bb](https://github.com/williamdes/mariadb-mysql-kbs/commit/04865bb1f58c16d2faa74ebf516ebda64a4c4623) scope bug

## [v1.0.0]

### Added

- [7a8fb1b](https://github.com/williamdes/mariadb-mysql-kbs/commit/7a8fb1ba9b28671c73b2f1cea54ce52bb3d7048b) composer.json
- [9719ee0](https://github.com/williamdes/mariadb-mysql-kbs/commit/9719ee02f688922ce43643035d93d4a93151cea2) [MySQL] data
- [d5b9751](https://github.com/williamdes/mariadb-mysql-kbs/commit/d5b975183c319a5ac0a9f341e69afe4eb15cfb8b) more MySQL documentations
- [b536a33](https://github.com/williamdes/mariadb-mysql-kbs/commit/b536a33ff4a3d95fa996aa269eb02687a5761c65) [MariaDB] data
- [951a927](https://github.com/williamdes/mariadb-mysql-kbs/commit/951a9272f1880f666425e4c1742778ef5bdd4f00) more MariaDB system variables
- [c03f2a6](https://github.com/williamdes/mariadb-mysql-kbs/commit/c03f2a63c002b28cae44d8f060ac09d2969e229c) [MariaDB] data
- [f45ad15](https://github.com/williamdes/mariadb-mysql-kbs/commit/f45ad15cfff626159a60396abbb5ff085514ccd1) [MariaDB] server status variables documentation
- [dc2e800](https://github.com/williamdes/mariadb-mysql-kbs/commit/dc2e800d6d493c30be62bc1e78e84404f994e8d3) [MySQL] data
- [4a1e8da](https://github.com/williamdes/mariadb-mysql-kbs/commit/4a1e8da123a15738288bdac1504333ef69df1ebf) more documentations for MySQL
- [b35e824](https://github.com/williamdes/mariadb-mysql-kbs/commit/b35e824cc58be1f2b3c7fece095e0a331fb09a9d) support for command line
- [6404ab5](https://github.com/williamdes/mariadb-mysql-kbs/commit/6404ab5ad48a2f76702dcbd2fbf40bf7c8976fde) [MySQL] data
- [3d7fec8](https://github.com/williamdes/mariadb-mysql-kbs/commit/3d7fec83c1debca9ef636d32c51073e56b354ea6) MySQL script
- [ecccb66](https://github.com/williamdes/mariadb-mysql-kbs/commit/ecccb6694c6b80b3a14b707fdda2318e68c9f5da) [MariaDB] data
- [b99b2b5](https://github.com/williamdes/mariadb-mysql-kbs/commit/b99b2b5482c9d089092a6106080299574629443c) files
- [e05b05a](https://github.com/williamdes/mariadb-mysql-kbs/commit/e05b05aa96895dee2c3222e93cdddfcb4055d950) package.json & :lock:
- [9783044](https://github.com/williamdes/mariadb-mysql-kbs/commit/9783044b051820a9ae893da2d7e488bc4a3f37c6) .gitignore & README
- [28e9e01](https://github.com/williamdes/mariadb-mysql-kbs/commit/28e9e010dc027dee17a55f5eedad776dcf983e95) LICENSE

### Changed

- [c0c22b9](https://github.com/williamdes/mariadb-mysql-kbs/commit/c0c22b92e6f8bd77addeae4a5e097f56cb4cc88e) data
- [1f61c63](https://github.com/williamdes/mariadb-mysql-kbs/commit/1f61c634686785d7cca3d291368c9a3e737ebff8) data
- [4f7f893](https://github.com/williamdes/mariadb-mysql-kbs/commit/4f7f893870fe295e698b4f6df91b5ba9ae1e88ea) [MariaDB] data

### Fixed

- [dded735](https://github.com/williamdes/mariadb-mysql-kbs/commit/dded735a2f1a16a31973fa623a29000c6e8e0fea) [MySQL] link
- [d9cd2a8](https://github.com/williamdes/mariadb-mysql-kbs/commit/d9cd2a8123a67d6adfddf0414988b98fcac9f082) bug in MariaDB script

### Testing

- [cb6e800](https://github.com/williamdes/mariadb-mysql-kbs/commit/cb6e800fd15eb7e2a582d489a17bf86dec079d58) Added test for common.js

[1.3.0]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.2.14..v1.3.0
[1.2.14]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.2.13..v1.2.14
[1.2.13]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.2.12..v1.2.13
[1.2.12]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.2.11..v1.2.12
[1.2.11]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.2.10..v1.2.11
[1.2.10]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.2.9..v1.2.10
[1.2.9]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.2.8..v1.2.9
[1.2.8]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.2.7..v1.2.8
[1.2.7]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.2.6..v1.2.7
[1.2.6]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.2.5..v1.2.6
[1.2.5]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.2.4..v1.2.5
[1.2.4]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.2.3..v1.2.4
[1.2.3]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.2.2..v1.2.3
[1.2.2]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.2.1..v1.2.2
[1.2.1]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.2.0..v1.2.1
[1.2.0]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.1.0..v1.2.0
[1.1.0]: https://github.com/williamdes/mariadb-mysql-kbs/compare/v1.0.0..v1.1.0

<!-- generated by git-cliff -->
