# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.xml_reader import XMLReader


class XMLHyperTreeGridReader(XMLReader):
    r"""
    XMLHyperTreeGridReader - Read VTK XML hyper_tree_grid files.
    
    Superclass: XMLReader
    
    XMLHyperTreeGridReader reads the VTK XML hyper_tree_grid file
    format. The standard extension for this reader's file format is
    "htg".
    
    NOTE: hyper_tree exists as separate units with all data within htg
          But each htg file is considered one piece for the parallel
    reader
          Later may want to treat individual hyper_trees as separate
    pieces.
    
    For developpers: To ensure the durability of this storage format over
    time, at least, the drive must continue to support playback of
    previous format.
    
    Understand:
    - version 0.0 (P. Fasel and D. de_marle Kitware US)
    - version 1.0 (J-B Lekien CEA, DAM, DIF, F-91297 Arpajon, France)
      This version of the format offers extensive loading options. With
      these options, regardless of the size of the backed-up mesh, it is
      possible to view a "reduced" version either by setting the maximum
      level (by set_fixed_level) or/and setting the hyper_trees to load (by
      set_coordinates_bounding_box, set_indices_bounding_box,
      clear_and_add_selected_ht and add_selected_ht.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXMLHyperTreeGridReader, obj, update, **traits)
    
    fixed_level = traits.Int(4294967295, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the fixed level to read. Option avaiblable in 1.0
        """
    )

    def _fixed_level_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFixedLevel,
                        self.fixed_level)

    def _get_number_of_pieces(self):
        return self._vtk_obj.GetNumberOfPieces()
    number_of_pieces = traits.Property(_get_number_of_pieces, desc=\
        r"""
        
        """
    )

    def _get_number_of_points(self):
        return self._vtk_obj.GetNumberOfPoints()
    number_of_points = traits.Property(_get_number_of_points, desc=\
        r"""
        
        """
    )

    def _get_output(self):
        return wrap_vtk(self._vtk_obj.GetOutput())
    output = traits.Property(_get_output,
                             desc="Output of this source, i.e. the result of `get_output()`.")
    
    def get_output(self, idx=None):
        """
        get_output(self) -> HyperTreeGrid
        C++: HyperTreeGrid *get_output()
        get_output(self, idx:int) -> HyperTreeGrid
        C++: HyperTreeGrid *get_output(int idx)
        Get the reader's output.
        """
        if idx is None:
            return wrap_vtk(self._vtk_obj.GetOutput())
        else:
            return wrap_vtk(self._vtk_obj.GetOutput(idx))

    def add_selected_ht(self, *args):
        """
        add_selected_ht(self, idg:int, fixedLevel:int=...) -> None
        C++: void add_selected_ht(unsigned int idg,
            unsigned int fixedLevel=UINT_MAX)"""
        ret = self._wrap_call(self._vtk_obj.AddSelectedHT, *args)
        return ret

    def clear_and_add_selected_ht(self, *args):
        """
        clear_and_add_selected_ht(self, idg:int, fixedLevel:int=...) -> None
        C++: void clear_and_add_selected_ht(unsigned int idg,
            unsigned int fixedLevel=UINT_MAX)"""
        ret = self._wrap_call(self._vtk_obj.ClearAndAddSelectedHT, *args)
        return ret

    def read_xml_data(self):
        """
        read_xml_data(self) -> None
        """
        ret = self._vtk_obj.ReadXMLData()
        return ret
        

    def set_coordinates_bounding_box(self, *args):
        """
        set_coordinates_bounding_box(self, xmin:float, xmax:float,
            ymin:float, ymax:float, zmin:float, zmax:float) -> None
        C++: void set_coordinates_bounding_box(double xmin, double xmax,
            double ymin, double ymax, double zmin, double zmax)
        Set/Get the selected hyper_trees (HTs) to read : by default, all
        Hts, or by set coordinates bounding box, exclusive or by set
        indices coordinates bounding box, exclusive or by set indices HTs
        (clear_and_add and more Add). Only available for files whose major
        version > 1 Option avaiblable in 1.0
        """
        ret = self._wrap_call(self._vtk_obj.SetCoordinatesBoundingBox, *args)
        return ret

    def set_indices_bounding_box(self, *args):
        """
        set_indices_bounding_box(self, imin:int, imax:int, jmin:int,
            jmax:int, kmin:int, kmax:int) -> None
        C++: void set_indices_bounding_box(unsigned int imin,
            unsigned int imax, unsigned int jmin, unsigned int jmax,
            unsigned int kmin, unsigned int kmax)"""
        ret = self._wrap_call(self._vtk_obj.SetIndicesBoundingBox, *args)
        return ret

    def setup_update_extent(self, *args):
        """
        setup_update_extent(self, piece:int, numberOfPieces:int) -> None
        C++: void setup_update_extent(int piece, int numberOfPieces)"""
        ret = self._wrap_call(self._vtk_obj.SetupUpdateExtent, *args)
        return ret

    _updateable_traits_ = \
    (('read_from_input_string', 'GetReadFromInputString'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('fixed_level',
    'GetFixedLevel'), ('active_time_data_array_name',
    'GetActiveTimeDataArrayName'), ('file_name', 'GetFileName'),
    ('time_step', 'GetTimeStep'), ('time_step_range', 'GetTimeStepRange'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'read_from_input_string', 'release_data_flag',
    'active_time_data_array_name', 'file_name', 'fixed_level',
    'object_name', 'progress_text', 'time_step', 'time_step_range'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(XMLHyperTreeGridReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit XMLHyperTreeGridReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['read_from_input_string'], [], ['active_time_data_array_name',
            'file_name', 'fixed_level', 'object_name', 'time_step',
            'time_step_range']),
            title='Edit XMLHyperTreeGridReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit XMLHyperTreeGridReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

