## ----setup, include = FALSE---------------------------------------------------
library(posterior)

set.seed(1234)

## ----x_rvar_rnorm-------------------------------------------------------------
x <- rvar(rnorm(4000, mean = 1, sd = 1))
x

## ----x_rvar_array-------------------------------------------------------------
n <- 4   # length of output vector
x <- rvar(array(rnorm(4000*n, mean = 1, sd = 1), dim = c(4000, n)))
x

## ----x_matrix-----------------------------------------------------------------
rows <- 4
cols <- 3
x <- rvar(array(rnorm(4000 * rows * cols, mean = 1, sd = 1), dim = c(4000, rows, cols)))
x

## ----str_draws----------------------------------------------------------------
str(draws_of(x))

## ----x_matrix_with_chains-----------------------------------------------------
iterations <- 1000
chains <- 4
rows <- 4
cols <- 3
x_array <- array(
  rnorm(iterations * chains * rows * cols, mean = 1, sd = 1),
  dim = c(iterations, chains, rows, cols)
)
x <- rvar(x_array, with_chains = TRUE)
x

## ----draws_rvars--------------------------------------------------------------
d <- draws_rvars(x = x, y = rvar(rnorm(iterations * chains), nchains = 4))
d

## ----post---------------------------------------------------------------------
post <- as_draws_rvars(example_draws("multi_normal"))
post

## ----variables_draws_rvars----------------------------------------------------
variables(post)

## ----variables_draws_list-----------------------------------------------------
variables(as_draws_list(post))

## ----mu_plus_1----------------------------------------------------------------
mu <- post$mu
Sigma <- post$Sigma

mu + 1

## ----matrix_mult--------------------------------------------------------------
Sigma %**% diag(1:3)

## ----mu-----------------------------------------------------------------------
mu

## ----E_mu---------------------------------------------------------------------
E(mu)

## ----Pr-----------------------------------------------------------------------
Pr(mu > 0)

## ----rvar_mean_mu-------------------------------------------------------------
rvar_mean(mu)

## ----mean_mu------------------------------------------------------------------
mean(mu)

## ----summarise_draws_mu_mean--------------------------------------------------
summarise_draws(mu, mean)

## ----const--------------------------------------------------------------------
const <- as_rvar(1:3)
const

## ----mu_plus_const------------------------------------------------------------
mu + const

## ----rfun_defs----------------------------------------------------------------
rvar_norm <- rfun(rnorm)
rvar_gamma <- rfun(rgamma)

## ----rfun_ex------------------------------------------------------------------
mu <- rvar_norm(4, mean = 1:4, sd = 1)
sigma <- rvar_gamma(1, shape = 1, rate = 1)
x <- rvar_norm(4, mu, sigma)
x

## ----mu_rdo-------------------------------------------------------------------
mu <- rdo(rnorm(4, mean = 1:4, sd = 1))
mu

## ----mu_rdo_ndraws------------------------------------------------------------
mu <- rdo(rnorm(4, mean = 1:4, sd = 1), ndraws = 1000)
mu

## ----rdo_ex-------------------------------------------------------------------
mu <- rdo(rnorm(4, mean = 1:4, sd = 1))
sigma <- rdo(rgamma(1, shape = 1, rate = 1))
x <- rdo(rnorm(4, mu, sigma))
x

## ----rvar_r_ex----------------------------------------------------------------
mu <- rvar_rng(rnorm, 4, mean = 1:4, sd = 1)
sigma <- rvar_rng(rgamma, 1, shape = 1, rate = 1)
x <- rvar_rng(rnorm, 4, mu, sigma)
x

## ----X_matrix-----------------------------------------------------------------
X <- rdo(rnorm(12, 1:12), dim = c(4,3))
X

## ----y_vector-----------------------------------------------------------------
y <- rdo(rnorm(3, 3:1))
y

## ----X_plus_y, error = TRUE---------------------------------------------------
X + y

## ----mean_X_plus_y------------------------------------------------------------
mean(X) + mean(y)

## ----row_y--------------------------------------------------------------------
row_y = t(y)
row_y

## ----X_plus_row_y-------------------------------------------------------------
X + row_y

## ----multidim_array-----------------------------------------------------------
set.seed(3456)
x <- rvar_rng(rnorm, 24, mean = 1:24)
dim(x) <- c(2,3,4)
x

## ----apply--------------------------------------------------------------------
apply(x, c(1,2), length)

## ----rvar_apply_one_dim-------------------------------------------------------
rvar_apply(x, 1, rvar_mean)

## ----rvar_apply_multi_dim-----------------------------------------------------
rvar_apply(x, c(2,3), rvar_mean)

## ----data_frame_with_y--------------------------------------------------------
data.frame(x = c("a","b","c"), y)

