import json
import re
import logging

from parse_acl2 import get_sexpr
from collect_defpkg import PackageDB
import convert_acl2data

KNOWN_INLINE_FUNCTIONS = ("ACL2::BOOL-FIX", 
                             "ACL2::CHAR-FIX", 
                             "ACL2::CHAREQV", 
                             "ACL2::EXPLODE", 
                             "ACL2::NAT-EQUIV", 
                             "ACL2::NAT-LIST-EQUIV", 
                             "ACL2::NAT-LIST-FIX", 
                             "ACL2::NATI-FINITE->GET", 
                             "ACL2::NATI-FIX", 
                             "ACL2::NATI-KIND", 
                             "ACL2::POS-LIST-EQUIV", 
                             "ACL2::POS-LIST-FIX", 
                             "ACL2::STR-FIX", 
                             "ACL2::STREQV", 
                             "ACL2::TAG", 
                             "ACL2-USER::POS-EVEN-LIST-EQUIV", 
                             "STR::CHARLISTEQV",
                             "STR::UPCASE-CHAR",
                             "STR::DOWNCASE-CHAR",
                             "ABNF::ALTERNATION-EQUIV", 
                             "ABNF::ALTERNATION-FIX", 
                             "ABNF::ALTERNATION-KIND",
                             "ABNF::ALTERNATION-SYMBOL-ALIST-FIX", 
                             "ABNF::ALTERNATION-SYMBOL-ALIST-KIND", 
                             "ABNF::CHAR-VAL-EQUIV", 
                             "ABNF::CHAR-VAL-FIX", 
                             "ABNF::CHAR-VAL-KIND",
                             "ABNF::CONCATENATION-EQUIV",
                             "ABNF::CONCATENATION-FIX", 
                             "ABNF::CONCATENATION-KIND",
                             "ABNF::DEF-PARSE-FUNCTION-SPEC-FIX",
                             "ABNF::DEF-PARSE-FUNCTION-SPEC-KIND",
                             "ABNF::ELEMENT-EQUIV", 
                             "ABNF::ELEMENT-FIX", 
                             "ABNF::ELEMENT-KIND",
                             "ABNF::MAYBE-RULE-FIX", 
                             "ABNF::MAYBE-RULE-KIND", 
                             "ABNF::MAYBE-RULENAME-FIX", 
                             "ABNF::MAYBE-RULENAME-KIND", 
                             "ABNF::NUM-VAL-DIRECT->GET",
                             "ABNF::NUM-VAL-EQUIV",
                             "ABNF::NUM-VAL-FIX",
                             "ABNF::NUM-VAL-KIND", 
                             "ABNF::NUM-VAL-RANGE->MIN", 
                             "ABNF::NUM-VAL-RANGE->MAX", 
                             "ABNF::PROSE-VAL-EQUIV", 
                             "ABNF::PROSE-VAL-FIX", 
                             "ABNF::PROSE-VAL-KIND",
                             "ABNF::REPEAT-RANGE-EQUIV", 
                             "ABNF::REPEAT-RANGE-FIX", 
                             "ABNF::REPEAT-RANGE-KIND",
                             "ABNF::REPEAT-RANGE->MIN", 
                             "ABNF::REPEAT-RANGE->MAX", 
                             "ABNF::REPETITION-RANGE", 
                             "ABNF::REPETITION-EQUIV", 
                             "ABNF::REPETITION-FIX", 
                             "ABNF::REPETITION-KIND",
                             "ABNF::REPETITION-SYMBOL-ALIST-FIX", 
                             "ABNF::REPETITION-SYMBOL-ALIST-KIND", 
                             "ABNF::RULE-FIX", 
                             "ABNF::RULELIST-EQUIV", 
                             "ABNF::RULELIST-FIX", 
                             "ABNF::RULENAME-EQUIV", 
                             "ABNF::RULENAME-FIX", 
                             "ABNF::STRING-EQUIV",
                             "ABNF::STRING-FIX",
                             "ABNF::STRING-KIND", 
                             "ABNF::SYMBOL-EQUIV",
                             "ABNF::SYMBOL-FIX",
                             "ABNF::SYMBOL-KIND", 
                             "ABNF::TREE-EQUIV",
                             "ABNF::TREE-FIX",
                             "ABNF::TREE-KIND", 
                             "ABNF::TREE-RESULT-EQUIV",
                             "ABNF::TREE-RESULT-FIX",
                             "ABNF::TREE-RESULT-KIND", 
                             "ABNF::TREE-LIST-EQUIV",
                             "ABNF::TREE-LIST-FIX",
                             "ABNF::TREE-LIST-KIND", 
                             "ABNF::TREE-LIST-RESULT-EQUIV",
                             "ABNF::TREE-LIST-RESULT-FIX",
                             "ABNF::TREE-LIST-RESULT-KIND", 
                             "ABNF::TREE-LIST-LIST-EQUIV",
                             "ABNF::TREE-LIST-LIST-FIX",
                             "ABNF::TREE-LIST-LIST-KIND", 
                             "ABNF::TREE-LIST-RESULT-EQUIV",
                             "ABNF::TREE-LIST-RESULT-FIX",
                             "ABNF::TREE-LIST-RESULT-KIND", 
                             "ABNF::TREE-LIST-LIST-RESULT-EQUIV",
                             "ABNF::TREE-LIST-LIST-RESULT-FIX",
                             "ABNF::TREE-LIST-LIST-RESULT-KIND", 
                             "ABNF::TREE-OPTION-EQUIV",
                             "ABNF::TREE-OPTION-RESULT-FIX",
                             "ABNF::TREE-OPTION-RESULT-KIND", 
                             "ABNF::TREE-OPTION-RESULT-EQUIV",
                             "ABNF::TREE-OPTION-FIX",
                             "ABNF::TREE-OPTION-KIND", 
                             "ABNF::TREE-SET-EQUIV",
                             "ABNF::TREE-SET-FIX",
                             "ABNF::TREE-SET-KIND", 
                             "ABNF::REPETITION->ELEMENT", 
                             "ABNF::REPETITION->RANGE", 
                             "ABNF::ELEMENT-CHAR-VAL->GET", 
                             "ABNF::ELEMENT-NUM-VAL->GET", 
                             "ABNF::ELEMENT-GROUP->GET", 
                             "ABNF::ELEMENT-OPTION->GET", 
                             "ABNF::TREE-LEAFRULE->GET", 
                             "ABNF::TREE-LEAFTERM->GET", 
                             "ABNF::CHAR-VAL-INSENSITIVE->GET", 
                             "ABNF::CHAR-VAL-SENSITIVE->GET", 
                             "ABNF::TREE-NONLEAF->BRANCHES", 
                             "ABNF::TREE-NONLEAF->RULENAME", 
                             "ABNF::TREE-NONLEAF->RULENAME?", 
                             "ACL2-USER::POS-EVEN-LIST-EQUIV",
                            "ACL2-USER::POS-EVEN-LIST-FIX",
                            "ACL2::2DPOINT-FIX",
                            "ACL2::POINT-FIX",
                            "ACL2::ALTERM-FIX",
                            "ACL2::ALTERM-KIND",
                            "ACL2::ANY-P",
                            "ACL2::ARG-DECL-FIX",
                            "ACL2::ARG-DECL-KIND",
                            "ACL2::B-NOT",
                            "ACL2::BFIX",
                            "ACL2::BIT-LIST-EQUIV",
                            "ACL2::BIT-LIST-FIX",
                            "ACL2::BOOLEAN-LIST-FIX",
                            "ACL2::BOOLEAN-RESULT-FIX",
                            "ACL2::BOOLEAN-RESULT-KIND",
                            "ACL2::BV-TYPE-WIDTH",
                            "ACL2::BYTE-EQUIV",
                            "ACL2::BYTE-LIST-EQUIV",
                            "ACL2::BYTE-LIST-FIX",
                            "ACL2::BYTES-EQUIV",
                            "ACL2::BYTES-FIX",
                            "ACL2::CALL-OF-DAG-VAL-WITH-AXE-EVALUATOR-WITH-INLINEABLE-DAGP",
                            "ACL2::CHARACTER-LIST-RESULT-FIX",
                            "ACL2::CHARACTER-LIST-RESULT-KIND",
                            "ACL2::CHARACTER-RESULT-FIX",
                            "ACL2::CHARACTER-RESULT-KIND",
                            "ACL2::DAB-BASE-EQUIV",
                            "ACL2::DARGS",
                            "ACL2::DEFARBREC-INFO->BODY",
                            "ACL2::DEFARBREC-INFO->CALL$",
                            "ACL2::DEFARBREC-INFO->EXPANSION",
                            "ACL2::DEFARBREC-INFO->MEASURE-FN",
                            "ACL2::DEFARBREC-INFO->TERMINATES-FN",
                            "ACL2::DEFARBREC-INFO->UPDATE-FNS",
                            "ACL2::DEFARBREC-INFO->X1...XN",
                            "ACL2::DEFARBREC-PRINTP-FIX",
                            "ACL2::DEFDIGITS-INFO->BASE",
                            "ACL2::DEFDIGITS-INFO->BENDIAN-TO-NAT",
                            "ACL2::DEFDIGITS-INFO->DIGITS-DESCRIPTION",
                            "ACL2::DEFDIGITS-INFO->DIGITS-FIX",
                            "ACL2::DEFDIGITS-INFO->DIGITS-FIX-CORRECT",
                            "ACL2::DEFDIGITS-INFO->DIGITS-PRED",
                            "ACL2::DEFDIGITS-INFO->DIGITS-PRED-CORRECT",
                            "ACL2::DEFDIGITS-INFO->LENDIAN-TO-NAT",
                            "ACL2::DEFDIGITS-INFO->NAT-TO-BENDIAN",
                            "ACL2::DEFDIGITS-INFO->NAT-TO-LENDIAN",
                            "ACL2::DEFMAPPING-INFO->ALPHA",
                            "ACL2::DEFMAPPING-INFO->ALPHA-GUARD",
                            "ACL2::DEFMAPPING-INFO->ALPHA-IMAGE",
                            "ACL2::DEFMAPPING-INFO->ALPHA-INJECTIVE",
                            "ACL2::DEFMAPPING-INFO->ALPHA-OF-BETA",
                            "ACL2::DEFMAPPING-INFO->BETA",
                            "ACL2::DEFMAPPING-INFO->BETA-GUARD",
                            "ACL2::DEFMAPPING-INFO->BETA-IMAGE",
                            "ACL2::DEFMAPPING-INFO->BETA-INJECTIVE",
                            "ACL2::DEFMAPPING-INFO->BETA-OF-ALPHA",
                            "ACL2::DEFMAPPING-INFO->CALL$",
                            "ACL2::DEFMAPPING-INFO->DOMA",
                            "ACL2::DEFMAPPING-INFO->DOMA-GUARD",
                            "ACL2::DEFMAPPING-INFO->DOMB",
                            "ACL2::DEFMAPPING-INFO->DOMB-GUARD",
                            "ACL2::DEFMAPPING-INFO->EXPANSION",
                            "ACL2::DEFMAPPING-INFO->UNCONDITIONAL",
                            "ACL2::DEFUN-SK-QUANTIFIER-FIX",
                            "ACL2::DEFUN-SK-REWRITE-KIND-FIX",
                            "ACL2::EVMAC-APPCOND->FORMULA",
                            "ACL2::EVMAC-APPCOND->NAME",
                            "ACL2::EVMAC-INPUT-PRINT-FIX",
                            "ACL2::FOOSUM-FIX",
                            "ACL2::FOOSUM-KIND",
                            "ACL2::FOOSUMLIST-EQUIV",
                            "ACL2::FOOSUMLIST-FIX",
                            "ACL2::IMPLODE",
                            "ACL2::INCREMENT-TRIES",
                            "ACL2::INT-EQUIV",
                            "ACL2::INT-TERM-M-FIX",
                            "ACL2::INT-TERM-M-KIND",
                            "ACL2::INT-TERM-S-FIX",
                            "ACL2::INT-TERM-S-KIND",
                            "ACL2::INTEGER-RESULT-FIX",
                            "ACL2::INTEGER-RESULT-KIND",
                            "ACL2::LOGHEAD",
                            "ACL2::LOGIC/PROGRAM-FIX",
                            "ACL2::LOGIC/PROGRAM/AUTO-FIX",
                            "ACL2::LOGMASK",
                            "ACL2::LOGTAIL",
                            "ACL2::LOOKUP-IN-REFINED-ASSUMPTION-ALIST",
                            "ACL2::MAKE-BV-TYPE",
                            "ACL2::MAYBE-NATP",
                            "ACL2::MAYBE-POSP",
                            "ACL2::MAYBE-STRING-RESULT-FIX",
                            "ACL2::MAYBE-STRING-RESULT-KIND",
                            "ACL2::MAYBE-STRINGP",
                            "ACL2::MYBYTE-LIST-EQUIV",
                            "ACL2::MYBYTE-LIST-FIX",
                            "ACL2::MYRATIONAL-FIX",
                            "ACL2::MYRATIONAL-LIST-EQUIV",
                            "ACL2::MYRATIONAL-LIST-FIX",
                            "ACL2::NAT-LIST-RESULT-FIX",
                            "ACL2::NAT-LIST-RESULT-KIND",
                            "ACL2::NAT-OPTION-FIX",
                            "ACL2::NAT-OPTION-LIST-EQUIV",
                            "ACL2::NAT-OPTION-LIST-FIX",
                            "ACL2::NAT-OPTION-LIST-RESULT-FIX",
                            "ACL2::NAT-OPTION-LIST-RESULT-KIND",
                            "ACL2::NAT-OPTION-RESULT-FIX",
                            "ACL2::NAT-OPTION-RESULT-KIND",
                            "ACL2::NAT-RESULT-FIX",
                            "ACL2::NAT-RESULT-KIND",
                            "ACL2::NAT/NATLIST-FIX",
                            "ACL2::NAT/NATLIST-KIND",
                            "ACL2::NAT/NATLIST-RESULT-FIX",
                            "ACL2::NAT/NATLIST-RESULT-KIND",
                            "ACL2::NATOPTION/NATOPTIONLIST-FIX",
                            "ACL2::NATOPTION/NATOPTIONLIST-KIND",
                            "ACL2::NATOPTION/NATOPTIONLIST-RESULT-FIX",
                            "ACL2::NATOPTION/NATOPTIONLIST-RESULT-KIND",
                            "ACL2::NIBBLE-EQUIV",
                            "ACL2::NIBBLE-LIST-EQUIV",
                            "ACL2::NIBBLE-LIST-FIX",
                            "ACL2::NIBBLES-EQUIV",
                            "ACL2::NIBBLES-FIX",
                            "ACL2::NIBEQ",
                            "ACL2::NIBFIX",
                            "ACL2::ONE/TWO/THREE-FIX",
                            "ACL2::ONE/TWO/THREE-KIND",
                            "ACL2::ONE/TWO-FIX",
                            "ACL2::ONETWO-FIX",
                            "ACL2::ONETWO-KIND",
                            "ACL2::OPEN-PROBLEM->BENEFIT",
                            "ACL2::OPEN-PROBLEM->CHANCE",
                            "ACL2::OPEN-PROBLEM->FORMULA",
                            "ACL2::OPEN-PROBLEM->LAST-STEP-LIMIT",
                            "ACL2::OPEN-PROBLEM->NAME",
                            "ACL2::OPEN-PROBLEM->OLD-TECHNIQUES",
                            "ACL2::OPEN-PROBLEM->PARENTS",
                            "ACL2::OPEN-PROBLEM->TECHNIQUE",
                            "ACL2::PENDING-PROBLEM->FORMULA",
                            "ACL2::PENDING-PROBLEM->MAIN-EVENTS",
                            "ACL2::PENDING-PROBLEM->NAME",
                            "ACL2::PENDING-PROBLEM->SUBPROBLEM-NAMES",
                            "ACL2::POS-EQUIV",
                            "ACL2::POS-OPTION-FIX",
                            "ACL2::PSEUDO-TERM-FIX",
                            "ACL2::PSEUDO-TERM-KIND",
                            "ACL2::PSEUDO-TERM-LIST-FIX",
                            "ACL2::RAW-PROBLEM->BENEFIT",
                            "ACL2::RAW-PROBLEM->FORMULA",
                            "ACL2::RAW-PROBLEM->NAME",
                            "ACL2::RAW-PROBLEM->OLD-TECHNIQUES",
                            "ACL2::RAW-PROBLEM->PARENTS",
                            "ACL2::REC-SET-FIX",
                            "ACL2::REC-SET-SSET->ARGS",
                            "ACL2::RENAME-DARG",
                            "ACL2::RENUMBER-DARG-WITH-STOBJ",
                            "ACL2::RULE-HYPS",
                            "ACL2::RULE-LHS",
                            "ACL2::RULE-RHS",
                            "ACL2::RULE-SYMBOL",
                            "ACL2::SBYTE1-LIST-EQUIV",
                            "ACL2::SBYTE1-LIST-FIX",
                            "ACL2::SBYTE128-LIST-EQUIV",
                            "ACL2::SBYTE128-LIST-FIX",
                            "ACL2::SBYTE16-LIST-EQUIV",
                            "ACL2::SBYTE16-LIST-FIX",
                            "ACL2::SBYTE2-LIST-EQUIV",
                            "ACL2::SBYTE2-LIST-FIX",
                            "ACL2::SBYTE256-LIST-EQUIV",
                            "ACL2::SBYTE256-LIST-FIX",
                            "ACL2::SBYTE3-LIST-EQUIV",
                            "ACL2::SBYTE3-LIST-FIX",
                            "ACL2::SBYTE32-LIST-EQUIV",
                            "ACL2::SBYTE32-LIST-FIX",
                            "ACL2::SBYTE4-LIST-EQUIV",
                            "ACL2::SBYTE4-LIST-FIX",
                            "ACL2::SBYTE64-LIST-EQUIV",
                            "ACL2::SBYTE64-LIST-FIX",
                            "ACL2::SBYTE8-LIST-EQUIV",
                            "ACL2::SBYTE8-LIST-FIX",
                            "ACL2::SEGMENT-FIX",
                            "ACL2::STORED-RULE-HYPS",
                            "ACL2::STORED-RULE-LHS-ARGS",
                            "ACL2::STORED-RULE-RHS",
                            "ACL2::STORED-RULE-SYMBOL",
                            "ACL2::STRING-LIST-RESULT-FIX",
                            "ACL2::STRING-LIST-RESULT-KIND",
                            "ACL2::STRING-RESULT-FIX",
                            "ACL2::STRING-RESULT-KIND",
                            "ACL2::STRING-STRINGLIST-ALIST-FIX",
                            "ACL2::SUB-TRIES",
                            "ACL2::SYMBOL-EQUIV",
                            "ACL2::SYMBOL-LIST-FIX",
                            "ACL2::SYMBOL-PSEUDOTERM-ALIST-FIX",
                            "ACL2::T/NIL/AUTO-FIX",
                            "ACL2::UBYTE1-LIST-EQUIV",
                            "ACL2::UBYTE1-LIST-FIX",
                            "ACL2::UBYTE100-LIST-EQUIV",
                            "ACL2::UBYTE100-LIST-FIX",
                            "ACL2::UBYTE11-LIST-EQUIV",
                            "ACL2::UBYTE11-LIST-FIX",
                            "ACL2::UBYTE128-LIST-EQUIV",
                            "ACL2::UBYTE128-LIST-FIX",
                            "ACL2::UBYTE16-EQUIV",
                            "ACL2::UBYTE16-LIST-EQUIV",
                            "ACL2::UBYTE16-LIST-FIX",
                            "ACL2::UBYTE2-LIST-EQUIV",
                            "ACL2::UBYTE2-LIST-FIX",
                            "ACL2::UBYTE256-LIST-EQUIV",
                            "ACL2::UBYTE256-LIST-FIX",
                            "ACL2::UBYTE3-LIST-EQUIV",
                            "ACL2::UBYTE3-LIST-FIX",
                            "ACL2::UBYTE32-EQUIV",
                            "ACL2::UBYTE32-LIST-EQUIV",
                            "ACL2::UBYTE32-LIST-FIX",
                            "ACL2::UBYTE4-LIST-EQUIV",
                            "ACL2::UBYTE4-LIST-FIX",
                            "ACL2::UBYTE64-LIST-EQUIV",
                            "ACL2::UBYTE64-LIST-FIX",
                            "ACL2::UBYTE8-LIST-EQUIV",
                            "ACL2::UBYTE8-LIST-FIX",
                            "ACL2::UNUSED-SUM-FIX",
                            "ACL2::UNUSED-SUM-KIND",
                            "ACL2::UNUSEDLIST-EQUIV",
                            "ACL2::UNUSEDLIST-FIX",
                            "ACL2::USE-ALIAS-FIX",
                            "ACL2::VL-TYPE-ERROR-FIX",
                            "ACL2::VL-TYPE-ERROR-KIND",
                            "ACL2::VL-TYPE-ERROR-MAP-EQUIV",
                            "ACL2::WORD-LIST-EQUIV",
                            "ACL2::WORD-LIST-FIX",
                            "ACL2::|STRUCT-integers-EQUIV|",
                            "ACL2::|STRUCT-point2D-EQUIV|",
                            "ACL2::|STRUCT-point3D-EQUIV|",
                            "ACL2::|STRUCT-scalar_and_array-EQUIV|",
                            "ACL2PL::EVAL-STATE-FIX",
                            "ACL2PL::EVAL-STATE-KIND",
                            "ACL2PL::EXEC-OUTCOME-FIX",
                            "ACL2PL::EXEC-OUTCOME-KIND",
                            "ACL2PL::FRAME-FIX",
                            "ACL2PL::FUNCTION-FIX",
                            "ACL2PL::FUNCTION-SET-EQUIV",
                            "ACL2PL::MAYBE-FUNCTION-FIX",
                            "ACL2PL::MAYBE-PACKAGE-FIX",
                            "ACL2PL::MAYBE-SYMBOL-VALUE-FIX",
                            "ACL2PL::MAYBE-TTERM-FIX",
                            "ACL2PL::MAYBE-VALUE-FIX",
                            "ACL2PL::PACKAGE-FIX",
                            "ACL2PL::PACKAGE-LIST-EQUIV",
                            "ACL2PL::PACKAGE-LIST-FIX",
                            "ACL2PL::PROGRAM-FIX",
                            "ACL2PL::STACK-EQUIV",
                            "ACL2PL::STACK-FIX",
                            "ACL2PL::SYMBOL-VALUE-FIX",
                            "ACL2PL::SYMBOL-VALUE-LIST-EQUIV",
                            "ACL2PL::SYMBOL-VALUE-LIST-FIX",
                            "ACL2PL::TFUNCTION-FIX",
                            "ACL2PL::TFUNCTION-KIND",
                            "ACL2PL::TTERM-FIX",
                            "ACL2PL::TTERM-KIND",
                            "ACL2PL::TTERM-LIST-EQUIV",
                            "ACL2PL::TTERM-LIST-FIX",
                            "ACL2PL::VALUE-FIX",
                            "ACL2PL::VALUE-KIND",
                            "ACL2PL::VALUE-LIST-EQUIV",
                            "ACL2PL::VALUE-LIST-FIX",
                            "ACL2PL::VALUE-NUMBER->GET",
                            "APT::EXPDATA-SURJMAP->BACK",
                            "APT::EXPDATA-SURJMAP->BACK-GUARD",
                            "APT::EXPDATA-SURJMAP->BACK-IMAGE",
                            "APT::EXPDATA-SURJMAP->BACK-OF-FORTH",
                            "APT::EXPDATA-SURJMAP->FORTH",
                            "APT::EXPDATA-SURJMAP->FORTH-GUARD",
                            "APT::EXPDATA-SURJMAP->FORTH-IMAGE",
                            "APT::EXPDATA-SURJMAP->FORTH-INJECTIVE",
                            "APT::EXPDATA-SURJMAP->HINTS",
                            "APT::EXPDATA-SURJMAP->LOCALP",
                            "APT::EXPDATA-SURJMAP->NEWP",
                            "APT::EXPDATA-SURJMAP->NEWP-GUARD",
                            "APT::EXPDATA-SURJMAP->OLDP",
                            "APT::EXPDATA-SURJMAP->OLDP-GUARD",
                            "APT::EXPDATA-SURJMAP->SURJNAME",
                            "APT::FN-INFO-ELT->ARG-TYPES",
                            "APT::FN-INFO-ELT->ISO-THM",
                            "APT::FN-INFO-ELT->OSI-THM",
                            "APT::FN-INFO-ELT->RESULT-TYPES",
                            "APT::FN-INFO-ELT->SOURCE-FN",
                            "APT::FN-INFO-ELT->TARGET-FN",
                            "APT::ISODATA-ISOMAP->BACK",
                            "APT::ISODATA-ISOMAP->BACK-GUARD",
                            "APT::ISODATA-ISOMAP->BACK-IMAGE",
                            "APT::ISODATA-ISOMAP->BACK-INJECTIVE",
                            "APT::ISODATA-ISOMAP->BACK-OF-FORTH",
                            "APT::ISODATA-ISOMAP->FORTH",
                            "APT::ISODATA-ISOMAP->FORTH-GUARD",
                            "APT::ISODATA-ISOMAP->FORTH-IMAGE",
                            "APT::ISODATA-ISOMAP->FORTH-INJECTIVE",
                            "APT::ISODATA-ISOMAP->FORTH-OF-BACK",
                            "APT::ISODATA-ISOMAP->HINTS",
                            "APT::ISODATA-ISOMAP->ISONAME",
                            "APT::ISODATA-ISOMAP->LOCALP",
                            "APT::ISODATA-ISOMAP->NEWP",
                            "APT::ISODATA-ISOMAP->NEWP-GUARD",
                            "APT::ISODATA-ISOMAP->OLDP",
                            "APT::ISODATA-ISOMAP->OLDP-GUARD",
                            "APT::PRINT-SPECIFIER-FIX",
                            "APT::PROPISO-INFO->HINTS-MAP",
                            "APT::PROPISO-INFO->ISO-OSI-RULESET-NAME",
                            "APT::PROPISO-INFO->ISO-RULESET-NAME",
                            "APT::PROPISO-INFO->OSI-RULESET-NAME",
                            "APT::PROPISO-INFO->WORLD",
                            "APT::TAILREC-VARIANTP-FIX",
                            "BITCOIN::BASE58-CHARACTER-EQUIV",
                            "BITCOIN::BASE58-CHARACTER-LIST-EQUIV",
                            "BITCOIN::BASE58-CHARACTER-LIST-FIX",
                            "BITCOIN::BASE58-VALUE-EQUIV",
                            "BITCOIN::BASE58-VALUE-LIST-EQUIV",
                            "BITCOIN::BASE58-VALUE-LIST-FIX",
                            "BITCOIN::BIP32-EXT-KEY-FIX",
                            "BITCOIN::BIP32-EXT-KEY-KIND",
                            "BITCOIN::BIP32-EXT-PRIV-KEY-FIX",
                            "BITCOIN::BIP32-EXT-PUB-KEY-FIX",
                            "BITCOIN::BIP32-KEY-TREE->INDEX-TREE",
                            "BITCOIN::BIP32-KEY-TREE->ROOT-KEY",
                            "BITCOIN::BIP32-KEY-TREE-FIX",
                            "BITCOIN::BIP32-PATH-SET-EQUIV",
                            "BITCOIN::BIP39-ENTROPY-EQUIV",
                            "BITCOIN::BIP39-ENTROPY-SIZE-FIX",
                            "BITCOIN::BIP43-PURPOSE-EQUIV",
                            "BITCOIN::BIP44-COIN-TYPE-SET-EQUIV",
                            "BITOPS::PART-INSTALL-WIDTH-LOW",
                            "C::ADDRESS-FIX",
                            "C::ASCII-BASIC-EXEC-CHAR-EQUIV",
                            "C::ASCII-BASIC-SOURCE-CHAR-EQUIV",
                            "C::ATC-CALL-INFO->ENCAPSULATE",
                            "C::ATC-STRING-TAGINFO-ALIST-FIX",
                            "C::ATC-SYMBOL-FNINFO-ALIST-FIX",
                            "C::ATC-SYMBOL-TYPE-ALIST-FIX",
                            "C::ATC-SYMBOL-TYPE-ALIST-LIST-EQUIV",
                            "C::ATC-SYMBOL-TYPE-ALIST-LIST-FIX",
                            "C::BINOP-FIX",
                            "C::BINOP-KIND",
                            "C::BINOP-LIST-EQUIV",
                            "C::BINOP-LIST-FIX",
                            "C::BLOCK-ITEM-DECLON->GET",
                            "C::BLOCK-ITEM-FIX",
                            "C::BLOCK-ITEM-KIND",
                            "C::BLOCK-ITEM-LIST-EQUIV",
                            "C::BLOCK-ITEM-LIST-FIX",
                            "C::BLOCK-ITEM-STMT->GET",
                            "C::BOOLEAN-RESULT-FIX",
                            "C::BOOLEAN-RESULT-KIND",
                            "C::COMPUSTATE->FRAMES",
                            "C::COMPUSTATE->HEAP",
                            "C::COMPUSTATE-FIX",
                            "C::COMPUSTATE-RESULT-KIND",
                            "C::CONST-FIX",
                            "C::CONST-KIND",
                            "C::DEFSTRUCT-INFO-FIX",
                            "C::DEFSTRUCT-MEMBER-INFO->MEMTYPE",
                            "C::DEFSTRUCT-MEMBER-INFO-FIX",
                            "C::DEFSTRUCT-MEMBER-INFO-LIST-EQUIV",
                            "C::DEFSTRUCT-MEMBER-INFO-LIST-FIX",
                            "C::ERROR-FIX",
                            "C::EXEC-CHAR-EQUIV",
                            "C::EXPR-BINARY->ARG2",
                            "C::EXPR-CALL->FUN",
                            "C::EXPR-CAST->TYPE",
                            "C::EXPR-COND->TEST",
                            "C::EXPR-CONST->GET",
                            "C::EXPR-FIX",
                            "C::EXPR-GRADE-FIX",
                            "C::EXPR-GRADE-KIND",
                            "C::EXPR-IDENT->GET",
                            "C::EXPR-KIND",
                            "C::EXPR-LIST-EQUIV",
                            "C::EXPR-LIST-FIX",
                            "C::EXPR-MEMBERP->TARGET",
                            "C::EXPR-OPTION-FIX",
                            "C::EXPR-TYPE-FIX",
                            "C::EXPR-TYPE-RESULT-FIX",
                            "C::EXPR-TYPE-RESULT-KIND",
                            "C::EXPR-UNARY->OP",
                            "C::EXT-DECLON-FIX",
                            "C::EXT-DECLON-KIND",
                            "C::EXT-DECLON-LIST-EQUIV",
                            "C::EXT-DECLON-LIST-FIX",
                            "C::FRAME->FUNCTION",
                            "C::FRAME->SCOPES",
                            "C::FRAME-FIX",
                            "C::FRAME-LIST-EQUIV",
                            "C::FRAME-LIST-FIX",
                            "C::FUN-ADECLOR-FIX",
                            "C::FUN-ADECLOR-KIND",
                            "C::FUN-DECLON-FIX",
                            "C::FUN-DECLOR-FIX",
                            "C::FUN-DECLOR-KIND",
                            "C::FUN-ENV-EQUIV",
                            "C::FUN-ENV-RESULT-FIX",
                            "C::FUN-ENV-RESULT-KIND",
                            "C::FUN-INFO->BODY",
                            "C::FUN-INFO->PARAMS",
                            "C::FUN-INFO-FIX",
                            "C::FUN-INFO-OPTION-FIX",
                            "C::FUN-TABLE-EQUIV",
                            "C::FUN-TABLE-RESULT-FIX",
                            "C::FUN-TABLE-RESULT-KIND",
                            "C::FUN-TYPE-FIX",
                            "C::FUN-TYPE-OPTION-FIX",
                            "C::FUNDEF-FIX",
                            "C::FUNDEF-LIST-EQUIV",
                            "C::FUNDEF-LIST-FIX",
                            "C::FUNTAB+TAGENV-FIX",
                            "C::FUNTAB+TAGENV-RESULT-FIX",
                            "C::FUNTAB+TAGENV-RESULT-KIND",
                            "C::ICONST->UNSIGNEDP",
                            "C::ICONST->VALUE",
                            "C::ICONST-BASE-FIX",
                            "C::ICONST-BASE-KIND",
                            "C::ICONST-FIX",
                            "C::ICONST-LENGTH-FIX",
                            "C::ICONST-LENGTH-KIND",
                            "C::ICONST-OPTION-FIX",
                            "C::IDENT->NAME",
                            "C::IDENT-FIX",
                            "C::IDENT-LIST-EQUIV",
                            "C::IDENT-LIST-FIX",
                            "C::LABEL-FIX",
                            "C::LABEL-KIND",
                            "C::MEMBER-TYPE-FIX",
                            "C::MEMBER-TYPE-LIST-EQUIV",
                            "C::MEMBER-TYPE-LIST-FIX",
                            "C::MEMBER-TYPE-LIST-OPTION-FIX",
                            "C::MEMBER-TYPE-LIST-OPTION-KIND",
                            "C::MEMBER-TYPE-LIST-RESULT-FIX",
                            "C::MEMBER-TYPE-LIST-RESULT-KIND",
                            "C::MEMBER-VALUE->NAME",
                            "C::MEMBER-VALUE->VALUE",
                            "C::MEMBER-VALUE-FIX",
                            "C::MEMBER-VALUE-LIST-EQUIV",
                            "C::MEMBER-VALUE-LIST-FIX",
                            "C::MEMBER-VALUE-LIST-RESULT-FIX",
                            "C::MEMBER-VALUE-LIST-RESULT-KIND",
                            "C::OBJ-ADECLOR-FIX",
                            "C::OBJ-ADECLOR-KIND",
                            "C::OBJ-DECLON-FIX",
                            "C::OBJ-DECLOR-FIX",
                            "C::OBJ-DECLOR-KIND",
                            "C::OBJDESIGN-ADDRESS->GET",
                            "C::OBJDESIGN-FIX",
                            "C::OBJDESIGN-KIND",
                            "C::OBJDESIGN-OPTION-FIX",
                            "C::PARAM-DECLON-FIX",
                            "C::PARAM-DECLON-LIST-EQUIV",
                            "C::PARAM-DECLON-LIST-FIX",
                            "C::PPRINT-OPTIONS-FIX",
                            "C::SCHAR->GET",
                            "C::SCHAR-ARRAY->ELEMENTS",
                            "C::SCHAR-ARRAY-FIX",
                            "C::SCHAR-FIX",
                            "C::SCHAR-INTEGER-LIST-EQUIV",
                            "C::SCHAR-INTEGER-LIST-FIX",
                            "C::SCHAR-LIST-EQUIV",
                            "C::SCHAR-LIST-FIX",
                            "C::SCOPE-LIST-EQUIV",
                            "C::SCOPE-LIST-FIX",
                            "C::SCOPE-LIST-RESULT-KIND",
                            "C::SCOPE-RESULT-KIND",
                            "C::SINT->GET",
                            "C::SINT-ARRAY->ELEMENTS",
                            "C::SINT-ARRAY-FIX",
                            "C::SINT-FIX",
                            "C::SINT-INTEGER-LIST-EQUIV",
                            "C::SINT-INTEGER-LIST-FIX",
                            "C::SINT-LIST-EQUIV",
                            "C::SINT-LIST-FIX",
                            "C::SLLONG->GET",
                            "C::SLLONG-ARRAY->ELEMENTS",
                            "C::SLLONG-ARRAY-FIX",
                            "C::SLLONG-FIX",
                            "C::SLLONG-INTEGER-LIST-EQUIV",
                            "C::SLLONG-INTEGER-LIST-FIX",
                            "C::SLLONG-LIST-EQUIV",
                            "C::SLLONG-LIST-FIX",
                            "C::SLONG->GET",
                            "C::SLONG-ARRAY->ELEMENTS",
                            "C::SLONG-ARRAY-FIX",
                            "C::SLONG-FIX",
                            "C::SLONG-INTEGER-LIST-EQUIV",
                            "C::SLONG-INTEGER-LIST-FIX",
                            "C::SLONG-LIST-EQUIV",
                            "C::SLONG-LIST-FIX",
                            "C::SOURCE-CHAR-EQUIV",
                            "C::SSHORT->GET",
                            "C::SSHORT-ARRAY->ELEMENTS",
                            "C::SSHORT-ARRAY-FIX",
                            "C::SSHORT-FIX",
                            "C::SSHORT-INTEGER-LIST-EQUIV",
                            "C::SSHORT-INTEGER-LIST-FIX",
                            "C::SSHORT-LIST-EQUIV",
                            "C::SSHORT-LIST-FIX",
                            "C::STMT-COMPOUND->ITEMS",
                            "C::STMT-EXPR->GET",
                            "C::STMT-FIX",
                            "C::STMT-IF->TEST",
                            "C::STMT-IFELSE->TEST",
                            "C::STMT-KIND",
                            "C::STMT-OPTION-FIX",
                            "C::STMT-RETURN->VALUE",
                            "C::STMT-TYPE->VARIABLES",
                            "C::STMT-TYPE-FIX",
                            "C::STMT-TYPE-RESULT-FIX",
                            "C::STMT-TYPE-RESULT-KIND",
                            "C::STMT-WHILE->TEST",
                            "C::STRUCT-DECLON-FIX",
                            "C::STRUCT-DECLON-LIST-EQUIV",
                            "C::STRUCT-DECLON-LIST-FIX",
                            "C::TAG-DECLON-FIX",
                            "C::TAG-DECLON-KIND",
                            "C::TAG-ENV-EQUIV",
                            "C::TAG-ENV-OPTION-FIX",
                            "C::TAG-ENV-OPTION-KIND",
                            "C::TAG-ENV-RESULT-FIX",
                            "C::TAG-ENV-RESULT-KIND",
                            "C::TAG-INFO-FIX",
                            "C::TAG-INFO-KIND",
                            "C::TAG-INFO-OPTION-FIX",
                            "C::TRANSUNIT-FIX",
                            "C::TYNAME-FIX",
                            "C::TYNAME-LIST-EQUIV",
                            "C::TYNAME-LIST-FIX",
                            "C::TYPE-FIX",
                            "C::TYPE-KIND",
                            "C::TYPE-LIST-EQUIV",
                            "C::TYPE-LIST-FIX",
                            "C::TYPE-LIST-RESULT-FIX",
                            "C::TYPE-LIST-RESULT-KIND",
                            "C::TYPE-OPTION-FIX",
                            "C::TYPE-OPTION-LIST-EQUIV",
                            "C::TYPE-OPTION-LIST-FIX",
                            "C::TYPE-RESULT-FIX",
                            "C::TYPE-RESULT-KIND",
                            "C::TYSPECSEQ-FIX",
                            "C::TYSPECSEQ-KIND",
                            "C::TYSPECSEQ-LIST-EQUIV",
                            "C::TYSPECSEQ-LIST-FIX",
                            "C::TYSPECSEQ-OPTION-FIX",
                            "C::UCHAR->GET",
                            "C::UCHAR-ARRAY->ELEMENTS",
                            "C::UCHAR-ARRAY-FIX",
                            "C::UCHAR-FIX",
                            "C::UCHAR-INTEGER-LIST-EQUIV",
                            "C::UCHAR-INTEGER-LIST-FIX",
                            "C::UCHAR-LIST-EQUIV",
                            "C::UCHAR-LIST-FIX",
                            "C::UINT->GET",
                            "C::UINT-ARRAY->ELEMENTS",
                            "C::UINT-ARRAY-FIX",
                            "C::UINT-FIX",
                            "C::UINT-INTEGER-LIST-EQUIV",
                            "C::UINT-INTEGER-LIST-FIX",
                            "C::UINT-LIST-EQUIV",
                            "C::UINT-LIST-FIX",
                            "C::ULLONG->GET",
                            "C::ULLONG-ARRAY->ELEMENTS",
                            "C::ULLONG-ARRAY-FIX",
                            "C::ULLONG-FIX",
                            "C::ULLONG-INTEGER-LIST-EQUIV",
                            "C::ULLONG-INTEGER-LIST-FIX",
                            "C::ULLONG-LIST-EQUIV",
                            "C::ULLONG-LIST-FIX",
                            "C::ULONG->GET",
                            "C::ULONG-ARRAY->ELEMENTS",
                            "C::ULONG-ARRAY-FIX",
                            "C::ULONG-FIX",
                            "C::ULONG-INTEGER-LIST-EQUIV",
                            "C::ULONG-INTEGER-LIST-FIX",
                            "C::ULONG-LIST-EQUIV",
                            "C::ULONG-LIST-FIX",
                            "C::UNOP-FIX",
                            "C::UNOP-KIND",
                            "C::UNOP-LIST-EQUIV",
                            "C::UNOP-LIST-FIX",
                            "C::USHORT->GET",
                            "C::USHORT-ARRAY->ELEMENTS",
                            "C::USHORT-ARRAY-FIX",
                            "C::USHORT-FIX",
                            "C::USHORT-INTEGER-LIST-EQUIV",
                            "C::USHORT-INTEGER-LIST-FIX",
                            "C::USHORT-LIST-EQUIV",
                            "C::USHORT-LIST-FIX",
                            "C::VALUE-ARRAY->ELEMENTS",
                            "C::VALUE-FIX",
                            "C::VALUE-KIND",
                            "C::VALUE-LIST-EQUIV",
                            "C::VALUE-LIST-FIX",
                            "C::VALUE-LIST-RESULT-FIX",
                            "C::VALUE-LIST-RESULT-KIND",
                            "C::VALUE-OPTION-FIX",
                            "C::VALUE-OPTION-RESULT-FIX",
                            "C::VALUE-OPTION-RESULT-KIND",
                            "C::VALUE-POINTER->REFTYPE",
                            "C::VALUE-RESULT-FIX",
                            "C::VALUE-RESULT-KIND",
                            "C::VALUE-STRUCT->MEMBERS",
                            "C::VAR-TABLE-FIX",
                            "C::VAR-TABLE-RESULT-FIX",
                            "C::VAR-TABLE-RESULT-KIND",
                            "C::WELLFORMED-RESULT-FIX",
                            "C::WELLFORMED-RESULT-KIND",
                            "CRYPTO::DEFINTERFACE-HASH-INFO->INPUT-SIZE-LIMIT",
                            "CRYPTO::DEFINTERFACE-HASH-INFO->OUTPUT-SIZE",
                            "CRYPTO::DEFINTERFACE-HMAC-INFO->BLOCK-SIZE",
                            "CRYPTO::DEFINTERFACE-HMAC-INFO->KEY-SIZE-LIMIT",
                            "CRYPTO::DEFINTERFACE-HMAC-INFO->OUTPUT-SIZE",
                            "ECURVE::MONTGOMERY-CURVE->A",
                            "ECURVE::MONTGOMERY-CURVE->B",
                            "ECURVE::MONTGOMERY-CURVE->P",
                            "ECURVE::MONTGOMERY-CURVE-FIX",
                            "ECURVE::POINT-EQUIV",
                            "ECURVE::SECP256K1-POINT->X",
                            "ECURVE::SECP256K1-POINT-FIX",
                            "ECURVE::SECP256K1-PRIV-KEY-EQUIV",
                            "ECURVE::SECP256K1-PUB-KEY-EQUIV",
                            "ECURVE::SHORT-WEIERSTRASS-FIX",
                            "ECURVE::TWISTED-EDWARDS-CURVE->A",
                            "ECURVE::TWISTED-EDWARDS-CURVE->D",
                            "ECURVE::TWISTED-EDWARDS-CURVE->P",
                            "ECURVE::TWISTED-EDWARDS-CURVE-FIX",
                            "ETHEREUM::BYTELIST-BYTELIST-MEQUIV",
                            "ETHEREUM::DATABASE-EQUIV",
                            "ETHEREUM::MAYBE-BYTE-LIST20-FIX",
                            "ETHEREUM::MAYBE-RLP-ERROR-FIX",
                            "ETHEREUM::NIBBLELIST-BYTELIST-MEQUIV",
                            "ETHEREUM::RLP-ERROR-FIX",
                            "ETHEREUM::RLP-ERROR-KIND",
                            "ETHEREUM::RLP-TREE-FIX",
                            "ETHEREUM::RLP-TREE-KIND",
                            "ETHEREUM::RLP-TREE-LEAF->BYTES",
                            "ETHEREUM::RLP-TREE-LIST-EQUIV",
                            "ETHEREUM::RLP-TREE-LIST-FIX",
                            "ETHEREUM::TRANSACTION-FIX",
                            "ETHEREUM::WORD-EQUIV",
                            "FTY::DEFBYTE-INFO->SIGNED",
                            "FTY::DEFBYTE-INFO->SIZE",
                            "FTY::RESULTERR->INFO",
                            "FTY::RESULTERR-FIX",
                            "FTY::RESULTERR-OPTION-FIX",
                            "HDWALLET::COMMAND-ERROR-FIX",
                            "HDWALLET::COMMAND-ERROR-KIND",
                            "HDWALLET::MAYBE-COMMAND-ERROR-FIX",
                            "HDWALLET::MAYBE-STAT-FIX",
                            "HDWALLET::STAT->ADDRESSES",
                            "HDWALLET::STAT-FIX",
                            "ISAR::FACT-INFO->FORMULA",
                            "ISAR::FACT-INFO->THM-NAME",
                            "JAVA::ARRAY-TYPE-FIX",
                            "JAVA::ARRAY-TYPE-KIND",
                            "JAVA::ASCII-EQUIV",
                            "JAVA::ASCII-LIST-EQUIV",
                            "JAVA::ASCII-LIST-FIX",
                            "JAVA::ATJ-ATYPE-FIX",
                            "JAVA::ATJ-ATYPE-KIND",
                            "JAVA::ATJ-FUNCTION-TYPE->INPUTS",
                            "JAVA::ATJ-FUNCTION-TYPE-FIX",
                            "JAVA::ATJ-FUNCTION-TYPE-INFO->MAIN",
                            "JAVA::ATJ-FUNCTION-TYPE-INFO-FIX",
                            "JAVA::ATJ-FUNCTION-TYPE-LIST-EQUIV",
                            "JAVA::ATJ-FUNCTION-TYPE-LIST-FIX",
                            "JAVA::ATJ-MAYBE-FUNCTION-TYPE-FIX",
                            "JAVA::ATJ-MAYBE-FUNCTION-TYPE-INFO-FIX",
                            "JAVA::ATJ-MAYBE-TYPE-FIX",
                            "JAVA::ATJ-MAYBE-TYPE-LIST-EQUIV",
                            "JAVA::ATJ-MAYBE-TYPE-LIST-FIX",
                            "JAVA::ATJ-QCONSTANTS->CHARS",
                            "JAVA::ATJ-QCONSTANTS->INTEGERS",
                            "JAVA::ATJ-QCONSTANTS->NEXT-INDEX",
                            "JAVA::ATJ-QCONSTANTS->NUMBERS",
                            "JAVA::ATJ-QCONSTANTS->PAIRS",
                            "JAVA::ATJ-QCONSTANTS->RATIONALS",
                            "JAVA::ATJ-QCONSTANTS->STRINGS",
                            "JAVA::ATJ-QCONSTANTS->SYMBOLS",
                            "JAVA::ATJ-SYMBOL-TYPE-ALIST-FIX",
                            "JAVA::ATJ-TEST-FIX",
                            "JAVA::ATJ-TEST-LIST-EQUIV",
                            "JAVA::ATJ-TEST-LIST-FIX",
                            "JAVA::ATJ-TEST-VALUE-FIX",
                            "JAVA::ATJ-TEST-VALUE-KIND",
                            "JAVA::ATJ-TEST-VALUE-LIST-EQUIV",
                            "JAVA::ATJ-TEST-VALUE-LIST-FIX",
                            "JAVA::ATJ-TYPE-FIX",
                            "JAVA::ATJ-TYPE-KIND",
                            "JAVA::ATJ-TYPE-LIST-EQUIV",
                            "JAVA::ATJ-TYPE-LIST-FIX",
                            "JAVA::ATJ-TYPE-LIST-LIST-EQUIV",
                            "JAVA::ATJ-TYPE-LIST-LIST-FIX",
                            "JAVA::BIN-DIGIT-EQUIV",
                            "JAVA::BIN-DIGIT-LIST-EQUIV",
                            "JAVA::BIN-DIGIT-LIST-FIX",
                            "JAVA::BIN-INTEGER-LITERAL-FIX",
                            "JAVA::BINDIG/USCORE-FIX",
                            "JAVA::BINDIG/USCORE-KIND",
                            "JAVA::BINDIG/USCORE-LIST-EQUIV",
                            "JAVA::BINDIG/USCORE-LIST-FIX",
                            "JAVA::BOOLEAN-ARRAY-FIX",
                            "JAVA::BOOLEAN-VALUE->BOOL",
                            "JAVA::BOOLEAN-VALUE-FIX",
                            "JAVA::BOOLEAN-VALUE-LIST-EQUIV",
                            "JAVA::BOOLEAN-VALUE-LIST-FIX",
                            "JAVA::BYTE-ARRAY-FIX",
                            "JAVA::BYTE-VALUE->INT",
                            "JAVA::BYTE-VALUE-FIX",
                            "JAVA::BYTE-VALUE-LIST-EQUIV",
                            "JAVA::BYTE-VALUE-LIST-FIX",
                            "JAVA::CHAR-ARRAY-FIX",
                            "JAVA::CHAR-LITERAL-FIX",
                            "JAVA::CHAR-LITERAL-KIND",
                            "JAVA::CHAR-VALUE-FIX",
                            "JAVA::CHAR-VALUE-LIST-EQUIV",
                            "JAVA::CHAR-VALUE-LIST-FIX",
                            "JAVA::CLASS-TYPE-FIX",
                            "JAVA::CLASS-TYPE-KIND",
                            "JAVA::DEC-DIGIT-EQUIV",
                            "JAVA::DEC-DIGIT-LIST-EQUIV",
                            "JAVA::DEC-DIGIT-LIST-FIX",
                            "JAVA::DEC-INTEGER-LITERAL-FIX",
                            "JAVA::DECDIG/USCORE-FIX",
                            "JAVA::DECDIG/USCORE-KIND",
                            "JAVA::DECDIG/USCORE-LIST-EQUIV",
                            "JAVA::DECDIG/USCORE-LIST-FIX",
                            "JAVA::DOUBLE-ARRAY-FIX",
                            "JAVA::DOUBLE-VALUE-FIX",
                            "JAVA::DOUBLE-VALUE-LIST-EQUIV",
                            "JAVA::DOUBLE-VALUE-LIST-FIX",
                            "JAVA::ESCAPE-SEQUENCE-FIX",
                            "JAVA::ESCAPE-SEQUENCE-KIND",
                            "JAVA::FLOAT-ARRAY-FIX",
                            "JAVA::FLOAT-VALUE-FIX",
                            "JAVA::FLOAT-VALUE-LIST-EQUIV",
                            "JAVA::FLOAT-VALUE-LIST-FIX",
                            "JAVA::FLOATING-POINT-TYPE-FIX",
                            "JAVA::FLOATING-POINT-TYPE-KIND",
                            "JAVA::FLOATING-POINT-VALUE-FIX",
                            "JAVA::FLOATING-POINT-VALUE-KIND",
                            "JAVA::HEX-DIGIT-EQUIV",
                            "JAVA::HEX-DIGIT-LIST-EQUIV",
                            "JAVA::HEX-DIGIT-LIST-FIX",
                            "JAVA::HEX-INTEGER-LITERAL-FIX",
                            "JAVA::HEXDIG/USCORE-FIX",
                            "JAVA::HEXDIG/USCORE-KIND",
                            "JAVA::HEXDIG/USCORE-LIST-EQUIV",
                            "JAVA::HEXDIG/USCORE-LIST-FIX",
                            "JAVA::IDENTIFIER-LIST-EQUIV",
                            "JAVA::IDENTIFIER-LIST-FIX",
                            "JAVA::INT-ARRAY-FIX",
                            "JAVA::INT-VALUE->INT",
                            "JAVA::INT-VALUE-FIX",
                            "JAVA::INT-VALUE-LIST-EQUIV",
                            "JAVA::INT-VALUE-LIST-FIX",
                            "JAVA::INTEGER-LITERAL-FIX",
                            "JAVA::INTEGER-LITERAL-KIND",
                            "JAVA::INTEGRAL-TYPE-FIX",
                            "JAVA::INTEGRAL-TYPE-KIND",
                            "JAVA::INTEGRAL-VALUE-FIX",
                            "JAVA::INTEGRAL-VALUE-KIND",
                            "JAVA::ISO8851-LIST-EQUIV",
                            "JAVA::ISO8851-LIST-FIX",
                            "JAVA::JACCESS-FIX",
                            "JAVA::JACCESS-KIND",
                            "JAVA::JBINOP-FIX",
                            "JAVA::JBINOP-KIND",
                            "JAVA::JBLOCK-EQUIV",
                            "JAVA::JBLOCK-FIX",
                            "JAVA::JBLOCK-LIST-EQUIV",
                            "JAVA::JBLOCK-LIST-FIX",
                            "JAVA::JCBODY-ELEMENT-FIX",
                            "JAVA::JCBODY-ELEMENT-KIND",
                            "JAVA::JCBODY-ELEMENT-LIST-EQUIV",
                            "JAVA::JCBODY-ELEMENT-LIST-FIX",
                            "JAVA::JCINITIALIZER-FIX",
                            "JAVA::JCLASS->BODY",
                            "JAVA::JCLASS-FIX",
                            "JAVA::JCLASS-LIST-EQUIV",
                            "JAVA::JCLASS-LIST-FIX",
                            "JAVA::JCMEMBER-FIX",
                            "JAVA::JCMEMBER-KIND",
                            "JAVA::JCUNIT-FIX",
                            "JAVA::JEXPR-FIX",
                            "JAVA::JEXPR-KIND",
                            "JAVA::JEXPR-LIST-EQUIV",
                            "JAVA::JEXPR-LIST-FIX",
                            "JAVA::JEXPR-RANK-FIX",
                            "JAVA::JEXPR-RANK-KIND",
                            "JAVA::JFIELD-FIX",
                            "JAVA::JFIELD-LIST-EQUIV",
                            "JAVA::JFIELD-LIST-FIX",
                            "JAVA::JIMPORT-FIX",
                            "JAVA::JIMPORT-LIST-EQUIV",
                            "JAVA::JIMPORT-LIST-FIX",
                            "JAVA::JLITERAL-FIX",
                            "JAVA::JLITERAL-KIND",
                            "JAVA::JLITERAL-LIST-EQUIV",
                            "JAVA::JLITERAL-LIST-FIX",
                            "JAVA::JLOCVAR-FIX",
                            "JAVA::JMETHOD-FIX",
                            "JAVA::JMETHOD-LIST-EQUIV",
                            "JAVA::JMETHOD-LIST-FIX",
                            "JAVA::JPARAM-FIX",
                            "JAVA::JPARAM-LIST-EQUIV",
                            "JAVA::JPARAM-LIST-FIX",
                            "JAVA::JRESULT-FIX",
                            "JAVA::JRESULT-KIND",
                            "JAVA::JSTATEM-FIX",
                            "JAVA::JSTATEM-KIND",
                            "JAVA::JTYPE-FIX",
                            "JAVA::JTYPE-KIND",
                            "JAVA::JTYPE-LIST-EQUIV",
                            "JAVA::JTYPE-LIST-FIX",
                            "JAVA::JUNOP-FIX",
                            "JAVA::JUNOP-KIND",
                            "JAVA::JVALUE-FIX",
                            "JAVA::JVALUE-KIND",
                            "JAVA::JVALUEX-FIX",
                            "JAVA::JVALUEX-KIND",
                            "JAVA::LITERAL-FIX",
                            "JAVA::LITERAL-KIND",
                            "JAVA::LONG-ARRAY-FIX",
                            "JAVA::LONG-VALUE->INT",
                            "JAVA::LONG-VALUE-FIX",
                            "JAVA::LONG-VALUE-LIST-EQUIV",
                            "JAVA::LONG-VALUE-LIST-FIX",
                            "JAVA::MAYBE-JEXPR-FIX",
                            "JAVA::NUMERIC-TYPE-FIX",
                            "JAVA::NUMERIC-TYPE-KIND",
                            "JAVA::NUMERIC-VALUE-FIX",
                            "JAVA::NUMERIC-VALUE-KIND",
                            "JAVA::OCT-DIGIT-EQUIV",
                            "JAVA::OCT-DIGIT-LIST-EQUIV",
                            "JAVA::OCT-DIGIT-LIST-FIX",
                            "JAVA::OCT-INTEGER-LITERAL-FIX",
                            "JAVA::OCTDIG/USCORE-FIX",
                            "JAVA::OCTDIG/USCORE-KIND",
                            "JAVA::OCTDIG/USCORE-LIST-EQUIV",
                            "JAVA::OCTDIG/USCORE-LIST-FIX",
                            "JAVA::OPTIONAL-INTEGER-TYPE-SUFFIX-FIX",
                            "JAVA::OPTIONAL-INTEGER-TYPE-SUFFIX-KIND",
                            "JAVA::PACKAGE-NAME-FIX",
                            "JAVA::POINTER-LIST-EQUIV",
                            "JAVA::POINTER-LIST-FIX",
                            "JAVA::PRIMITIVE-TYPE-FIX",
                            "JAVA::PRIMITIVE-TYPE-KIND",
                            "JAVA::PRIMITIVE-VALUE-FIX",
                            "JAVA::PRIMITIVE-VALUE-KIND",
                            "JAVA::REFERENCE-TYPE-FIX",
                            "JAVA::REFERENCE-TYPE-KIND",
                            "JAVA::REFERENCE-VALUE-FIX",
                            "JAVA::REFERENCE-VALUE-KIND",
                            "JAVA::SHORT-ARRAY-FIX",
                            "JAVA::SHORT-VALUE-FIX",
                            "JAVA::SHORT-VALUE-LIST-EQUIV",
                            "JAVA::SHORT-VALUE-LIST-FIX",
                            "JAVA::STRING-LITERAL-CHAR-FIX",
                            "JAVA::STRING-LITERAL-CHAR-KIND",
                            "JAVA::STRING-LITERAL-EQUIV",
                            "JAVA::STRING-LITERAL-FIX",
                            "JAVA::TYPE-ARGUMENT-FIX",
                            "JAVA::TYPE-ARGUMENT-KIND",
                            "JAVA::TYPE-ARGUMENT-LIST-EQUIV",
                            "JAVA::TYPE-ARGUMENT-LIST-FIX",
                            "JAVA::UNICODE-EQUIV",
                            "JAVA::UNICODE-INPUT-CHAR-FIX",
                            "JAVA::UNICODE-LIST-EQUIV",
                            "JAVA::UNICODE-LIST-FIX",
                            "JSON::MAYBE-VALUE-FIX",
                            "JSON::MEMBER->VALUE",
                            "JSON::MEMBER-FIX",
                            "JSON::MEMBER-LIST-EQUIV",
                            "JSON::MEMBER-LIST-FIX",
                            "JSON::VALUE-FIX",
                            "JSON::VALUE-KIND",
                            "JSON::VALUE-LIST-EQUIV",
                            "JSON::VALUE-LIST-FIX",
                            "PFCS::ASSERTION-FIX",
                            "PFCS::ASSERTION-LIST-EQUIV",
                            "PFCS::ASSERTION-LIST-FIX",
                            "PFCS::ASSIGNMENT-EQUIV",
                            "PFCS::ASSIGNMENT-LIST-EQUIV",
                            "PFCS::ASSIGNMENT-LIST-FIX",
                            "PFCS::CONSTRAINT-EQUAL->LEFT",
                            "PFCS::CONSTRAINT-FIX",
                            "PFCS::CONSTRAINT-KIND",
                            "PFCS::CONSTRAINT-LIST-EQUIV",
                            "PFCS::CONSTRAINT-LIST-FIX",
                            "PFCS::DEFINITION-FIX",
                            "PFCS::DEFINITION-OPTION-FIX",
                            "PFCS::EXPRESSION-FIX",
                            "PFCS::EXPRESSION-KIND",
                            "PFCS::EXPRESSION-LIST-EQUIV",
                            "PFCS::EXPRESSION-LIST-FIX",
                            "PFCS::PROOF-LIST-OUTCOME-FIX",
                            "PFCS::PROOF-LIST-OUTCOME-KIND",
                            "PFCS::PROOF-OUTCOME-FIX",
                            "PFCS::PROOF-OUTCOME-KIND",
                            "PFCS::PROOF-TREE-FIX",
                            "PFCS::PROOF-TREE-KIND",
                            "PFCS::PROOF-TREE-LIST-EQUIV",
                            "PFCS::PROOF-TREE-LIST-FIX",
                            "PFCS::SYSTEM-EQUIV",
                            "PFCS::SYSTEM-FIX",
                            "R1CS::R1CS->CONSTRAINTS",
                            "R1CS::R1CS->PRIME",
                            "R1CS::R1CS->VARS",
                            "R1CS::R1CS-CONSTRAINT->A",
                            "R1CS::R1CS-CONSTRAINT->B",
                            "R1CS::R1CS-CONSTRAINT->C",
                            "SIMPL-IMP::AEXP-FIX",
                            "SIMPL-IMP::AEXP-KIND",
                            "SIMPL-IMP::BEXP-FIX",
                            "SIMPL-IMP::BEXP-KIND",
                            "SIMPL-IMP::COMM-FIX",
                            "SIMPL-IMP::COMM-KIND",
                            "SIMPL-IMP::COMM-LIST-EQUIV",
                            "SIMPL-IMP::COMM-LIST-FIX",
                            "SIMPL-IMP::CONFIG->COMMS",
                            "SIMPL-IMP::CONFIG-FIX",
                            "SIMPL-IMP::ENV-EQUIV",
                            "SIMPL-IMP::OUTCOME-FIX",
                            "SIMPL-IMP::OUTCOME-KIND",
                            "SOLIDITY::BOOL-FIX",
                            "SOLIDITY::INT-FIX",
                            "SOLIDITY::UINT->SIZE",
                            "SOLIDITY::UINT-FIX",
                            "STR::BIN-DIGIT-CHAR-P",
                            "STR::CHAR-IN-CHARSET-P",
                            "STR::CHARACTER-LIST-FIX",
                            "STR::DEC-DIGIT-CHAR-P",
                            "STR::HEX-DIGIT-CHAR-P",
                            "STR::HEX-DIGIT-CHAR-VALUE",
                            "STR::HEX-DIGIT-CHARS-VALUE",
                            "STR::JOIN",
                            "STR::OCT-DIGIT-CHAR-P",
                            "STR::STRING-LIST-EQUIV",
                            "STR::UP-ALPHA-P",
                            "SYNDEF::OPTION[BOOL]-FIX",
                            "SYNDEF::OPTION[BOOL]-KIND",
                            "SYNDEF::OPTION[CHARACTER]-FIX",
                            "SYNDEF::OPTION[CHARACTER]-KIND",
                            "SYNDEF::OPTION[INT]-FIX",
                            "SYNDEF::OPTION[INT]-KIND",
                            "SYNDEF::OPTION[SEQUENCE[INT]]-FIX",
                            "SYNDEF::OPTION[SEQUENCE[INT]]-KIND",
                            "SYNDEF::OPTION[SET[BOOL]]-FIX",
                            "SYNDEF::OPTION[SET[BOOL]]-KIND",
                            "SYNDEF::OPTION[SET[OPTION[SET[BOOL]]]]-FIX",
                            "SYNDEF::OPTION[SET[OPTION[SET[BOOL]]]]-KIND",
                            "SYNDEF::OPTION[STRING]-FIX",
                            "SYNDEF::OPTION[STRING]-KIND",
                            "SYNDEF::SEQUENCE[BOOL]-EQUIV",
                            "SYNDEF::SEQUENCE[BOOL]-FIX",
                            "SYNDEF::SEQUENCE[CHARACTER]-EQUIV",
                            "SYNDEF::SEQUENCE[CHARACTER]-FIX",
                            "SYNDEF::SEQUENCE[INT]-EQUIV",
                            "SYNDEF::SEQUENCE[INT]-FIX",
                            "SYNDEF::SEQUENCE[OPTION[BOOL]]-EQUIV",
                            "SYNDEF::SEQUENCE[OPTION[BOOL]]-FIX",
                            "SYNDEF::SEQUENCE[OPTION[INT]]-EQUIV",
                            "SYNDEF::SEQUENCE[OPTION[INT]]-FIX",
                            "SYNDEF::SEQUENCE[SEQUENCE[SEQUENCE[SET[STRING]]]]-EQUIV",
                            "SYNDEF::SEQUENCE[SEQUENCE[SEQUENCE[SET[STRING]]]]-FIX",
                            "SYNDEF::SEQUENCE[SEQUENCE[SET[STRING]]]-EQUIV",
                            "SYNDEF::SEQUENCE[SEQUENCE[SET[STRING]]]-FIX",
                            "SYNDEF::SEQUENCE[SET[INT]]-EQUIV",
                            "SYNDEF::SEQUENCE[SET[INT]]-FIX",
                            "SYNDEF::SEQUENCE[SET[STRING]]-EQUIV",
                            "SYNDEF::SEQUENCE[SET[STRING]]-FIX",
                            "SYNDEF::SEQUENCE[STRING]-EQUIV",
                            "SYNDEF::SEQUENCE[STRING]-FIX",
                            "SYNDEF::|OPTION[MAP[CHARACTER->simple-test]]-FIX|",
                            "SYNDEF::|OPTION[MAP[CHARACTER->simple-test]]-KIND|",
                            "SYNDEF::|OPTION[OPTION[simple-test]]-FIX|",
                            "SYNDEF::|OPTION[OPTION[simple-test]]-KIND|",
                            "SYNDEF::|OPTION[simple-test]-FIX|",
                            "SYNDEF::|OPTION[simple-test]-KIND|",
                            "SYNDEF::|SEQUENCE[MAP[simple-test->INT]]-EQUIV|",
                            "SYNDEF::|SEQUENCE[MAP[simple-test->INT]]-FIX|",
                            "SYNDEF::|SEQUENCE[SEQUENCE[acid]]-EQUIV|",
                            "SYNDEF::|SEQUENCE[SEQUENCE[acid]]-FIX|",
                            "SYNDEF::|SEQUENCE[acid]-EQUIV|",
                            "SYNDEF::|SEQUENCE[acid]-FIX|",
                            "SYNDEF::|SEQUENCE[edge]-EQUIV|",
                            "SYNDEF::|SEQUENCE[edge]-FIX|",
                            "SYNDEF::|SEQUENCE[intPair]-EQUIV|",
                            "SYNDEF::|SEQUENCE[intPair]-FIX|",
                            "SYNDEF::|SEQUENCE[myRational]-EQUIV|",
                            "SYNDEF::|SEQUENCE[myRational]-FIX|",
                            "SYNDEF::|SEQUENCE[point]-EQUIV|",
                            "SYNDEF::|SEQUENCE[point]-FIX|",
                            "SYNDEF::|acid-FIX|",
                            "SYNDEF::|acid4-FIX|",
                            "SYNDEF::|actype-FIX|",
                            "SYNDEF::|actype-KIND|",
                            "SYNDEF::|aircraft-FIX|",
                            "SYNDEF::|edge->p1|",
                            "SYNDEF::|edge->p2|",
                            "SYNDEF::|edge-FIX|",
                            "SYNDEF::|intPair-FIX|",
                            "SYNDEF::|mission-FIX|",
                            "SYNDEF::|myRational-FIX|",
                            "SYNDEF::|mytype-FIX|",
                            "SYNDEF::|point-FIX|",
                            "SYNDEF::|positive2-FIX|",
                            "SYNDEF::|result-FIX|",
                            "SYNDEF::|result-KIND|",
                            "SYNDEF::|seq2-EQUIV|",
                            "SYNDEF::|seq2-FIX|",
                            "SYNDEF::|simple-test-FIX|",
                            "SYNDEF::|str-and-len-FIX|",
                            "SYNDEF::|sum-of-two-inv-FIX|",
                            "SYNDEF::|sum-of-two-inv-KIND|",
                            "SYNDEF::|test-options-of-primitive-types-FIX|",
                            "SYNDEF::|test-primitive-types-FIX|",
                            "SYNDEF::|test-types-misc-map-FIX|",
                            "SYNDEF::|test-types-misc-opt-FIX|",
                            "SYNDEF::|test-types-misc-seq-FIX|",
                            "SYNDEF::|test-types-misc-set-FIX|",
                            "SYNDEF::|test-types-random1-FIX|",
                            "SYNDEF::|tiny-mid-big-FIX|",
                            "SYNDEF::|tiny-mid-big-KIND|",
                            "SYNTHETO::ALTERNATIVE-FIX",
                            "SYNTHETO::ALTERNATIVE-LIST-EQUIV",
                            "SYNTHETO::ALTERNATIVE-LIST-FIX",
                            "SYNTHETO::BINARY-OP-FIX",
                            "SYNTHETO::BINARY-OP-KIND",
                            "SYNTHETO::BINDING-FIX",
                            "SYNTHETO::BRANCH->ACTION",
                            "SYNTHETO::BRANCH->CONDITION",
                            "SYNTHETO::BRANCH-FIX",
                            "SYNTHETO::BRANCH-LIST-EQUIV",
                            "SYNTHETO::BRANCH-LIST-FIX",
                            "SYNTHETO::CONTEXT-FIX",
                            "SYNTHETO::EXPRESSION-BIND->BODY",
                            "SYNTHETO::EXPRESSION-FIX",
                            "SYNTHETO::EXPRESSION-IF->THEN",
                            "SYNTHETO::EXPRESSION-KIND",
                            "SYNTHETO::EXPRESSION-LIST-EQUIV",
                            "SYNTHETO::EXPRESSION-LIST-FIX",
                            "SYNTHETO::FIELD-FIX",
                            "SYNTHETO::FIELD-LIST-EQUIV",
                            "SYNTHETO::FIELD-LIST-FIX",
                            "SYNTHETO::FUNCTION-DEFINER-FIX",
                            "SYNTHETO::FUNCTION-DEFINER-KIND",
                            "SYNTHETO::FUNCTION-DEFINITION-FIX",
                            "SYNTHETO::FUNCTION-DEFINITION-LIST-EQUIV",
                            "SYNTHETO::FUNCTION-DEFINITION-LIST-FIX",
                            "SYNTHETO::FUNCTION-HEADER-FIX",
                            "SYNTHETO::FUNCTION-HEADER-LIST-EQUIV",
                            "SYNTHETO::FUNCTION-HEADER-LIST-FIX",
                            "SYNTHETO::FUNCTION-NAME-FIX",
                            "SYNTHETO::FUNCTION-NAME-KIND",
                            "SYNTHETO::FUNCTION-RECURSION-FIX",
                            "SYNTHETO::FUNCTION-SPECIFICATION-FIX",
                            "SYNTHETO::FUNCTION-SPECIFIER-FIX",
                            "SYNTHETO::FUNCTION-SPECIFIER-KIND",
                            "SYNTHETO::IDENTIFIER-FIX",
                            "SYNTHETO::IDENTIFIER-LIST-EQUIV",
                            "SYNTHETO::IDENTIFIER-LIST-FIX",
                            "SYNTHETO::INITIALIZER->VALUE",
                            "SYNTHETO::INITIALIZER-FIX",
                            "SYNTHETO::INITIALIZER-LIST-EQUIV",
                            "SYNTHETO::INITIALIZER-LIST-FIX",
                            "SYNTHETO::LITERAL-FIX",
                            "SYNTHETO::LITERAL-KIND",
                            "SYNTHETO::MAYBE-EXPRESSION-FIX",
                            "SYNTHETO::MAYBE-FUNCTION-DEFINITION-FIX",
                            "SYNTHETO::MAYBE-FUNCTION-HEADER-FIX",
                            "SYNTHETO::MAYBE-FUNCTION-SPECIFICATION-FIX",
                            "SYNTHETO::MAYBE-PROOF-OBLIGATION-FIX",
                            "SYNTHETO::MAYBE-THEOREM-FIX",
                            "SYNTHETO::MAYBE-TYPE-DEFINER-FIX",
                            "SYNTHETO::MAYBE-TYPE-DEFINITION-FIX",
                            "SYNTHETO::MAYBE-TYPE-FIX",
                            "SYNTHETO::MAYBE-TYPE-PRODUCT-FIX",
                            "SYNTHETO::MAYBE-TYPE-SUBSET-FIX",
                            "SYNTHETO::MAYBE-TYPE-SUM-FIX",
                            "SYNTHETO::MAYBE-TYPED-VARIABLE-FIX",
                            "SYNTHETO::OBLIGATION-HYP-FIX",
                            "SYNTHETO::OBLIGATION-HYP-KIND",
                            "SYNTHETO::OBLIGATION-HYP-LIST-EQUIV",
                            "SYNTHETO::OBLIGATION-HYP-LIST-FIX",
                            "SYNTHETO::OUTCOME-FIX",
                            "SYNTHETO::OUTCOME-KIND",
                            "SYNTHETO::OUTCOME-LIST-EQUIV",
                            "SYNTHETO::OUTCOME-LIST-FIX",
                            "SYNTHETO::PROGRAM-FIX",
                            "SYNTHETO::PROOF-OBLIGATION-FIX",
                            "SYNTHETO::PROOF-OBLIGATION-LIST-EQUIV",
                            "SYNTHETO::PROOF-OBLIGATION-LIST-FIX",
                            "SYNTHETO::QUANTIFIER-FIX",
                            "SYNTHETO::QUANTIFIER-KIND",
                            "SYNTHETO::THEOREM-FIX",
                            "SYNTHETO::TOPLEVEL-FIX",
                            "SYNTHETO::TOPLEVEL-KIND",
                            "SYNTHETO::TOPLEVEL-LIST-EQUIV",
                            "SYNTHETO::TOPLEVEL-LIST-FIX",
                            "SYNTHETO::TRANS-STATE-FIX",
                            "SYNTHETO::TRANSFORM-ARGUMENT-FIX",
                            "SYNTHETO::TRANSFORM-ARGUMENT-LIST-EQUIV",
                            "SYNTHETO::TRANSFORM-ARGUMENT-LIST-FIX",
                            "SYNTHETO::TRANSFORM-ARGUMENT-VALUE-FIX",
                            "SYNTHETO::TRANSFORM-ARGUMENT-VALUE-KIND",
                            "SYNTHETO::TRANSFORM-FIX",
                            "SYNTHETO::TYPE-DEFINER-FIX",
                            "SYNTHETO::TYPE-DEFINER-KIND",
                            "SYNTHETO::TYPE-DEFINITION-FIX",
                            "SYNTHETO::TYPE-DEFINITION-LIST-EQUIV",
                            "SYNTHETO::TYPE-DEFINITION-LIST-FIX",
                            "SYNTHETO::TYPE-FIX",
                            "SYNTHETO::TYPE-KIND",
                            "SYNTHETO::TYPE-LIST-EQUIV",
                            "SYNTHETO::TYPE-LIST-FIX",
                            "SYNTHETO::TYPE-PRODUCT-FIX",
                            "SYNTHETO::TYPE-RECURSION-FIX",
                            "SYNTHETO::TYPE-RESULT-FIX",
                            "SYNTHETO::TYPE-RESULT-KIND",
                            "SYNTHETO::TYPE-SUBSET-FIX",
                            "SYNTHETO::TYPE-SUM-FIX",
                            "SYNTHETO::TYPED-VARIABLE-FIX",
                            "SYNTHETO::TYPED-VARIABLE-LIST-EQUIV",
                            "SYNTHETO::TYPED-VARIABLE-LIST-FIX",
                            "SYNTHETO::UNARY-OP-FIX",
                            "SYNTHETO::UNARY-OP-KIND",
                            "SYNTHETO::VARIABLE-CONTEXT-EQUIV",
                            "SYNTHETO::VARIABLE-SUBSTITUTION-EQUIV",
                            "X86ISA::!RFLAGSBITS->AC",
                            "X86ISA::!RFLAGSBITS->AF",
                            "X86ISA::!RFLAGSBITS->CF",
                            "X86ISA::!RFLAGSBITS->DF",
                            "X86ISA::!RFLAGSBITS->ID",
                            "X86ISA::!RFLAGSBITS->INTF",
                            "X86ISA::!RFLAGSBITS->IOPL",
                            "X86ISA::!RFLAGSBITS->NT",
                            "X86ISA::!RFLAGSBITS->OF",
                            "X86ISA::!RFLAGSBITS->PF",
                            "X86ISA::!RFLAGSBITS->RF",
                            "X86ISA::!RFLAGSBITS->SF",
                            "X86ISA::!RFLAGSBITS->TF",
                            "X86ISA::!RFLAGSBITS->VIF",
                            "X86ISA::!RFLAGSBITS->VIP",
                            "X86ISA::!RFLAGSBITS->VM",
                            "X86ISA::!RFLAGSBITS->ZF",
                            "X86ISA::32-BIT-MODE-ONE-BYTE-OPCODE-MODR/M-P",
                            "X86ISA::64-BIT-MODE-ONE-BYTE-OPCODE-MODR/M-P",
                            "X86ISA::ADD-TO-*IP",
                            "X86ISA::ADDRESS-ALIGNED-P",
                            "X86ISA::CANONICAL-ADDRESS-P",
                            "X86ISA::CF-SPEC16",
                            "X86ISA::CF-SPEC32",
                            "X86ISA::CF-SPEC8",
                            "X86ISA::CR0BITS->AM",
                            "X86ISA::CR3BITS->PDB",
                            "X86ISA::DATA-SEGMENT-DESCRIPTOR-ATTRIBUTESBITS->E",
                            "X86ISA::EA-TO-LA",
                            "X86ISA::I48",
                            "X86ISA::N08P",
                            "X86ISA::OF-SPEC16",
                            "X86ISA::OF-SPEC32",
                            "X86ISA::OF-SPEC64",
                            "X86ISA::OF-SPEC8",
                            "X86ISA::ONE-BYTE-OPCODE-MODR/M-P",
                            "X86ISA::PF-SPEC16",
                            "X86ISA::PF-SPEC32",
                            "X86ISA::PF-SPEC8",
                            "X86ISA::PREFIXES->REP",
                            "X86ISA::RFLAGSBITS",
                            "X86ISA::RFLAGSBITS->AC",
                            "X86ISA::RFLAGSBITS->AF",
                            "X86ISA::RFLAGSBITS->CF",
                            "X86ISA::RFLAGSBITS->DF",
                            "X86ISA::RFLAGSBITS->ID",
                            "X86ISA::RFLAGSBITS->INTF",
                            "X86ISA::RFLAGSBITS->IOPL",
                            "X86ISA::RFLAGSBITS->NT",
                            "X86ISA::RFLAGSBITS->OF",
                            "X86ISA::RFLAGSBITS->PF",
                            "X86ISA::RFLAGSBITS->RF",
                            "X86ISA::RFLAGSBITS->SF",
                            "X86ISA::RFLAGSBITS->TF",
                            "X86ISA::RFLAGSBITS->VIF",
                            "X86ISA::RFLAGSBITS->VIP",
                            "X86ISA::RFLAGSBITS->VM",
                            "X86ISA::RFLAGSBITS->ZF",
                            "X86ISA::RFLAGSBITS-FIX",
                            "X86ISA::RME-SIZE",
                            "X86ISA::RME08",
                            "X86ISA::RML-SIZE",
                            "X86ISA::RVM08",
                            "X86ISA::SEGMENT-BASE-AND-BOUNDS",
                            "X86ISA::SF-SPEC16",
                            "X86ISA::SF-SPEC32",
                            "X86ISA::SF-SPEC64",
                            "X86ISA::SF-SPEC8",
                            "X86ISA::SUB-AF-SPEC16",
                            "X86ISA::SUB-AF-SPEC32",
                            "X86ISA::SUB-AF-SPEC8",
                            "X86ISA::TWO-BYTE-OPCODE-MODR/M-P",
                            "X86ISA::ZF-SPEC",
                            "YUL::BLOCK->STATEMENTS",
                            "YUL::BLOCK-FIX",
                            "YUL::BLOCK-OPTION-FIX",
                            "YUL::BLOCK-OPTION-SOME->VAL",
                            "YUL::BLOCK-RESULT-FIX",
                            "YUL::BLOCK-RESULT-KIND",
                            "YUL::CSTATE->LOCAL",
                            "YUL::CSTATE-FIX",
                            "YUL::CSTATE-RESULT-FIX",
                            "YUL::CSTATE-RESULT-KIND",
                            "YUL::DATA-ITEM-FIX",
                            "YUL::DATA-VALUE-FIX",
                            "YUL::DATA-VALUE-KIND",
                            "YUL::EOUTCOME->CSTATE",
                            "YUL::EOUTCOME-FIX",
                            "YUL::EOUTCOME-RESULT-FIX",
                            "YUL::EOUTCOME-RESULT-KIND",
                            "YUL::ESCAPE-FIX",
                            "YUL::ESCAPE-KIND",
                            "YUL::ESCAPE-RESULT-FIX",
                            "YUL::ESCAPE-RESULT-KIND",
                            "YUL::EXPRESSION-FIX",
                            "YUL::EXPRESSION-KIND",
                            "YUL::EXPRESSION-LIST-EQUIV",
                            "YUL::EXPRESSION-LIST-FIX",
                            "YUL::EXPRESSION-OPTION-FIX",
                            "YUL::EXPRESSION-RESULT-FIX",
                            "YUL::EXPRESSION-RESULT-KIND",
                            "YUL::FUNCALL->ARGS",
                            "YUL::FUNCALL-FIX",
                            "YUL::FUNCALL-OPTION-FIX",
                            "YUL::FUNCALL-RESULT-FIX",
                            "YUL::FUNCALL-RESULT-KIND",
                            "YUL::FUNDEF->BODY",
                            "YUL::FUNDEF->INPUTS",
                            "YUL::FUNDEF->NAME",
                            "YUL::FUNDEF-FIX",
                            "YUL::FUNDEF-LIST-EQUIV",
                            "YUL::FUNDEF-LIST-FIX",
                            "YUL::FUNDEF-RESULT-FIX",
                            "YUL::FUNDEF-RESULT-KIND",
                            "YUL::FUNENV-EQUIV",
                            "YUL::FUNENV-FIX",
                            "YUL::FUNENV-RESULT-FIX",
                            "YUL::FUNENV-RESULT-KIND",
                            "YUL::FUNINFO+FUNENV->ENV",
                            "YUL::FUNINFO+FUNENV->INFO",
                            "YUL::FUNINFO+FUNENV-FIX",
                            "YUL::FUNINFO+FUNENV-RESULT-FIX",
                            "YUL::FUNINFO+FUNENV-RESULT-KIND",
                            "YUL::FUNINFO-FIX",
                            "YUL::FUNINFO-RESULT-FIX",
                            "YUL::FUNINFO-RESULT-KIND",
                            "YUL::FUNSCOPE-EQUIV",
                            "YUL::FUNSCOPE-RESULT-FIX",
                            "YUL::FUNSCOPE-RESULT-KIND",
                            "YUL::FUNTABLE-EQUIV",
                            "YUL::FUNTABLE-RESULT-FIX",
                            "YUL::FUNTABLE-RESULT-KIND",
                            "YUL::FUNTYPE->IN",
                            "YUL::FUNTYPE-FIX",
                            "YUL::FUNTYPE-RESULT-FIX",
                            "YUL::FUNTYPE-RESULT-KIND",
                            "YUL::HEX-DIGIT->GET",
                            "YUL::HEX-DIGIT-FIX",
                            "YUL::HEX-DIGIT-LIST-EQUIV",
                            "YUL::HEX-DIGIT-LIST-FIX",
                            "YUL::HEX-PAIR-FIX",
                            "YUL::HEX-PAIR-LIST-EQUIV",
                            "YUL::HEX-PAIR-LIST-FIX",
                            "YUL::HEX-PAIR-LIST-RESULT-FIX",
                            "YUL::HEX-PAIR-LIST-RESULT-KIND",
                            "YUL::HEX-QUAD-FIX",
                            "YUL::HEX-STRING-FIX",
                            "YUL::IDENTIFIER-FIX",
                            "YUL::IDENTIFIER-IDENTIFIER-ALIST-FIX",
                            "YUL::IDENTIFIER-IDENTIFIER-MAP-RESULT-FIX",
                            "YUL::IDENTIFIER-IDENTIFIER-MAP-RESULT-KIND",
                            "YUL::IDENTIFIER-LIST-EQUIV",
                            "YUL::IDENTIFIER-LIST-FIX",
                            "YUL::IDENTIFIER-LIST-RESULT-FIX",
                            "YUL::IDENTIFIER-LIST-RESULT-KIND",
                            "YUL::IDENTIFIER-OPTION-FIX",
                            "YUL::IDENTIFIER-RESULT-FIX",
                            "YUL::IDENTIFIER-RESULT-KIND",
                            "YUL::IDENTIFIER-SET-EQUIV",
                            "YUL::IDENTIFIER-SET-RESULT-FIX",
                            "YUL::IDENTIFIER-SET-RESULT-KIND",
                            "YUL::LITERAL-FIX",
                            "YUL::LITERAL-KIND",
                            "YUL::LITERAL-LIST-EQUIV",
                            "YUL::LITERAL-LIST-FIX",
                            "YUL::LITERAL-OPTION-FIX",
                            "YUL::LITERAL-RESULT-FIX",
                            "YUL::LITERAL-RESULT-KIND",
                            "YUL::LSTATE-EQUIV",
                            "YUL::MODE-FIX",
                            "YUL::MODE-KIND",
                            "YUL::MODE-SET-RESULT-FIX",
                            "YUL::MODE-SET-RESULT-KIND",
                            "YUL::OBJECT->SUB/DATA",
                            "YUL::OBJECT-FIX",
                            "YUL::OBJECT/DATA-FIX",
                            "YUL::OBJECT/DATA-KIND",
                            "YUL::OBJECT/DATA-LIST-EQUIV",
                            "YUL::OBJECT/DATA-LIST-FIX",
                            "YUL::PATH->GET",
                            "YUL::PATH-FIX",
                            "YUL::PATH-LIST-EQUIV",
                            "YUL::PATH-LIST-FIX",
                            "YUL::PATH-RESULT-FIX",
                            "YUL::PATH-RESULT-KIND",
                            "YUL::PLAIN-STRING-FIX",
                            "YUL::RENAMING->LIST",
                            "YUL::RENAMING-FIX",
                            "YUL::RENAMING-RESULT-FIX",
                            "YUL::RENAMING-RESULT-KIND",
                            "YUL::SOUTCOME->CSTATE",
                            "YUL::SOUTCOME->MODE",
                            "YUL::SOUTCOME-FIX",
                            "YUL::SOUTCOME-RESULT-FIX",
                            "YUL::SOUTCOME-RESULT-KIND",
                            "YUL::STATEMENT-FIX",
                            "YUL::STATEMENT-FUNDEF->GET",
                            "YUL::STATEMENT-KIND",
                            "YUL::STATEMENT-LIST-EQUIV",
                            "YUL::STATEMENT-LIST-FIX",
                            "YUL::STATEMENT-OPTION-FIX",
                            "YUL::STATEMENT-RESULT-FIX",
                            "YUL::STATEMENT-RESULT-KIND",
                            "YUL::STRING-ELEMENT-FIX",
                            "YUL::STRING-ELEMENT-KIND",
                            "YUL::STRING-ELEMENT-LIST-EQUIV",
                            "YUL::STRING-ELEMENT-LIST-FIX",
                            "YUL::STRING-ELEMENT-LIST-RESULT-FIX",
                            "YUL::STRING-ELEMENT-LIST-RESULT-KIND",
                            "YUL::STRING-ELEMENT-RESULT-FIX",
                            "YUL::STRING-ELEMENT-RESULT-KIND",
                            "YUL::SWCASE->BODY",
                            "YUL::SWCASE->VALUE",
                            "YUL::SWCASE-FIX",
                            "YUL::SWCASE-LIST-EQUIV",
                            "YUL::SWCASE-LIST-FIX",
                            "YUL::SWCASE-RESULT-FIX",
                            "YUL::SWCASE-RESULT-KIND",
                            "YUL::VALUE-FIX",
                            "YUL::VALUE-LIST-EQUIV",
                            "YUL::VALUE-LIST-FIX",
                            "YUL::VALUE-LIST-RESULT-FIX",
                            "YUL::VALUE-LIST-RESULT-KIND",
                            "YUL::VALUE-RESULT-FIX",
                            "YUL::VALUE-RESULT-KIND",
                            "YUL::VARS+MODES->VARS",
                            "YUL::VARS+MODES-FIX",
                            "YUL::VARS+MODES-RESULT-FIX",
                            "YUL::VARS+MODES-RESULT-KIND",
                            "ACL2::ALTERM-T->AL",
                            "ACL2::ARG-DECL-NEXT->NEXT",
                            "ACL2::BOOL->BIT",
                            "ACL2::FOOSUM-PROD2->LST",
                            "ACL2::FOOSUM-PROD2->LST2",
                            "ACL2::FOOSUM-PROD3->ALST1",
                            "ACL2::FOOSUM-PROD3->ALST2",
                            "ACL2::FOOSUM-PROD3->ALST3",
                            "ACL2::FOOSUM-PROD3->ALST4",
                            "ACL2::INT-TERM-M-PLUS->ARGS",
                            "ACL2::INT-TERM-S-PLUS->ARGS",
                            "ACL2::REC-SET-KIND",
                            "ACL2::UNUSED-SUM-PRODA->SUM1",
                            "ACL2::UNUSED-SUM-PRODB->SUM2",
                            "ACL2::VL-TYPE-ERROR-EQUIV",
                            "ACL2::VL-TYPE-ERROR-QMARK-SUBEXPR->MAP",
                            "ACL2PL::EVAL-STATE-EQUIV",
                            "ACL2PL::PROGRAM-EQUIV",
                            "ACL2PL::SYMBOL-VALUE-EQUIV",
                            "ACL2PL::TFUNCTION-EQUIV",
                            "ACL2PL::TFUNCTION-LAMBDA->BODY",
                            "ACL2PL::TTERM-CALL->ARGUMENTS",
                            "ACL2PL::TTERM-CALL->FUNCTION",
                            "ACL2PL::TTERM-EQUIV",
                            "ACL2PL::VALUE-CONS->CAR",
                            "ACL2PL::VALUE-CONS->CDR",
                            "ACL2PL::VALUE-EQUIV",
                            "BITCOIN::BIP32-EXT-KEY-EQUIV",
                            "BITCOIN::BIP32-EXT-PRIV-KEY-EQUIV",
                            "BITCOIN::BIP32-EXT-PUB-KEY-EQUIV",
                            "BITCOIN::BIP32-KEY-TREE->ROOT-DEPTH",
                            "BITCOIN::BIP32-KEY-TREE-EQUIV",
                            "C::ATC-SYMBOL-TYPE-ALIST-EQUIV",
                            "C::BINOP-EQUIV",
                            "C::BLOCK-ITEM-EQUIV",
                            "C::COMPUSTATE-EQUIV",
                            "C::COMPUSTATE-RESULT-FIX",
                            "C::CONST-EQUIV",
                            "C::CONST-INT->GET",
                            "C::ERROR->INFO",
                            "C::EXPR-ARRSUB->ARR",
                            "C::EXPR-ARRSUB->SUB",
                            "C::EXPR-BINARY->ARG1",
                            "C::EXPR-BINARY->OP",
                            "C::EXPR-CALL->ARGS",
                            "C::EXPR-CAST->ARG",
                            "C::EXPR-COND->ELSE",
                            "C::EXPR-COND->THEN",
                            "C::EXPR-EQUIV",
                            "C::EXPR-GRADE-EQUIV",
                            "C::EXPR-MEMBER->TARGET",
                            "C::EXPR-MEMBERP->NAME",
                            "C::EXPR-POSTDEC->ARG",
                            "C::EXPR-POSTINC->ARG",
                            "C::EXPR-PREDEC->ARG",
                            "C::EXPR-PREINC->ARG",
                            "C::EXPR-TYPE-EQUIV",
                            "C::EXPR-UNARY->ARG",
                            "C::EXT-DECLON-EQUIV",
                            "C::FRAME-EQUIV",
                            "C::FUN-ADECLOR-BASE->PARAMS",
                            "C::FUN-ADECLOR-EQUIV",
                            "C::FUN-ADECLOR-POINTER->DECL",
                            "C::FUN-DECLON-EQUIV",
                            "C::FUN-DECLOR-BASE->NAME",
                            "C::FUN-DECLOR-EQUIV",
                            "C::FUN-DECLOR-POINTER->DECL",
                            "C::FUN-INFO->RESULT",
                            "C::FUN-TYPE-EQUIV",
                            "C::FUNDEF-EQUIV",
                            "C::ICONST->LENGTH",
                            "C::ICONST-EQUIV",
                            "C::ICONST-LENGTH-EQUIV",
                            "C::IDENT-EQUIV",
                            "C::LABEL-EQUIV",
                            "C::MEMBER-TYPE-EQUIV",
                            "C::MEMBER-VALUE-EQUIV",
                            "C::OBJ-ADECLOR-ARRAY->DECL",
                            "C::OBJ-ADECLOR-EQUIV",
                            "C::OBJ-ADECLOR-POINTER->DECL",
                            "C::OBJ-DECLON-EQUIV",
                            "C::OBJ-DECLOR-ARRAY->DECL",
                            "C::OBJ-DECLOR-EQUIV",
                            "C::OBJ-DECLOR-IDENT->GET",
                            "C::OBJ-DECLOR-POINTER->DECL",
                            "C::OBJDESIGN-ELEMENT->SUPER",
                            "C::OBJDESIGN-EQUIV",
                            "C::OBJDESIGN-MEMBER->SUPER",
                            "C::PARAM-DECLON-EQUIV",
                            "C::PPRINT-OPTIONS-EQUIV",
                            "C::SCHAR-ARRAY-EQUIV",
                            "C::SCHAR-EQUIV",
                            "C::SCOPE-LIST-RESULT-FIX",
                            "C::SCOPE-RESULT-FIX",
                            "C::SINT-ARRAY-EQUIV",
                            "C::SINT-EQUIV",
                            "C::SLLONG-ARRAY-EQUIV",
                            "C::SLLONG-EQUIV",
                            "C::SLONG-ARRAY-EQUIV",
                            "C::SLONG-EQUIV",
                            "C::SSHORT-ARRAY-EQUIV",
                            "C::SSHORT-EQUIV",
                            "C::STMT-DOWHILE->BODY",
                            "C::STMT-EQUIV",
                            "C::STMT-FOR->BODY",
                            "C::STMT-IF->THEN",
                            "C::STMT-IFELSE->ELSE",
                            "C::STMT-IFELSE->THEN",
                            "C::STMT-LABELED->BODY",
                            "C::STMT-SWITCH->BODY",
                            "C::STMT-WHILE->BODY",
                            "C::STRUCT-DECLON-EQUIV",
                            "C::TAG-DECLON-EQUIV",
                            "C::TAG-INFO-EQUIV",
                            "C::TRANSUNIT-EQUIV",
                            "C::TYNAME-EQUIV",
                            "C::TYPE-ARRAY->OF",
                            "C::TYPE-EQUIV",
                            "C::TYPE-POINTER->TO",
                            "C::TYSPECSEQ-EQUIV",
                            "C::UCHAR-ARRAY-EQUIV",
                            "C::UCHAR-EQUIV",
                            "C::UINT-ARRAY-EQUIV",
                            "C::UINT-EQUIV",
                            "C::ULLONG-ARRAY-EQUIV",
                            "C::ULLONG-EQUIV",
                            "C::ULONG-ARRAY-EQUIV",
                            "C::ULONG-EQUIV",
                            "C::UNOP-EQUIV",
                            "C::USHORT-ARRAY-EQUIV",
                            "C::USHORT-EQUIV",
                            "C::VALUE-ARRAY->ELEMTYPE",
                            "C::VALUE-EQUIV",
                            "C::VALUE-OPTION-EQUIV",
                            "C::VALUE-RESULT-EQUIV",
                            "C::VALUE-STRUCT->TAG",
                            "C::VAR-TABLE-EQUIV",
                            "ECURVE::MONTGOMERY-CURVE-EQUIV",
                            "ECURVE::SECP256K1-POINT->Y",
                            "ECURVE::SECP256K1-POINT-EQUIV",
                            "ECURVE::SHORT-WEIERSTRASS-EQUIV",
                            "ECURVE::TWISTED-EDWARDS-CURVE-EQUIV",
                            "ETHEREUM::MAYBE-BYTE-LIST20-EQUIV",
                            "ETHEREUM::RLP-ERROR-SUBTREE->ERROR",
                            "ETHEREUM::RLP-TREE-BRANCH->SUBTREES",
                            "ETHEREUM::RLP-TREE-EQUIV",
                            "ETHEREUM::TRANSACTION-EQUIV",
                            "FTY::RESULTERR-EQUIV",
                            "HDWALLET::STAT->KEYS",
                            "JAVA::ARRAY-TYPE-CLASS->ELEMENT",
                            "JAVA::ATJ-ATYPE-EQUIV",
                            "JAVA::ATJ-FUNCTION-TYPE-INFO->OTHERS",
                            "JAVA::ATJ-MAYBE-TYPE-EQUIV",
                            "JAVA::ATJ-TEST-VALUE-ACL2->GET",
                            "JAVA::ATJ-TEST-VALUE-EQUIV",
                            "JAVA::ATJ-TYPE-ACL2->GET",
                            "JAVA::ATJ-TYPE-EQUIV",
                            "JAVA::ATJ-TYPE-JPRIM->GET",
                            "JAVA::BIN-INTEGER-LITERAL-EQUIV",
                            "JAVA::BINDIG/USCORE-EQUIV",
                            "JAVA::BOOLEAN-ARRAY->COMPONENTS",
                            "JAVA::BOOLEAN-VALUE-EQUIV",
                            "JAVA::BYTE-ARRAY->COMPONENTS",
                            "JAVA::BYTE-VALUE-EQUIV",
                            "JAVA::CHAR-ARRAY->COMPONENTS",
                            "JAVA::CHAR-VALUE-EQUIV",
                            "JAVA::CLASS-TYPE-NESTED->ARGUMENTS",
                            "JAVA::CLASS-TYPE-NESTED->ENCLOSING",
                            "JAVA::CLASS-TYPE-PACKAGE->ARGUMENTS",
                            "JAVA::CLASS-TYPE-SIMPLE->ARGUMENTS",
                            "JAVA::DEC-INTEGER-LITERAL-EQUIV",
                            "JAVA::DECDIG/USCORE-EQUIV",
                            "JAVA::DOUBLE-ARRAY->COMPONENTS",
                            "JAVA::DOUBLE-VALUE-EQUIV",
                            "JAVA::FLOAT-ARRAY->COMPONENTS",
                            "JAVA::FLOAT-VALUE-EQUIV",
                            "JAVA::HEX-INTEGER-LITERAL-EQUIV",
                            "JAVA::HEXDIG/USCORE-EQUIV",
                            "JAVA::INT-ARRAY->COMPONENTS",
                            "JAVA::INT-VALUE-EQUIV",
                            "JAVA::INTEGER-LITERAL-EQUIV",
                            "JAVA::JCBODY-ELEMENT-MEMBER->GET",
                            "JAVA::JCMEMBER-CLASS->GET",
                            "JAVA::JEXPR-ARRAY->ARRAY",
                            "JAVA::JEXPR-ARRAY->INDEX",
                            "JAVA::JEXPR-BINARY->LEFT",
                            "JAVA::JEXPR-BINARY->RIGHT",
                            "JAVA::JEXPR-CAST->ARG",
                            "JAVA::JEXPR-COND->ELSE",
                            "JAVA::JEXPR-COND->TEST",
                            "JAVA::JEXPR-COND->THEN",
                            "JAVA::JEXPR-EQUIV",
                            "JAVA::JEXPR-FIELD->TARGET",
                            "JAVA::JEXPR-IMETHOD->ARGS",
                            "JAVA::JEXPR-IMETHOD->TARGET",
                            "JAVA::JEXPR-INSTANCEOF->LEFT",
                            "JAVA::JEXPR-METHOD->ARGS",
                            "JAVA::JEXPR-NEWARRAY->SIZE",
                            "JAVA::JEXPR-NEWARRAY-INIT->INIT",
                            "JAVA::JEXPR-NEWCLASS->ARGS",
                            "JAVA::JEXPR-PAREN->GET",
                            "JAVA::JEXPR-POSTDEC->ARG",
                            "JAVA::JEXPR-POSTINC->ARG",
                            "JAVA::JEXPR-SMETHOD->ARGS",
                            "JAVA::JEXPR-UNARY->ARG",
                            "JAVA::JSTATEM-DO->BODY",
                            "JAVA::JSTATEM-EQUIV",
                            "JAVA::JSTATEM-FOR->BODY",
                            "JAVA::JSTATEM-IF->THEN",
                            "JAVA::JSTATEM-IFELSE->ELSE",
                            "JAVA::JSTATEM-IFELSE->THEN",
                            "JAVA::JSTATEM-RETURN->EXPR?",
                            "JAVA::JSTATEM-WHILE->BODY",
                            "JAVA::JTYPE-ARRAY->COMP",
                            "JAVA::JTYPE-PRIM->TYPE",
                            "JAVA::LONG-ARRAY->COMPONENTS",
                            "JAVA::LONG-VALUE-EQUIV",
                            "JAVA::OCT-INTEGER-LITERAL-EQUIV",
                            "JAVA::OCTDIG/USCORE-EQUIV",
                            "JAVA::OPTIONAL-INTEGER-TYPE-SUFFIX-EQUIV",
                            "JAVA::PRIMITIVE-TYPE-EQUIV",
                            "JAVA::REFERENCE-TYPE-ARRAY->GET",
                            "JAVA::REFERENCE-TYPE-CLASS->GET",
                            "JAVA::SHORT-ARRAY->COMPONENTS",
                            "JAVA::SHORT-VALUE-EQUIV",
                            "JAVA::TYPE-ARGUMENT-REFTYPE->GET",
                            "JAVA::TYPE-ARGUMENT-WILDCARD-EXTENDS->BOUND",
                            "JAVA::TYPE-ARGUMENT-WILDCARD-SUPER->BOUND",
                            "JSON::VALUE-ARRAY->ELEMENTS",
                            "JSON::VALUE-OBJECT->MEMBERS",
                            "PFCS::ASSERTION->ASG",
                            "PFCS::ASSERTION->CONSTR",
                            "PFCS::CONSTRAINT-EQUAL->RIGHT",
                            "PFCS::CONSTRAINT-EQUIV",
                            "PFCS::DEFINITION-EQUIV",
                            "PFCS::EXPRESSION-ADD->ARG1",
                            "PFCS::EXPRESSION-ADD->ARG2",
                            "PFCS::EXPRESSION-CONST->VALUE",
                            "PFCS::EXPRESSION-EQUIV",
                            "PFCS::EXPRESSION-MUL->ARG1",
                            "PFCS::EXPRESSION-MUL->ARG2",
                            "PFCS::PROOF-TREE-EQUIV",
                            "PFCS::PROOF-TREE-RELATION->SUB",
                            "SIMPL-IMP::AEXP-ADD->LEFT",
                            "SIMPL-IMP::AEXP-ADD->RIGHT",
                            "SIMPL-IMP::AEXP-CONST->VALUE",
                            "SIMPL-IMP::AEXP-EQUIV",
                            "SIMPL-IMP::AEXP-MUL->LEFT",
                            "SIMPL-IMP::AEXP-MUL->RIGHT",
                            "SIMPL-IMP::BEXP-AND->LEFT",
                            "SIMPL-IMP::BEXP-AND->RIGHT",
                            "SIMPL-IMP::BEXP-CONST->VALUE",
                            "SIMPL-IMP::BEXP-EQUIV",
                            "SIMPL-IMP::BEXP-NOT->ARG",
                            "SIMPL-IMP::COMM-IF->ELSE",
                            "SIMPL-IMP::COMM-IF->THEN",
                            "SIMPL-IMP::COMM-WHILE->BODY",
                            "SIMPL-IMP::CONFIG-EQUIV",
                            "SOLIDITY::BOOL-EQUIV",
                            "SOLIDITY::INT-EQUIV",
                            "SOLIDITY::UINT->VALUE",
                            "SOLIDITY::UINT-EQUIV",
                            "STR::HEX-DIGIT-TO-CHAR",
                            "STR::LCLETTER-CHARS",
                            "STR::LCLETTER/DIGIT-CHARS",
                            "STR::LETTER-CHARS",
                            "STR::LETTER/DIGIT-CHARS",
                            "STR::LETTER/DIGIT/DASH-CHARS",
                            "STR::LETTER/DIGIT/USCORE-CHARS",
                            "STR::LETTER/DIGIT/USCORE/DOLLAR-CHARS",
                            "STR::LETTER/USCORE/DOLLAR-CHARS",
                            "STR::NONDIGIT-CHARS",
                            "STR::PRINTABLE-CHARS",
                            "STR::UCLETTER-CHARS",
                            "STR::UCLETTER/DIGIT-CHARS",
                            "SYNTHETO::ALTERNATIVE-EQUIV",
                            "SYNTHETO::BINARY-OP-EQUIV",
                            "SYNTHETO::BINDING-EQUIV",
                            "SYNTHETO::BRANCH-EQUIV",
                            "SYNTHETO::CONTEXT-EQUIV",
                            "SYNTHETO::EXPRESSION-BINARY->LEFT-OPERAND",
                            "SYNTHETO::EXPRESSION-BINARY->RIGHT-OPERAND",
                            "SYNTHETO::EXPRESSION-BIND->VALUE",
                            "SYNTHETO::EXPRESSION-CALL->ARGUMENTS",
                            "SYNTHETO::EXPRESSION-COMPONENT->MULTI",
                            "SYNTHETO::EXPRESSION-COND->BRANCHES",
                            "SYNTHETO::EXPRESSION-EQUIV",
                            "SYNTHETO::EXPRESSION-IF->ELSE",
                            "SYNTHETO::EXPRESSION-IF->TEST",
                            "SYNTHETO::EXPRESSION-MULTI->ARGUMENTS",
                            "SYNTHETO::EXPRESSION-PRODUCT-CONSTRUCT->FIELDS",
                            "SYNTHETO::EXPRESSION-PRODUCT-FIELD->TARGET",
                            "SYNTHETO::EXPRESSION-PRODUCT-UPDATE->FIELDS",
                            "SYNTHETO::EXPRESSION-PRODUCT-UPDATE->TARGET",
                            "SYNTHETO::EXPRESSION-SUM-CONSTRUCT->FIELDS",
                            "SYNTHETO::EXPRESSION-SUM-FIELD->TARGET",
                            "SYNTHETO::EXPRESSION-SUM-TEST->TARGET",
                            "SYNTHETO::EXPRESSION-SUM-UPDATE->FIELDS",
                            "SYNTHETO::EXPRESSION-SUM-UPDATE->TARGET",
                            "SYNTHETO::EXPRESSION-UNARY->OPERAND",
                            "SYNTHETO::EXPRESSION-UNLESS->ELSE",
                            "SYNTHETO::EXPRESSION-UNLESS->TEST",
                            "SYNTHETO::EXPRESSION-UNLESS->THEN",
                            "SYNTHETO::EXPRESSION-WHEN->ELSE",
                            "SYNTHETO::EXPRESSION-WHEN->TEST",
                            "SYNTHETO::EXPRESSION-WHEN->THEN",
                            "SYNTHETO::FIELD-EQUIV",
                            "SYNTHETO::FUNCTION-DEFINER-EQUIV",
                            "SYNTHETO::FUNCTION-DEFINITION->DEFINER",
                            "SYNTHETO::FUNCTION-DEFINITION-EQUIV",
                            "SYNTHETO::FUNCTION-HEADER-EQUIV",
                            "SYNTHETO::FUNCTION-RECURSION-EQUIV",
                            "SYNTHETO::FUNCTION-SPECIFICATION-EQUIV",
                            "SYNTHETO::FUNCTION-SPECIFIER-EQUIV",
                            "SYNTHETO::IDENTIFIER-EQUIV",
                            "SYNTHETO::INITIALIZER-EQUIV",
                            "SYNTHETO::LITERAL-EQUIV",
                            "SYNTHETO::OBLIGATION-HYP-EQUIV",
                            "SYNTHETO::THEOREM-EQUIV",
                            "SYNTHETO::TOPLEVEL-EQUIV",
                            "SYNTHETO::TOPLEVEL-TYPE->GET",
                            "SYNTHETO::TRANS-STATE-EQUIV",
                            "SYNTHETO::TRANSFORM-EQUIV",
                            "SYNTHETO::TYPE-DEFINER-EQUIV",
                            "SYNTHETO::TYPE-DEFINITION-EQUIV",
                            "SYNTHETO::TYPE-EQUIV",
                            "SYNTHETO::TYPE-MAP->DOMAIN",
                            "SYNTHETO::TYPE-MAP->RANGE",
                            "SYNTHETO::TYPE-OPTION->BASE",
                            "SYNTHETO::TYPE-PRODUCT-EQUIV",
                            "SYNTHETO::TYPE-RECURSION-EQUIV",
                            "SYNTHETO::TYPE-RESULT-EQUIV",
                            "SYNTHETO::TYPE-SEQUENCE->ELEMENT",
                            "SYNTHETO::TYPE-SET->ELEMENT",
                            "SYNTHETO::TYPE-SUBSET-EQUIV",
                            "SYNTHETO::TYPE-SUM-EQUIV",
                            "SYNTHETO::UNARY-OP-EQUIV",
                            "X86ISA::!PREFIXES->ADR",
                            "X86ISA::!PREFIXES->LCK",
                            "X86ISA::!PREFIXES->NUM",
                            "X86ISA::!PREFIXES->OPR",
                            "X86ISA::!PREFIXES->SEG",
                            "X86ISA::N48",
                            "X86ISA::PREFIXES->OPR",
                            "X86ISA::RFLAGSBITS->RES1",
                            "YUL::BLOCK-EQUIV",
                            "YUL::BLOCK-OPTION-EQUIV",
                            "YUL::CSTATE-EQUIV",
                            "YUL::EOUTCOME-EQUIV",
                            "YUL::EOUTCOME-RESULT-EQUIV",
                            "YUL::ESCAPE-EQUIV",
                            "YUL::EXPRESSION-EQUIV",
                            "YUL::EXPRESSION-FUNCALL->GET",
                            "YUL::EXPRESSION-OPTION-EQUIV",
                            "YUL::FUNCALL-EQUIV",
                            "YUL::FUNCALL-OPTION-EQUIV",
                            "YUL::FUNDEF-EQUIV",
                            "YUL::FUNENV-RESULT-EQUIV",
                            "YUL::FUNINFO+FUNENV-EQUIV",
                            "YUL::FUNINFO+FUNENV-RESULT-EQUIV",
                            "YUL::FUNINFO-EQUIV",
                            "YUL::FUNSCOPE-RESULT-EQUIV",
                            "YUL::HEX-PAIR->1ST",
                            "YUL::HEX-PAIR->2ND",
                            "YUL::HEX-PAIR-EQUIV",
                            "YUL::HEX-QUAD->1ST",
                            "YUL::HEX-QUAD->4TH",
                            "YUL::HEX-QUAD-EQUIV",
                            "YUL::HEX-STRING-EQUIV",
                            "YUL::IDENTIFIER-EQUIV",
                            "YUL::LITERAL-EQUIV",
                            "YUL::OBJECT/DATA-OBJECT->GET",
                            "YUL::PATH-EQUIV",
                            "YUL::PLAIN-STRING-EQUIV",
                            "YUL::RENAMING-EQUIV",
                            "YUL::SOUTCOME-EQUIV",
                            "YUL::SOUTCOME-RESULT-EQUIV",
                            "YUL::STATEMENT-BLOCK->GET",
                            "YUL::STATEMENT-EQUIV",
                            "YUL::STATEMENT-FOR->BODY",
                            "YUL::STATEMENT-FOR->INIT",
                            "YUL::STATEMENT-FOR->UPDATE",
                            "YUL::STATEMENT-IF->BODY",
                            "YUL::STATEMENT-SWITCH->CASES",
                            "YUL::STATEMENT-SWITCH->DEFAULT",
                            "YUL::STRING-ELEMENT-CHAR->GET",
                            "YUL::STRING-ELEMENT-EQUIV",
                            "YUL::SWCASE-EQUIV",
                            "YUL::VALUE-EQUIV",
                            "YUL::VARS+MODES->MODES",
                            "C::FUN-DECLOR-BASE->PARAMS",
                            "C::ICONST->BASE",
                            "JAVA::JSTATEM-EXPR->GET",
                            "PFCS::PROOF-OUTCOME-ASSERTION->GET",
                            "SYNTHETO::CONTEXT->FUNCTIONS",
                            "SYNTHETO::CONTEXT->OBLIGATION-HYPS",
                            "SYNTHETO::CONTEXT->OBLIGATION-VARS",
                            "SYNTHETO::CONTEXT->TYPES",
                            "SYNTHETO::CONTEXT->VARIABLES",
                            "X86ISA::!PREFIXES->NXT",
                            "X86ISA::32-BIT-COMPUTE-MANDATORY-PREFIX-FOR-TWO-BYTE-OPCODE",
                            "X86ISA::RFLAGSBITS->RES2",
                            "YUL::HEX-QUAD->2ND",
                            "YUL::HEX-QUAD->3RD",                             )

def _parse_into_sexps (content, pkg, db):
    lst = []
    i = 0
    while i < len(content):
        if content[i] != '(':
            while i < len(content) and content[i] != '\n':
                i += 1
            i += 1
            continue
        _, sexpr, i = get_sexpr(pkg, content, i, db)
        if sexpr is None:
            break
        lst.append(sexpr)
    return lst

def _fn_symbol_is(form, pkg, fnsymb):
    return isinstance(form, list) and len(form)>0 and form[0] in ("ACL2::"+fnsymb, pkg+"::"+fnsymb, fnsymb)

def _to_clause(checkpoint, pkg="ACL2", top=True):
    # if top:
    #     print ("*** CHECKPOINT ***")
    #     print (checkpoint)
    if top and checkpoint in ("NIL", "ACL2::NIL"):
        return "NIL"
    if top and not _fn_symbol_is(checkpoint, pkg, "IMPLIES"):
        return [ _to_clause(checkpoint, pkg, False) ]
    if isinstance(checkpoint, str):
        fraction_regex = re.compile("^[-+]?\\d+(/\\d+)?$")
        if fraction_regex.match(checkpoint):
            return [ "'", checkpoint ]
        if checkpoint.isnumeric():
            return [ "'", checkpoint ]
        if checkpoint in ("ACL2::T", "ACL2::NIL", pkg+"::T", pkg+"::NIL", "T", "NIL"):
            return [ "'", checkpoint ]
        if checkpoint.startswith("#") or checkpoint.startswith(":") or checkpoint.startswith("\""):
            return [ "'", checkpoint ]
        return checkpoint
    if isinstance(checkpoint, list):
        if top and _fn_symbol_is(checkpoint, pkg, "IMPLIES"):
            hyps, conclusion = checkpoint[1:]
            clause = []
            if _fn_symbol_is(hyps, pkg, "AND"):
                all_hyps = hyps[1:]
            else:
                all_hyps = [hyps]
            for item in all_hyps:
                if _fn_symbol_is(item, pkg, "NOT"):
                    clause.append(_to_clause(item[1], pkg, False))
                else:
                    clause.append(_to_clause(["NOT", item], pkg, False))
            clause.append(_to_clause(conclusion, pkg, False))
            return clause
        if len(checkpoint) == 0:
            return []
        if checkpoint[0] == "'":
            return checkpoint
        if _fn_symbol_is(checkpoint, pkg, "LET*"):
            top_term = None
            cur_term = None
            for varname, varvalue in checkpoint[1]:
                if cur_term is None:
                    top_term = [ "LET", [[varname, varvalue]] ]
                    cur_term = top_term
                else:
                    cur_term.append([ "LET", [[varname, varvalue]] ])
            if cur_term is None:
                return _to_clause(checkpoint[2], pkg, False)
            else:
                cur_term.append(_to_clause(checkpoint[2], pkg, False))
                return cur_term
        if _fn_symbol_is(checkpoint, pkg, "LET"):
            letvars = []
            letargs = []
            for varname, varvalue in checkpoint[1]:
                letvars.append(varname)
                letargs.append(_to_clause(varvalue, pkg, False))
            if len(letvars) == 0:
                return _to_clause(checkpoint[2], pkg, False)
            else:
                return [ ["LAMBDA", letvars, _to_clause(checkpoint[2], pkg, False) ] ] + letargs 
        if _fn_symbol_is(checkpoint, pkg, "MV-LET"):
            return [ ["LAMBDA", ["MV"],
                     [ ["LAMBDA", checkpoint[1], _to_clause(checkpoint[3], pkg, False)] ] +
                     [ ["MV-NTH", ["'", f"{i}"], "MV"] for i in range(len(checkpoint[1]))] ],
                     _to_clause(checkpoint[2], pkg, False) ]
        if _fn_symbol_is(checkpoint, pkg, "NOT"):
            subterm = _to_clause(checkpoint[1], pkg, False)
            # logging.info ("Subterm of NOT:" + json.dumps(subterm, indent=2))
            if isinstance(subterm, list) and len(subterm) > 1 and _fn_symbol_is(subterm, pkg, "NOT"):
                return subterm[1]
            if isinstance(subterm, list) and len(subterm) > 1 and _fn_symbol_is(subterm, pkg, "'"): 
                if isinstance(subterm[1], str) and (subterm[1].endswith("ACL2::NIL") or subterm[1].endswith("NIL")):
                    return ["'", "T"]
                else:
                    return ["'", "NIL"]
            return ["NOT", subterm]
        if _fn_symbol_is(checkpoint, pkg, "AND"):
            if len(checkpoint) == 1:
                return ["'", "ACL2::T"]
            if len(checkpoint) == 2:
                return _to_clause(checkpoint[1], pkg, False)
            cond = _to_clause(checkpoint[1], pkg, False)
            if _fn_symbol_is(cond, pkg, "NOT"):
                return [ "IF",  cond[1], 
                         [ "'", "NIL" ],
                         _to_clause(["AND"] + checkpoint[2:], pkg, False), ]
            else:
                return [ "IF",  cond, 
                         _to_clause(["AND"] + checkpoint[2:], pkg, False),
                         [ "'", "NIL" ] ]                
        if _fn_symbol_is(checkpoint, pkg, "OR"):
            if len(checkpoint) == 1:
                return ["'", "NIL"]
            if len(checkpoint) == 2:
                return _to_clause(checkpoint[1], pkg, False)
            return [ "IF",  _to_clause(checkpoint[1], pkg, False), 
                     _to_clause(checkpoint[1], pkg, False), 
                     _to_clause(["OR"] + checkpoint[2:], pkg, False) ]
        if _fn_symbol_is(checkpoint, pkg, "CASE"):
            subterm = _to_clause(checkpoint[1], pkg, False)
            top_term = None
            cur_term = None
            for i in range(2,len(checkpoint)):
                q, a = checkpoint[i]
                if q in ("ACL2::NIL", pkg+"::NIL", "NIL"):
                    continue
                if q in ("ACL2::T", pkg+"::T", "T", "ACL2::OTHERWISE", pkg+"::OTHERWISE", "OTHERWISE"):
                    if cur_term is None:
                        return _to_clause(a, pkg, False)
                    cur_term.append (_to_clause(a, pkg, False))
                    return top_term
                if isinstance(q, list):
                    new_if = _to_clause(["IF", ["MEMBER", subterm, ["'", q]], a], pkg, False)
                else:
                    new_if = _to_clause(["IF", ["EQL", subterm, ["'", q]], a], pkg, False)
                if cur_term is None:
                    top_term = new_if
                else:
                    cur_term.append (new_if)
                cur_term = new_if
            if cur_term is None:
                return ["'", "NIL"]
            cur_term.append(["'", "NIL"])
            return top_term
        if _fn_symbol_is(checkpoint, pkg, "COND"):
            top_term = None
            cur_term = None
            for i in range(1,len(checkpoint)):
                q, a = checkpoint[i]
                if q in ("ACL2::NIL", pkg+"::NIL", "NIL"):
                    continue
                if q in ("ACL2::T", pkg+"::T", "T"):
                    if cur_term is None:
                        return _to_clause(a, pkg, False)
                    cur_term.append (_to_clause(a, pkg, False))
                    return top_term
                new_if = _to_clause(["IF", q, a], pkg, False)
                if cur_term is None:
                    top_term = new_if
                else:
                    cur_term.append (new_if)
                cur_term = new_if
            if cur_term is None:
                return ["'", "NIL"]
            cur_term.append(["'", "NIL"])
            return top_term          
        if _fn_symbol_is(checkpoint[0], pkg, "LAMBDA"):
            return [["LAMBDA", checkpoint[0][1], _to_clause(checkpoint[0][2], pkg, False)]] + [_to_clause(ck, pkg, False) for ck in checkpoint[1:]]
        m = re.search("^.*::C([AD][AD][AD]?[AD]?)R$", checkpoint[0])
        if m:
            ad = m.group(1)
            subterm = _to_clause(checkpoint[1], pkg, False)
            for a in reversed(ad):
                if a == 'A':
                    subterm = [ "CAR", subterm ]
                else:
                    subterm = [ "CDR", subterm ]
            return subterm
        if _fn_symbol_is(checkpoint, pkg, ">"):
            return _to_clause(["<", checkpoint[2], checkpoint[1]], pkg, False)
        if _fn_symbol_is(checkpoint, pkg, "<="):
            return _to_clause(["NOT", ["<", checkpoint[2], checkpoint[1]]], pkg, False)
        if _fn_symbol_is(checkpoint, pkg, ">="):
            return _to_clause(["NOT", ["<", checkpoint[1], checkpoint[2]]], pkg, False)
        if _fn_symbol_is(checkpoint, pkg, "-"):
            if len(checkpoint) > 2:
                x, y = checkpoint[1:]
                if isinstance(y, str) and y.isnumeric():
                    return ["BINARY-+", ["UNARY--", _to_clause(y, pkg, False)], _to_clause(x, pkg, False)]
                else:
                    return ["BINARY-+", _to_clause(x, pkg, False), ["UNARY--", _to_clause(y, pkg, False)]]
            else:
                x = checkpoint[1]
                return ["UNARY--", _to_clause(x, pkg, False)]
        if _fn_symbol_is(checkpoint, pkg, "/"):
            if len(checkpoint) > 2:
                x, y = checkpoint[1:]
                return ["BINARY-*", _to_clause(x, pkg, False), ["UNARY-/", _to_clause(y, pkg, False)]]
            else:
                x = checkpoint[1]
                return ["UNARY-/", _to_clause(x, pkg, False)]
        specials = [("+", 0), ("*", 1), ("APPEND", "NIL"), ("LOGIOR", 0), ("LOGXOR", 0), ("LOGAND", -1), ("LOGEQV", 0)]
        for fnsymb, identity in specials:
            if _fn_symbol_is(checkpoint, pkg, fnsymb):
                if len(checkpoint) == 1:
                    return _to_clause(identity, pkg, False)
                if len(checkpoint) == 2:
                    return _to_clause(checkpoint[1], pkg, False)
                top_term = ["BINARY-"+fnsymb, _to_clause(checkpoint[1], pkg, False)]
                cur_term = top_term
                for i in range(2, len(checkpoint)-1):
                    new_term = ["BINARY-"+fnsymb, _to_clause(checkpoint[i], pkg, False)]
                    cur_term.append(new_term)
                    cur_term = new_term
                cur_term.append(_to_clause(checkpoint[-1], pkg, False))
                return top_term
        if _fn_symbol_is(checkpoint, pkg, "LIST") or _fn_symbol_is(checkpoint, pkg, "LIST*"):
            if len(checkpoint) == 1:
                return _to_clause("NIL", pkg, False)
            top_term = ["CONS", _to_clause(checkpoint[1], pkg, False)]
            cur_term = top_term
            if _fn_symbol_is(checkpoint, pkg, "LIST"):
                idx_limit = len(checkpoint)
            else:
                idx_limit = len(checkpoint) - 1
            for i in range(2, idx_limit):
                new_term = ["CONS", _to_clause(checkpoint[i], pkg, False)]
                cur_term.append(new_term)
                cur_term = new_term
            if _fn_symbol_is(checkpoint, pkg, "LIST"):
                cur_term.append(_to_clause("NIL", pkg, False))
            else:
                cur_term.append(_to_clause(checkpoint[-1], pkg, False))
            return top_term
        if checkpoint[0] in KNOWN_INLINE_FUNCTIONS or "ACL2::"+checkpoint[0] in KNOWN_INLINE_FUNCTIONS:
            return [checkpoint[0]+"$INLINE"] + [_to_clause(ck, pkg, False) for ck in checkpoint[1:]]
        return [_to_clause(ck, pkg, False) for ck in checkpoint]
    return checkpoint

def checkpoints_to_clause (checkpoints, pkg="ACL2", names={}, db=None):
    if isinstance(checkpoints, str):
        checkpoints = _parse_into_sexps(checkpoints, pkg, db)
    if names is None:
        checkpoints = [_to_clause(ck, pkg, True) for ck in checkpoints]
    else:
        checkpoints = [_to_clause(convert_acl2data.normalize_vars(ck, names), pkg, True) for ck in checkpoints]
    return checkpoints

def _canonize_checkpoint (checkpoint, names={}):
    clause = [convert_acl2data.normalize_vars(term, names) for term in checkpoint]
    return clause

def canonize_checkpoints (checkpoints, names={}):
    new_checkpoints = [_canonize_checkpoint(ck, names) for ck in checkpoints]
    return new_checkpoints


if __name__ == "__main__":
    checkpoints = """
(IMPLIES (AND (CONSP X)
                  (MEMBER (+ 3 (* I I)) (REV X))
                  (LIST-OF-INTEGERS X)
                  (INTEGERP I)
                  (<= 0 I)
                  (INTEGERP K)
                  (<= 0 K)
                  (< I K)
                  (SQUARES-PLUS-3P K X)
                  (NOT (EQUAL (CAR X) (+ 3 (* I I))))
                  (NOT (MEMBER (+ 3 (* I I)) X)))
             (SQUARES-PLUS-3P K (REV X)))
This is just some text
(IMPLIES (AND (CONSP A)
                  (INTEGERP (CAR A))
                  (MEMBER (CAR A) B)
                  (SUBSETP (CDR A) B)
                  (NOT (SUBSETP (CDR A) (APPEND B C))))
             (MEMBER (CAR A) C))
The important thing is that 

(eq (- (- y)) y)

(IMPLIES (NOT (INTEGERP X)) (REALP X))

    (EQUAL (APPEND A B C D E) (APPEND A B))

    (EQUAL (- A) (+ A))

    (EQUAL (+) (*))

    (EQUAL (+ A B C D E) (+ A B))

    (EQUAL (- A B) (- A))

    (EQUAL (- A 2) (- A))

    (EQUAL (/ A B) (/ A))

    ;; Deliberate white space at end

    """

    db = PackageDB("pkgdefs.json")

    db = None

    names = {}
    print(json.dumps(checkpoints_to_clause(checkpoints, pkg="PRIMES", db=db, names=names), indent=2))
    print(names)

    forest = checkpoints_to_clause(checkpoints, pkg="PRIMES", db=db, names=None)
    names = {}
    print(json.dumps(canonize_checkpoints(forest, names=names), indent=2))
    print(names)

