/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 13:59:05 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.File;
import java.io.IOException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureEnumeration;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.EmblDocumentEntry;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.MSPcrunchEntryInformation;
import uk.ac.sanger.artemis.io.PublicDBDocumentEntry;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.util.Document;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class Entry_ESTest extends Entry_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      Entry.FeatureEnumerator entry_FeatureEnumerator0 = entry0.new FeatureEnumerator();
      boolean boolean0 = entry_FeatureEnumerator0.hasMoreFeatures();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, ".IZP\rhfI_k");
      Entry entry0 = filteredEntryGroup0.createEntry();
      Entry.FeatureEnumerator entry_FeatureEnumerator0 = entry0.new FeatureEnumerator();
      // Undeclared exception!
      try { 
        entry_FeatureEnumerator0.nextFeature();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "");
      filteredEntryGroup0.createEntry("");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.createFeature();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: Parse error at this point: java.lang.Integer@0000000031: range bounds must be greater than 0
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(simpleEntryInformation0);
      Entry entry0 = new Entry((Bases) null, emblDocumentEntry0);
      String string0 = entry0.getName();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("yyG_%4c>t3kF8xIA");
      Bases bases0 = entry0.getBases();
      assertNull(bases0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(simpleEntryInformation0);
      Entry entry0 = new Entry((Bases) null, emblDocumentEntry0);
      try { 
        entry0.setHeaderText("internal error - unexpected exception: ");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // the header must contain only header lines
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      // Undeclared exception!
      try { 
        entry0.saveStandardOnly((File) null, 2, false);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry((String) null);
      // Undeclared exception!
      try { 
        entry0.saveStandardOnly((-1799));
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unknown DocumentEntry type
         //
         verifyException("uk.ac.sanger.artemis.io.DocumentEntryFactory", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("C0<#");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("):");
      // Undeclared exception!
      try { 
        entry0.save(136);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unknown DocumentEntry type
         //
         verifyException("uk.ac.sanger.artemis.io.DocumentEntryFactory", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Entry.newEntry((Bases) null);
      // Undeclared exception!
      Entry.newEntry((Bases) null);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry(" is in GTF format");
      // Undeclared exception!
      try { 
        entry0.add((Feature) null, false, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      // Undeclared exception!
      try { 
        entry0.add((Feature) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Entry entry0 = null;
      try {
        entry0 = new Entry((uk.ac.sanger.artemis.io.Entry) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("C0<#");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("):");
      entry0.dispose();
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("C0<#");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry();
      boolean boolean0 = entry0.setName("internal error - unexpected exception: ");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      boolean boolean0 = entry0.setName("");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("");
      entry0.addEntryChangeListener(simpleEntryGroup0);
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      entry0.removeEntryChangeListener(simpleEntryGroup0);
      assertEquals(1, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      entry0.removeFeatureChangeListener(simpleEntryGroup0);
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "");
      Entry entry0 = filteredEntryGroup0.createEntry("gvBW9t<{");
      String string0 = entry0.getName();
      assertEquals("gvBW9t<{", string0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("C0<#");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("):");
      Bases bases1 = entry0.getBases();
      assertEquals(1, Bases.FORWARD);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("");
      EmblDocumentEntry emblDocumentEntry0 = (EmblDocumentEntry)entry0.getEMBLEntry();
      assertTrue(PublicDBDocumentEntry.IGNORE_OBSOLETE_FEATURES);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("w(3hY?]&$O");
      // Undeclared exception!
      try { 
        entry0.createFeature();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      entry0.addFeatureChangeListener(simpleEntryGroup0);
      assertEquals(1, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("eJ#VzDW J");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Entry entry0 = null;
      try {
        entry0 = new Entry(bases0, (uk.ac.sanger.artemis.io.Entry) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("");
      FeatureEnumeration featureEnumeration0 = entry0.features();
      assertFalse(featureEnumeration0.hasMoreFeatures());
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("LH");
      int int0 = entry0.getFeatureCount();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Key key0 = blastEntryInformation0.getDefaultKey();
      QualifierVector qualifierVector0 = new QualifierVector();
      // Undeclared exception!
      try { 
        entry0.createFeature(key0, (Location) null, qualifierVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.FeatureTree", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("w(3hY?]&$O");
      FeatureVector featureVector0 = entry0.checkForMissingQualifiers();
      assertNotNull(featureVector0);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("");
      FeatureVector featureVector0 = entry0.checkForOverlappingCDSs();
      assertNotNull(featureVector0);
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("yyG_%4c>t3kF8xIA");
      FeatureVector featureVector0 = entry0.checkForEMBLDuplicates();
      assertNotNull(featureVector0);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry((String) null);
      FeatureVector featureVector0 = entry0.checkFeatureStopCodons();
      assertNotNull(featureVector0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "");
      Entry entry0 = filteredEntryGroup0.createEntry("gvBW9t<{");
      FeatureVector featureVector0 = entry0.checkFeatureStartCodons();
      assertNotNull(featureVector0);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      FeatureVector featureVector0 = entry0.checkForNonEMBLKeys();
      assertNotNull(featureVector0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      Range range0 = new Range(230, 230);
      entry0.truncate((Bases) null, range0);
      // Undeclared exception!
      entry0.truncate((Bases) null, range0);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      FeatureVector featureVector0 = entry0.getAllFeatures();
      assertNotNull(featureVector0);
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      Range range0 = new Range(9999, 9999);
      FeatureVector featureVector0 = entry0.getFeaturesInRange(range0);
      assertNotNull(featureVector0);
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("C0<#");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("):");
      Document document0 = entry0.getRootDocument();
      assertTrue(document0.writable());
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Entry entry0 = Entry.newEntry(bases0);
      Document document0 = entry0.getRootDocument();
      assertNull(document0);
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("LH");
      boolean boolean0 = entry0.setHeaderText("LH");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("C0<#");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("):");
      boolean boolean0 = entry0.setName("):");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("C0<#");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("):");
      boolean boolean0 = entry0.setName("internal error - unexpected exception: ");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry((String) null);
      entry0.saveStandardOnly(0);
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("$Ld'&MHOwN]Z");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      entry0.saveStandardOnly(1);
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("C0<#");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("):");
      entry0.save(0);
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("C0<#");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("):");
      entry0.save(2);
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(mSPcrunchEntryInformation0);
      Entry entry0 = null;
      try {
        entry0 = new Entry(emblDocumentEntry0);
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      // Undeclared exception!
      try { 
        entry0.indexOf((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("C0<#");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("):");
      boolean boolean0 = entry0.isReadOnly();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("");
      entry0.featureChanged((FeatureChangeEvent) null);
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      String string0 = entry0.getHeaderText();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      Key key0 = Key.CDS;
      // Undeclared exception!
      try { 
        entry0.createFeature(key0, (Location) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.FeatureTree", e);
      }
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "operation cannot be applied to this entry");
      Entry entry0 = filteredEntryGroup0.createEntry();
      // Undeclared exception!
      try { 
        entry0.contains((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("C0<#");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("):");
      Feature feature0 = simpleEntryGroup0.createFeature();
      // Undeclared exception!
      try { 
        entry0.add(feature0, true);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - Feature has a parent
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test54()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      // Undeclared exception!
      try { 
        entry0.getFeature(803);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test55()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("C0<#");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("):");
      boolean boolean0 = entry0.hasUnsavedChanges();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test56()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("C0<#");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("):");
      entry0.removeAllFeatures();
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test57()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("C0<#");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("):");
      MockFile mockFile0 = new MockFile("internal error - unexpected exception: ", "internal error - unexpected exception: ");
      entry0.saveStandardOnly((File) mockFile0, 1, false);
      assertEquals(1392409281320L, mockFile0.lastModified());
  }

  @Test(timeout = 4000)
  public void test58()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      MockFile mockFile0 = new MockFile("internnl error - (nexpected5exception: ", "', ");
      EntryInformation entryInformation0 = entry0.getEntryInformation();
      // Undeclared exception!
      try { 
        entry0.save((File) mockFile0, (-1), true, entryInformation0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unknown DocumentEntry type
         //
         verifyException("uk.ac.sanger.artemis.io.DocumentEntryFactory", e);
      }
  }
}
