(in-package :si)
;;; Autoloaders.


;;; DEFAUTOLOAD definitions. for lsp directory files normally loaded.
(if (fboundp 'abs) (push :numlib *features*))
;;hack to avoid interning all the :symbols if the files are loaded..
#-numlib
(progn
(autoload 'abs '|gcl_numlib|)
(autoload 'acos '|gcl_numlib|)
(autoload 'acosh '|gcl_numlib|)
(autoload 'adjust-array '|gcl_arraylib|)
(autoload 'apropos '|gcl_packlib|)
(autoload 'apropos-list '|gcl_packlib|)
(autoload 'array-dimensions '|gcl_arraylib|)
(autoload 'array-in-bounds-p '|gcl_arraylib|)
(autoload 'array-row-major-index '|gcl_arraylib|)
(autoload 'asin '|gcl_numlib|)
(autoload 'asinh  '|gcl_numlib|)
(autoload 'atanh '|gcl_numlib|)
(autoload 'best-array-element-type '|gcl_arraylib|)
(autoload 'bit '|gcl_arraylib|)
(autoload 'bit-and '|gcl_arraylib|)
(autoload 'bit-andc1 '|gcl_arraylib|)
(autoload 'bit-andc2 '|gcl_arraylib|)
(autoload 'bit-eqv '|gcl_arraylib|)
(autoload 'bit-ior '|gcl_arraylib|)
(autoload 'bit-nand '|gcl_arraylib|)
(autoload 'bit-nor '|gcl_arraylib|)
(autoload 'bit-not '|gcl_arraylib|)
(autoload 'bit-orc1 '|gcl_arraylib|)
(autoload 'bit-orc2 '|gcl_arraylib|)
(autoload 'bit-xor '|gcl_arraylib|)
(autoload 'byte '|gcl_numlib|)
(autoload 'byte-position '|gcl_numlib|)
(autoload 'byte-size '|gcl_numlib|)
(autoload 'cis '|gcl_numlib|)
(autoload 'coerce '|gcl_predlib|)
(autoload 'compile-file '|gcl_loadcmp|)
(autoload 'compile '|gcl_loadcmp|)
(autoload 'disassemble '|gcl_loadcmp|)
(autoload 'concatenate '|gcl_seq|)
(autoload 'cosh '|gcl_numlib|)
(autoload 'count '|gcl_seqlib|)
(autoload 'count-if '|gcl_seqlib|)
(autoload 'count-if-not '|gcl_seqlib|)
(autoload 'decode-universal-time '|gcl_mislib|)
(autoload 'delete '|gcl_seqlib|)
(autoload 'delete-duplicates '|gcl_seqlib|)
(autoload 'delete-if '|gcl_seqlib|)
(autoload 'delete-if-not  '|gcl_seqlib|)
(autoload 'deposit-field '|gcl_numlib|)
(autoload 'describe '|gcl_describe|)
(autoload 'dpb '|gcl_numlib|)
(autoload 'dribble '|gcl_iolib|)
(autoload 'encode-universal-time '|gcl_mislib|)
(autoload 'every '|gcl_seq|)
(autoload 'fceiling '|gcl_numlib|)
(autoload 'ffloor '|gcl_numlib|)
(autoload 'fill '|gcl_seqlib|)
(autoload 'find '|gcl_seqlib|)
(autoload 'find-all-symbols '|gcl_packlib|)
(autoload 'find-if '|gcl_seqlib|)
(autoload 'find-if-not '|gcl_seqlib|)
(autoload 'fround '|gcl_numlib|)
(autoload 'ftruncate '|gcl_numlib|)
#-unix (autoload 'get-decoded-time '|gcl_mislib|)
#+aosvs (autoload 'get-universal-time '|gcl_mislib|)
(autoload 'get-setf-expansion '|gcl_setf|)
(autoload 'inspect '|gcl_describe|)
(autoload 'intersection '|gcl_listlib|)
(autoload 'isqrt '|gcl_numlib|)
(autoload 'ldb '|gcl_numlib|)
(autoload 'ldb-test '|gcl_numlib|)
(autoload 'logandc1 '|gcl_numlib|)
(autoload 'logandc2 '|gcl_numlib|)
(autoload 'lognand '|gcl_numlib|)
(autoload 'lognor '|gcl_numlib|)
(autoload 'lognot '|gcl_numlib|)
(autoload 'logorc1 '|gcl_numlib|)
(autoload 'logorc2 '|gcl_numlib|)
(autoload 'logtest '|gcl_numlib|)
(autoload 'make-array '|gcl_arraylib|)
(autoload 'make-sequence '|gcl_seq|)
(autoload 'map '|gcl_seq|)
(autoload 'mask-field '|gcl_numlib|)
(autoload 'merge '|gcl_seqlib|)
(autoload 'mismatch '|gcl_seqlib|)
(autoload 'nintersection '|gcl_listlib|)
(autoload 'notany '|gcl_seq|)
(autoload 'notevery '|gcl_seq|)
(autoload 'si::normalize-type ':predlib)
(autoload 'nset-difference '|gcl_listlib|)
(autoload 'nset-exclusive-or '|gcl_listlib|)
(autoload 'nsubstitute '|gcl_seqlib|)
(autoload 'nsubstitute-if '|gcl_seqlib|)
(autoload 'nsubstitute-if-not '|gcl_seqlib|)
(autoload 'nunion '|gcl_listlib|)
(autoload 'phase '|gcl_numlib|)
(autoload 'position '|gcl_seqlib|)
(autoload 'position-if '|gcl_seqlib|)
(autoload 'position-if-not '|gcl_seqlib|)
(autoload 'prin1-to-string '|gcl_iolib|)
(autoload 'princ-to-string '|gcl_iolib|)
(autoload 'rational '|gcl_numlib|)
(autoload 'rationalize '|gcl_numlib|)
(autoload 'read-from-string '|gcl_iolib|)
(autoload 'reduce '|gcl_seqlib|)
(autoload 'remove '|gcl_seqlib|)
(autoload 'remove-duplicates '|gcl_seqlib|)
(autoload 'remove-if '|gcl_seqlib|)
(autoload 'remove-if-not '|gcl_seqlib|)
(autoload 'replace '|gcl_seqlib|)
(autoload 'sbit '|gcl_arraylib|)
(autoload 'search '|gcl_seqlib|)
(autoload 'set-difference '|gcl_listlib|)
(autoload 'set-exclusive-or '|gcl_listlib|)
(autoload 'signum '|gcl_numlib|)
(autoload 'sinh '|gcl_numlib|)
(autoload 'some '|gcl_seq|)
(autoload 'sort '|gcl_seqlib|)
(autoload 'stable-sort '|gcl_seqlib|)
(autoload 'subsetp '|gcl_listlib|)
(autoload 'substitute '|gcl_seqlib|)
(autoload 'substitute-if '|gcl_seqlib|)
(autoload 'substitute-if-not '|gcl_seqlib|)
(autoload 'subtypep '|gcl_predlib|)
(autoload 'tanh '|gcl_numlib|)
(autoload 'typep '|gcl_predlib|)
(autoload 'union '|gcl_listlib|)
(autoload 'vector '|gcl_arraylib|)
(autoload 'vector-pop '|gcl_arraylib|)
(autoload 'vector-push '|gcl_arraylib|)
(autoload 'vector-extend '|gcl_arraylib|)
(autoload 'write-to-string '|gcl_iolib|)
(autoload 'y-or-n-p '|gcl_iolib|)
(autoload 'yes-or-no-p '|gcl_iolib|)


(set-dispatch-macro-character #\# #\a 'si::sharp-a-reader)
(set-dispatch-macro-character #\# #\A 'si::sharp-a-reader)
(autoload 'si::sharp-a-reader '"iolib")
(set-dispatch-macro-character #\# #\s 'si::sharp-s-reader)
(set-dispatch-macro-character #\# #\S 'si::sharp-s-reader)
(autoload 'si::sharp-s-reader '|gcl_iolib|)


;;; DEFAUTOLOADMACRO definitions.

(autoload-macro 'assert '|gcl_assert|)
(autoload-macro 'ccase '|gcl_assert|)
(autoload-macro 'check-type '|gcl_assert|)
(autoload-macro 'ctypecase '|gcl_assert|)
(autoload-macro 'decf '|gcl_setf|)
(autoload-macro 'define-modify-macro '|gcl_setf|)
(autoload-macro 'define-setf-method '|gcl_setf|)
(autoload-macro 'defsetf '|gcl_setf|)
(autoload-macro 'defstruct '|gcl_defstruct|)
(autoload-macro 'si::define-structure '|gcl_defstruct|)
(autoload-macro 'deftype '|gcl_predlib|)
(autoload-macro 'do-all-symbols '|gcl_packlib|)
(autoload-macro 'do-external-symbols '|gcl_packlib|)
(autoload-macro 'do-symbols '|gcl_packlib|)
(autoload-macro 'ecase '|gcl_assert|)
(autoload-macro 'etypecase '|gcl_assert|)
(autoload-macro 'incf '|gcl_setf|)
(autoload-macro 'pop '|gcl_setf|)
(autoload-macro 'push '|gcl_setf|)
(autoload-macro 'pushnew '|gcl_setf|)
(autoload-macro 'remf '|gcl_setf|)
(autoload-macro 'rotatef '|gcl_setf|)
(autoload-macro 'setf '|gcl_setf|)
(autoload-macro 'shiftf '|gcl_setf|)
(autoload-macro 'step '|gcl_trace|)
(autoload-macro 'time '|gcl_mislib|)
(autoload-macro 'trace '|gcl_trace|)
(autoload-macro 'typecase '|gcl_assert|)
(autoload-macro 'untrace '|gcl_trace|)
(autoload-macro 'with-input-from-string '|gcl_iolib|)
(autoload-macro 'with-open-file '|gcl_iolib|)
(autoload-macro 'with-open-stream '|gcl_iolib|)
(autoload-macro 'with-output-to-string '|gcl_iolib|)
)   ;;end autoloads of normally loaded files.j
(if (find-package "COMPILER") (push :compiler *features*))
#+compiler
(autoload 'compiler::emit-fn '|../cmpnew/gcl_collectfn|)
(autoload 'compiler::init-fn '|../cmpnew/gcl_collectfn|)
(autoload 'si::monstartup '"gprof")
(autoload  'si::set-up-profile '"profile")

(AUTOLOAD 'IDESCRIBE '|gcl_info|)
(AUTOLOAD 'INFO '|gcl_info|)
(AUTOLOAD 'LIST-MATCHES '|gcl_info|)
(AUTOLOAD 'get-match '|gcl_info|)
(AUTOLOAD 'print-node '|tinfo|)
(AUTOLOAD 'offer-choices '|tinfo|)
(AUTOLOAD 'tkconnect '|tkl|)

(AUTOLOAD 'user::xgcl-demo '|gcl_dwtest|)
(defun user::xgcl nil
 (use-package :xlib)
 (format t "Welcome to xgcl! Try (xgcl-demo) for a demonstration."))

;; the sun has a broken ypbind business, if one wants to save.
;; So to stop users from invoking this
#+sun
(defun user-homedir-pathname ()
 (let* ((tem (si::getenv "HOME"))
	(l (- (length tem) 1)))
   (cond ((null tem) nil)
	 (t 
	  (or (and (>= l 0)
		   (eql (aref tem l) #\/))
	      (setq tem (concatenate 'string tem "/")))
	  (pathname tem)))))


(AUTOLOAD 'init-readline '|gcl_readline|)
