/*
 * messages.c:  Error message handling
 *
 * Author:
 *	Dick Porter (dick@ximian.com)
 *
 * (C) 2008 Novell, Inc.
 */

#include <config.h>
#include <glib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>

#include <mono/io-layer/wapi.h>
#include <mono/io-layer/wapi-private.h>
#include <mono/io-layer/messages.h>
#include <mono/utils/bsearch.h>

#undef DEBUG

typedef struct {
	int id;
	const char *txt;
} ErrorDesc;

static ErrorDesc common_messages [] = {
	{ ERROR_SUCCESS, "Success" },
	{ ERROR_FILE_NOT_FOUND, "Cannot find the specified file" },
	{ ERROR_PATH_NOT_FOUND, "Cannot find the specified file" },
	{ ERROR_TOO_MANY_OPEN_FILES, "Too many open files" },
	{ ERROR_ACCESS_DENIED, "Access denied" },
	{ ERROR_INVALID_HANDLE, "Invalid handle" },
	{ ERROR_INVALID_DATA, "Invalid data" },
	{ ERROR_OUTOFMEMORY, "Out of memory" },
	{ ERROR_NOT_SAME_DEVICE, "Not same device" },
	{ ERROR_NO_MORE_FILES, "No more files" },
	{ ERROR_BAD_LENGTH, "Bad length" },
	{ ERROR_GEN_FAILURE, "General failure" },
	{ ERROR_SHARING_VIOLATION, "Sharing violation" },
	{ ERROR_LOCK_VIOLATION, "Lock violation" },
	{ ERROR_NOT_SUPPORTED, "Operation not supported" },
	{ ERROR_INVALID_PARAMETER, "Invalid parameter" },
	{ ERROR_CALL_NOT_IMPLEMENTED, "Call not implemented" },
	{ ERROR_INVALID_NAME, "Invalid name" },
	{ ERROR_PROC_NOT_FOUND, "Process not found" },
	{ ERROR_ALREADY_EXISTS, "Already exists" },
	{ ERROR_DIRECTORY, "Is a directory" },
	{ ERROR_OPERATION_ABORTED, "Operation aborted" },
	{ ERROR_ENCRYPTION_FAILED, "Encryption failed" },
	{ WSAEINTR, "interrupted" },
	{ WSAEBADF, "Bad file number" },
	{ WSAEACCES, "Access denied" },
	{ WSAEFAULT, "Bad address" },
	{ WSAEINVAL, "Invalid arguments" },
	{ WSAEMFILE, "Too many open files" },
	{ WSAEWOULDBLOCK, "Operation on non-blocking socket would block" },
	{ WSAEINPROGRESS, "Operation in progress" },
	{ WSAEALREADY, "Operation already in progress" },
	{ WSAENOTSOCK, "The descriptor is not a socket" },
	{ WSAEDESTADDRREQ, "Destination address required" },
	{ WSAEMSGSIZE, "Message too long" },
	{ WSAEPROTOTYPE, "Protocol wrong type for socket" },
	{ WSAENOPROTOOPT, "Protocol option not supported" },
	{ WSAEPROTONOSUPPORT, "Protocol not supported" },
	{ WSAESOCKTNOSUPPORT, "Socket not supported" },
	{ WSAEOPNOTSUPP, "Operation not supported" },
	{ WSAEPFNOSUPPORT, "Protocol family not supported" },
	{ WSAEAFNOSUPPORT, "An address incompatible with the requested protocol was used" },
	{ WSAEADDRINUSE, "Address already in use" },
	{ WSAEADDRNOTAVAIL, "The requested address is not valid in this context" },
	{ WSAENETDOWN, "Network subsystem is down" },
	{ WSAENETUNREACH, "Network is unreachable" },
	{ WSAENETRESET, "Connection broken, keep-alive detected a problem" },
	{ WSAECONNABORTED, "An established connection was aborted in your host machine." },
	{ WSAECONNRESET, "Connection reset by peer" },
	{ WSAENOBUFS, "Not enough buffer space is available" },
	{ WSAEISCONN, "Socket is already connected" },
	{ WSAENOTCONN, "The socket is not connected" },
	{ WSAESHUTDOWN, "The socket has been shut down" },
	{ WSAETOOMANYREFS, "Too many references: cannot splice" },
	{ WSAETIMEDOUT, "Connection timed out" },
	{ WSAECONNREFUSED, "Connection refused" },
	{ WSAELOOP, "Too many symbolic links encountered" },
	{ WSAENAMETOOLONG, "File name too long" },
	{ WSAEHOSTDOWN, "Host is down" },
	{ WSAEHOSTUNREACH, "No route to host" },
	{ WSAENOTEMPTY, "Directory not empty" },
	{ WSAEPROCLIM, "EPROCLIM" },
	{ WSAEUSERS, "Too many users" },
	{ WSAEDQUOT, "Quota exceeded" },
	{ WSAESTALE, "Stale NFS file handle" },
	{ WSAEREMOTE, "Object is remote" },
	{ WSASYSNOTREADY, "SYSNOTREADY" },
	{ WSAVERNOTSUPPORTED, "VERNOTSUPPORTED" },
	{ WSANOTINITIALISED, "Winsock not initialised" },
	{ WSAEDISCON, "EDISCON" },
	{ WSAENOMORE, "ENOMORE" },
	{ WSAECANCELLED, "Operation canceled" },
	{ WSAEINVALIDPROCTABLE, "EINVALIDPROCTABLE" },
	{ WSAEINVALIDPROVIDER, "EINVALIDPROVIDER" },
	{ WSAEPROVIDERFAILEDINIT, "EPROVIDERFAILEDINIT" },
	{ WSASYSCALLFAILURE, "System call failed" },
	{ WSASERVICE_NOT_FOUND, "SERVICE_NOT_FOUND" },
	{ WSATYPE_NOT_FOUND, "TYPE_NOT_FOUND" },
	{ WSA_E_NO_MORE, "E_NO_MORE" },
	{ WSA_E_CANCELLED, "E_CANCELLED" },
	{ WSAEREFUSED, "EREFUSED" },
	{ WSAHOST_NOT_FOUND, "No such host is known" },
	{ WSATRY_AGAIN, "A temporary error occurred on an authoritative name server.  Try again later." },
	{ WSANO_RECOVERY, "No recovery" },
	{ WSANO_DATA, "No data" },
};

#ifndef DISABLE_FULL_MESSAGES
static ErrorDesc messages [] = {
	{ ERROR_INVALID_FUNCTION, "Invalid function" },
	{ ERROR_ARENA_TRASHED, "Arena trashed" },
	{ ERROR_NOT_ENOUGH_MEMORY, "Not enough memory" },
	{ ERROR_INVALID_BLOCK, "Invalid block" },
	{ ERROR_BAD_ENVIRONMENT, "Bad environment" },
	{ ERROR_BAD_FORMAT, "Bad format" },
	{ ERROR_INVALID_ACCESS, "Invalid access" },
	{ ERROR_INVALID_DRIVE, "Invalid drive" },
	{ ERROR_CURRENT_DIRECTORY, "Current directory" },
	{ ERROR_WRITE_PROTECT, "Write protect" },
	{ ERROR_BAD_UNIT, "Bad unit" },
	{ ERROR_NOT_READY, "Not ready" },
	{ ERROR_BAD_COMMAND, "Bad command" },
	{ ERROR_CRC, "CRC" },
	{ ERROR_SEEK, "Seek" },
	{ ERROR_NOT_DOS_DISK, "Not DOS disk" },
	{ ERROR_SECTOR_NOT_FOUND, "Sector not found" },
	{ ERROR_OUT_OF_PAPER, "Out of paper" },
	{ ERROR_WRITE_FAULT, "Write fault" },
	{ ERROR_READ_FAULT, "Read fault" },
	{ ERROR_WRONG_DISK, "Wrong disk" },
	{ ERROR_SHARING_BUFFER_EXCEEDED, "Sharing buffer exceeded" },
	{ ERROR_HANDLE_EOF, "Handle EOF" },
	{ ERROR_HANDLE_DISK_FULL, "Handle disk full" },
	{ ERROR_REM_NOT_LIST, "Rem not list" },
	{ ERROR_DUP_NAME, "Duplicate name" },
	{ ERROR_BAD_NETPATH, "Bad netpath" },
	{ ERROR_NETWORK_BUSY, "Network busy" },
	{ ERROR_DEV_NOT_EXIST, "Device does not exist" },
	{ ERROR_TOO_MANY_CMDS, "Too many commands" },
	{ ERROR_ADAP_HDW_ERR, "ADAP HDW error" },
	{ ERROR_BAD_NET_RESP, "Bad net response" },
	{ ERROR_UNEXP_NET_ERR, "Unexpected net error" },
	{ ERROR_BAD_REM_ADAP, "Bad rem adap" },
	{ ERROR_PRINTQ_FULL, "Print queue full" },
	{ ERROR_NO_SPOOL_SPACE, "No spool space" },
	{ ERROR_PRINT_CANCELLED, "Print cancelled" },
	{ ERROR_NETNAME_DELETED, "Netname deleted" },
	{ ERROR_NETWORK_ACCESS_DENIED, "Network access denied" },
	{ ERROR_BAD_DEV_TYPE, "Bad device type" },
	{ ERROR_BAD_NET_NAME, "Bad net name" },
	{ ERROR_TOO_MANY_NAMES, "Too many names" },
	{ ERROR_TOO_MANY_SESS, "Too many sessions" },
	{ ERROR_SHARING_PAUSED, "Sharing paused" },
	{ ERROR_REQ_NOT_ACCEP, "Req not accep" },
	{ ERROR_REDIR_PAUSED, "Redir paused" },
	{ ERROR_FILE_EXISTS, "File exists" },
	{ ERROR_CANNOT_MAKE, "Cannot make" },
	{ ERROR_FAIL_I24, "Fail i24" },
	{ ERROR_OUT_OF_STRUCTURES, "Out of structures" },
	{ ERROR_ALREADY_ASSIGNED, "Already assigned" },
	{ ERROR_INVALID_PASSWORD, "Invalid password" },
	{ ERROR_NET_WRITE_FAULT, "Net write fault" },
	{ ERROR_NO_PROC_SLOTS, "No proc slots" },
	{ ERROR_TOO_MANY_SEMAPHORES, "Too many semaphores" },
	{ ERROR_EXCL_SEM_ALREADY_OWNED, "Exclusive semaphore already owned" },
	{ ERROR_SEM_IS_SET, "Semaphore is set" },
	{ ERROR_TOO_MANY_SEM_REQUESTS, "Too many semaphore requests" },
	{ ERROR_INVALID_AT_INTERRUPT_TIME, "Invalid at interrupt time" },
	{ ERROR_SEM_OWNER_DIED, "Semaphore owner died" },
	{ ERROR_SEM_USER_LIMIT, "Semaphore user limit" },
	{ ERROR_DISK_CHANGE, "Disk change" },
	{ ERROR_DRIVE_LOCKED, "Drive locked" },
	{ ERROR_BROKEN_PIPE, "Broken pipe" },
	{ ERROR_OPEN_FAILED, "Open failed" },
	{ ERROR_BUFFER_OVERFLOW, "Buffer overflow" },
	{ ERROR_DISK_FULL, "Disk full" },
	{ ERROR_NO_MORE_SEARCH_HANDLES, "No more search handles" },
	{ ERROR_INVALID_TARGET_HANDLE, "Invalid target handle" },
	{ ERROR_INVALID_CATEGORY, "Invalid category" },
	{ ERROR_INVALID_VERIFY_SWITCH, "Invalid verify switch" },
	{ ERROR_BAD_DRIVER_LEVEL, "Bad driver level" },
	{ ERROR_SEM_TIMEOUT, "Semaphore timeout" },
	{ ERROR_INSUFFICIENT_BUFFER, "Insufficient buffer" },
	{ ERROR_INVALID_LEVEL, "Invalid level" },
	{ ERROR_NO_VOLUME_LABEL, "No volume label" },
	{ ERROR_MOD_NOT_FOUND, "Module not found" },
	{ ERROR_WAIT_NO_CHILDREN, "Wait no children" },
	{ ERROR_CHILD_NOT_COMPLETE, "Child not complete" },
	{ ERROR_DIRECT_ACCESS_HANDLE, "Direct access handle" },
	{ ERROR_NEGATIVE_SEEK, "Negative seek" },
	{ ERROR_SEEK_ON_DEVICE, "Seek on device" },
	{ ERROR_IS_JOIN_TARGET, "Is join target" },
	{ ERROR_IS_JOINED, "Is joined" },
	{ ERROR_IS_SUBSTED, "Is substed" },
	{ ERROR_NOT_JOINED, "Not joined" },
	{ ERROR_NOT_SUBSTED, "Not substed" },
	{ ERROR_JOIN_TO_JOIN, "Join to join" },
	{ ERROR_SUBST_TO_SUBST, "Subst to subst" },
	{ ERROR_JOIN_TO_SUBST, "Join to subst" },
	{ ERROR_SUBST_TO_JOIN, "Subst to join" },
	{ ERROR_BUSY_DRIVE, "Busy drive" },
	{ ERROR_SAME_DRIVE, "Same drive" },
	{ ERROR_DIR_NOT_ROOT, "Directory not root" },
	{ ERROR_DIR_NOT_EMPTY, "Directory not empty" },
	{ ERROR_IS_SUBST_PATH, "Is subst path" },
	{ ERROR_IS_JOIN_PATH, "Is join path" },
	{ ERROR_PATH_BUSY, "Path busy" },
	{ ERROR_IS_SUBST_TARGET, "Is subst target" },
	{ ERROR_SYSTEM_TRACE, "System trace" },
	{ ERROR_INVALID_EVENT_COUNT, "Invalid event count" },
	{ ERROR_TOO_MANY_MUXWAITERS, "Too many muxwaiters" },
	{ ERROR_INVALID_LIST_FORMAT, "Invalid list format" },
	{ ERROR_LABEL_TOO_LONG, "Label too long" },
	{ ERROR_TOO_MANY_TCBS, "Too many TCBs" },
	{ ERROR_SIGNAL_REFUSED, "Signal refused" },
	{ ERROR_DISCARDED, "Discarded" },
	{ ERROR_NOT_LOCKED, "Not locked" },
	{ ERROR_BAD_THREADID_ADDR, "Bad thread ID addr" },
	{ ERROR_BAD_ARGUMENTS, "Bad arguments" },
	{ ERROR_BAD_PATHNAME, "Bad pathname" },
	{ ERROR_SIGNAL_PENDING, "Signal pending" },
	{ ERROR_MAX_THRDS_REACHED, "Max thrds reached" },
	{ ERROR_LOCK_FAILED, "Lock failed" },
	{ ERROR_BUSY, "Busy" },
	{ ERROR_CANCEL_VIOLATION, "Cancel violation" },
	{ ERROR_ATOMIC_LOCKS_NOT_SUPPORTED, "Atomic locks not supported" },
	{ ERROR_INVALID_SEGMENT_NUMBER, "Invalid segment number" },
	{ ERROR_INVALID_ORDINAL, "Invalid ordinal" },
	{ ERROR_INVALID_FLAG_NUMBER, "Invalid flag number" },
	{ ERROR_SEM_NOT_FOUND, "Sem not found" },
	{ ERROR_INVALID_STARTING_CODESEG, "Invalid starting codeseg" },
	{ ERROR_INVALID_STACKSEG, "Invalid stackseg" },
	{ ERROR_INVALID_MODULETYPE, "Invalid moduletype" },
	{ ERROR_INVALID_EXE_SIGNATURE, "Invalid exe signature" },
	{ ERROR_EXE_MARKED_INVALID, "Exe marked invalid" },
	{ ERROR_BAD_EXE_FORMAT, "Bad exe format" },
	{ ERROR_ITERATED_DATA_EXCEEDS_64k, "Iterated data exceeds 64k (and that should be enough for anybody!)" },
	{ ERROR_INVALID_MINALLOCSIZE, "Invalid minallocsize" },
	{ ERROR_DYNLINK_FROM_INVALID_RING, "Dynlink from invalid ring" },
	{ ERROR_IOPL_NOT_ENABLED, "IOPL not enabled" },
	{ ERROR_INVALID_SEGDPL, "Invalid segdpl" },
	{ ERROR_AUTODATASEG_EXCEEDS_64k, "Autodataseg exceeds 64k" },
	{ ERROR_RING2SEG_MUST_BE_MOVABLE, "Ring2seg must be movable" },
	{ ERROR_RELOC_CHAIN_XEEDS_SEGLIM, "Reloc chain exceeds seglim" },
	{ ERROR_INFLOOP_IN_RELOC_CHAIN, "Infloop in reloc chain" },
	{ ERROR_ENVVAR_NOT_FOUND, "Env var not found" },
	{ ERROR_NO_SIGNAL_SENT, "No signal sent" },
	{ ERROR_FILENAME_EXCED_RANGE, "Filename exceeds range" },
	{ ERROR_RING2_STACK_IN_USE, "Ring2 stack in use" },
	{ ERROR_META_EXPANSION_TOO_LONG, "Meta expansion too long" },
	{ ERROR_INVALID_SIGNAL_NUMBER, "Invalid signal number" },
	{ ERROR_THREAD_1_INACTIVE, "Thread 1 inactive" },
	{ ERROR_LOCKED, "Locked" },
	{ ERROR_TOO_MANY_MODULES, "Too many modules" },
	{ ERROR_NESTING_NOT_ALLOWED, "Nesting not allowed" },
	{ ERROR_EXE_MACHINE_TYPE_MISMATCH, "Exe machine type mismatch" },
	{ ERROR_BAD_PIPE, "Bad pipe" },
	{ ERROR_PIPE_BUSY, "Pipe busy" },
	{ ERROR_NO_DATA, "No data" },
	{ ERROR_PIPE_NOT_CONNECTED, "Pipe not connected" },
	{ ERROR_MORE_DATA, "More data" },
	{ ERROR_VC_DISCONNECTED, "VC disconnected" },
	{ ERROR_INVALID_EA_NAME, "Invalid EA name" },
	{ ERROR_EA_LIST_INCONSISTENT, "EA list inconsistent" },
	{ WAIT_TIMEOUT, "Wait timeout" },
	{ ERROR_NO_MORE_ITEMS, "No more items" },
	{ ERROR_CANNOT_COPY, "Cannot copy" },
	{ ERROR_EAS_DIDNT_FIT, "EAS didnt fit" },
	{ ERROR_EA_FILE_CORRUPT, "EA file corrupt" },
	{ ERROR_EA_TABLE_FULL, "EA table full" },
	{ ERROR_INVALID_EA_HANDLE, "Invalid EA handle" },
	{ ERROR_EAS_NOT_SUPPORTED, "EAs not supported" },
	{ ERROR_NOT_OWNER, "Not owner" },
	{ ERROR_TOO_MANY_POSTS, "Too many posts" },
	{ ERROR_PARTIAL_COPY, "Partial copy" },
	{ ERROR_OPLOCK_NOT_GRANTED, "Oplock not granted" },
	{ ERROR_INVALID_OPLOCK_PROTOCOL, "Invalid oplock protocol" },
	{ ERROR_DISK_TOO_FRAGMENTED, "Disk too fragmented" },
	{ ERROR_DELETE_PENDING, "Delete pending" },
	{ ERROR_MR_MID_NOT_FOUND, "Mr Mid not found" },
	{ ERROR_INVALID_ADDRESS, "Invalid address" },
	{ ERROR_ARITHMETIC_OVERFLOW, "Arithmetic overflow" },
	{ ERROR_PIPE_CONNECTED, "Pipe connected" },
	{ ERROR_PIPE_LISTENING, "Pipe listening" },
	{ ERROR_EA_ACCESS_DENIED, "EA access denied" },
	{ ERROR_IO_INCOMPLETE, "IO incomplete" },
	{ ERROR_IO_PENDING, "IO pending" },
	{ ERROR_NOACCESS, "No access" },
	{ ERROR_SWAPERROR, "Swap error" },
	{ ERROR_STACK_OVERFLOW, "Stack overflow" },
	{ ERROR_INVALID_MESSAGE, "Invalid message" },
	{ ERROR_CAN_NOT_COMPLETE, "Can not complete" },
	{ ERROR_INVALID_FLAGS, "Invalid flags" },
	{ ERROR_UNRECOGNIZED_VOLUME, "Unrecognised volume" },
	{ ERROR_FILE_INVALID, "File invalid" },
	{ ERROR_FULLSCREEN_MODE, "Full screen mode" },
	{ ERROR_NO_TOKEN, "No token" },
	{ ERROR_BADDB, "Bad DB" },
	{ ERROR_BADKEY, "Bad key" },
	{ ERROR_CANTOPEN, "Can't open" },
	{ ERROR_CANTREAD, "Can't read" },
	{ ERROR_CANTWRITE, "Can't write" },
	{ ERROR_REGISTRY_RECOVERED, "Registry recovered" },
	{ ERROR_REGISTRY_CORRUPT, "Registry corrupt" },
	{ ERROR_REGISTRY_IO_FAILED, "Registry IO failed" },
	{ ERROR_NOT_REGISTRY_FILE, "Not registry file" },
	{ ERROR_KEY_DELETED, "Key deleted" },
	{ ERROR_NO_LOG_SPACE, "No log space" },
	{ ERROR_KEY_HAS_CHILDREN, "Key has children" },
	{ ERROR_CHILD_MUST_BE_VOLATILE, "Child must be volatile" },
	{ ERROR_NOTIFY_ENUM_DIR, "Notify enum dir" },
	{ ERROR_DEPENDENT_SERVICES_RUNNING, "Dependent services running" },
	{ ERROR_INVALID_SERVICE_CONTROL, "Invalid service control" },
	{ ERROR_SERVICE_REQUEST_TIMEOUT, "Service request timeout" },
	{ ERROR_SERVICE_NO_THREAD, "Service no thread" },
	{ ERROR_SERVICE_DATABASE_LOCKED, "Service database locked" },
	{ ERROR_SERVICE_ALREADY_RUNNING, "Service already running" },
	{ ERROR_INVALID_SERVICE_ACCOUNT, "Invalid service account" },
	{ ERROR_SERVICE_DISABLED, "Service disabled" },
	{ ERROR_CIRCULAR_DEPENDENCY, "Circular dependency" },
	{ ERROR_SERVICE_DOES_NOT_EXIST, "Service does not exist" },
	{ ERROR_SERVICE_CANNOT_ACCEPT_CTRL, "Service cannot accept ctrl" },
	{ ERROR_SERVICE_NOT_ACTIVE, "Service not active" },
	{ ERROR_FAILED_SERVICE_CONTROLLER_CONNECT, "Failed service controller connect" },
	{ ERROR_EXCEPTION_IN_SERVICE, "Exception in service" },
	{ ERROR_DATABASE_DOES_NOT_EXIST, "Database does not exist" },
	{ ERROR_SERVICE_SPECIFIC_ERROR, "Service specific error" },
	{ ERROR_PROCESS_ABORTED, "Process aborted" },
	{ ERROR_SERVICE_DEPENDENCY_FAIL, "Service dependency fail" },
	{ ERROR_SERVICE_LOGON_FAILED, "Service logon failed" },
	{ ERROR_SERVICE_START_HANG, "Service start hang" },
	{ ERROR_INVALID_SERVICE_LOCK, "Invalid service lock" },
	{ ERROR_SERVICE_MARKED_FOR_DELETE, "Service marked for delete" },
	{ ERROR_SERVICE_EXISTS, "Service exists" },
	{ ERROR_ALREADY_RUNNING_LKG, "Already running lkg" },
	{ ERROR_SERVICE_DEPENDENCY_DELETED, "Service dependency deleted" },
	{ ERROR_BOOT_ALREADY_ACCEPTED, "Boot already accepted" },
	{ ERROR_SERVICE_NEVER_STARTED, "Service never started" },
	{ ERROR_DUPLICATE_SERVICE_NAME, "Duplicate service name" },
	{ ERROR_DIFFERENT_SERVICE_ACCOUNT, "Different service account" },
	{ ERROR_CANNOT_DETECT_DRIVER_FAILURE, "Cannot detect driver failure" },
	{ ERROR_CANNOT_DETECT_PROCESS_ABORT, "Cannot detect process abort" },
	{ ERROR_NO_RECOVERY_PROGRAM, "No recovery program" },
	{ ERROR_SERVICE_NOT_IN_EXE, "Service not in exe" },
	{ ERROR_NOT_SAFEBOOT_SERVICE, "Not safeboot service" },
	{ ERROR_END_OF_MEDIA, "End of media" },
	{ ERROR_FILEMARK_DETECTED, "Filemark detected" },
	{ ERROR_BEGINNING_OF_MEDIA, "Beginning of media" },
	{ ERROR_SETMARK_DETECTED, "Setmark detected" },
	{ ERROR_NO_DATA_DETECTED, "No data detected" },
	{ ERROR_PARTITION_FAILURE, "Partition failure" },
	{ ERROR_INVALID_BLOCK_LENGTH, "Invalid block length" },
	{ ERROR_DEVICE_NOT_PARTITIONED, "Device not partitioned" },
	{ ERROR_UNABLE_TO_LOCK_MEDIA, "Unable to lock media" },
	{ ERROR_UNABLE_TO_UNLOAD_MEDIA, "Unable to unload media" },
	{ ERROR_MEDIA_CHANGED, "Media changed" },
	{ ERROR_BUS_RESET, "Bus reset" },
	{ ERROR_NO_MEDIA_IN_DRIVE, "No media in drive" },
	{ ERROR_NO_UNICODE_TRANSLATION, "No unicode translation" },
	{ ERROR_DLL_INIT_FAILED, "DLL init failed" },
	{ ERROR_SHUTDOWN_IN_PROGRESS, "Shutdown in progress" },
	{ ERROR_NO_SHUTDOWN_IN_PROGRESS, "No shutdown in progress" },
	{ ERROR_IO_DEVICE, "IO device" },
	{ ERROR_SERIAL_NO_DEVICE, "Serial IO device" },
	{ ERROR_IRQ_BUSY, "IRQ busy" },
	{ ERROR_MORE_WRITES, "More writes" },
	{ ERROR_COUNTER_TIMEOUT, "Counter timeout" },
	{ ERROR_FLOPPY_ID_MARK_NOT_FOUND, "Floppy ID mark not found" },
	{ ERROR_FLOPPY_WRONG_CYLINDER, "Floppy wrong cylinder" },
	{ ERROR_FLOPPY_UNKNOWN_ERROR, "Floppy unknown error" },
	{ ERROR_FLOPPY_BAD_REGISTERS, "Floppy bad registers" },
	{ ERROR_DISK_RECALIBRATE_FAILED, "Disk recalibrate failed" },
	{ ERROR_DISK_OPERATION_FAILED, "Disk operation failed" },
	{ ERROR_DISK_RESET_FAILED, "Disk reset failed" },
	{ ERROR_EOM_OVERFLOW, "EOM overflow" },
	{ ERROR_NOT_ENOUGH_SERVER_MEMORY, "Not enough server memory" },
	{ ERROR_POSSIBLE_DEADLOCK, "Possible deadlock" },
	{ ERROR_MAPPED_ALIGNMENT, "Mapped alignment" },
	{ ERROR_SET_POWER_STATE_VETOED, "Set power state vetoed" },
	{ ERROR_SET_POWER_STATE_FAILED, "Set power state failed" },
	{ ERROR_TOO_MANY_LINKS, "Too many links" },
	{ ERROR_OLD_WIN_VERSION, "Old win version" },
	{ ERROR_APP_WRONG_OS, "App wrong OS" },
	{ ERROR_SINGLE_INSTANCE_APP, "Single instance app" },
	{ ERROR_RMODE_APP, "Rmode app" },
	{ ERROR_INVALID_DLL, "Invalid DLL" },
	{ ERROR_NO_ASSOCIATION, "No association" },
	{ ERROR_DDE_FAIL, "DDE fail" },
	{ ERROR_DLL_NOT_FOUND, "DLL not found" },
	{ ERROR_NO_MORE_USER_HANDLES, "No more user handles" },
	{ ERROR_MESSAGE_SYNC_ONLY, "Message sync only" },
	{ ERROR_SOURCE_ELEMENT_EMPTY, "Source element empty" },
	{ ERROR_DESTINATION_ELEMENT_FULL, "Destination element full" },
	{ ERROR_ILLEGAL_ELEMENT_ADDRESS, "Illegal element address" },
	{ ERROR_MAGAZINE_NOT_PRESENT, "Magazine not present" },
	{ ERROR_DEVICE_REINITIALIZATION_NEEDED, "Device reinitialization needed" },
	{ ERROR_DEVICE_REQUIRES_CLEANING, "Device requires cleaning" },
	{ ERROR_DEVICE_DOOR_OPEN, "Device door open" },
	{ ERROR_DEVICE_NOT_CONNECTED, "Device not connected" },
	{ ERROR_NOT_FOUND, "Not found" },
	{ ERROR_NO_MATCH, "No match" },
	{ ERROR_SET_NOT_FOUND, "Set not found" },
	{ ERROR_POINT_NOT_FOUND, "Point not found" },
	{ ERROR_NO_TRACKING_SERVICE, "No tracking service" },
	{ ERROR_NO_VOLUME_ID, "No volume ID" },
	{ ERROR_UNABLE_TO_REMOVE_REPLACED, "Unable to remove replaced" },
	{ ERROR_UNABLE_TO_MOVE_REPLACEMENT, "Unable to move replacement" },
	{ ERROR_UNABLE_TO_MOVE_REPLACEMENT_2, "Unable to move replacement 2" },
	{ ERROR_JOURNAL_DELETE_IN_PROGRESS, "Journal delete in progress" },
	{ ERROR_JOURNAL_NOT_ACTIVE, "Journal not active" },
	{ ERROR_POTENTIAL_FILE_FOUND, "Potential file found" },
	{ ERROR_JOURNAL_ENTRY_DELETED, "Journal entry deleted" },
	{ ERROR_BAD_DEVICE, "Bad device" },
	{ ERROR_CONNECTION_UNAVAIL, "Connection unavail" },
	{ ERROR_DEVICE_ALREADY_REMEMBERED, "Device already remembered" },
	{ ERROR_NO_NET_OR_BAD_PATH, "No net or bad path" },
	{ ERROR_BAD_PROVIDER, "Bad provider" },
	{ ERROR_CANNOT_OPEN_PROFILE, "Cannot open profile" },
	{ ERROR_BAD_PROFILE, "Bad profile" },
	{ ERROR_NOT_CONTAINER, "Not container" },
	{ ERROR_EXTENDED_ERROR, "Extended error" },
	{ ERROR_INVALID_GROUPNAME, "Invalid group name" },
	{ ERROR_INVALID_COMPUTERNAME, "Invalid computer name" },
	{ ERROR_INVALID_EVENTNAME, "Invalid event name" },
	{ ERROR_INVALID_DOMAINNAME, "Invalid domain name" },
	{ ERROR_INVALID_SERVICENAME, "Invalid service name" },
	{ ERROR_INVALID_NETNAME, "Invalid net name" },
	{ ERROR_INVALID_SHARENAME, "Invalid share name" },
	{ ERROR_INVALID_PASSWORDNAME, "Invalid password name" },
	{ ERROR_INVALID_MESSAGENAME, "Invalid message name" },
	{ ERROR_INVALID_MESSAGEDEST, "Invalid message dest" },
	{ ERROR_SESSION_CREDENTIAL_CONFLICT, "Session credential conflict" },
	{ ERROR_REMOTE_SESSION_LIMIT_EXCEEDED, "Remote session limit exceeded" },
	{ ERROR_DUP_DOMAINNAME, "Dup domain name" },
	{ ERROR_NO_NETWORK, "No network" },
	{ ERROR_CANCELLED, "Cancelled" },
	{ ERROR_USER_MAPPED_FILE, "User mapped file" },
	{ ERROR_CONNECTION_REFUSED, "Connection refused" },
	{ ERROR_GRACEFUL_DISCONNECT, "Graceful disconnect" },
	{ ERROR_ADDRESS_ALREADY_ASSOCIATED, "Address already associated" },
	{ ERROR_ADDRESS_NOT_ASSOCIATED, "Address not associated" },
	{ ERROR_CONNECTION_INVALID, "Connected invalid" },
	{ ERROR_CONNECTION_ACTIVE, "Connection active" },
	{ ERROR_NETWORK_UNREACHABLE, "Network unreachable" },
	{ ERROR_HOST_UNREACHABLE, "Host unreachable" },
	{ ERROR_PROTOCOL_UNREACHABLE, "Protocol unreachable" },
	{ ERROR_PORT_UNREACHABLE, "Port unreachable" },
	{ ERROR_REQUEST_ABORTED, "Request aborted" },
	{ ERROR_CONNECTION_ABORTED, "Connection aborted" },
	{ ERROR_RETRY, "Retry" },
	{ ERROR_CONNECTION_COUNT_LIMIT, "Connection count limit" },
	{ ERROR_LOGIN_TIME_RESTRICTION, "Login time restriction" },
	{ ERROR_LOGIN_WKSTA_RESTRICTION, "Login wksta restriction" },
	{ ERROR_INCORRECT_ADDRESS, "Incorrect address" },
	{ ERROR_ALREADY_REGISTERED, "Already registered" },
	{ ERROR_SERVICE_NOT_FOUND, "Service not found" },
	{ ERROR_NOT_AUTHENTICATED, "Not authenticated" },
	{ ERROR_NOT_LOGGED_ON, "Not logged on" },
	{ ERROR_CONTINUE, "Continue" },
	{ ERROR_ALREADY_INITIALIZED, "Already initialised" },
	{ ERROR_NO_MORE_DEVICES, "No more devices" },
	{ ERROR_NO_SUCH_SITE, "No such site" },
	{ ERROR_DOMAIN_CONTROLLER_EXISTS, "Domain controller exists" },
	{ ERROR_ONLY_IF_CONNECTED, "Only if connected" },
	{ ERROR_OVERRIDE_NOCHANGES, "Override no changes" },
	{ ERROR_BAD_USER_PROFILE, "Bad user profile" },
	{ ERROR_NOT_SUPPORTED_ON_SBS, "Not supported on SBS" },
	{ ERROR_SERVER_SHUTDOWN_IN_PROGRESS, "Server shutdown in progress" },
	{ ERROR_HOST_DOWN, "Host down" },
	{ ERROR_NON_ACCOUNT_SID, "Non account sid" },
	{ ERROR_NON_DOMAIN_SID, "Non domain sid" },
	{ ERROR_APPHELP_BLOCK, "Apphelp block" },
	{ ERROR_ACCESS_DISABLED_BY_POLICY, "Access disabled by policy" },
	{ ERROR_REG_NAT_CONSUMPTION, "Reg nat consumption" },
	{ ERROR_CSCSHARE_OFFLINE, "CSC share offline" },
	{ ERROR_PKINIT_FAILURE, "PK init failure" },
	{ ERROR_SMARTCARD_SUBSYSTEM_FAILURE, "Smartcard subsystem failure" },
	{ ERROR_DOWNGRADE_DETECTED, "Downgrade detected" },
	{ SEC_E_SMARTCARD_CERT_REVOKED, "Smartcard cert revoked" },
	{ SEC_E_ISSUING_CA_UNTRUSTED, "Issuing CA untrusted" },
	{ SEC_E_REVOCATION_OFFLINE_C, "Revocation offline" },
	{ SEC_E_PKINIT_CLIENT_FAILUR, "PK init client failure" },
	{ SEC_E_SMARTCARD_CERT_EXPIRED, "Smartcard cert expired" },
	{ ERROR_MACHINE_LOCKED, "Machine locked" },
	{ ERROR_CALLBACK_SUPPLIED_INVALID_DATA, "Callback supplied invalid data" },
	{ ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED, "Sync foreground refresh required" },
	{ ERROR_DRIVER_BLOCKED, "Driver blocked" },
	{ ERROR_INVALID_IMPORT_OF_NON_DLL, "Invalid import of non DLL" },
	{ ERROR_NOT_ALL_ASSIGNED, "Not all assigned" },
	{ ERROR_SOME_NOT_MAPPED, "Some not mapped" },
	{ ERROR_NO_QUOTAS_FOR_ACCOUNT, "No quotas for account" },
	{ ERROR_LOCAL_USER_SESSION_KEY, "Local user session key" },
	{ ERROR_NULL_LM_PASSWORD, "Null LM password" },
	{ ERROR_UNKNOWN_REVISION, "Unknown revision" },
	{ ERROR_REVISION_MISMATCH, "Revision mismatch" },
	{ ERROR_INVALID_OWNER, "Invalid owner" },
	{ ERROR_INVALID_PRIMARY_GROUP, "Invalid primary group" },
	{ ERROR_NO_IMPERSONATION_TOKEN, "No impersonation token" },
	{ ERROR_CANT_DISABLE_MANDATORY, "Can't disable mandatory" },
	{ ERROR_NO_LOGON_SERVERS, "No logon servers" },
	{ ERROR_NO_SUCH_LOGON_SESSION, "No such logon session" },
	{ ERROR_NO_SUCH_PRIVILEGE, "No such privilege" },
	{ ERROR_PRIVILEGE_NOT_HELD, "Privilege not held" },
	{ ERROR_INVALID_ACCOUNT_NAME, "Invalid account name" },
	{ ERROR_USER_EXISTS, "User exists" },
	{ ERROR_NO_SUCH_USER, "No such user" },
	{ ERROR_GROUP_EXISTS, "Group exists" },
	{ ERROR_NO_SUCH_GROUP, "No such group" },
	{ ERROR_MEMBER_IN_GROUP, "Member in group" },
	{ ERROR_MEMBER_NOT_IN_GROUP, "Member not in group" },
	{ ERROR_LAST_ADMIN, "Last admin" },
	{ ERROR_WRONG_PASSWORD, "Wrong password" },
	{ ERROR_ILL_FORMED_PASSWORD, "Ill formed password" },
	{ ERROR_PASSWORD_RESTRICTION, "Password restriction" },
	{ ERROR_LOGON_FAILURE, "Logon failure" },
	{ ERROR_ACCOUNT_RESTRICTION, "Account restriction" },
	{ ERROR_INVALID_LOGON_HOURS, "Invalid logon hours" },
	{ ERROR_INVALID_WORKSTATION, "Invalid workstation" },
	{ ERROR_PASSWORD_EXPIRED, "Password expired" },
	{ ERROR_ACCOUNT_DISABLED, "Account disabled" },
	{ ERROR_NONE_MAPPED, "None mapped" },
	{ ERROR_TOO_MANY_LUIDS_REQUESTED, "Too many LUIDs requested" },
	{ ERROR_LUIDS_EXHAUSTED, "LUIDs exhausted" },
	{ ERROR_INVALID_SUB_AUTHORITY, "Invalid sub authority" },
	{ ERROR_INVALID_ACL, "Invalid ACL" },
	{ ERROR_INVALID_SID, "Invalid SID" },
	{ ERROR_INVALID_SECURITY_DESCR, "Invalid security descr" },
	{ ERROR_BAD_INHERITANCE_ACL, "Bad inheritance ACL" },
	{ ERROR_SERVER_DISABLED, "Server disabled" },
	{ ERROR_SERVER_NOT_DISABLED, "Server not disabled" },
	{ ERROR_INVALID_ID_AUTHORITY, "Invalid ID authority" },
	{ ERROR_ALLOTTED_SPACE_EXCEEDED, "Allotted space exceeded" },
	{ ERROR_INVALID_GROUP_ATTRIBUTES, "Invalid group attributes" },
	{ ERROR_BAD_IMPERSONATION_LEVEL, "Bad impersonation level" },
	{ ERROR_CANT_OPEN_ANONYMOUS, "Can't open anonymous" },
	{ ERROR_BAD_VALIDATION_CLASS, "Bad validation class" },
	{ ERROR_BAD_TOKEN_TYPE, "Bad token type" },
	{ ERROR_NO_SECURITY_ON_OBJECT, "No security on object" },
	{ ERROR_CANT_ACCESS_DOMAIN_INFO, "Can't access domain info" },
	{ ERROR_INVALID_SERVER_STATE, "Invalid server state" },
	{ ERROR_INVALID_DOMAIN_STATE, "Invalid domain state" },
	{ ERROR_INVALID_DOMAIN_ROLE, "Invalid domain role" },
	{ ERROR_NO_SUCH_DOMAIN, "No such domain" },
	{ ERROR_DOMAIN_EXISTS, "Domain exists" },
	{ ERROR_DOMAIN_LIMIT_EXCEEDED, "Domain limit exceeded" },
	{ ERROR_INTERNAL_DB_CORRUPTION, "Internal DB corruption" },
	{ ERROR_INTERNAL_ERROR, "Internal error" },
	{ ERROR_GENERIC_NOT_MAPPED, "Generic not mapped" },
	{ ERROR_BAD_DESCRIPTOR_FORMAT, "Bad descriptor format" },
	{ ERROR_NOT_LOGON_PROCESS, "Not logon process" },
	{ ERROR_LOGON_SESSION_EXISTS, "Logon session exists" },
	{ ERROR_NO_SUCH_PACKAGE, "No such package" },
	{ ERROR_BAD_LOGON_SESSION_STATE, "Bad logon session state" },
	{ ERROR_LOGON_SESSION_COLLISION, "Logon session collision" },
	{ ERROR_INVALID_LOGON_TYPE, "Invalid logon type" },
	{ ERROR_CANNOT_IMPERSONATE, "Cannot impersonate" },
	{ ERROR_RXACT_INVALID_STATE, "Rxact invalid state" },
	{ ERROR_RXACT_COMMIT_FAILURE, "Rxact commit failure" },
	{ ERROR_SPECIAL_ACCOUNT, "Special account" },
	{ ERROR_SPECIAL_GROUP, "Special group" },
	{ ERROR_SPECIAL_USER, "Special user" },
	{ ERROR_MEMBERS_PRIMARY_GROUP, "Members primary group" },
	{ ERROR_TOKEN_ALREADY_IN_USE, "Token already in use" },
	{ ERROR_NO_SUCH_ALIAS, "No such alias" },
	{ ERROR_MEMBER_NOT_IN_ALIAS, "Member not in alias" },
	{ ERROR_MEMBER_IN_ALIAS, "Member in alias" },
	{ ERROR_ALIAS_EXISTS, "Alias exists" },
	{ ERROR_LOGON_NOT_GRANTED, "Logon not granted" },
	{ ERROR_TOO_MANY_SECRETS, "Too many secrets" },
	{ ERROR_SECRET_TOO_LONG, "Secret too long" },
	{ ERROR_INTERNAL_DB_ERROR, "Internal DB error" },
	{ ERROR_TOO_MANY_CONTEXT_IDS, "Too many context IDs" },
	{ ERROR_LOGON_TYPE_NOT_GRANTED, "Logon type not granted" },
	{ ERROR_NT_CROSS_ENCRYPTION_REQUIRED, "NT cross encryption required" },
	{ ERROR_NO_SUCH_MEMBER, "No such member" },
	{ ERROR_INVALID_MEMBER, "Invalid member" },
	{ ERROR_TOO_MANY_SIDS, "Too many SIDs" },
	{ ERROR_LM_CROSS_ENCRYPTION_REQUIRED, "LM cross encryption required" },
	{ ERROR_NO_INHERITANCE, "No inheritance" },
	{ ERROR_FILE_CORRUPT, "File corrupt" },
	{ ERROR_DISK_CORRUPT, "Disk corrupt" },
	{ ERROR_NO_USER_SESSION_KEY, "No user session key" },
	{ ERROR_LICENSE_QUOTA_EXCEEDED, "Licence quota exceeded" },
	{ ERROR_WRONG_TARGET_NAME, "Wrong target name" },
	{ ERROR_MUTUAL_AUTH_FAILED, "Mutual auth failed" },
	{ ERROR_TIME_SKEW, "Time skew" },
	{ ERROR_CURRENT_DOMAIN_NOT_ALLOWED, "Current domain not allowed" },
	{ ERROR_INVALID_WINDOW_HANDLE, "Invalid window handle" },
	{ ERROR_INVALID_MENU_HANDLE, "Invalid menu handle" },
	{ ERROR_INVALID_CURSOR_HANDLE, "Invalid cursor handle" },
	{ ERROR_INVALID_ACCEL_HANDLE, "Invalid accel handle" },
	{ ERROR_INVALID_HOOK_HANDLE, "Invalid hook handle" },
	{ ERROR_INVALID_DWP_HANDLE, "Invalid DWP handle" },
	{ ERROR_TLW_WITH_WSCHILD, "TLW with wschild" },
	{ ERROR_CANNOT_FIND_WND_CLASS, "Cannot find WND class" },
	{ ERROR_WINDOW_OF_OTHER_THREAD, "Window of other thread" },
	{ ERROR_HOTKEY_ALREADY_REGISTERED, "Hotkey already registered" },
	{ ERROR_CLASS_ALREADY_EXISTS, "Class already exists" },
	{ ERROR_CLASS_DOES_NOT_EXIST, "Class does not exist" },
	{ ERROR_CLASS_HAS_WINDOWS, "Class has windows" },
	{ ERROR_INVALID_INDEX, "Invalid index" },
	{ ERROR_INVALID_ICON_HANDLE, "Invalid icon handle" },
	{ ERROR_PRIVATE_DIALOG_INDEX, "Private dialog index" },
	{ ERROR_LISTBOX_ID_NOT_FOUND, "Listbox ID not found" },
	{ ERROR_NO_WILDCARD_CHARACTERS, "No wildcard characters" },
	{ ERROR_CLIPBOARD_NOT_OPEN, "Clipboard not open" },
	{ ERROR_HOTKEY_NOT_REGISTERED, "Hotkey not registered" },
	{ ERROR_WINDOW_NOT_DIALOG, "Window not dialog" },
	{ ERROR_CONTROL_ID_NOT_FOUND, "Control ID not found" },
	{ ERROR_INVALID_COMBOBOX_MESSAGE, "Invalid combobox message" },
	{ ERROR_WINDOW_NOT_COMBOBOX, "Window not combobox" },
	{ ERROR_INVALID_EDIT_HEIGHT, "Invalid edit height" },
	{ ERROR_DC_NOT_FOUND, "DC not found" },
	{ ERROR_INVALID_HOOK_FILTER, "Invalid hook filter" },
	{ ERROR_INVALID_FILTER_PROC, "Invalid filter proc" },
	{ ERROR_HOOK_NEEDS_HMOD, "Hook needs HMOD" },
	{ ERROR_GLOBAL_ONLY_HOOK, "Global only hook" },
	{ ERROR_JOURNAL_HOOK_SET, "Journal hook set" },
	{ ERROR_HOOK_NOT_INSTALLED, "Hook not installed" },
	{ ERROR_INVALID_LB_MESSAGE, "Invalid LB message" },
	{ ERROR_SETCOUNT_ON_BAD_LB, "Setcount on bad LB" },
	{ ERROR_LB_WITHOUT_TABSTOPS, "LB without tabstops" },
	{ ERROR_DESTROY_OBJECT_OF_OTHER_THREAD, "Destroy object of other thread" },
	{ ERROR_CHILD_WINDOW_MENU, "Child window menu" },
	{ ERROR_NO_SYSTEM_MENU, "No system menu" },
	{ ERROR_INVALID_MSGBOX_STYLE, "Invalid msgbox style" },
	{ ERROR_INVALID_SPI_VALUE, "Invalid SPI value" },
	{ ERROR_SCREEN_ALREADY_LOCKED, "Screen already locked" },
	{ ERROR_HWNDS_HAVE_DIFF_PARENT, "HWNDs have different parent" },
	{ ERROR_NOT_CHILD_WINDOW, "Not child window" },
	{ ERROR_INVALID_GW_COMMAND, "Invalid GW command" },
	{ ERROR_INVALID_THREAD_ID, "Invalid thread ID" },
	{ ERROR_NON_MDICHILD_WINDOW, "Non MDI child window" },
	{ ERROR_POPUP_ALREADY_ACTIVE, "Popup already active" },
	{ ERROR_NO_SCROLLBARS, "No scrollbars" },
	{ ERROR_INVALID_SCROLLBAR_RANGE, "Invalid scrollbar range" },
	{ ERROR_INVALID_SHOWWIN_COMMAND, "Invalid showwin command" },
	{ ERROR_NO_SYSTEM_RESOURCES, "No system resources" },
	{ ERROR_NONPAGED_SYSTEM_RESOURCES, "Nonpaged system resources" },
	{ ERROR_PAGED_SYSTEM_RESOURCES, "Paged system resources" },
	{ ERROR_WORKING_SET_QUOTA, "Working set quota" },
	{ ERROR_PAGEFILE_QUOTA, "Pagefile quota" },
	{ ERROR_COMMITMENT_LIMIT, "Commitment limit" },
	{ ERROR_MENU_ITEM_NOT_FOUND, "Menu item not found" },
	{ ERROR_INVALID_KEYBOARD_HANDLE, "Invalid keyboard handle" },
	{ ERROR_HOOK_TYPE_NOT_ALLOWED, "Hook type not allowed" },
	{ ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION, "Requires interactive windowstation" },
	{ ERROR_TIMEOUT, "Timeout" },
	{ ERROR_INVALID_MONITOR_HANDLE, "Invalid monitor handle" },
	{ ERROR_EVENTLOG_FILE_CORRUPT, "Eventlog file corrupt" },
	{ ERROR_EVENTLOG_CANT_START, "Eventlog can't start" },
	{ ERROR_LOG_FILE_FULL, "Log file full" },
	{ ERROR_EVENTLOG_FILE_CHANGED, "Eventlog file changed" },
	{ ERROR_INSTALL_SERVICE_FAILURE, "Install service failure" },
	{ ERROR_INSTALL_USEREXIT, "Install userexit" },
	{ ERROR_INSTALL_FAILURE, "Install failure" },
	{ ERROR_INSTALL_SUSPEND, "Install suspend" },
	{ ERROR_UNKNOWN_PRODUCT, "Unknown product" },
	{ ERROR_UNKNOWN_FEATURE, "Unknown feature" },
	{ ERROR_UNKNOWN_COMPONENT, "Unknown component" },
	{ ERROR_UNKNOWN_PROPERTY, "Unknown property" },
	{ ERROR_INVALID_HANDLE_STATE, "Invalid handle state" },
	{ ERROR_BAD_CONFIGURATION, "Bad configuration" },
	{ ERROR_INDEX_ABSENT, "Index absent" },
	{ ERROR_INSTALL_SOURCE_ABSENT, "Install source absent" },
	{ ERROR_INSTALL_PACKAGE_VERSION, "Install package version" },
	{ ERROR_PRODUCT_UNINSTALLED, "Product uninstalled" },
	{ ERROR_BAD_QUERY_SYNTAX, "Bad query syntax" },
	{ ERROR_INVALID_FIELD, "Invalid field" },
	{ ERROR_DEVICE_REMOVED, "Device removed" },
	{ ERROR_INSTALL_ALREADY_RUNNING, "Install already running" },
	{ ERROR_INSTALL_PACKAGE_OPEN_FAILED, "Install package open failed" },
	{ ERROR_INSTALL_PACKAGE_INVALID, "Install package invalid" },
	{ ERROR_INSTALL_UI_FAILURE, "Install UI failure" },
	{ ERROR_INSTALL_LOG_FAILURE, "Install log failure" },
	{ ERROR_INSTALL_LANGUAGE_UNSUPPORTED, "Install language unsupported" },
	{ ERROR_INSTALL_TRANSFORM_FAILURE, "Install transform failure" },
	{ ERROR_INSTALL_PACKAGE_REJECTED, "Install package rejected" },
	{ ERROR_FUNCTION_NOT_CALLED, "Function not called" },
	{ ERROR_FUNCTION_FAILED, "Function failed" },
	{ ERROR_INVALID_TABLE, "Invalid table" },
	{ ERROR_DATATYPE_MISMATCH, "Datatype mismatch" },
	{ ERROR_UNSUPPORTED_TYPE, "Unsupported type" },
	{ ERROR_CREATE_FAILED, "Create failed" },
	{ ERROR_INSTALL_TEMP_UNWRITABLE, "Install temp unwritable" },
	{ ERROR_INSTALL_PLATFORM_UNSUPPORTED, "Install platform unsupported" },
	{ ERROR_INSTALL_NOTUSED, "Install notused" },
	{ ERROR_PATCH_PACKAGE_OPEN_FAILED, "Patch package open failed" },
	{ ERROR_PATCH_PACKAGE_INVALID, "Patch package invalid" },
	{ ERROR_PATCH_PACKAGE_UNSUPPORTED, "Patch package unsupported" },
	{ ERROR_PRODUCT_VERSION, "Product version" },
	{ ERROR_INVALID_COMMAND_LINE, "Invalid command line" },
	{ ERROR_INSTALL_REMOTE_DISALLOWED, "Install remote disallowed" },
	{ ERROR_SUCCESS_REBOOT_INITIATED, "Success reboot initiated" },
	{ ERROR_PATCH_TARGET_NOT_FOUND, "Patch target not found" },
	{ ERROR_PATCH_PACKAGE_REJECTED, "Patch package rejected" },
	{ ERROR_INSTALL_TRANSFORM_REJECTED, "Install transform rejected" },
	{ RPC_S_INVALID_STRING_BINDING, "RPC S Invalid string binding" },
	{ RPC_S_WRONG_KIND_OF_BINDING, "RPC S Wrong kind of binding" },
	{ RPC_S_INVALID_BINDING, "RPC S Invalid binding" },
	{ RPC_S_PROTSEQ_NOT_SUPPORTED, "RPC S Protseq not supported" },
	{ RPC_S_INVALID_RPC_PROTSEQ, "RPC S Invalid RPC protseq" },
	{ RPC_S_INVALID_STRING_UUID, "RPC S Invalid string UUID" },
	{ RPC_S_INVALID_ENDPOINT_FORMAT, "RPC S Invalid endpoint format" },
	{ RPC_S_INVALID_NET_ADDR, "RPC S Invalid net addr" },
	{ RPC_S_NO_ENDPOINT_FOUND, "RPC S No endpoint found" },
	{ RPC_S_INVALID_TIMEOUT, "RPC S Invalid timeout" },
	{ RPC_S_OBJECT_NOT_FOUND, "RPC S Object not found" },
	{ RPC_S_ALREADY_REGISTERED, "RPC S Already registered" },
	{ RPC_S_TYPE_ALREADY_REGISTERED, "RPC S Type already registered" },
	{ RPC_S_ALREADY_LISTENING, "RPC S Already listening" },
	{ RPC_S_NO_PROTSEQS_REGISTERED, "RPC S Not protseqs registered" },
	{ RPC_S_NOT_LISTENING, "RPC S Not listening" },
	{ RPC_S_UNKNOWN_MGR_TYPE, "RPC S Unknown mgr type" },
	{ RPC_S_UNKNOWN_IF, "RPC S Unknown IF" },
	{ RPC_S_NO_BINDINGS, "RPC S No bindings" },
	{ RPC_S_NO_PROTSEQS, "RPC S Not protseqs" },
	{ RPC_S_CANT_CREATE_ENDPOINT, "RPC S Can't create endpoint" },
	{ RPC_S_OUT_OF_RESOURCES, "RPC S Out of resources" },
	{ RPC_S_SERVER_UNAVAILABLE, "RPC S Server unavailable" },
	{ RPC_S_SERVER_TOO_BUSY, "RPC S Server too busy" },
	{ RPC_S_INVALID_NETWORK_OPTIONS, "RPC S Invalid network options" },
	{ RPC_S_NO_CALL_ACTIVE, "RPC S No call active" },
	{ RPC_S_CALL_FAILED, "RPC S Call failed" },
	{ RPC_S_CALL_FAILED_DNE, "RPC S Call failed DNE" },
	{ RPC_S_PROTOCOL_ERROR, "RPC S Protocol error" },
	{ RPC_S_UNSUPPORTED_TRANS_SYN, "RPC S Unsupported trans syn" },
	{ RPC_S_UNSUPPORTED_TYPE, "RPC S Unsupported type" },
	{ RPC_S_INVALID_TAG, "RPC S Invalid tag" },
	{ RPC_S_INVALID_BOUND, "RPC S Invalid bound" },
	{ RPC_S_NO_ENTRY_NAME, "RPC S No entry name" },
	{ RPC_S_INVALID_NAME_SYNTAX, "RPC S Invalid name syntax" },
	{ RPC_S_UNSUPPORTED_NAME_SYNTAX, "RPC S Unsupported name syntax" },
	{ RPC_S_UUID_NO_ADDRESS, "RPC S UUID no address" },
	{ RPC_S_DUPLICATE_ENDPOINT, "RPC S Duplicate endpoint" },
	{ RPC_S_UNKNOWN_AUTHN_TYPE, "RPC S Unknown authn type" },
	{ RPC_S_MAX_CALLS_TOO_SMALL, "RPC S Max calls too small" },
	{ RPC_S_STRING_TOO_LONG, "RPC S String too long" },
	{ RPC_S_PROTSEQ_NOT_FOUND, "RPC S Protseq not found" },
	{ RPC_S_PROCNUM_OUT_OF_RANGE, "RPC S Procnum out of range" },
	{ RPC_S_BINDING_HAS_NO_AUTH, "RPC S Binding has no auth" },
	{ RPC_S_UNKNOWN_AUTHN_SERVICE, "RPC S Unknown authn service" },
	{ RPC_S_UNKNOWN_AUTHN_LEVEL, "RPC S Unknown authn level" },
	{ RPC_S_INVALID_AUTH_IDENTITY, "RPC S Invalid auth identity" },
	{ RPC_S_UNKNOWN_AUTHZ_SERVICE, "RPC S Unknown authz service" },
	{ EPT_S_INVALID_ENTRY, "EPT S Invalid entry" },
	{ EPT_S_CANT_PERFORM_OP, "EPT S Can't perform op" },
	{ EPT_S_NOT_REGISTERED, "EPT S Not registered" },
	{ RPC_S_NOTHING_TO_EXPORT, "RPC S Nothing to export" },
	{ RPC_S_INCOMPLETE_NAME, "RPC S Incomplete name" },
	{ RPC_S_INVALID_VERS_OPTION, "RPC S Invalid vers option" },
	{ RPC_S_NO_MORE_MEMBERS, "RPC S No more members" },
	{ RPC_S_NOT_ALL_OBJS_UNEXPORTED, "RPC S Not all objs unexported" },
	{ RPC_S_INTERFACE_NOT_FOUND, "RPC S Interface not found" },
	{ RPC_S_ENTRY_ALREADY_EXISTS, "RPC S Entry already exists" },
	{ RPC_S_ENTRY_NOT_FOUND, "RPC S Entry not found" },
	{ RPC_S_NAME_SERVICE_UNAVAILABLE, "RPC S Name service unavailable" },
	{ RPC_S_INVALID_NAF_ID, "RPC S Invalid naf ID" },
	{ RPC_S_CANNOT_SUPPORT, "RPC S Cannot support" },
	{ RPC_S_NO_CONTEXT_AVAILABLE, "RPC S No context available" },
	{ RPC_S_INTERNAL_ERROR, "RPC S Internal error" },
	{ RPC_S_ZERO_DIVIDE, "RPC S Zero divide" },
	{ RPC_S_ADDRESS_ERROR, "RPC S Address error" },
	{ RPC_S_FP_DIV_ZERO, "RPC S FP div zero" },
	{ RPC_S_FP_UNDERFLOW, "RPC S FP Underflow" },
	{ RPC_S_FP_OVERFLOW, "RPC S Overflow" },
	{ RPC_X_NO_MORE_ENTRIES, "RPC X No more entries" },
	{ RPC_X_SS_CHAR_TRANS_OPEN_FAIL, "RPC X SS char trans open fail" },
	{ RPC_X_SS_CHAR_TRANS_SHORT_FILE, "RPC X SS char trans short file" },
	{ RPC_X_SS_IN_NULL_CONTEXT, "RPC S SS in null context" },
	{ RPC_X_SS_CONTEXT_DAMAGED, "RPC X SS context damaged" },
	{ RPC_X_SS_HANDLES_MISMATCH, "RPC X SS handles mismatch" },
	{ RPC_X_SS_CANNOT_GET_CALL_HANDLE, "RPC X SS cannot get call handle" },
	{ RPC_X_NULL_REF_POINTER, "RPC X Null ref pointer" },
	{ RPC_X_ENUM_VALUE_OUT_OF_RANGE, "RPC X enum value out of range" },
	{ RPC_X_BYTE_COUNT_TOO_SMALL, "RPC X byte count too small" },
	{ RPC_X_BAD_STUB_DATA, "RPC X bad stub data" },
	{ ERROR_INVALID_USER_BUFFER, "Invalid user buffer" },
	{ ERROR_UNRECOGNIZED_MEDIA, "Unrecognised media" },
	{ ERROR_NO_TRUST_LSA_SECRET, "No trust lsa secret" },
	{ ERROR_NO_TRUST_SAM_ACCOUNT, "No trust sam account" },
	{ ERROR_TRUSTED_DOMAIN_FAILURE, "Trusted domain failure" },
	{ ERROR_TRUSTED_RELATIONSHIP_FAILURE, "Trusted relationship failure" },
	{ ERROR_TRUST_FAILURE, "Trust failure" },
	{ RPC_S_CALL_IN_PROGRESS, "RPC S call in progress" },
	{ ERROR_NETLOGON_NOT_STARTED, "Error netlogon not started" },
	{ ERROR_ACCOUNT_EXPIRED, "Account expired" },
	{ ERROR_REDIRECTOR_HAS_OPEN_HANDLES, "Redirector has open handles" },
	{ ERROR_PRINTER_DRIVER_ALREADY_INSTALLED, "Printer driver already installed" },
	{ ERROR_UNKNOWN_PORT, "Unknown port" },
	{ ERROR_UNKNOWN_PRINTER_DRIVER, "Unknown printer driver" },
	{ ERROR_UNKNOWN_PRINTPROCESSOR, "Unknown printprocessor" },
	{ ERROR_INVALID_SEPARATOR_FILE, "Invalid separator file" },
	{ ERROR_INVALID_PRIORITY, "Invalid priority" },
	{ ERROR_INVALID_PRINTER_NAME, "Invalid printer name" },
	{ ERROR_PRINTER_ALREADY_EXISTS, "Printer already exists" },
	{ ERROR_INVALID_PRINTER_COMMAND, "Invalid printer command" },
	{ ERROR_INVALID_DATATYPE, "Invalid datatype" },
	{ ERROR_INVALID_ENVIRONMENT, "Invalid environment" },
	{ RPC_S_NO_MORE_BINDINGS, "RPC S no more bindings" },
	{ ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT, "Nologon interdomain trust account" },
	{ ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT, "Nologon workstation trust account" },
	{ ERROR_NOLOGON_SERVER_TRUST_ACCOUNT, "Nologon server trust account" },
	{ ERROR_DOMAIN_TRUST_INCONSISTENT, "Domain trust inconsistent" },
	{ ERROR_SERVER_HAS_OPEN_HANDLES, "Server has open handles" },
	{ ERROR_RESOURCE_DATA_NOT_FOUND, "Resource data not found" },
	{ ERROR_RESOURCE_TYPE_NOT_FOUND, "Resource type not found" },
	{ ERROR_RESOURCE_NAME_NOT_FOUND, "Resource name not found" },
	{ ERROR_RESOURCE_LANG_NOT_FOUND, "Resource lang not found" },
	{ ERROR_NOT_ENOUGH_QUOTA, "Not enough quota" },
	{ RPC_S_NO_INTERFACES, "RPC S no interfaces" },
	{ RPC_S_CALL_CANCELLED, "RPC S Call cancelled" },
	{ RPC_S_BINDING_INCOMPLETE, "RPC S Binding incomplete" },
	{ RPC_S_COMM_FAILURE, "RPC S Comm failure" },
	{ RPC_S_UNSUPPORTED_AUTHN_LEVEL, "RPC S Unsupported authn level" },
	{ RPC_S_NO_PRINC_NAME, "RPC S No princ name" },
	{ RPC_S_NOT_RPC_ERROR, "RPC S Not RPC error" },
	{ RPC_S_UUID_LOCAL_ONLY, "RPC U UUID local only" },
	{ RPC_S_SEC_PKG_ERROR, "RPC S Sec pkg error" },
	{ RPC_S_NOT_CANCELLED, "RPC S Not cancelled" },
	{ RPC_X_INVALID_ES_ACTION, "RPC X Invalid ES action" },
	{ RPC_X_WRONG_ES_VERSION, "RPC X Wrong ES version" },
	{ RPC_X_WRONG_STUB_VERSION, "RPC X Wrong stub version" },
	{ RPC_X_INVALID_PIPE_OBJECT, "RPC X Invalid pipe object" },
	{ RPC_X_WRONG_PIPE_ORDER, "RPC X Wrong pipe order" },
	{ RPC_X_WRONG_PIPE_VERSION, "RPC X Wrong pipe version" },
	{ RPC_S_GROUP_MEMBER_NOT_FOUND, "RPC S group member not found" },
	{ EPT_S_CANT_CREATE, "EPT S Can't create" },
	{ RPC_S_INVALID_OBJECT, "RPC S Invalid object" },
	{ ERROR_INVALID_TIME, "Invalid time" },
	{ ERROR_INVALID_FORM_NAME, "Invalid form name" },
	{ ERROR_INVALID_FORM_SIZE, "Invalid form size" },
	{ ERROR_ALREADY_WAITING, "Already waiting" },
	{ ERROR_PRINTER_DELETED, "Printer deleted" },
	{ ERROR_INVALID_PRINTER_STATE, "Invalid printer state" },
	{ ERROR_PASSWORD_MUST_CHANGE, "Password must change" },
	{ ERROR_DOMAIN_CONTROLLER_NOT_FOUND, "Domain controller not found" },
	{ ERROR_ACCOUNT_LOCKED_OUT, "Account locked out" },
	{ OR_INVALID_OXID, "OR Invalid OXID" },
	{ OR_INVALID_OID, "OR Invalid OID" },
	{ OR_INVALID_SET, "OR Invalid set" },
	{ RPC_S_SEND_INCOMPLETE, "RPC S Send incomplete" },
	{ RPC_S_INVALID_ASYNC_HANDLE, "RPC S Invalid async handle" },
	{ RPC_S_INVALID_ASYNC_CALL, "RPC S Invalid async call" },
	{ RPC_X_PIPE_CLOSED, "RPC X Pipe closed" },
	{ RPC_X_PIPE_DISCIPLINE_ERROR, "RPC X Pipe discipline error" },
	{ RPC_X_PIPE_EMPTY, "RPC X Pipe empty" },
	{ ERROR_NO_SITENAME, "No sitename" },
	{ ERROR_CANT_ACCESS_FILE, "Can't access file" },
	{ ERROR_CANT_RESOLVE_FILENAME, "Can't resolve filename" },
	{ RPC_S_ENTRY_TYPE_MISMATCH, "RPC S Entry type mismatch" },
	{ RPC_S_NOT_ALL_OBJS_EXPORTED, "RPC S Not all objs exported" },
	{ RPC_S_INTERFACE_NOT_EXPORTED, "RPC S Interface not exported" },
	{ RPC_S_PROFILE_NOT_ADDED, "RPC S Profile not added" },
	{ RPC_S_PRF_ELT_NOT_ADDED, "RPC S PRF ELT not added" },
	{ RPC_S_PRF_ELT_NOT_REMOVED, "RPC S PRF ELT not removed" },
	{ RPC_S_GRP_ELT_NOT_ADDED, "RPC S GRP ELT not added" },
	{ RPC_S_GRP_ELT_NOT_REMOVED, "RPC S GRP ELT not removed" },
	{ ERROR_KM_DRIVER_BLOCKED, "KM driver blocked" },
	{ ERROR_CONTEXT_EXPIRED, "Context expired" },
	{ ERROR_INVALID_PIXEL_FORMAT, "Invalid pixel format" },
	{ ERROR_BAD_DRIVER, "Bad driver" },
	{ ERROR_INVALID_WINDOW_STYLE, "Invalid window style" },
	{ ERROR_METAFILE_NOT_SUPPORTED, "Metafile not supported" },
	{ ERROR_TRANSFORM_NOT_SUPPORTED, "Transform not supported" },
	{ ERROR_CLIPPING_NOT_SUPPORTED, "Clipping not supported" },
	{ ERROR_INVALID_CMM, "Invalid CMM" },
	{ ERROR_INVALID_PROFILE, "Invalid profile" },
	{ ERROR_TAG_NOT_FOUND, "Tag not found" },
	{ ERROR_TAG_NOT_PRESENT, "Tag not present" },
	{ ERROR_DUPLICATE_TAG, "Duplicate tag" },
	{ ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE, "Profile not associated with device" },
	{ ERROR_PROFILE_NOT_FOUND, "Profile not found" },
	{ ERROR_INVALID_COLORSPACE, "Invalid colorspace" },
	{ ERROR_ICM_NOT_ENABLED, "ICM not enabled" },
	{ ERROR_DELETING_ICM_XFORM, "Deleting ICM xform" },
	{ ERROR_INVALID_TRANSFORM, "Invalid transform" },
	{ ERROR_COLORSPACE_MISMATCH, "Colorspace mismatch" },
	{ ERROR_INVALID_COLORINDEX, "Invalid colorindex" },
	{ ERROR_CONNECTED_OTHER_PASSWORD, "Connected other password" },
	{ ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT, "Connected other password default" },
	{ ERROR_BAD_USERNAME, "Bad username" },
	{ ERROR_NOT_CONNECTED, "Not connected" },
	{ ERROR_OPEN_FILES, "Open files" },
	{ ERROR_ACTIVE_CONNECTIONS, "Active connections" },
	{ ERROR_DEVICE_IN_USE, "Device in use" },
	{ ERROR_UNKNOWN_PRINT_MONITOR, "Unknown print monitor" },
	{ ERROR_PRINTER_DRIVER_IN_USE, "Printer driver in use" },
	{ ERROR_SPOOL_FILE_NOT_FOUND, "Spool file not found" },
	{ ERROR_SPL_NO_STARTDOC, "SPL no startdoc" },
	{ ERROR_SPL_NO_ADDJOB, "SPL no addjob" },
	{ ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED, "Print processor already installed" },
	{ ERROR_PRINT_MONITOR_ALREADY_INSTALLED, "Print monitor already installed" },
	{ ERROR_INVALID_PRINT_MONITOR, "Invalid print monitor" },
	{ ERROR_PRINT_MONITOR_IN_USE, "Print monitor in use" },
	{ ERROR_PRINTER_HAS_JOBS_QUEUED, "Printer has jobs queued" },
	{ ERROR_SUCCESS_REBOOT_REQUIRED, "Success reboot required" },
	{ ERROR_SUCCESS_RESTART_REQUIRED, "Success restart required" },
	{ ERROR_PRINTER_NOT_FOUND, "Printer not found" },
	{ ERROR_PRINTER_DRIVER_WARNED, "Printer driver warned" },
	{ ERROR_PRINTER_DRIVER_BLOCKED, "Printer driver blocked" },
	{ ERROR_WINS_INTERNAL, "Wins internal" },
	{ ERROR_CAN_NOT_DEL_LOCAL_WINS, "Can not del local wins" },
	{ ERROR_STATIC_INIT, "Static init" },
	{ ERROR_INC_BACKUP, "Inc backup" },
	{ ERROR_FULL_BACKUP, "Full backup" },
	{ ERROR_REC_NON_EXISTENT, "Rec not existent" },
	{ ERROR_RPL_NOT_ALLOWED, "RPL not allowed" },
	{ ERROR_DHCP_ADDRESS_CONFLICT, "DHCP address conflict" },
	{ ERROR_WMI_GUID_NOT_FOUND, "WMU GUID not found" },
	{ ERROR_WMI_INSTANCE_NOT_FOUND, "WMI instance not found" },
	{ ERROR_WMI_ITEMID_NOT_FOUND, "WMI ItemID not found" },
	{ ERROR_WMI_TRY_AGAIN, "WMI try again" },
	{ ERROR_WMI_DP_NOT_FOUND, "WMI DP not found" },
	{ ERROR_WMI_UNRESOLVED_INSTANCE_REF, "WMI unresolved instance ref" },
	{ ERROR_WMI_ALREADY_ENABLED, "WMU already enabled" },
	{ ERROR_WMI_GUID_DISCONNECTED, "WMU GUID disconnected" },
	{ ERROR_WMI_SERVER_UNAVAILABLE, "WMI server unavailable" },
	{ ERROR_WMI_DP_FAILED, "WMI DP failed" },
	{ ERROR_WMI_INVALID_MOF, "WMI invalid MOF" },
	{ ERROR_WMI_INVALID_REGINFO, "WMI invalid reginfo" },
	{ ERROR_WMI_ALREADY_DISABLED, "WMI already disabled" },
	{ ERROR_WMI_READ_ONLY, "WMI read only" },
	{ ERROR_WMI_SET_FAILURE, "WMI set failure" },
	{ ERROR_INVALID_MEDIA, "Invalid media" },
	{ ERROR_INVALID_LIBRARY, "Invalid library" },
	{ ERROR_INVALID_MEDIA_POOL, "Invalid media pool" },
	{ ERROR_DRIVE_MEDIA_MISMATCH, "Drive media mismatch" },
	{ ERROR_MEDIA_OFFLINE, "Media offline" },
	{ ERROR_LIBRARY_OFFLINE, "Library offline" },
	{ ERROR_EMPTY, "Empty" },
	{ ERROR_NOT_EMPTY, "Not empty" },
	{ ERROR_MEDIA_UNAVAILABLE, "Media unavailable" },
	{ ERROR_RESOURCE_DISABLED, "Resource disabled" },
	{ ERROR_INVALID_CLEANER, "Invalid cleaner" },
	{ ERROR_UNABLE_TO_CLEAN, "Unable to clean" },
	{ ERROR_OBJECT_NOT_FOUND, "Object not found" },
	{ ERROR_DATABASE_FAILURE, "Database failure" },
	{ ERROR_DATABASE_FULL, "Database full" },
	{ ERROR_MEDIA_INCOMPATIBLE, "Media incompatible" },
	{ ERROR_RESOURCE_NOT_PRESENT, "Resource not present" },
	{ ERROR_INVALID_OPERATION, "Invalid operation" },
	{ ERROR_MEDIA_NOT_AVAILABLE, "Media not available" },
	{ ERROR_DEVICE_NOT_AVAILABLE, "Device not available" },
	{ ERROR_REQUEST_REFUSED, "Request refused" },
	{ ERROR_INVALID_DRIVE_OBJECT, "Invalid drive object" },
	{ ERROR_LIBRARY_FULL, "Library full" },
	{ ERROR_MEDIUM_NOT_ACCESSIBLE, "Medium not accessible" },
	{ ERROR_UNABLE_TO_LOAD_MEDIUM, "Unable to load medium" },
	{ ERROR_UNABLE_TO_INVENTORY_DRIVE, "Unable to inventory drive" },
	{ ERROR_UNABLE_TO_INVENTORY_SLOT, "Unable to inventory slot" },
	{ ERROR_UNABLE_TO_INVENTORY_TRANSPORT, "Unable to inventory transport" },
	{ ERROR_TRANSPORT_FULL, "Transport full" },
	{ ERROR_CONTROLLING_IEPORT, "Controlling ieport" },
	{ ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA, "Unable to eject mounted media" },
	{ ERROR_CLEANER_SLOT_SET, "Cleaner slot set" },
	{ ERROR_CLEANER_SLOT_NOT_SET, "Cleaner slot not set" },
	{ ERROR_CLEANER_CARTRIDGE_SPENT, "Cleaner cartridge spent" },
	{ ERROR_UNEXPECTED_OMID, "Unexpected omid" },
	{ ERROR_CANT_DELETE_LAST_ITEM, "Can't delete last item" },
	{ ERROR_MESSAGE_EXCEEDS_MAX_SIZE, "Message exceeds max size" },
	{ ERROR_VOLUME_CONTAINS_SYS_FILES, "Volume contains sys files" },
	{ ERROR_INDIGENOUS_TYPE, "Indigenous type" },
	{ ERROR_NO_SUPPORTING_DRIVES, "No supporting drives" },
	{ ERROR_CLEANER_CARTRIDGE_INSTALLED, "Cleaner cartridge installed" },
	{ ERROR_FILE_OFFLINE, "Fill offline" },
	{ ERROR_REMOTE_STORAGE_NOT_ACTIVE, "Remote storage not active" },
	{ ERROR_REMOTE_STORAGE_MEDIA_ERROR, "Remote storage media error" },
	{ ERROR_NOT_A_REPARSE_POINT, "Not a reparse point" },
	{ ERROR_REPARSE_ATTRIBUTE_CONFLICT, "Reparse attribute conflict" },
	{ ERROR_INVALID_REPARSE_DATA, "Invalid reparse data" },
	{ ERROR_REPARSE_TAG_INVALID, "Reparse tag invalid" },
	{ ERROR_REPARSE_TAG_MISMATCH, "Reparse tag mismatch" },
	{ ERROR_VOLUME_NOT_SIS_ENABLED, "Volume not sis enabled" },
	{ ERROR_DEPENDENT_RESOURCE_EXISTS, "Dependent resource exists" },
	{ ERROR_DEPENDENCY_NOT_FOUND, "Dependency not found" },
	{ ERROR_DEPENDENCY_ALREADY_EXISTS, "Dependency already exists" },
	{ ERROR_RESOURCE_NOT_ONLINE, "Resource not online" },
	{ ERROR_HOST_NODE_NOT_AVAILABLE, "Host node not available" },
	{ ERROR_RESOURCE_NOT_AVAILABLE, "Resource not available" },
	{ ERROR_RESOURCE_NOT_FOUND, "Resource not found" },
	{ ERROR_SHUTDOWN_CLUSTER, "Shutdown cluster" },
	{ ERROR_CANT_EVICT_ACTIVE_NODE, "Can't evict active node" },
	{ ERROR_OBJECT_ALREADY_EXISTS, "Object already exists" },
	{ ERROR_OBJECT_IN_LIST, "Object in list" },
	{ ERROR_GROUP_NOT_AVAILABLE, "Group not available" },
	{ ERROR_GROUP_NOT_FOUND, "Group not found" },
	{ ERROR_GROUP_NOT_ONLINE, "Group not online" },
	{ ERROR_HOST_NODE_NOT_RESOURCE_OWNER, "Host node not resource owner" },
	{ ERROR_HOST_NODE_NOT_GROUP_OWNER, "Host node not group owner" },
	{ ERROR_RESMON_CREATE_FAILED, "Resmon create failed" },
	{ ERROR_RESMON_ONLINE_FAILED, "Resmon online failed" },
	{ ERROR_RESOURCE_ONLINE, "Resource online" },
	{ ERROR_QUORUM_RESOURCE, "Quorum resource" },
	{ ERROR_NOT_QUORUM_CAPABLE, "Not quorum capable" },
	{ ERROR_CLUSTER_SHUTTING_DOWN, "Cluster shutting down" },
	{ ERROR_INVALID_STATE, "Invalid state" },
	{ ERROR_RESOURCE_PROPERTIES_STORED, "Resource properties stored" },
	{ ERROR_NOT_QUORUM_CLASS, "Not quorum class" },
	{ ERROR_CORE_RESOURCE, "Core resource" },
	{ ERROR_QUORUM_RESOURCE_ONLINE_FAILED, "Quorum resource online failed" },
	{ ERROR_QUORUMLOG_OPEN_FAILED, "Quorumlog open failed" },
	{ ERROR_CLUSTERLOG_CORRUPT, "Clusterlog corrupt" },
	{ ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE, "Clusterlog record exceeds maxsize" },
	{ ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE, "Clusterlog exceeds maxsize" },
	{ ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND, "Clusterlog chkpoint not found" },
	{ ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE, "Clusterlog not enough space" },
	{ ERROR_QUORUM_OWNER_ALIVE, "Quorum owner alive" },
	{ ERROR_NETWORK_NOT_AVAILABLE, "Network not available" },
	{ ERROR_NODE_NOT_AVAILABLE, "Node not available" },
	{ ERROR_ALL_NODES_NOT_AVAILABLE, "All nodes not available" },
	{ ERROR_RESOURCE_FAILED, "Resource failed" },
	{ ERROR_CLUSTER_INVALID_NODE, "Cluster invalid node" },
	{ ERROR_CLUSTER_NODE_EXISTS, "Cluster node exists" },
	{ ERROR_CLUSTER_JOIN_IN_PROGRESS, "Cluster join in progress" },
	{ ERROR_CLUSTER_NODE_NOT_FOUND, "Cluster node not found" },
	{ ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND, "Cluster local node not found" },
	{ ERROR_CLUSTER_NETWORK_EXISTS, "Cluster network exists" },
	{ ERROR_CLUSTER_NETWORK_NOT_FOUND, "Cluster network not found" },
	{ ERROR_CLUSTER_NETINTERFACE_EXISTS, "Cluster netinterface exists" },
	{ ERROR_CLUSTER_NETINTERFACE_NOT_FOUND, "Cluster netinterface not found" },
	{ ERROR_CLUSTER_INVALID_REQUEST, "Cluster invalid request" },
	{ ERROR_CLUSTER_INVALID_NETWORK_PROVIDER, "Cluster invalid network provider" },
	{ ERROR_CLUSTER_NODE_DOWN, "Cluster node down" },
	{ ERROR_CLUSTER_NODE_UNREACHABLE, "Cluster node unreachable" },
	{ ERROR_CLUSTER_NODE_NOT_MEMBER, "Cluster node not member" },
	{ ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS, "Cluster join not in progress" },
	{ ERROR_CLUSTER_INVALID_NETWORK, "Cluster invalid network" },
	{ ERROR_CLUSTER_NODE_UP, "Cluster node up" },
	{ ERROR_CLUSTER_IPADDR_IN_USE, "Cluster ipaddr in use" },
	{ ERROR_CLUSTER_NODE_NOT_PAUSED, "Cluster node not paused" },
	{ ERROR_CLUSTER_NO_SECURITY_CONTEXT, "Cluster no security context" },
	{ ERROR_CLUSTER_NETWORK_NOT_INTERNAL, "Cluster network not internal" },
	{ ERROR_CLUSTER_NODE_ALREADY_UP, "Cluster node already up" },
	{ ERROR_CLUSTER_NODE_ALREADY_DOWN, "Cluster node already down" },
	{ ERROR_CLUSTER_NETWORK_ALREADY_ONLINE, "Cluster network already online" },
	{ ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE, "Cluster network already offline" },
	{ ERROR_CLUSTER_NODE_ALREADY_MEMBER, "Cluster node already member" },
	{ ERROR_CLUSTER_LAST_INTERNAL_NETWORK, "Cluster last internal network" },
	{ ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS, "Cluster network has dependents" },
	{ ERROR_INVALID_OPERATION_ON_QUORUM, "Invalid operation on quorum" },
	{ ERROR_DEPENDENCY_NOT_ALLOWED, "Dependency not allowed" },
	{ ERROR_CLUSTER_NODE_PAUSED, "Cluster node paused" },
	{ ERROR_NODE_CANT_HOST_RESOURCE, "Node can't host resource" },
	{ ERROR_CLUSTER_NODE_NOT_READY, "Cluster node not ready" },
	{ ERROR_CLUSTER_NODE_SHUTTING_DOWN, "Cluster node shutting down" },
	{ ERROR_CLUSTER_JOIN_ABORTED, "Cluster join aborted" },
	{ ERROR_CLUSTER_INCOMPATIBLE_VERSIONS, "Cluster incompatible versions" },
	{ ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED, "Cluster maxnum of resources exceeded" },
	{ ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED, "Cluster system config changed" },
	{ ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND, "Cluster resource type not found" },
	{ ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED, "Cluster restype not supported" },
	{ ERROR_CLUSTER_RESNAME_NOT_FOUND, "Cluster resname not found" },
	{ ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED, "Cluster no RPC packages registered" },
	{ ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST, "Cluster owner not in preflist" },
	{ ERROR_CLUSTER_DATABASE_SEQMISMATCH, "Cluster database seqmismatch" },
	{ ERROR_RESMON_INVALID_STATE, "Resmon invalid state" },
	{ ERROR_CLUSTER_GUM_NOT_LOCKER, "Cluster gum not locker" },
	{ ERROR_QUORUM_DISK_NOT_FOUND, "Quorum disk not found" },
	{ ERROR_DATABASE_BACKUP_CORRUPT, "Database backup corrupt" },
	{ ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT, "Cluster node already has DFS root" },
	{ ERROR_RESOURCE_PROPERTY_UNCHANGEABLE, "Resource property unchangeable" },
	{ ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE, "Cluster membership invalid state" },
	{ ERROR_CLUSTER_QUORUMLOG_NOT_FOUND, "Cluster quorumlog not found" },
	{ ERROR_CLUSTER_MEMBERSHIP_HALT, "Cluster membership halt" },
	{ ERROR_CLUSTER_INSTANCE_ID_MISMATCH, "Cluster instance ID mismatch" },
	{ ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP, "Cluster network not found for IP" },
	{ ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH, "Cluster property data type mismatch" },
	{ ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP, "Cluster evict without cleanup" },
	{ ERROR_CLUSTER_PARAMETER_MISMATCH, "Cluster parameter mismatch" },
	{ ERROR_NODE_CANNOT_BE_CLUSTERED, "Node cannot be clustered" },
	{ ERROR_CLUSTER_WRONG_OS_VERSION, "Cluster wrong OS version" },
	{ ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME, "Cluster can't create dup cluster name" },
	{ ERROR_DECRYPTION_FAILED, "Decryption failed" },
	{ ERROR_FILE_ENCRYPTED, "File encrypted" },
	{ ERROR_NO_RECOVERY_POLICY, "No recovery policy" },
	{ ERROR_NO_EFS, "No EFS" },
	{ ERROR_WRONG_EFS, "Wrong EFS" },
	{ ERROR_NO_USER_KEYS, "No user keys" },
	{ ERROR_FILE_NOT_ENCRYPTED, "File not encryped" },
	{ ERROR_NOT_EXPORT_FORMAT, "Not export format" },
	{ ERROR_FILE_READ_ONLY, "File read only" },
	{ ERROR_DIR_EFS_DISALLOWED, "Dir EFS disallowed" },
	{ ERROR_EFS_SERVER_NOT_TRUSTED, "EFS server not trusted" },
	{ ERROR_BAD_RECOVERY_POLICY, "Bad recovery policy" },
	{ ERROR_EFS_ALG_BLOB_TOO_BIG, "ETS alg blob too big" },
	{ ERROR_VOLUME_NOT_SUPPORT_EFS, "Volume not support EFS" },
	{ ERROR_EFS_DISABLED, "EFS disabled" },
	{ ERROR_EFS_VERSION_NOT_SUPPORT, "EFS version not support" },
	{ ERROR_NO_BROWSER_SERVERS_FOUND, "No browser servers found" },
	{ SCHED_E_SERVICE_NOT_LOCALSYSTEM, "Sched E service not localsystem" },
	{ ERROR_CTX_WINSTATION_NAME_INVALID, "Ctx winstation name invalid" },
	{ ERROR_CTX_INVALID_PD, "Ctx invalid PD" },
	{ ERROR_CTX_PD_NOT_FOUND, "Ctx PD not found" },
	{ ERROR_CTX_WD_NOT_FOUND, "Ctx WD not found" },
	{ ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY, "Ctx cannot make eventlog entry" },
	{ ERROR_CTX_SERVICE_NAME_COLLISION, "Ctx service name collision" },
	{ ERROR_CTX_CLOSE_PENDING, "Ctx close pending" },
	{ ERROR_CTX_NO_OUTBUF, "Ctx no outbuf" },
	{ ERROR_CTX_MODEM_INF_NOT_FOUND, "Ctx modem inf not found" },
	{ ERROR_CTX_INVALID_MODEMNAME, "Ctx invalid modemname" },
	{ ERROR_CTX_MODEM_RESPONSE_ERROR, "Ctx modem response error" },
	{ ERROR_CTX_MODEM_RESPONSE_TIMEOUT, "Ctx modem response timeout" },
	{ ERROR_CTX_MODEM_RESPONSE_NO_CARRIER, "Ctx modem response no carrier" },
	{ ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE, "Ctx modem response no dial tone" },
	{ ERROR_CTX_MODEM_RESPONSE_BUSY, "Ctx modem response busy" },
	{ ERROR_CTX_MODEM_RESPONSE_VOICE, "Ctx modem response voice" },
	{ ERROR_CTX_TD_ERROR, "Ctx TD error" },
	{ ERROR_CTX_WINSTATION_NOT_FOUND, "Ctx winstation not found" },
	{ ERROR_CTX_WINSTATION_ALREADY_EXISTS, "Ctx winstation already exists" },
	{ ERROR_CTX_WINSTATION_BUSY, "Ctx winstation busy" },
	{ ERROR_CTX_BAD_VIDEO_MODE, "Ctx bad video mode" },
	{ ERROR_CTX_GRAPHICS_INVALID, "Ctx graphics invalid" },
	{ ERROR_CTX_LOGON_DISABLED, "Ctx logon disabled" },
	{ ERROR_CTX_NOT_CONSOLE, "Ctx not console" },
	{ ERROR_CTX_CLIENT_QUERY_TIMEOUT, "Ctx client query timeout" },
	{ ERROR_CTX_CONSOLE_DISCONNECT, "Ctx console disconnect" },
	{ ERROR_CTX_CONSOLE_CONNECT, "Ctx console connect" },
	{ ERROR_CTX_SHADOW_DENIED, "Ctx shadow denied" },
	{ ERROR_CTX_WINSTATION_ACCESS_DENIED, "Ctx winstation access denied" },
	{ ERROR_CTX_INVALID_WD, "Ctx invalid WD" },
	{ ERROR_CTX_SHADOW_INVALID, "Ctx shadow invalid" },
	{ ERROR_CTX_SHADOW_DISABLED, "Ctx shadow disabled" },
	{ ERROR_CTX_CLIENT_LICENSE_IN_USE, "Ctx client licence in use" },
	{ ERROR_CTX_CLIENT_LICENSE_NOT_SET, "Ctx client licence not set" },
	{ ERROR_CTX_LICENSE_NOT_AVAILABLE, "Ctx licence not available" },
	{ ERROR_CTX_LICENSE_CLIENT_INVALID, "Ctx licence client invalid" },
	{ ERROR_CTX_LICENSE_EXPIRED, "Ctx licence expired" },
	{ ERROR_CTX_SHADOW_NOT_RUNNING, "Ctx shadow not running" },
	{ ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE, "Ctx shadow ended by mode change" },
	{ FRS_ERR_INVALID_API_SEQUENCE, "FRS err invalid API sequence" },
	{ FRS_ERR_STARTING_SERVICE, "FRS err starting service" },
	{ FRS_ERR_STOPPING_SERVICE, "FRS err stopping service" },
	{ FRS_ERR_INTERNAL_API, "FRS err internal API" },
	{ FRS_ERR_INTERNAL, "FRS err internal" },
	{ FRS_ERR_SERVICE_COMM, "FRS err service comm" },
	{ FRS_ERR_INSUFFICIENT_PRIV, "FRS err insufficient priv" },
	{ FRS_ERR_AUTHENTICATION, "FRS err authentication" },
	{ FRS_ERR_PARENT_INSUFFICIENT_PRIV, "FRS err parent insufficient priv" },
	{ FRS_ERR_PARENT_AUTHENTICATION, "FRS err parent authentication" },
	{ FRS_ERR_CHILD_TO_PARENT_COMM, "FRS err child to parent comm" },
	{ FRS_ERR_PARENT_TO_CHILD_COMM, "FRS err parent to child comm" },
	{ FRS_ERR_SYSVOL_POPULATE, "FRS err sysvol populate" },
	{ FRS_ERR_SYSVOL_POPULATE_TIMEOUT, "FRS err sysvol populate timeout" },
	{ FRS_ERR_SYSVOL_IS_BUSY, "FRS err sysvol is busy" },
	{ FRS_ERR_SYSVOL_DEMOTE, "FRS err sysvol demote" },
	{ FRS_ERR_INVALID_SERVICE_PARAMETER, "FRS err invalid service parameter" },
	{ ERROR_DS_NOT_INSTALLED, "DS not installed" },
	{ ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY, "DS membership evaluated locally" },
	{ ERROR_DS_NO_ATTRIBUTE_OR_VALUE, "DS no attribute or value" },
	{ ERROR_DS_INVALID_ATTRIBUTE_SYNTAX, "DS invalid attribute syntax" },
	{ ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED, "DS attribute type undefined" },
	{ ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS, "DS attribute or value exists" },
	{ ERROR_DS_BUSY, "DS busy" },
	{ ERROR_DS_UNAVAILABLE, "DS unavailable" },
	{ ERROR_DS_NO_RIDS_ALLOCATED, "DS no rids allocated" },
	{ ERROR_DS_NO_MORE_RIDS, "DS no more rids" },
	{ ERROR_DS_INCORRECT_ROLE_OWNER, "DS incorrect role owner" },
	{ ERROR_DS_RIDMGR_INIT_ERROR, "DS ridmgr init error" },
	{ ERROR_DS_OBJ_CLASS_VIOLATION, "DS obj class violation" },
	{ ERROR_DS_CANT_ON_NON_LEAF, "DS can't on non leaf" },
	{ ERROR_DS_CANT_ON_RDN, "DS can't on rnd" },
	{ ERROR_DS_CANT_MOD_OBJ_CLASS, "DS can't mod obj class" },
	{ ERROR_DS_CROSS_DOM_MOVE_ERROR, "DS cross dom move error" },
	{ ERROR_DS_GC_NOT_AVAILABLE, "DS GC not available" },
	{ ERROR_SHARED_POLICY, "Shared policy" },
	{ ERROR_POLICY_OBJECT_NOT_FOUND, "Policy object not found" },
	{ ERROR_POLICY_ONLY_IN_DS, "Policy only in DS" },
	{ ERROR_PROMOTION_ACTIVE, "Promotion active" },
	{ ERROR_NO_PROMOTION_ACTIVE, "No promotion active" },
	{ ERROR_DS_OPERATIONS_ERROR, "DS operations error" },
	{ ERROR_DS_PROTOCOL_ERROR, "DS protocol error" },
	{ ERROR_DS_TIMELIMIT_EXCEEDED, "DS timelimit exceeded" },
	{ ERROR_DS_SIZELIMIT_EXCEEDED, "DS sizelimit exceeded" },
	{ ERROR_DS_ADMIN_LIMIT_EXCEEDED, "DS admin limit exceeded" },
	{ ERROR_DS_COMPARE_FALSE, "DS compare false" },
	{ ERROR_DS_COMPARE_TRUE, "DS compare true" },
	{ ERROR_DS_AUTH_METHOD_NOT_SUPPORTED, "DS auth method not supported" },
	{ ERROR_DS_STRONG_AUTH_REQUIRED, "DS strong auth required" },
	{ ERROR_DS_INAPPROPRIATE_AUTH, "DS inappropriate auth" },
	{ ERROR_DS_AUTH_UNKNOWN, "DS auth unknown" },
	{ ERROR_DS_REFERRAL, "DS referral" },
	{ ERROR_DS_UNAVAILABLE_CRIT_EXTENSION, "DS unavailable crit extension" },
	{ ERROR_DS_CONFIDENTIALITY_REQUIRED, "DS confidentiality required" },
	{ ERROR_DS_INAPPROPRIATE_MATCHING, "DS inappropriate matching" },
	{ ERROR_DS_CONSTRAINT_VIOLATION, "DS constraint violation" },
	{ ERROR_DS_NO_SUCH_OBJECT, "DS no such object" },
	{ ERROR_DS_ALIAS_PROBLEM, "DS alias problem" },
	{ ERROR_DS_INVALID_DN_SYNTAX, "DS invalid dn syntax" },
	{ ERROR_DS_IS_LEAF, "DS is leaf" },
	{ ERROR_DS_ALIAS_DEREF_PROBLEM, "DS alias deref problem" },
	{ ERROR_DS_UNWILLING_TO_PERFORM, "DS unwilling to perform" },
	{ ERROR_DS_LOOP_DETECT, "DS loop detect" },
	{ ERROR_DS_NAMING_VIOLATION, "DS naming violation" },
	{ ERROR_DS_OBJECT_RESULTS_TOO_LARGE, "DS object results too large" },
	{ ERROR_DS_AFFECTS_MULTIPLE_DSAS, "DS affects multiple dsas" },
	{ ERROR_DS_SERVER_DOWN, "DS server down" },
	{ ERROR_DS_LOCAL_ERROR, "DS local error" },
	{ ERROR_DS_ENCODING_ERROR, "DS encoding error" },
	{ ERROR_DS_DECODING_ERROR, "DS decoding error" },
	{ ERROR_DS_FILTER_UNKNOWN, "DS filter unknown" },
	{ ERROR_DS_PARAM_ERROR, "DS param error" },
	{ ERROR_DS_NOT_SUPPORTED, "DS not supported" },
	{ ERROR_DS_NO_RESULTS_RETURNED, "DS no results returned" },
	{ ERROR_DS_CONTROL_NOT_FOUND, "DS control not found" },
	{ ERROR_DS_CLIENT_LOOP, "DS client loop" },
	{ ERROR_DS_REFERRAL_LIMIT_EXCEEDED, "DS referral limit exceeded" },
	{ ERROR_DS_SORT_CONTROL_MISSING, "DS sort control missing" },
	{ ERROR_DS_OFFSET_RANGE_ERROR, "DS offset range error" },
	{ ERROR_DS_ROOT_MUST_BE_NC, "DS root must be nc" },
	{ ERROR_DS_ADD_REPLICA_INHIBITED, "DS and replica inhibited" },
	{ ERROR_DS_ATT_NOT_DEF_IN_SCHEMA, "DS att not def in schema" },
	{ ERROR_DS_MAX_OBJ_SIZE_EXCEEDED, "DS max obj size exceeded" },
	{ ERROR_DS_OBJ_STRING_NAME_EXISTS, "DS obj string name exists" },
	{ ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA, "DS no rdn defined in schema" },
	{ ERROR_DS_RDN_DOESNT_MATCH_SCHEMA, "DS rdn doesn't match schema" },
	{ ERROR_DS_NO_REQUESTED_ATTS_FOUND, "DS no requested atts found" },
	{ ERROR_DS_USER_BUFFER_TO_SMALL, "DS user buffer too small" },
	{ ERROR_DS_ATT_IS_NOT_ON_OBJ, "DS att is not on obj" },
	{ ERROR_DS_ILLEGAL_MOD_OPERATION, "DS illegal mod operation" },
	{ ERROR_DS_OBJ_TOO_LARGE, "DS obj too large" },
	{ ERROR_DS_BAD_INSTANCE_TYPE, "DS bad instance type" },
	{ ERROR_DS_MASTERDSA_REQUIRED, "DS masterdsa required" },
	{ ERROR_DS_OBJECT_CLASS_REQUIRED, "DS object class required" },
	{ ERROR_DS_MISSING_REQUIRED_ATT, "DS missing required att" },
	{ ERROR_DS_ATT_NOT_DEF_FOR_CLASS, "DS att not def for class" },
	{ ERROR_DS_ATT_ALREADY_EXISTS, "DS att already exists" },
	{ ERROR_DS_CANT_ADD_ATT_VALUES, "DS can't add att values" },
	{ ERROR_DS_SINGLE_VALUE_CONSTRAINT, "DS single value constraint" },
	{ ERROR_DS_RANGE_CONSTRAINT, "DS range constraint" },
	{ ERROR_DS_ATT_VAL_ALREADY_EXISTS, "DS att val already exists" },
	{ ERROR_DS_CANT_REM_MISSING_ATT, "DS can't rem missing att" },
	{ ERROR_DS_CANT_REM_MISSING_ATT_VAL, "DS can't rem missing att val" },
	{ ERROR_DS_ROOT_CANT_BE_SUBREF, "DS root can't be subref" },
	{ ERROR_DS_NO_CHAINING, "DS no chaining" },
	{ ERROR_DS_NO_CHAINED_EVAL, "DS no chained eval" },
	{ ERROR_DS_NO_PARENT_OBJECT, "DS no parent object" },
	{ ERROR_DS_PARENT_IS_AN_ALIAS, "DS parent is an alias" },
	{ ERROR_DS_CANT_MIX_MASTER_AND_REPS, "DS can't mix master and reps" },
	{ ERROR_DS_CHILDREN_EXIST, "DS children exist" },
	{ ERROR_DS_OBJ_NOT_FOUND, "DS obj not found" },
	{ ERROR_DS_ALIASED_OBJ_MISSING, "DS aliased obj missing" },
	{ ERROR_DS_BAD_NAME_SYNTAX, "DS bad name syntax" },
	{ ERROR_DS_ALIAS_POINTS_TO_ALIAS, "DS alias points to alias" },
	{ ERROR_DS_CANT_DEREF_ALIAS, "DS can't redef alias" },
	{ ERROR_DS_OUT_OF_SCOPE, "DS out of scope" },
	{ ERROR_DS_OBJECT_BEING_REMOVED, "DS object being removed" },
	{ ERROR_DS_CANT_DELETE_DSA_OBJ, "DS can't delete dsa obj" },
	{ ERROR_DS_GENERIC_ERROR, "DS generic error" },
	{ ERROR_DS_DSA_MUST_BE_INT_MASTER, "DS dsa must be int master" },
	{ ERROR_DS_CLASS_NOT_DSA, "DS class not dsa" },
	{ ERROR_DS_INSUFF_ACCESS_RIGHTS, "DS insuff access rights" },
	{ ERROR_DS_ILLEGAL_SUPERIOR, "DS illegal superior" },
	{ ERROR_DS_ATTRIBUTE_OWNED_BY_SAM, "DS attribute owned by sam" },
	{ ERROR_DS_NAME_TOO_MANY_PARTS, "DS name too many parts" },
	{ ERROR_DS_NAME_TOO_LONG, "DS name too long" },
	{ ERROR_DS_NAME_VALUE_TOO_LONG, "DS name value too long" },
	{ ERROR_DS_NAME_UNPARSEABLE, "DS name unparseable" },
	{ ERROR_DS_NAME_TYPE_UNKNOWN, "DS name type unknown" },
	{ ERROR_DS_NOT_AN_OBJECT, "DS not an object" },
	{ ERROR_DS_SEC_DESC_TOO_SHORT, "DS sec desc too short" },
	{ ERROR_DS_SEC_DESC_INVALID, "DS sec desc invalid" },
	{ ERROR_DS_NO_DELETED_NAME, "DS no deleted name" },
	{ ERROR_DS_SUBREF_MUST_HAVE_PARENT, "DS subref must have parent" },
	{ ERROR_DS_NCNAME_MUST_BE_NC, "DS ncname must be nc" },
	{ ERROR_DS_CANT_ADD_SYSTEM_ONLY, "DS can't add system only" },
	{ ERROR_DS_CLASS_MUST_BE_CONCRETE, "DS class must be concrete" },
	{ ERROR_DS_INVALID_DMD, "DS invalid dmd" },
	{ ERROR_DS_OBJ_GUID_EXISTS, "DS obj GUID exists" },
	{ ERROR_DS_NOT_ON_BACKLINK, "DS not on backlink" },
	{ ERROR_DS_NO_CROSSREF_FOR_NC, "DS no crossref for nc" },
	{ ERROR_DS_SHUTTING_DOWN, "DS shutting down" },
	{ ERROR_DS_UNKNOWN_OPERATION, "DS unknown operation" },
	{ ERROR_DS_INVALID_ROLE_OWNER, "DS invalid role owner" },
	{ ERROR_DS_COULDNT_CONTACT_FSMO, "DS couldn't contact fsmo" },
	{ ERROR_DS_CROSS_NC_DN_RENAME, "DS cross nc dn rename" },
	{ ERROR_DS_CANT_MOD_SYSTEM_ONLY, "DS can't mod system only" },
	{ ERROR_DS_REPLICATOR_ONLY, "DS replicator only" },
	{ ERROR_DS_OBJ_CLASS_NOT_DEFINED, "DS obj class not defined" },
	{ ERROR_DS_OBJ_CLASS_NOT_SUBCLASS, "DS obj class not subclass" },
	{ ERROR_DS_NAME_REFERENCE_INVALID, "DS name reference invalid" },
	{ ERROR_DS_CROSS_REF_EXISTS, "DS cross ref exists" },
	{ ERROR_DS_CANT_DEL_MASTER_CROSSREF, "DS can't del master crossref" },
	{ ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD, "DS subtree notify not nc head" },
	{ ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX, "DS notify filter too complex" },
	{ ERROR_DS_DUP_RDN, "DS dup rdn" },
	{ ERROR_DS_DUP_OID, "DS dup oid" },
	{ ERROR_DS_DUP_MAPI_ID, "DS dup mapi ID" },
	{ ERROR_DS_DUP_SCHEMA_ID_GUID, "DS dup schema ID GUID" },
	{ ERROR_DS_DUP_LDAP_DISPLAY_NAME, "DS dup LDAP display name" },
	{ ERROR_DS_SEMANTIC_ATT_TEST, "DS semantic att test" },
	{ ERROR_DS_SYNTAX_MISMATCH, "DS syntax mismatch" },
	{ ERROR_DS_EXISTS_IN_MUST_HAVE, "DS exists in must have" },
	{ ERROR_DS_EXISTS_IN_MAY_HAVE, "DS exists in may have" },
	{ ERROR_DS_NONEXISTENT_MAY_HAVE, "DS nonexistent may have" },
	{ ERROR_DS_NONEXISTENT_MUST_HAVE, "DS nonexistent must have" },
	{ ERROR_DS_AUX_CLS_TEST_FAIL, "DS aux cls test fail" },
	{ ERROR_DS_NONEXISTENT_POSS_SUP, "DS nonexistent poss sup" },
	{ ERROR_DS_SUB_CLS_TEST_FAIL, "DS sub cls test fail" },
	{ ERROR_DS_BAD_RDN_ATT_ID_SYNTAX, "DS bad rdn att ID syntax" },
	{ ERROR_DS_EXISTS_IN_AUX_CLS, "DS exists in aux cls" },
	{ ERROR_DS_EXISTS_IN_SUB_CLS, "DS exists in sub cls" },
	{ ERROR_DS_EXISTS_IN_POSS_SUP, "DS exists in poss sup" },
	{ ERROR_DS_RECALCSCHEMA_FAILED, "DS recalcschema failed" },
	{ ERROR_DS_TREE_DELETE_NOT_FINISHED, "DS tree delete not finished" },
	{ ERROR_DS_CANT_DELETE, "DS can't delete" },
	{ ERROR_DS_ATT_SCHEMA_REQ_ID, "DS att schema req ID" },
	{ ERROR_DS_BAD_ATT_SCHEMA_SYNTAX, "DS bad att schema syntax" },
	{ ERROR_DS_CANT_CACHE_ATT, "DS can't cache att" },
	{ ERROR_DS_CANT_CACHE_CLASS, "DS can't cache class" },
	{ ERROR_DS_CANT_REMOVE_ATT_CACHE, "DS can't remove att cache" },
	{ ERROR_DS_CANT_REMOVE_CLASS_CACHE, "DS can't remove class cache" },
	{ ERROR_DS_CANT_RETRIEVE_DN, "DS can't retrieve DN" },
	{ ERROR_DS_MISSING_SUPREF, "DS missing supref" },
	{ ERROR_DS_CANT_RETRIEVE_INSTANCE, "DS can't retrieve instance" },
	{ ERROR_DS_CODE_INCONSISTENCY, "DS code inconsistency" },
	{ ERROR_DS_DATABASE_ERROR, "DS database error" },
	{ ERROR_DS_GOVERNSID_MISSING, "DS governsid missing" },
	{ ERROR_DS_MISSING_EXPECTED_ATT, "DS missing expected att" },
	{ ERROR_DS_NCNAME_MISSING_CR_REF, "DS ncname missing cr ref" },
	{ ERROR_DS_SECURITY_CHECKING_ERROR, "DS security checking error" },
	{ ERROR_DS_SCHEMA_NOT_LOADED, "DS schema not loaded" },
	{ ERROR_DS_SCHEMA_ALLOC_FAILED, "DS schema alloc failed" },
	{ ERROR_DS_ATT_SCHEMA_REQ_SYNTAX, "DS att schema req syntax" },
	{ ERROR_DS_GCVERIFY_ERROR, "DS gcverify error" },
	{ ERROR_DS_DRA_SCHEMA_MISMATCH, "DS dra schema mismatch" },
	{ ERROR_DS_CANT_FIND_DSA_OBJ, "DS can't find dsa obj" },
	{ ERROR_DS_CANT_FIND_EXPECTED_NC, "DS can't find expected nc" },
	{ ERROR_DS_CANT_FIND_NC_IN_CACHE, "DS can't find nc in cache" },
	{ ERROR_DS_CANT_RETRIEVE_CHILD, "DS can't retrieve child" },
	{ ERROR_DS_SECURITY_ILLEGAL_MODIFY, "DS security illegal modify" },
	{ ERROR_DS_CANT_REPLACE_HIDDEN_REC, "DS can't replace hidden rec" },
	{ ERROR_DS_BAD_HIERARCHY_FILE, "DS bad hierarchy file" },
	{ ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED, "DS build hierarchy table failed" },
	{ ERROR_DS_CONFIG_PARAM_MISSING, "DS config param missing" },
	{ ERROR_DS_COUNTING_AB_INDICES_FAILED, "DS counting ab indices failed" },
	{ ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED, "DS hierarchy table malloc failed" },
	{ ERROR_DS_INTERNAL_FAILURE, "DS internal failure" },
	{ ERROR_DS_UNKNOWN_ERROR, "DS unknown error" },
	{ ERROR_DS_ROOT_REQUIRES_CLASS_TOP, "DS root requires class top" },
	{ ERROR_DS_REFUSING_FSMO_ROLES, "DS refusing fmso roles" },
	{ ERROR_DS_MISSING_FSMO_SETTINGS, "DS missing fmso settings" },
	{ ERROR_DS_UNABLE_TO_SURRENDER_ROLES, "DS unable to surrender roles" },
	{ ERROR_DS_DRA_GENERIC, "DS dra generic" },
	{ ERROR_DS_DRA_INVALID_PARAMETER, "DS dra invalid parameter" },
	{ ERROR_DS_DRA_BUSY, "DS dra busy" },
	{ ERROR_DS_DRA_BAD_DN, "DS dra bad dn" },
	{ ERROR_DS_DRA_BAD_NC, "DS dra bad nc" },
	{ ERROR_DS_DRA_DN_EXISTS, "DS dra dn exists" },
	{ ERROR_DS_DRA_INTERNAL_ERROR, "DS dra internal error" },
	{ ERROR_DS_DRA_INCONSISTENT_DIT, "DS dra inconsistent dit" },
	{ ERROR_DS_DRA_CONNECTION_FAILED, "DS dra connection failed" },
	{ ERROR_DS_DRA_BAD_INSTANCE_TYPE, "DS dra bad instance type" },
	{ ERROR_DS_DRA_OUT_OF_MEM, "DS dra out of mem" },
	{ ERROR_DS_DRA_MAIL_PROBLEM, "DS dra mail problem" },
	{ ERROR_DS_DRA_REF_ALREADY_EXISTS, "DS dra ref already exists" },
	{ ERROR_DS_DRA_REF_NOT_FOUND, "DS dra ref not found" },
	{ ERROR_DS_DRA_OBJ_IS_REP_SOURCE, "DS dra obj is rep source" },
	{ ERROR_DS_DRA_DB_ERROR, "DS dra db error" },
	{ ERROR_DS_DRA_NO_REPLICA, "DS dra no replica" },
	{ ERROR_DS_DRA_ACCESS_DENIED, "DS dra access denied" },
	{ ERROR_DS_DRA_NOT_SUPPORTED, "DS dra not supported" },
	{ ERROR_DS_DRA_RPC_CANCELLED, "DS dra RPC cancelled" },
	{ ERROR_DS_DRA_SOURCE_DISABLED, "DS dra source disabled" },
	{ ERROR_DS_DRA_SINK_DISABLED, "DS dra sink disabled" },
	{ ERROR_DS_DRA_NAME_COLLISION, "DS dra name collision" },
	{ ERROR_DS_DRA_SOURCE_REINSTALLED, "DS dra source reinstalled" },
	{ ERROR_DS_DRA_MISSING_PARENT, "DS dra missing parent" },
	{ ERROR_DS_DRA_PREEMPTED, "DS dra preempted" },
	{ ERROR_DS_DRA_ABANDON_SYNC, "DS dra abandon sync" },
	{ ERROR_DS_DRA_SHUTDOWN, "DS dra shutdown" },
	{ ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET, "DS dra incompatible partial set" },
	{ ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA, "DS dra source is partial replica" },
	{ ERROR_DS_DRA_EXTN_CONNECTION_FAILED, "DS dra extn connection failed" },
	{ ERROR_DS_INSTALL_SCHEMA_MISMATCH, "DS install schema mismatch" },
	{ ERROR_DS_DUP_LINK_ID, "DS dup link ID" },
	{ ERROR_DS_NAME_ERROR_RESOLVING, "DS name error resolving" },
	{ ERROR_DS_NAME_ERROR_NOT_FOUND, "DS name error not found" },
	{ ERROR_DS_NAME_ERROR_NOT_UNIQUE, "DS name error not unique" },
	{ ERROR_DS_NAME_ERROR_NO_MAPPING, "DS name error no mapping" },
	{ ERROR_DS_NAME_ERROR_DOMAIN_ONLY, "DS name error domain only" },
	{ ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING, "DS name error no syntactical mapping" },
	{ ERROR_DS_CONSTRUCTED_ATT_MOD, "DS constructed att mod" },
	{ ERROR_DS_WRONG_OM_OBJ_CLASS, "DS wrong om obj class" },
	{ ERROR_DS_DRA_REPL_PENDING, "DS dra repl pending" },
	{ ERROR_DS_DS_REQUIRED, "DS ds required" },
	{ ERROR_DS_INVALID_LDAP_DISPLAY_NAME, "DS invalid LDAP display name" },
	{ ERROR_DS_NON_BASE_SEARCH, "DS non base search" },
	{ ERROR_DS_CANT_RETRIEVE_ATTS, "DS can't retrieve atts" },
	{ ERROR_DS_BACKLINK_WITHOUT_LINK, "DS backlink without link" },
	{ ERROR_DS_EPOCH_MISMATCH, "DS epoch mismatch" },
	{ ERROR_DS_SRC_NAME_MISMATCH, "DS src name mismatch" },
	{ ERROR_DS_SRC_AND_DST_NC_IDENTICAL, "DS src and dst nc identical" },
	{ ERROR_DS_DST_NC_MISMATCH, "DS dst nc mismatch" },
	{ ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC, "DS not authoritive for dst nc" },
	{ ERROR_DS_SRC_GUID_MISMATCH, "DS src GUID mismatch" },
	{ ERROR_DS_CANT_MOVE_DELETED_OBJECT, "DS can't move deleted object" },
	{ ERROR_DS_PDC_OPERATION_IN_PROGRESS, "DS pdc operation in progress" },
	{ ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD, "DS cross domain cleanup reqd" },
	{ ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION, "DS illegal xdom move operation" },
	{ ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS, "DS can't with acct group membershps" },
	{ ERROR_DS_NC_MUST_HAVE_NC_PARENT, "DS nc must have nc parent" },
	{ ERROR_DS_DST_DOMAIN_NOT_NATIVE, "DS dst domain not native" },
	{ ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER, "DS missing infrastructure container" },
	{ ERROR_DS_CANT_MOVE_ACCOUNT_GROUP, "DS can't move account group" },
	{ ERROR_DS_CANT_MOVE_RESOURCE_GROUP, "DS can't move resource group" },
	{ ERROR_DS_INVALID_SEARCH_FLAG, "DS invalid search flag" },
	{ ERROR_DS_NO_TREE_DELETE_ABOVE_NC, "DS no tree delete above nc" },
	{ ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE, "DS couldn't lock tree for delete" },
	{ ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE, "DS couldn't identify objects for tree delete" },
	{ ERROR_DS_SAM_INIT_FAILURE, "DS sam init failure" },
	{ ERROR_DS_SENSITIVE_GROUP_VIOLATION, "DS sensitive group violation" },
	{ ERROR_DS_CANT_MOD_PRIMARYGROUPID, "DS can't mod primarygroupid" },
	{ ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD, "DS illegal base schema mod" },
	{ ERROR_DS_NONSAFE_SCHEMA_CHANGE, "DS nonsafe schema change" },
	{ ERROR_DS_SCHEMA_UPDATE_DISALLOWED, "DS schema update disallowed" },
	{ ERROR_DS_CANT_CREATE_UNDER_SCHEMA, "DS can't create under schema" },
	{ ERROR_DS_INSTALL_NO_SRC_SCH_VERSION, "DS install no src sch version" },
	{ ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE, "DS install no sch version in inifile" },
	{ ERROR_DS_INVALID_GROUP_TYPE, "DS invalid group type" },
	{ ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN, "DS no nest globalgroup in mixeddomain" },
	{ ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN, "DS no nest localgroup in mixeddomain" },
	{ ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER, "DS global can't have local member" },
	{ ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER, "DS global can't have universal member" },
	{ ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER, "DS universal can't have local member" },
	{ ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER, "DS global can't have crossdomain member" },
	{ ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER, "DS local can't have crossdomain local member" },
	{ ERROR_DS_HAVE_PRIMARY_MEMBERS, "DS have primary members" },
	{ ERROR_DS_STRING_SD_CONVERSION_FAILED, "DS string sd conversion failed" },
	{ ERROR_DS_NAMING_MASTER_GC, "DS naming master gc" },
	{ ERROR_DS_LOOKUP_FAILURE, "DS lookup failure" },
	{ ERROR_DS_COULDNT_UPDATE_SPNS, "DS couldn't update spns" },
	{ ERROR_DS_CANT_RETRIEVE_SD, "DS can't retrieve sd" },
	{ ERROR_DS_KEY_NOT_UNIQUE, "DS key not unique" },
	{ ERROR_DS_WRONG_LINKED_ATT_SYNTAX, "DS wrong linked att syntax" },
	{ ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD, "DS sam need bootkey password" },
	{ ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY, "DS sam need bootkey floppy" },
	{ ERROR_DS_CANT_START, "DS can't start" },
	{ ERROR_DS_INIT_FAILURE, "DS init failure" },
	{ ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION, "DS no pkt privacy on connection" },
	{ ERROR_DS_SOURCE_DOMAIN_IN_FOREST, "DS source domain in forest" },
	{ ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST, "DS destination domain not in forest" },
	{ ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED, "DS destination auditing not enabled" },
	{ ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN, "DS can't find dc for src domain" },
	{ ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER, "DS src obj not group or user" },
	{ ERROR_DS_SRC_SID_EXISTS_IN_FOREST, "DS src sid exists in forest" },
	{ ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH, "DS src and dst object class mismatch" },
	{ ERROR_SAM_INIT_FAILURE, "Sam init failure" },
	{ ERROR_DS_DRA_SCHEMA_INFO_SHIP, "DS dra schema info ship" },
	{ ERROR_DS_DRA_SCHEMA_CONFLICT, "DS dra schema conflict" },
	{ ERROR_DS_DRA_EARLIER_SCHEMA_CONLICT, "DS dra earlier schema conflict" },
	{ ERROR_DS_DRA_OBJ_NC_MISMATCH, "DS dra obj nc mismatch" },
	{ ERROR_DS_NC_STILL_HAS_DSAS, "DS nc still has dsas" },
	{ ERROR_DS_GC_REQUIRED, "DS gc required" },
	{ ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY, "DS local member of local only" },
	{ ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS, "DS no fpo in universal groups" },
	{ ERROR_DS_CANT_ADD_TO_GC, "DS can't add to gc" },
	{ ERROR_DS_NO_CHECKPOINT_WITH_PDC, "DS no checkpoint with pdc" },
	{ ERROR_DS_SOURCE_AUDITING_NOT_ENABLED, "DS source auditing not enabled" },
	{ ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC, "DS can't create in nondomain nc" },
	{ ERROR_DS_INVALID_NAME_FOR_SPN, "DS invalid name for spn" },
	{ ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS, "DS filter uses constructed attrs" },
	{ ERROR_DS_UNICODEPWD_NOT_IN_QUOTES, "DS unicodepwd not in quotes" },
	{ ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED, "DS machine account quota exceeded" },
	{ ERROR_DS_MUST_BE_RUN_ON_DST_DC, "DS must be run on dst dc" },
	{ ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER, "DS src dc must be sp4 or greater" },
	{ ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ, "DS can't tree delete critical obj" },
	{ ERROR_DS_INIT_FAILURE_CONSOLE, "DS init failure console" },
	{ ERROR_DS_SAM_INIT_FAILURE_CONSOLE, "DS sam init failure console" },
	{ ERROR_DS_FOREST_VERSION_TOO_HIGH, "DS forest version too high" },
	{ ERROR_DS_DOMAIN_VERSION_TOO_HIGH, "DS domain version too high" },
	{ ERROR_DS_FOREST_VERSION_TOO_LOW, "DS forest version too low" },
	{ ERROR_DS_DOMAIN_VERSION_TOO_LOW, "DS domain version too low" },
	{ ERROR_DS_INCOMPATIBLE_VERSION, "DS incompatible version" },
	{ ERROR_DS_LOW_DSA_VERSION, "DS low dsa version" },
	{ ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN, "DS no behaviour version in mixeddomain" },
	{ ERROR_DS_NOT_SUPPORTED_SORT_ORDER, "DS not supported sort order" },
	{ ERROR_DS_NAME_NOT_UNIQUE, "DS name not unique" },
	{ ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4, "DS machine account created prent4" },
	{ ERROR_DS_OUT_OF_VERSION_STORE, "DS out of version store" },
	{ ERROR_DS_INCOMPATIBLE_CONTROLS_USED, "DS incompatible controls used" },
	{ ERROR_DS_NO_REF_DOMAIN, "DS no ref domain" },
	{ ERROR_DS_RESERVED_LINK_ID, "DS reserved link ID" },
	{ ERROR_DS_LINK_ID_NOT_AVAILABLE, "DS link ID not available" },
	{ ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER, "DS ag can't have universal member" },
	{ ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE, "DS modifydn disallowed by instance type" },
	{ ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC, "DS no object move in schema nc" },
	{ ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG, "DS modifydn disallowed by flag" },
	{ ERROR_DS_MODIFYDN_WRONG_GRANDPARENT, "DS modifydn wrong grandparent" },
	{ ERROR_DS_NAME_ERROR_TRUST_REFERRAL, "DS name error trust referral" },
	{ ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER, "Not supported on standard server" },
	{ ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD, "DS can't access remote part of ad" },
	{ ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE, "DS cr impossible to validate" },
	{ ERROR_DS_THREAD_LIMIT_EXCEEDED, "DS thread limit exceeded" },
	{ ERROR_DS_NOT_CLOSEST, "DS not closest" },
	{ ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF, "DS can't derive spn without server ref" },
	{ ERROR_DS_SINGLE_USER_MODE_FAILED, "DS single user mode failed" },
	{ ERROR_DS_NTDSCRIPT_SYNTAX_ERROR, "DS ntdscript syntax error" },
	{ ERROR_DS_NTDSCRIPT_PROCESS_ERROR, "DS ntdscript process error" },
	{ ERROR_DS_DIFFERENT_REPL_EPOCHS, "DS different repl epochs" },
	{ ERROR_DS_DRS_EXTENSIONS_CHANGED, "DS drs extensions changed" },
	{ ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR, "DS replica set change not allowed on disabled cr" },
	{ ERROR_DS_NO_MSDS_INTID, "DS no msds intid" },
	{ ERROR_DS_DUP_MSDS_INTID, "DS dup msds intid" },
	{ ERROR_DS_EXISTS_IN_RDNATTID, "DS exists in rdnattid" },
	{ ERROR_DS_AUTHORIZATION_FAILED, "DS authorisation failed" },
	{ ERROR_DS_INVALID_SCRIPT, "DS invalid script" },
	{ ERROR_DS_REMOTE_CROSSREF_OP_FAILED, "DS remote crossref op failed" },
	{ DNS_ERROR_RCODE_FORMAT_ERROR, "DNS error rcode format error" },
	{ DNS_ERROR_RCODE_SERVER_FAILURE, "DNS error rcode server failure" },
	{ DNS_ERROR_RCODE_NAME_ERROR, "DNS error rcode name error" },
	{ DNS_ERROR_RCODE_NOT_IMPLEMENTED, "DNS error rcode not implemented" },
	{ DNS_ERROR_RCODE_REFUSED, "DNS error rcode refused" },
	{ DNS_ERROR_RCODE_YXDOMAIN, "DNS error rcode yxdomain" },
	{ DNS_ERROR_RCODE_YXRRSET, "DNS error rcode yxrrset" },
	{ DNS_ERROR_RCODE_NXRRSET, "DNS error rcode nxrrset" },
	{ DNS_ERROR_RCODE_NOTAUTH, "DNS error rcode notauth" },
	{ DNS_ERROR_RCODE_NOTZONE, "DNS error rcode notzone" },
	{ DNS_ERROR_RCODE_BADSIG, "DNS error rcode badsig" },
	{ DNS_ERROR_RCODE_BADKEY, "DNS error rcode badkey" },
	{ DNS_ERROR_RCODE_BADTIME, "DNS error rcode badtime" },
	{ DNS_INFO_NO_RECORDS, "DNS info no records" },
	{ DNS_ERROR_BAD_PACKET, "DNS error bad packet" },
	{ DNS_ERROR_NO_PACKET, "DNS error no packet" },
	{ DNS_ERROR_RCODE, "DNS error rcode" },
	{ DNS_ERROR_UNSECURE_PACKET, "DNS error unsecure packet" },
	{ DNS_ERROR_INVALID_TYPE, "DNS error invalid type" },
	{ DNS_ERROR_INVALID_IP_ADDRESS, "DNS error invalid IP address" },
	{ DNS_ERROR_INVALID_PROPERTY, "DNS error invalid property" },
	{ DNS_ERROR_TRY_AGAIN_LATER, "DNS error try again later" },
	{ DNS_ERROR_NOT_UNIQUE, "DNS error not unique" },
	{ DNS_ERROR_NON_RFC_NAME, "DNS error non RFC name" },
	{ DNS_STATUS_FQDN, "DNS status FQDN" },
	{ DNS_STATUS_DOTTED_NAME, "DNS status dotted name" },
	{ DNS_STATUS_SINGLE_PART_NAME, "DNS status single part name" },
	{ DNS_ERROR_INVALID_NAME_CHAR, "DNS error invalid name char" },
	{ DNS_ERROR_NUMERIC_NAME, "DNS error numeric name" },
	{ DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER, "DNS error not allowed on root server" },
	{ DNS_ERROR_ZONE_DOES_NOT_EXIST, "DNS error zone does not exist" },
	{ DNS_ERROR_NO_ZONE_INFO, "DNS error not zone info" },
	{ DNS_ERROR_INVALID_ZONE_OPERATION, "DNS error invalid zone operation" },
	{ DNS_ERROR_ZONE_CONFIGURATION_ERROR, "DNS error zone configuration error" },
	{ DNS_ERROR_ZONE_HAS_NO_SOA_RECORD, "DNS error zone has not SOA record" },
	{ DNS_ERROR_ZONE_HAS_NO_NS_RECORDS, "DNS error zone has no NS records" },
	{ DNS_ERROR_ZONE_LOCKED, "DNS error zone locked" },
	{ DNS_ERROR_ZONE_CREATION_FAILED, "DNS error zone creation failed" },
	{ DNS_ERROR_ZONE_ALREADY_EXISTS, "DNS error zone already exists" },
	{ DNS_ERROR_AUTOZONE_ALREADY_EXISTS, "DNS error autozone already exists" },
	{ DNS_ERROR_INVALID_ZONE_TYPE, "DNS error invalid zone type" },
	{ DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP, "DNS error secondary requires master IP" },
	{ DNS_ERROR_ZONE_NOT_SECONDARY, "DNS error zone not secondary" },
	{ DNS_ERROR_NEED_SECONDARY_ADDRESSES, "DNS error need secondary addresses" },
	{ DNS_ERROR_WINS_INIT_FAILED, "DNS error wins init failed" },
	{ DNS_ERROR_NEED_WINS_SERVERS, "DNS error need wins servers" },
	{ DNS_ERROR_NBSTAT_INIT_FAILED, "DNS error nbstat init failed" },
	{ DNS_ERROR_SOA_DELETE_INVALID, "DNS error SOA delete invalid" },
	{ DNS_ERROR_FORWARDER_ALREADY_EXISTS, "DNS error forwarder already exists" },
	{ DNS_ERROR_ZONE_REQUIRES_MASTER_IP, "DNS error zone requires master IP" },
	{ DNS_ERROR_ZONE_IS_SHUTDOWN, "DNS error zone is shutdown" },
	{ DNS_ERROR_PRIMARY_REQUIRES_DATAFILE, "DNS error primary requires datafile" },
	{ DNS_ERROR_INVALID_DATAFILE_NAME, "DNS error invalid datafile name" },
	{ DNS_ERROR_DATAFILE_OPEN_FAILURE, "DNS error datafile open failure" },
	{ DNS_ERROR_FILE_WRITEBACK_FAILED, "DNS error file writeback failed" },
	{ DNS_ERROR_DATAFILE_PARSING, "DNS error datafile parsing" },
	{ DNS_ERROR_RECORD_DOES_NOT_EXIST, "DNS error record does not exist" },
	{ DNS_ERROR_RECORD_FORMAT, "DNS error record format" },
	{ DNS_ERROR_NODE_CREATION_FAILED, "DNS error node creation failed" },
	{ DNS_ERROR_UNKNOWN_RECORD_TYPE, "DNS error unknown record type" },
	{ DNS_ERROR_RECORD_TIMED_OUT, "DNS error record timed out" },
	{ DNS_ERROR_NAME_NOT_IN_ZONE, "DNS error name not in zone" },
	{ DNS_ERROR_CNAME_LOOP, "DNS error CNAME loop" },
	{ DNS_ERROR_NODE_IS_CNAME, "DNS error node is CNAME" },
	{ DNS_ERROR_CNAME_COLLISION, "DNS error CNAME collision" },
	{ DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT, "DNS error record only at zone root" },
	{ DNS_ERROR_RECORD_ALREADY_EXISTS, "DNS error record already exists" },
	{ DNS_ERROR_SECONDARY_DATA, "DNS error secondary data" },
	{ DNS_ERROR_NO_CREATE_CACHE_DATA, "DNS error no create cache data" },
	{ DNS_ERROR_NAME_DOES_NOT_EXIST, "DNS error name does not exist" },
	{ DNS_WARNING_PTR_CREATE_FAILED, "DNS warning PTR create failed" },
	{ DNS_WARNING_DOMAIN_UNDELETED, "DNS warning domain undeleted" },
	{ DNS_ERROR_DS_UNAVAILABLE, "DNS error ds unavailable" },
	{ DNS_ERROR_DS_ZONE_ALREADY_EXISTS, "DNS error ds zone already exists" },
	{ DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE, "DNS error no bootfile if ds zone" },
	{ DNS_INFO_AXFR_COMPLETE, "DNS info AXFR complete" },
	{ DNS_ERROR_AXFR, "DNS error AXFR" },
	{ DNS_INFO_ADDED_LOCAL_WINS, "DNS info added local wins" },
	{ DNS_STATUS_CONTINUE_NEEDED, "DNS status continue needed" },
	{ DNS_ERROR_NO_TCPIP, "DNS error no TCPIP" },
	{ DNS_ERROR_NO_DNS_SERVERS, "DNS error no DNS servers" },
	{ DNS_ERROR_DP_DOES_NOT_EXIST, "DNS error dp does not exist" },
	{ DNS_ERROR_DP_ALREADY_EXISTS, "DNS error dp already exists" },
	{ DNS_ERROR_DP_NOT_ENLISTED, "DNS error dp not enlisted" },
	{ DNS_ERROR_DP_ALREADY_ENLISTED, "DNS error dp already enlisted" },
	{ WSA_QOS_RECEIVERS, "QOS receivers" },
	{ WSA_QOS_SENDERS, "QOS senders" },
	{ WSA_QOS_NO_SENDERS, "QOS no senders" },
	{ WSA_QOS_NO_RECEIVERS, "QOS no receivers" },
	{ WSA_QOS_REQUEST_CONFIRMED, "QOS request confirmed" },
	{ WSA_QOS_ADMISSION_FAILURE, "QOS admission failure" },
	{ WSA_QOS_POLICY_FAILURE, "QOS policy failure" },
	{ WSA_QOS_BAD_STYLE, "QOS bad style" },
	{ WSA_QOS_BAD_OBJECT, "QOS bad object" },
	{ WSA_QOS_TRAFFIC_CTRL_ERROR, "QOS traffic ctrl error" },
	{ WSA_QOS_GENERIC_ERROR, "QOS generic error" },
	{ WSA_QOS_ESERVICETYPE, "QOS eservicetype" },
	{ WSA_QOS_EFLOWSPEC, "QOS eflowspec" },
	{ WSA_QOS_EPROVSPECBUF, "QOS eprovspecbuf" },
	{ WSA_QOS_EFILTERSTYLE, "QOS efilterstyle" },
	{ WSA_QOS_EFILTERTYPE, "QOS efiltertype" },
	{ WSA_QOS_EFILTERCOUNT, "QOS efiltercount" },
	{ WSA_QOS_EOBJLENGTH, "QOS eobjlength" },
	{ WSA_QOS_EFLOWCOUNT, "QOS eflowcount" },
	{ WSA_QOS_EUNKNOWNPSOBJ, "QOS eunknownpsobj" },
	{ WSA_QOS_EPOLICYOBJ, "QOS epolicyobj" },
	{ WSA_QOS_EFLOWDESC, "QOS eflowdesc" },
	{ WSA_QOS_EPSFLOWSPEC, "QOS epsflowspec" },
	{ WSA_QOS_EPSFILTERSPEC, "QOS epsfilterspec" },
	{ WSA_QOS_ESDMODEOBJ, "QOS esdmodeobj" },
	{ WSA_QOS_ESHAPERATEOBJ, "QOS eshaperateobj" },
	{ WSA_QOS_RESERVED_PETYPE, "QOS reserved petype" },
	{ ERROR_IPSEC_QM_POLICY_EXISTS, "IPSEC qm policy exists" },
	{ ERROR_IPSEC_QM_POLICY_NOT_FOUND, "IPSEC qm policy not found" },
	{ ERROR_IPSEC_QM_POLICY_IN_USE, "IPSEC qm policy in use" },
	{ ERROR_IPSEC_MM_POLICY_EXISTS, "IPSEC mm policy exists" },
	{ ERROR_IPSEC_MM_POLICY_NOT_FOUND, "IPSEC mm policy not found" },
	{ ERROR_IPSEC_MM_POLICY_IN_USE, "IPSEC mm policy in use" },
	{ ERROR_IPSEC_MM_FILTER_EXISTS, "IPSEC mm filter exists" },
	{ ERROR_IPSEC_MM_FILTER_NOT_FOUND, "IPSEC mm filter not found" },
	{ ERROR_IPSEC_TRANSPORT_FILTER_EXISTS, "IPSEC transport filter exists" },
	{ ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND, "IPSEC transport filter not found" },
	{ ERROR_IPSEC_MM_AUTH_EXISTS, "IPSEC mm auth exists" },
	{ ERROR_IPSEC_MM_AUTH_NOT_FOUND, "IPSEC mm auth not found" },
	{ ERROR_IPSEC_MM_AUTH_IN_USE, "IPSEC mm auth in use" },
	{ ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND, "IPSEC default mm policy not found" },
	{ ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND, "IPSEC default mm auth not found" },
	{ ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND, "IPSEC default qm policy not found" },
	{ ERROR_IPSEC_TUNNEL_FILTER_EXISTS, "IPSEC tunnel filter exists" },
	{ ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND, "IPSEC tunnel filter not found" },
	{ ERROR_IPSEC_MM_FILTER_PENDING_DELETION, "IPSEC mm filter pending deletion" },
	{ ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION, "IPSEC transport filter pending deletion" },
	{ ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION, "IPSEC tunnel filter pending deletion" },
	{ ERROR_IPSEC_MM_POLICY_PENDING_DELETION, "IPSEC mm policy pending deletion" },
	{ ERROR_IPSEC_MM_AUTH_PENDING_DELETION, "IPSEC mm auth pending deletion" },
	{ ERROR_IPSEC_QM_POLICY_PENDING_DELETION, "IPSEC qm policy pending deletion" },
	{ ERROR_IPSEC_IKE_AUTH_FAIL, "IPSEC IKE auth fail" },
	{ ERROR_IPSEC_IKE_ATTRIB_FAIL, "IPSEC IKE attrib fail" },
	{ ERROR_IPSEC_IKE_NEGOTIATION_PENDING, "IPSEC IKE negotiation pending" },
	{ ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR, "IPSEC IKE general processing error" },
	{ ERROR_IPSEC_IKE_TIMED_OUT, "IPSEC IKE timed out" },
	{ ERROR_IPSEC_IKE_NO_CERT, "IPSEC IKE no cert" },
	{ ERROR_IPSEC_IKE_SA_DELETED, "IPSEC IKE sa deleted" },
	{ ERROR_IPSEC_IKE_SA_REAPED, "IPSEC IKE sa reaped" },
	{ ERROR_IPSEC_IKE_MM_ACQUIRE_DROP, "IPSEC IKE mm acquire drop" },
	{ ERROR_IPSEC_IKE_QM_ACQUIRE_DROP, "IPSEC IKE qm acquire drop" },
	{ ERROR_IPSEC_IKE_QUEUE_DROP_MM, "IPSEC IKE queue drop mm" },
	{ ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM, "IPSEC IKE queue drop no mm" },
	{ ERROR_IPSEC_IKE_DROP_NO_RESPONSE, "IPSEC IKE drop no response" },
	{ ERROR_IPSEC_IKE_MM_DELAY_DROP, "IPSEC IKE mm delay drop" },
	{ ERROR_IPSEC_IKE_QM_DELAY_DROP, "IPSEC IKE qm delay drop" },
	{ ERROR_IPSEC_IKE_ERROR, "IPSEC IKE error" },
	{ ERROR_IPSEC_IKE_CRL_FAILED, "IPSEC IKE crl failed" },
	{ ERROR_IPSEC_IKE_INVALID_KEY_USAGE, "IPSEC IKE invalid key usage" },
	{ ERROR_IPSEC_IKE_INVALID_CERT_TYPE, "IPSEC IKE invalid cert type" },
	{ ERROR_IPSEC_IKE_NO_PRIVATE_KEY, "IPSEC IKE no private key" },
	{ ERROR_IPSEC_IKE_DH_FAIL, "IPSEC IKE dh fail" },
	{ ERROR_IPSEC_IKE_INVALID_HEADER, "IPSEC IKE invalid header" },
	{ ERROR_IPSEC_IKE_NO_POLICY, "IPSEC IKE no policy" },
	{ ERROR_IPSEC_IKE_INVALID_SIGNATURE, "IPSEC IKE invalid signature" },
	{ ERROR_IPSEC_IKE_KERBEROS_ERROR, "IPSEC IKE kerberos error" },
	{ ERROR_IPSEC_IKE_NO_PUBLIC_KEY, "IPSEC IKE no public key" },
	{ ERROR_IPSEC_IKE_PROCESS_ERR, "IPSEC IKE process err" },
	{ ERROR_IPSEC_IKE_PROCESS_ERR_SA, "IPSEC IKE process err sa" },
	{ ERROR_IPSEC_IKE_PROCESS_ERR_PROP, "IPSEC IKE process err prop" },
	{ ERROR_IPSEC_IKE_PROCESS_ERR_TRANS, "IPSEC IKE process err trans" },
	{ ERROR_IPSEC_IKE_PROCESS_ERR_KE, "IPSEC IKE process err ke" },
	{ ERROR_IPSEC_IKE_PROCESS_ERR_ID, "IPSEC IKE process err ID" },
	{ ERROR_IPSEC_IKE_PROCESS_ERR_CERT, "IPSEC IKE process err cert" },
	{ ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ, "IPSEC IKE process err cert req" },
	{ ERROR_IPSEC_IKE_PROCESS_ERR_HASH, "IPSEC IKE process err hash" },
	{ ERROR_IPSEC_IKE_PROCESS_ERR_SIG, "IPSEC IKE process err sig" },
	{ ERROR_IPSEC_IKE_PROCESS_ERR_NONCE, "IPSEC IKE process err nonce" },
	{ ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY, "IPSEC IKE process err notify" },
	{ ERROR_IPSEC_IKE_PROCESS_ERR_DELETE, "IPSEC IKE process err delete" },
	{ ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR, "IPSEC IKE process err vendor" },
	{ ERROR_IPSEC_IKE_INVALID_PAYLOAD, "IPSEC IKE invalid payload" },
	{ ERROR_IPSEC_IKE_LOAD_SOFT_SA, "IPSEC IKE load soft sa" },
	{ ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN, "IPSEC IKE soft sa torn down" },
	{ ERROR_IPSEC_IKE_INVALID_COOKIE, "IPSEC IKE invalid cookie" },
	{ ERROR_IPSEC_IKE_NO_PEER_CERT, "IPSEC IKE no peer cert" },
	{ ERROR_IPSEC_IKE_PEER_CRL_FAILED, "IPSEC IKE peer CRL failed" },
	{ ERROR_IPSEC_IKE_POLICY_CHANGE, "IPSEC IKE policy change" },
	{ ERROR_IPSEC_IKE_NO_MM_POLICY, "IPSEC IKE no mm policy" },
	{ ERROR_IPSEC_IKE_NOTCBPRIV, "IPSEC IKE notcbpriv" },
	{ ERROR_IPSEC_IKE_SECLOADFAIL, "IPSEC IKE secloadfail" },
	{ ERROR_IPSEC_IKE_FAILSSPINIT, "IPSEC IKE failsspinit" },
	{ ERROR_IPSEC_IKE_FAILQUERYSSP, "IPSEC IKE failqueryssp" },
	{ ERROR_IPSEC_IKE_SRVACQFAIL, "IPSEC IKE srvacqfail" },
	{ ERROR_IPSEC_IKE_SRVQUERYCRED, "IPSEC IKE srvquerycred" },
	{ ERROR_IPSEC_IKE_GETSPIFAIL, "IPSEC IKE getspifail" },
	{ ERROR_IPSEC_IKE_INVALID_FILTER, "IPSEC IKE invalid filter" },
	{ ERROR_IPSEC_IKE_OUT_OF_MEMORY, "IPSEC IKE out of memory" },
	{ ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED, "IPSEC IKE add update key failed" },
	{ ERROR_IPSEC_IKE_INVALID_POLICY, "IPSEC IKE invalid policy" },
	{ ERROR_IPSEC_IKE_UNKNOWN_DOI, "IPSEC IKE unknown doi" },
	{ ERROR_IPSEC_IKE_INVALID_SITUATION, "IPSEC IKE invalid situation" },
	{ ERROR_IPSEC_IKE_DH_FAILURE, "IPSEC IKE dh failure" },
	{ ERROR_IPSEC_IKE_INVALID_GROUP, "IPSEC IKE invalid group" },
	{ ERROR_IPSEC_IKE_ENCRYPT, "IPSEC IKE encrypt" },
	{ ERROR_IPSEC_IKE_DECRYPT, "IPSEC IKE decrypt" },
	{ ERROR_IPSEC_IKE_POLICY_MATCH, "IPSEC IKE policy match" },
	{ ERROR_IPSEC_IKE_UNSUPPORTED_ID, "IPSEC IKE unsupported ID" },
	{ ERROR_IPSEC_IKE_INVALID_HASH, "IPSEC IKE invalid hash" },
	{ ERROR_IPSEC_IKE_INVALID_HASH_ALG, "IPSEC IKE invalid hash alg" },
	{ ERROR_IPSEC_IKE_INVALID_HASH_SIZE, "IPSEC IKE invalid hash size" },
	{ ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG, "IPSEC IKE invalid encrypt alg" },
	{ ERROR_IPSEC_IKE_INVALID_AUTH_ALG, "IPSEC IKE invalid auth alg" },
	{ ERROR_IPSEC_IKE_INVALID_SIG, "IPSEC IKE invalid sig" },
	{ ERROR_IPSEC_IKE_LOAD_FAILED, "IPSEC IKE load failed" },
	{ ERROR_IPSEC_IKE_RPC_DELETE, "IPSEC IKE rpc delete" },
	{ ERROR_IPSEC_IKE_BENIGN_REINIT, "IPSEC IKE benign reinit" },
	{ ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY, "IPSEC IKE invalid responder lifetime notify" },
	{ ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN, "IPSEC IKE invalid cert keylen" },
	{ ERROR_IPSEC_IKE_MM_LIMIT, "IPSEC IKE mm limit" },
	{ ERROR_IPSEC_IKE_NEGOTIATION_DISABLED, "IPSEC IKE negotiation disabled" },
	{ ERROR_IPSEC_IKE_NEG_STATUS_END, "IPSEC IKE neg status end" },
	{ ERROR_SXS_SECTION_NOT_FOUND, "Sxs section not found" },
	{ ERROR_SXS_CANT_GEN_ACTCTX, "Sxs can't gen actctx" },
	{ ERROR_SXS_INVALID_ACTCTXDATA_FORMAT, "Sxs invalid actctxdata format" },
	{ ERROR_SXS_ASSEMBLY_NOT_FOUND, "Sxs assembly not found" },
	{ ERROR_SXS_MANIFEST_FORMAT_ERROR, "Sxs manifest format error" },
	{ ERROR_SXS_MANIFEST_PARSE_ERROR, "Sxs manifest parse error" },
	{ ERROR_SXS_ACTIVATION_CONTEXT_DISABLED, "Sxs activation context disabled" },
	{ ERROR_SXS_KEY_NOT_FOUND, "Sxs key not found" },
	{ ERROR_SXS_VERSION_CONFLICT, "Sxs version conflict" },
	{ ERROR_SXS_WRONG_SECTION_TYPE, "Sxs wrong section type" },
	{ ERROR_SXS_THREAD_QUERIES_DISABLED, "Sxs thread queries disabled" },
	{ ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET, "Sxs process default already set" },
	{ ERROR_SXS_UNKNOWN_ENCODING_GROUP, "Sxs unknown encoding group" },
	{ ERROR_SXS_UNKNOWN_ENCODING, "Sxs unknown encoding" },
	{ ERROR_SXS_INVALID_XML_NAMESPACE_URI, "Sxs invalid XML namespace URI" },
	{ ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED, "Sxs root manifest dependency not installed" },
	{ ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED, "Sxs leaf manifest dependency not installed" },
	{ ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE, "Sxs invalid assembly indentity attribute" },
	{ ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE, "Sxs manifest missing required default namespace" },
	{ ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE, "Sxs manifest invalid required default namespace" },
	{ ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT, "Sxs private manifest cross path with reparse point" },
	{ ERROR_SXS_DUPLICATE_DLL_NAME, "Sxs duplicate dll name" },
	{ ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME, "Sxs duplicate windowclass name" },
	{ ERROR_SXS_DUPLICATE_CLSID, "Sxs duplicate clsid" },
	{ ERROR_SXS_DUPLICATE_IID, "Sxs duplicate iid" },
	{ ERROR_SXS_DUPLICATE_TLBID, "Sxs duplicate tlbid" },
	{ ERROR_SXS_DUPLICATE_PROGID, "Sxs duplicate progid" },
	{ ERROR_SXS_DUPLICATE_ASSEMBLY_NAME, "Sxs duplicate assembly name" },
	{ ERROR_SXS_FILE_HASH_MISMATCH, "Sxs file hash mismatch" },
	{ ERROR_SXS_POLICY_PARSE_ERROR, "Sxs policy parse error" },
	{ ERROR_SXS_XML_E_MISSINGQUOTE, "Sxs XML e missingquote" },
	{ ERROR_SXS_XML_E_COMMENTSYNTAX, "Sxs XML e commentsyntax" },
	{ ERROR_SXS_XML_E_BADSTARTNAMECHAR, "Sxs XML e badstartnamechar" },
	{ ERROR_SXS_XML_E_BADNAMECHAR, "Sxs XML e badnamechar" },
	{ ERROR_SXS_XML_E_BADCHARINSTRING, "Sxs XML e badcharinstring" },
	{ ERROR_SXS_XML_E_XMLDECLSYNTAX, "Sxs XML e xmldeclsyntax" },
	{ ERROR_SXS_XML_E_BADCHARDATA, "Sxs XML e badchardata" },
	{ ERROR_SXS_XML_E_MISSINGWHITESPACE, "Sxs XML e missingwhitespace" },
	{ ERROR_SXS_XML_E_EXPECTINGTAGEND, "Sxs XML e expectingtagend" },
	{ ERROR_SXS_XML_E_MISSINGSEMICOLON, "Sxs XML e missingsemicolon" },
	{ ERROR_SXS_XML_E_UNBALANCEDPAREN, "Sxs XML e unbalancedparen" },
	{ ERROR_SXS_XML_E_INTERNALERROR, "Sxs XML e internalerror" },
	{ ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE, "Sxs XML e unexpected whitespace" },
	{ ERROR_SXS_XML_E_INCOMPLETE_ENCODING, "Sxs XML e incomplete encoding" },
	{ ERROR_SXS_XML_E_MISSING_PAREN, "Sxs XML e missing paren" },
	{ ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE, "Sxs XML e expectingclosequote" },
	{ ERROR_SXS_XML_E_MULTIPLE_COLONS, "Sxs XML e multiple colons" },
	{ ERROR_SXS_XML_E_INVALID_DECIMAL, "Sxs XML e invalid decimal" },
	{ ERROR_SXS_XML_E_INVALID_HEXIDECIMAL, "Sxs XML e invalid hexidecimal" },
	{ ERROR_SXS_XML_E_INVALID_UNICODE, "Sxs XML e invalid unicode" },
	{ ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK, "Sxs XML e whitespaceorquestionmark" },
	{ ERROR_SXS_XML_E_UNEXPECTEDENDTAG, "Sxs XML e unexpectedendtag" },
	{ ERROR_SXS_XML_E_UNCLOSEDTAG, "Sxs XML e unclosedtag" },
	{ ERROR_SXS_XML_E_DUPLICATEATTRIBUTE, "Sxs XML e duplicateattribute" },
	{ ERROR_SXS_XML_E_MULTIPLEROOTS, "Sxs XML e multipleroots" },
	{ ERROR_SXS_XML_E_INVALIDATROOTLEVEL, "Sxs XML e invalidatrootlevel" },
	{ ERROR_SXS_XML_E_BADXMLDECL, "Sxs XML e badxmldecl" },
	{ ERROR_SXS_XML_E_MISSINGROOT, "Sxs XML e missingroot" },
	{ ERROR_SXS_XML_E_UNEXPECTEDEOF, "Sxs XML e unexpectedeof" },
	{ ERROR_SXS_XML_E_BADPEREFINSUBSET, "Sxs XML e badperefinsubset" },
	{ ERROR_SXS_XML_E_UNCLOSEDSTARTTAG, "Sxs XML e unclosedstarttag" },
	{ ERROR_SXS_XML_E_UNCLOSEDENDTAG, "Sxs XML e unclosedendtag" },
	{ ERROR_SXS_XML_E_UNCLOSEDSTRING, "Sxs XML e unclosedstring" },
	{ ERROR_SXS_XML_E_UNCLOSEDCOMMENT, "Sxs XML e unclosedcomment" },
	{ ERROR_SXS_XML_E_UNCLOSEDDECL, "Sxs XML e uncloseddecl" },
	{ ERROR_SXS_XML_E_UNCLOSEDCDATA, "Sxs XML e unclosedcdata" },
	{ ERROR_SXS_XML_E_RESERVEDNAMESPACE, "Sxs XML e reservednamespace" },
	{ ERROR_SXS_XML_E_INVALIDENCODING, "Sxs XML e invalidencoding" },
	{ ERROR_SXS_XML_E_INVALIDSWITCH, "Sxs XML e invalidswitch" },
	{ ERROR_SXS_XML_E_BADXMLCASE, "Sxs XML e badxmlcase" },
	{ ERROR_SXS_XML_E_INVALID_STANDALONE, "Sxs XML e invalid standalone" },
	{ ERROR_SXS_XML_E_UNEXPECTED_STANDALONE, "Sxs XML e unexpected standalone" },
	{ ERROR_SXS_XML_E_INVALID_VERSION, "Sxs XML e invalid version" },
	{ ERROR_SXS_XML_E_MISSINGEQUALS, "Sxs XML e missingequals" },
	{ ERROR_SXS_PROTECTION_RECOVERY_FAILED, "Sxs protection recovery failed" },
	{ ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT, "Sxs protection public key too short" },
	{ ERROR_SXS_PROTECTION_CATALOG_NOT_VALID, "Sxs protection catalog not valid" },
	{ ERROR_SXS_UNTRANSLATABLE_HRESULT, "Sxs untranslatable hresult" },
	{ ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING, "Sxs protection catalog file missing" },
	{ ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE, "Sxs missing assembly identity attribute" },
	{ ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME, "Sxs invalid assembly identity attribute name" },
};
#endif /* DISABLE_FULL_MESSAGES */

static int
msg_compare (const void *first, const void *second)
{
	ErrorDesc *efirst = (ErrorDesc *) first;
	ErrorDesc *esecond = (ErrorDesc *) second;

	return efirst->id - esecond->id;
}

static const gchar *
find_msg (guint32 id, ErrorDesc *base, int n)
{
	ErrorDesc d, *result;
	d.id = id;
	
	result = (ErrorDesc *)mono_binary_search (&d, base, n, sizeof (ErrorDesc), msg_compare);
	if (result == NULL)
		return NULL;
	return result->txt;
}

static const gchar *
find_linear_msg (guint32 id, ErrorDesc *base, int n)
{
	int i, prev = -1;

	for (i = 0; i < n; i++){
		if (base [i].id > prev)
			prev = base [i].id;
		else {
			static int error_shown;
			if (!error_shown){
				error_shown = 1;
				fprintf (stderr, "Mono: Incorrect message sorted in io-layer/messages.c at index %d (msg=%s)\n", i, base [i].txt);
			}
		}	
		if (base [i].id == id){
			static int error_shown;
			if (!error_shown){
				error_shown = 1;
				fprintf (stderr, "Mono: Error %d with text %s is improperly sorted in io-layer/messages.c\n", id, base [i].txt);
			}
			return base [i].txt;
		}
	}
	return NULL;
}

static const gchar *
message_string (guint32 id)
{
	const char *msg = find_msg (id, common_messages, G_N_ELEMENTS (common_messages));
	if (msg != NULL)
		return msg;

#ifndef DISABLE_FULL_MESSAGES
	msg = find_msg (id, messages, G_N_ELEMENTS (messages));
	if (msg != NULL){
		fprintf (stderr, "messages.c: A message was found on the uncommon code path: %d - %s", id, msg);
		return msg;
	}
#endif
	
	/*
	 * Linear search, in case someone adds an error message and does not add it
	 * to the list in a sorted position, this will be catched during development.
	 */
	msg = find_linear_msg (id, common_messages, G_N_ELEMENTS (common_messages));
	if (msg != NULL)
		return msg;

#ifndef DISABLE_FULL_MESSAGES
	msg = find_linear_msg (id, messages, G_N_ELEMENTS (messages));
	if (msg != NULL)
		return msg;
#endif

	return NULL;
}

static guint32
unicode_chars (const gunichar2 *str)
{
	guint32 len = 0;
	
	do {
		if (str[len] == '\0') {
			return(len);
		}
		len++;
	} while(1);
}

guint32
FormatMessage (guint32 flags, gconstpointer source, guint32 messageid,
	       guint32 languageid, gunichar2 *buf, guint32 size, ...)
{
	/*va_list ap;*/
	guint32 strlen, cpy;
	gunichar2 *str;
	gboolean freestr = FALSE;
	
	if ((flags & FORMAT_MESSAGE_FROM_HMODULE) ||
	    (flags & FORMAT_MESSAGE_ARGUMENT_ARRAY) ||
	    !(flags & FORMAT_MESSAGE_IGNORE_INSERTS)) {
		g_warning ("%s: Unsupported flags passed: %d", __func__,
			   flags);
		SetLastError (ERROR_NOT_SUPPORTED);
		return(0);
	}

	if ((flags & FORMAT_MESSAGE_MAX_WIDTH_MASK) != 0) {
		g_warning ("%s: Message width mask (%d) not supported",
			   __func__, (flags & FORMAT_MESSAGE_MAX_WIDTH_MASK));
	}
	
	if (languageid != 0) {
		g_warning ("%s: Locale 0x%x not supported, returning language neutral string", __func__, languageid);
	}
	
	/* We're only supporting IGNORE_INSERTS, so we don't need to
	 * use va_start (ap, size) and va_end (ap)
	 */

	if (flags & FORMAT_MESSAGE_FROM_STRING) {
		str = (gunichar2 *)source;
	} else if (flags & FORMAT_MESSAGE_FROM_SYSTEM) {
		const char *msg = message_string (messageid);
		if (msg != NULL)
			str = g_utf8_to_utf16 (msg, -1, NULL, NULL, NULL);
		else {
			char *msg2 = g_strdup_printf ("mono-io-layer-error (%d)", messageid);
			str = g_utf8_to_utf16 (msg2, -1, NULL, NULL, NULL);
			g_free (msg2);
		}
		freestr = TRUE;
	} else
		str = g_utf8_to_utf16 ("No message specified", -1, NULL, NULL, NULL);

	strlen = unicode_chars (str);

	if (flags & FORMAT_MESSAGE_ALLOCATE_BUFFER) {
		*(gpointer *)buf = (gunichar2 *)g_new0 (gunichar2, strlen + 2 < size?size:strlen + 2);
	}

	if (strlen >= size) {
		cpy = size - 1;
	} else {
		cpy = strlen;
	}
	memcpy (buf, str, cpy * 2);
	buf[cpy] = '\0';

	if (freestr) {
		g_free (str);
	}
	
	return(strlen);
}

