/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions;

import org.apache.turbine.modules.Action;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.TurbineSecurityException;

public class LoginUser
extends Action {
    public void doPerform(RunData data) throws Exception {
        if (data.getUserFromSession() != null) {
            return;
        }
        String username = data.getParameters().getString("username", "");
        String password = data.getParameters().getString("password", "");
        User user = null;
        try {
            user = TurbineSecurity.getAuthenticatedUser(username, password);
            data.setUser(user);
            user.setHasLoggedIn(new Boolean(true));
            user.updateLastLogin();
            data.save();
        }
        catch (TurbineSecurityException e) {
            if (e instanceof DataBackendException) {
                Log.error(e);
            }
            data.setMessage(TurbineResources.getString("login.error"));
            data.setUser(TurbineSecurity.getAnonymousUser());
            String loginTemplate = TurbineResources.getString("template.login");
            if (loginTemplate != null && loginTemplate.length() > 0) {
                data.setScreenTemplate(loginTemplate);
            }
            data.setScreen(TurbineResources.getString("screen.login"));
        }
    }
}

